package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import org.richfaces.component.UIListShuttle;

public class HtmlListShuttle extends UIListShuttle{

public static final  String COMPONENT_FAMILY = "org.richfaces.ListShuttle";

public static final  String COMPONENT_TYPE = "org.richfaces.ListShuttle";

/*
* CSS class for a "Bottom" control
*/
private  String _bottomControlClass = null;

/*
* Defines a label for a bottom control
*/
private  String _bottomControlLabel = null;

/*
* HTML: alt for the last button
*/
private  String _bottomTitle = null;

/*
* Comma-separated list of CSS classes for columns
*/
private  String _columnClasses = null;

/*
* Defines type of a control: button or none. Default value is "button".
*/
private  String _controlsType = null;

/*
* Customizes vertically a position of move/copy and order controls relatively to lists. Default value is "middle"
*/
private  String _controlsVerticalAlign = null;

/*
* Id of Converter to be used or reference to a Converter
*/
private  Converter _converter = null;

/*
* A ValueExpression enabled attribute that, if present,
			will be used as the text of the converter message,
			replacing any message that comes from the converter
*/
private  String _converterMessage = null;

/*
* CSS class for a "Copy all" control
*/
private  String _copyAllControlClass = null;

/*
* Defines a label for a "Copy all" control
*/
private  String _copyAllControlLabel = null;

/*
* HTML: alt for "Copy all" button
*/
private  String _copyAllTitle = null;

/*
* CSS class for "Copy" control
*/
private  String _copyControlClass = null;

/*
* Defines a label for a "Copy" control
*/
private  String _copyControlLabel = null;

/*
* HTML: alt for a "Copy" button
*/
private  String _copyTitle = null;

/*
* CSS class for a disabled control
*/
private  String _disabledControlClass = null;

/*
* CSS class for a "Down" control
*/
private  String _downControlClass = null;

/*
* Defines a label for a down control
*/
private  String _downControlLabel = null;

/*
* HTML: alt for bottom button
*/
private  String _downTitle = null;

/*
* If "false", 'Copy All' and 'Remove All' controls aren't displayed. Default value is "true".
*/
private  boolean _fastMoveControlsVisible = true;

private  boolean _fastMoveControlsVisibleSet = false;

/*
* If "false", 'Top' and 'Bottom' controls aren't displayed. Default value is "true".
*/
private  boolean _fastOrderControlsVisible = true;

private  boolean _fastOrderControlsVisibleSet = false;

/*
* A flag indicating that this component value must be converted
            and validated immediately (that is, during Apply Request Values
            phase), rather than waiting until a Process Validations phase
*/
private  boolean _immediate = false;

private  boolean _immediateSet = false;

/*
* A localized user presentable name for this component.
*/
private  String _label = null;

/*
* CSS class for a list
*/
private  String _listClass = null;

/*
* Defines height of the list. Default value is "140".
*/
private  String _listsHeight = null;

/*
* If "false", 'Copy' and 'Remove' controls aren't displayed. Default value is "true".
*/
private  boolean _moveControlsVisible = true;

private  boolean _moveControlsVisibleSet = false;

/*
* HTML: script expression; the element lost the focus
*/
private  String _onblur = null;

/*
* A JavaScript event handler; a button "Bottom" is clicked
*/
private  String _onbottomclick = null;

/*
* null
*/
private  String _onchange = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _onclick = null;

/*
* A JavaScript event handler; a button "Copy All" is clicked
*/
private  String _oncopyallclick = null;

/*
* HTML: a script expression; a button "Copy" is clicked
*/
private  String _oncopyclick = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _ondblclick = null;

/*
* A JavaScript event handler; a button "Down" is clicked
*/
private  String _ondownclick = null;

/*
* HTML: script expression; the element got the focus
*/
private  String _onfocus = null;

/*
* HTML: script expression; before a list is changed
*/
private  String _onlistchange = null;

/*
* HTML: script expression; a list is changed
*/
private  String _onlistchanged = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _onmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _onmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _onmouseover = null;

/*
* HTML: script expression; called before ordering action
*/
private  String _onorderchange = null;

/*
* HTML: script expression; called after ordering action
*/
private  String _onorderchanged = null;

/*
* A JavaScript event handler; a button "Remove All" is clicked
*/
private  String _onremoveallclick = null;

/*
* A JavaScript event handler; a button "Remove" is clicked
*/
private  String _onremoveclick = null;

/*
* A JavaScript event handler; a button "Top" is clicked
*/
private  String _ontopclick = null;

/*
* HTML: a script expression; a button "Up" is clicked
*/
private  String _onupclick = null;

/*
* If "false", 'Up' and 'Down' controls aren't displayed. Default value is "true".
*/
private  boolean _orderControlsVisible = true;

private  boolean _orderControlsVisibleSet = false;

/*
* CSS class for "Remove all" control
*/
private  String _removeAllControlClass = null;

/*
* Defines a label for a "Remove all" control
*/
private  String _removeAllControlLabel = null;

/*
* HTML: alt for "Remove all" button
*/
private  String _removeAllTitle = null;

/*
* CSS class for a "Remove" control
*/
private  String _removeControlClass = null;

/*
* Defines a label for a "Remove" control
*/
private  String _removeControlLabel = null;

/*
* HTML: alt for a "Remove" button
*/
private  String _removeTitle = null;

/*
* required
*/
private  boolean _required = false;

private  boolean _requiredSet = false;

/*
* A ValueExpression enabled attribute that, if present,
			will be used as the text of the validation message for
			the "required" facility, if the "required" facility is
			used
*/
private  String _requiredMessage = null;

/*
* CSS class for a row
*/
private  String _rowClasses = null;

/*
* Shows a label for a button. Default value is "true".
*/
private  boolean _showButtonLabels = true;

private  boolean _showButtonLabelsSet = false;

/*
* Defines source list caption representation text
*/
private  String _sourceCaptionLabel = null;

/*
* Defines width of a source list. Default value is "140".
*/
private  String _sourceListWidth = null;

/*
* Defines the case when source value is being validated.
				If the value is "true", there should be at least one item in the source list
*/
private  boolean _sourceRequired = false;

private  boolean _sourceRequiredSet = false;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* If "true", dragging between lists realized by click
*/
private  boolean _switchByClick = false;

private  boolean _switchByClickSet = false;

/*
* If "true", items can be moved between the lists by double-clicking on them. Default value is "true".
*/
private  boolean _switchByDblClick = true;

private  boolean _switchByDblClickSet = false;

/*
* Defines target list caption representation text
*/
private  String _targetCaptionLabel = null;

/*
* Defines width of a target list. Default value is "140".
*/
private  String _targetListWidth = null;

/*
* Defines the case when target value is being validated.
				If the value is "true", there should be at least one item in the target list
*/
private  boolean _targetRequired = false;

private  boolean _targetRequiredSet = false;

/*
* CSS class for a "Top" control
*/
private  String _topControlClass = null;

/*
* Defines a label for a "Top" control
*/
private  String _topControlLabel = null;

/*
* HTML: alt for the first button
*/
private  String _topTitle = null;

/*
* CSS class for an "Up" control
*/
private  String _upControlClass = null;

/*
* Defines a label for an "Up" control
*/
private  String _upControlLabel = null;

/*
* HTML: alt for top button
*/
private  String _upTitle = null;

/*
* valid
*/
private  boolean _valid = true;

private  boolean _validSet = false;

/*
* A ValueExpression enabled attribute that, if present,
			will be used as the text of the validator message,
			replacing any message that comes from the validator
*/
private  String _validatorMessage = null;

/*
* Listener for value changes
*/
private  MethodBinding _valueChangeListener = null;


public HtmlListShuttle(){
setRendererType("org.richfaces.ListShuttleRenderer");
}

public String getBottomControlClass(){
	if (this._bottomControlClass != null) {
		return this._bottomControlClass;
	}
	ValueExpression ve = getValueExpression("bottomControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setBottomControlClass(String _bottomControlClass){
this._bottomControlClass = _bottomControlClass;
}

public String getBottomControlLabel(){
	if (this._bottomControlLabel != null) {
		return this._bottomControlLabel;
	}
	ValueExpression ve = getValueExpression("bottomControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setBottomControlLabel(String _bottomControlLabel){
this._bottomControlLabel = _bottomControlLabel;
}

public String getBottomTitle(){
	if (this._bottomTitle != null) {
		return this._bottomTitle;
	}
	ValueExpression ve = getValueExpression("bottomTitle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setBottomTitle(String _bottomTitle){
this._bottomTitle = _bottomTitle;
}

public String getColumnClasses(){
	if (this._columnClasses != null) {
		return this._columnClasses;
	}
	ValueExpression ve = getValueExpression("columnClasses");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setColumnClasses(String _columnClasses){
this._columnClasses = _columnClasses;
}

public String getControlsType(){
	if (this._controlsType != null) {
		return this._controlsType;
	}
	ValueExpression ve = getValueExpression("controlsType");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "button";
	

}

public void setControlsType(String _controlsType){
this._controlsType = _controlsType;
}

public String getControlsVerticalAlign(){
	if (this._controlsVerticalAlign != null) {
		return this._controlsVerticalAlign;
	}
	ValueExpression ve = getValueExpression("controlsVerticalAlign");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "middle";
	

}

public void setControlsVerticalAlign(String _controlsVerticalAlign){
this._controlsVerticalAlign = _controlsVerticalAlign;
}

public Converter getConverter(){
	if (this._converter != null) {
		return this._converter;
	}
	ValueExpression ve = getValueExpression("converter");
	if (ve != null) {
	    Converter value = null;
	    
	    try {
			value = (Converter) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setConverter(Converter _converter){
this._converter = _converter;
}

public String getConverterMessage(){
	if (this._converterMessage != null) {
		return this._converterMessage;
	}
	ValueExpression ve = getValueExpression("converterMessage");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setConverterMessage(String _converterMessage){
this._converterMessage = _converterMessage;
}

public String getCopyAllControlClass(){
	if (this._copyAllControlClass != null) {
		return this._copyAllControlClass;
	}
	ValueExpression ve = getValueExpression("copyAllControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setCopyAllControlClass(String _copyAllControlClass){
this._copyAllControlClass = _copyAllControlClass;
}

public String getCopyAllControlLabel(){
	if (this._copyAllControlLabel != null) {
		return this._copyAllControlLabel;
	}
	ValueExpression ve = getValueExpression("copyAllControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCopyAllControlLabel(String _copyAllControlLabel){
this._copyAllControlLabel = _copyAllControlLabel;
}

public String getCopyAllTitle(){
	if (this._copyAllTitle != null) {
		return this._copyAllTitle;
	}
	ValueExpression ve = getValueExpression("copyAllTitle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setCopyAllTitle(String _copyAllTitle){
this._copyAllTitle = _copyAllTitle;
}

public String getCopyControlClass(){
	if (this._copyControlClass != null) {
		return this._copyControlClass;
	}
	ValueExpression ve = getValueExpression("copyControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setCopyControlClass(String _copyControlClass){
this._copyControlClass = _copyControlClass;
}

public String getCopyControlLabel(){
	if (this._copyControlLabel != null) {
		return this._copyControlLabel;
	}
	ValueExpression ve = getValueExpression("copyControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCopyControlLabel(String _copyControlLabel){
this._copyControlLabel = _copyControlLabel;
}

public String getCopyTitle(){
	if (this._copyTitle != null) {
		return this._copyTitle;
	}
	ValueExpression ve = getValueExpression("copyTitle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setCopyTitle(String _copyTitle){
this._copyTitle = _copyTitle;
}

public String getDisabledControlClass(){
	if (this._disabledControlClass != null) {
		return this._disabledControlClass;
	}
	ValueExpression ve = getValueExpression("disabledControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setDisabledControlClass(String _disabledControlClass){
this._disabledControlClass = _disabledControlClass;
}

public String getDownControlClass(){
	if (this._downControlClass != null) {
		return this._downControlClass;
	}
	ValueExpression ve = getValueExpression("downControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setDownControlClass(String _downControlClass){
this._downControlClass = _downControlClass;
}

public String getDownControlLabel(){
	if (this._downControlLabel != null) {
		return this._downControlLabel;
	}
	ValueExpression ve = getValueExpression("downControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDownControlLabel(String _downControlLabel){
this._downControlLabel = _downControlLabel;
}

public String getDownTitle(){
	if (this._downTitle != null) {
		return this._downTitle;
	}
	ValueExpression ve = getValueExpression("downTitle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setDownTitle(String _downTitle){
this._downTitle = _downTitle;
}

public boolean isFastMoveControlsVisible(){
	if (this._fastMoveControlsVisibleSet) {
	    return (this._fastMoveControlsVisible);
	}
	ValueExpression ve = getValueExpression("fastMoveControlsVisible");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._fastMoveControlsVisible);
	    }
	    
	    return value;
	} else {
	    return (this._fastMoveControlsVisible);
	}

}

public void setFastMoveControlsVisible(boolean _fastMoveControlsVisible){
this._fastMoveControlsVisible = _fastMoveControlsVisible;
this._fastMoveControlsVisibleSet = true;
}

public boolean isFastOrderControlsVisible(){
	if (this._fastOrderControlsVisibleSet) {
	    return (this._fastOrderControlsVisible);
	}
	ValueExpression ve = getValueExpression("fastOrderControlsVisible");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._fastOrderControlsVisible);
	    }
	    
	    return value;
	} else {
	    return (this._fastOrderControlsVisible);
	}

}

public void setFastOrderControlsVisible(boolean _fastOrderControlsVisible){
this._fastOrderControlsVisible = _fastOrderControlsVisible;
this._fastOrderControlsVisibleSet = true;
}

public boolean isImmediate(){
	if (this._immediateSet) {
	    return (this._immediate);
	}
	ValueExpression ve = getValueExpression("immediate");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._immediate);
	    }
	    
	    return value;
	} else {
	    return (this._immediate);
	}

}

public void setImmediate(boolean _immediate){
this._immediate = _immediate;
this._immediateSet = true;
}

public String getLabel(){
	if (this._label != null) {
		return this._label;
	}
	ValueExpression ve = getValueExpression("label");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLabel(String _label){
this._label = _label;
}

public String getListClass(){
	if (this._listClass != null) {
		return this._listClass;
	}
	ValueExpression ve = getValueExpression("listClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setListClass(String _listClass){
this._listClass = _listClass;
}

public String getListsHeight(){
	if (this._listsHeight != null) {
		return this._listsHeight;
	}
	ValueExpression ve = getValueExpression("listsHeight");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "140";
	

}

public void setListsHeight(String _listsHeight){
this._listsHeight = _listsHeight;
}

public boolean isMoveControlsVisible(){
	if (this._moveControlsVisibleSet) {
	    return (this._moveControlsVisible);
	}
	ValueExpression ve = getValueExpression("moveControlsVisible");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._moveControlsVisible);
	    }
	    
	    return value;
	} else {
	    return (this._moveControlsVisible);
	}

}

public void setMoveControlsVisible(boolean _moveControlsVisible){
this._moveControlsVisible = _moveControlsVisible;
this._moveControlsVisibleSet = true;
}

public String getOnblur(){
	if (this._onblur != null) {
		return this._onblur;
	}
	ValueExpression ve = getValueExpression("onblur");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnblur(String _onblur){
this._onblur = _onblur;
}

public String getOnbottomclick(){
	if (this._onbottomclick != null) {
		return this._onbottomclick;
	}
	ValueExpression ve = getValueExpression("onbottomclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnbottomclick(String _onbottomclick){
this._onbottomclick = _onbottomclick;
}

public String getOnchange(){
	if (this._onchange != null) {
		return this._onchange;
	}
	ValueExpression ve = getValueExpression("onchange");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnchange(String _onchange){
this._onchange = _onchange;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOncopyallclick(){
	if (this._oncopyallclick != null) {
		return this._oncopyallclick;
	}
	ValueExpression ve = getValueExpression("oncopyallclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOncopyallclick(String _oncopyallclick){
this._oncopyallclick = _oncopyallclick;
}

public String getOncopyclick(){
	if (this._oncopyclick != null) {
		return this._oncopyclick;
	}
	ValueExpression ve = getValueExpression("oncopyclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOncopyclick(String _oncopyclick){
this._oncopyclick = _oncopyclick;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOndownclick(){
	if (this._ondownclick != null) {
		return this._ondownclick;
	}
	ValueExpression ve = getValueExpression("ondownclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOndownclick(String _ondownclick){
this._ondownclick = _ondownclick;
}

public String getOnfocus(){
	if (this._onfocus != null) {
		return this._onfocus;
	}
	ValueExpression ve = getValueExpression("onfocus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnfocus(String _onfocus){
this._onfocus = _onfocus;
}

public String getOnlistchange(){
	if (this._onlistchange != null) {
		return this._onlistchange;
	}
	ValueExpression ve = getValueExpression("onlistchange");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnlistchange(String _onlistchange){
this._onlistchange = _onlistchange;
}

public String getOnlistchanged(){
	if (this._onlistchanged != null) {
		return this._onlistchanged;
	}
	ValueExpression ve = getValueExpression("onlistchanged");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnlistchanged(String _onlistchanged){
this._onlistchanged = _onlistchanged;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnorderchange(){
	if (this._onorderchange != null) {
		return this._onorderchange;
	}
	ValueExpression ve = getValueExpression("onorderchange");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnorderchange(String _onorderchange){
this._onorderchange = _onorderchange;
}

public String getOnorderchanged(){
	if (this._onorderchanged != null) {
		return this._onorderchanged;
	}
	ValueExpression ve = getValueExpression("onorderchanged");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnorderchanged(String _onorderchanged){
this._onorderchanged = _onorderchanged;
}

public String getOnremoveallclick(){
	if (this._onremoveallclick != null) {
		return this._onremoveallclick;
	}
	ValueExpression ve = getValueExpression("onremoveallclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnremoveallclick(String _onremoveallclick){
this._onremoveallclick = _onremoveallclick;
}

public String getOnremoveclick(){
	if (this._onremoveclick != null) {
		return this._onremoveclick;
	}
	ValueExpression ve = getValueExpression("onremoveclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnremoveclick(String _onremoveclick){
this._onremoveclick = _onremoveclick;
}

public String getOntopclick(){
	if (this._ontopclick != null) {
		return this._ontopclick;
	}
	ValueExpression ve = getValueExpression("ontopclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOntopclick(String _ontopclick){
this._ontopclick = _ontopclick;
}

public String getOnupclick(){
	if (this._onupclick != null) {
		return this._onupclick;
	}
	ValueExpression ve = getValueExpression("onupclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnupclick(String _onupclick){
this._onupclick = _onupclick;
}

public boolean isOrderControlsVisible(){
	if (this._orderControlsVisibleSet) {
	    return (this._orderControlsVisible);
	}
	ValueExpression ve = getValueExpression("orderControlsVisible");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._orderControlsVisible);
	    }
	    
	    return value;
	} else {
	    return (this._orderControlsVisible);
	}

}

public void setOrderControlsVisible(boolean _orderControlsVisible){
this._orderControlsVisible = _orderControlsVisible;
this._orderControlsVisibleSet = true;
}

public String getRemoveAllControlClass(){
	if (this._removeAllControlClass != null) {
		return this._removeAllControlClass;
	}
	ValueExpression ve = getValueExpression("removeAllControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setRemoveAllControlClass(String _removeAllControlClass){
this._removeAllControlClass = _removeAllControlClass;
}

public String getRemoveAllControlLabel(){
	if (this._removeAllControlLabel != null) {
		return this._removeAllControlLabel;
	}
	ValueExpression ve = getValueExpression("removeAllControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setRemoveAllControlLabel(String _removeAllControlLabel){
this._removeAllControlLabel = _removeAllControlLabel;
}

public String getRemoveAllTitle(){
	if (this._removeAllTitle != null) {
		return this._removeAllTitle;
	}
	ValueExpression ve = getValueExpression("removeAllTitle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setRemoveAllTitle(String _removeAllTitle){
this._removeAllTitle = _removeAllTitle;
}

public String getRemoveControlClass(){
	if (this._removeControlClass != null) {
		return this._removeControlClass;
	}
	ValueExpression ve = getValueExpression("removeControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setRemoveControlClass(String _removeControlClass){
this._removeControlClass = _removeControlClass;
}

public String getRemoveControlLabel(){
	if (this._removeControlLabel != null) {
		return this._removeControlLabel;
	}
	ValueExpression ve = getValueExpression("removeControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setRemoveControlLabel(String _removeControlLabel){
this._removeControlLabel = _removeControlLabel;
}

public String getRemoveTitle(){
	if (this._removeTitle != null) {
		return this._removeTitle;
	}
	ValueExpression ve = getValueExpression("removeTitle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setRemoveTitle(String _removeTitle){
this._removeTitle = _removeTitle;
}

public boolean isRequired(){
	if (this._requiredSet) {
	    return (this._required);
	}
	ValueExpression ve = getValueExpression("required");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._required);
	    }
	    
	    return value;
	} else {
	    return (this._required);
	}

}

public void setRequired(boolean _required){
this._required = _required;
this._requiredSet = true;
}

public String getRequiredMessage(){
	if (this._requiredMessage != null) {
		return this._requiredMessage;
	}
	ValueExpression ve = getValueExpression("requiredMessage");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setRequiredMessage(String _requiredMessage){
this._requiredMessage = _requiredMessage;
}

public String getRowClasses(){
	if (this._rowClasses != null) {
		return this._rowClasses;
	}
	ValueExpression ve = getValueExpression("rowClasses");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setRowClasses(String _rowClasses){
this._rowClasses = _rowClasses;
}

public boolean isShowButtonLabels(){
	if (this._showButtonLabelsSet) {
	    return (this._showButtonLabels);
	}
	ValueExpression ve = getValueExpression("showButtonLabels");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._showButtonLabels);
	    }
	    
	    return value;
	} else {
	    return (this._showButtonLabels);
	}

}

public void setShowButtonLabels(boolean _showButtonLabels){
this._showButtonLabels = _showButtonLabels;
this._showButtonLabelsSet = true;
}

public String getSourceCaptionLabel(){
	if (this._sourceCaptionLabel != null) {
		return this._sourceCaptionLabel;
	}
	ValueExpression ve = getValueExpression("sourceCaptionLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSourceCaptionLabel(String _sourceCaptionLabel){
this._sourceCaptionLabel = _sourceCaptionLabel;
}

public String getSourceListWidth(){
	if (this._sourceListWidth != null) {
		return this._sourceListWidth;
	}
	ValueExpression ve = getValueExpression("sourceListWidth");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "140";
	

}

public void setSourceListWidth(String _sourceListWidth){
this._sourceListWidth = _sourceListWidth;
}

public boolean isSourceRequired(){
	if (this._sourceRequiredSet) {
	    return (this._sourceRequired);
	}
	ValueExpression ve = getValueExpression("sourceRequired");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._sourceRequired);
	    }
	    
	    return value;
	} else {
	    return (this._sourceRequired);
	}

}

public void setSourceRequired(boolean _sourceRequired){
this._sourceRequired = _sourceRequired;
this._sourceRequiredSet = true;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public boolean isSwitchByClick(){
	if (this._switchByClickSet) {
	    return (this._switchByClick);
	}
	ValueExpression ve = getValueExpression("switchByClick");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._switchByClick);
	    }
	    
	    return value;
	} else {
	    return (this._switchByClick);
	}

}

public void setSwitchByClick(boolean _switchByClick){
this._switchByClick = _switchByClick;
this._switchByClickSet = true;
}

public boolean isSwitchByDblClick(){
	if (this._switchByDblClickSet) {
	    return (this._switchByDblClick);
	}
	ValueExpression ve = getValueExpression("switchByDblClick");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._switchByDblClick);
	    }
	    
	    return value;
	} else {
	    return (this._switchByDblClick);
	}

}

public void setSwitchByDblClick(boolean _switchByDblClick){
this._switchByDblClick = _switchByDblClick;
this._switchByDblClickSet = true;
}

public String getTargetCaptionLabel(){
	if (this._targetCaptionLabel != null) {
		return this._targetCaptionLabel;
	}
	ValueExpression ve = getValueExpression("targetCaptionLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTargetCaptionLabel(String _targetCaptionLabel){
this._targetCaptionLabel = _targetCaptionLabel;
}

public String getTargetListWidth(){
	if (this._targetListWidth != null) {
		return this._targetListWidth;
	}
	ValueExpression ve = getValueExpression("targetListWidth");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "140";
	

}

public void setTargetListWidth(String _targetListWidth){
this._targetListWidth = _targetListWidth;
}

public boolean isTargetRequired(){
	if (this._targetRequiredSet) {
	    return (this._targetRequired);
	}
	ValueExpression ve = getValueExpression("targetRequired");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._targetRequired);
	    }
	    
	    return value;
	} else {
	    return (this._targetRequired);
	}

}

public void setTargetRequired(boolean _targetRequired){
this._targetRequired = _targetRequired;
this._targetRequiredSet = true;
}

public String getTopControlClass(){
	if (this._topControlClass != null) {
		return this._topControlClass;
	}
	ValueExpression ve = getValueExpression("topControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setTopControlClass(String _topControlClass){
this._topControlClass = _topControlClass;
}

public String getTopControlLabel(){
	if (this._topControlLabel != null) {
		return this._topControlLabel;
	}
	ValueExpression ve = getValueExpression("topControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTopControlLabel(String _topControlLabel){
this._topControlLabel = _topControlLabel;
}

public String getTopTitle(){
	if (this._topTitle != null) {
		return this._topTitle;
	}
	ValueExpression ve = getValueExpression("topTitle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setTopTitle(String _topTitle){
this._topTitle = _topTitle;
}

public String getUpControlClass(){
	if (this._upControlClass != null) {
		return this._upControlClass;
	}
	ValueExpression ve = getValueExpression("upControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setUpControlClass(String _upControlClass){
this._upControlClass = _upControlClass;
}

public String getUpControlLabel(){
	if (this._upControlLabel != null) {
		return this._upControlLabel;
	}
	ValueExpression ve = getValueExpression("upControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUpControlLabel(String _upControlLabel){
this._upControlLabel = _upControlLabel;
}

public String getUpTitle(){
	if (this._upTitle != null) {
		return this._upTitle;
	}
	ValueExpression ve = getValueExpression("upTitle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setUpTitle(String _upTitle){
this._upTitle = _upTitle;
}

public boolean isValid(){
return _valid;
}

public void setValid(boolean _valid){
this._valid = _valid;
this._validSet = true;
}

public String getValidatorMessage(){
	if (this._validatorMessage != null) {
		return this._validatorMessage;
	}
	ValueExpression ve = getValueExpression("validatorMessage");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setValidatorMessage(String _validatorMessage){
this._validatorMessage = _validatorMessage;
}

public MethodBinding getValueChangeListener(){
return _valueChangeListener;
}

public void setValueChangeListener(MethodBinding _valueChangeListener){
this._valueChangeListener = _valueChangeListener;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[88];
state[0] = super.saveState(context);
state[1] = _bottomControlClass;
state[2] = _bottomControlLabel;
state[3] = _bottomTitle;
state[4] = _columnClasses;
state[5] = _controlsType;
state[6] = _controlsVerticalAlign;
state[7] = saveAttachedState(context, _converter);
state[8] = _converterMessage;
state[9] = _copyAllControlClass;
state[10] = _copyAllControlLabel;
state[11] = _copyAllTitle;
state[12] = _copyControlClass;
state[13] = _copyControlLabel;
state[14] = _copyTitle;
state[15] = _disabledControlClass;
state[16] = _downControlClass;
state[17] = _downControlLabel;
state[18] = _downTitle;
state[19] = Boolean.valueOf(_fastMoveControlsVisible);
state[20] = Boolean.valueOf(_fastMoveControlsVisibleSet);
state[21] = Boolean.valueOf(_fastOrderControlsVisible);
state[22] = Boolean.valueOf(_fastOrderControlsVisibleSet);
state[23] = Boolean.valueOf(_immediate);
state[24] = Boolean.valueOf(_immediateSet);
state[25] = _label;
state[26] = _listClass;
state[27] = _listsHeight;
state[28] = Boolean.valueOf(_moveControlsVisible);
state[29] = Boolean.valueOf(_moveControlsVisibleSet);
state[30] = _onblur;
state[31] = _onbottomclick;
state[32] = _onchange;
state[33] = _onclick;
state[34] = _oncopyallclick;
state[35] = _oncopyclick;
state[36] = _ondblclick;
state[37] = _ondownclick;
state[38] = _onfocus;
state[39] = _onlistchange;
state[40] = _onlistchanged;
state[41] = _onmousemove;
state[42] = _onmouseout;
state[43] = _onmouseover;
state[44] = _onorderchange;
state[45] = _onorderchanged;
state[46] = _onremoveallclick;
state[47] = _onremoveclick;
state[48] = _ontopclick;
state[49] = _onupclick;
state[50] = Boolean.valueOf(_orderControlsVisible);
state[51] = Boolean.valueOf(_orderControlsVisibleSet);
state[52] = _removeAllControlClass;
state[53] = _removeAllControlLabel;
state[54] = _removeAllTitle;
state[55] = _removeControlClass;
state[56] = _removeControlLabel;
state[57] = _removeTitle;
state[58] = Boolean.valueOf(_required);
state[59] = Boolean.valueOf(_requiredSet);
state[60] = _requiredMessage;
state[61] = _rowClasses;
state[62] = Boolean.valueOf(_showButtonLabels);
state[63] = Boolean.valueOf(_showButtonLabelsSet);
state[64] = _sourceCaptionLabel;
state[65] = _sourceListWidth;
state[66] = Boolean.valueOf(_sourceRequired);
state[67] = Boolean.valueOf(_sourceRequiredSet);
state[68] = _style;
state[69] = _styleClass;
state[70] = Boolean.valueOf(_switchByClick);
state[71] = Boolean.valueOf(_switchByClickSet);
state[72] = Boolean.valueOf(_switchByDblClick);
state[73] = Boolean.valueOf(_switchByDblClickSet);
state[74] = _targetCaptionLabel;
state[75] = _targetListWidth;
state[76] = Boolean.valueOf(_targetRequired);
state[77] = Boolean.valueOf(_targetRequiredSet);
state[78] = _topControlClass;
state[79] = _topControlLabel;
state[80] = _topTitle;
state[81] = _upControlClass;
state[82] = _upControlLabel;
state[83] = _upTitle;
state[84] = Boolean.valueOf(_valid);
state[85] = Boolean.valueOf(_validSet);
state[86] = _validatorMessage;
state[87] = saveAttachedState(context, _valueChangeListener);
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_bottomControlClass = (String)states[1];;
		_bottomControlLabel = (String)states[2];;
		_bottomTitle = (String)states[3];;
		_columnClasses = (String)states[4];;
		_controlsType = (String)states[5];;
		_controlsVerticalAlign = (String)states[6];;
		_converter = (Converter)restoreAttachedState(context, states[7]);
		_converterMessage = (String)states[8];;
		_copyAllControlClass = (String)states[9];;
		_copyAllControlLabel = (String)states[10];;
		_copyAllTitle = (String)states[11];;
		_copyControlClass = (String)states[12];;
		_copyControlLabel = (String)states[13];;
		_copyTitle = (String)states[14];;
		_disabledControlClass = (String)states[15];;
		_downControlClass = (String)states[16];;
		_downControlLabel = (String)states[17];;
		_downTitle = (String)states[18];;
		_fastMoveControlsVisible = ((Boolean)states[19]).booleanValue();
		_fastMoveControlsVisibleSet = ((Boolean)states[20]).booleanValue();
		_fastOrderControlsVisible = ((Boolean)states[21]).booleanValue();
		_fastOrderControlsVisibleSet = ((Boolean)states[22]).booleanValue();
		_immediate = ((Boolean)states[23]).booleanValue();
		_immediateSet = ((Boolean)states[24]).booleanValue();
		_label = (String)states[25];;
		_listClass = (String)states[26];;
		_listsHeight = (String)states[27];;
		_moveControlsVisible = ((Boolean)states[28]).booleanValue();
		_moveControlsVisibleSet = ((Boolean)states[29]).booleanValue();
		_onblur = (String)states[30];;
		_onbottomclick = (String)states[31];;
		_onchange = (String)states[32];;
		_onclick = (String)states[33];;
		_oncopyallclick = (String)states[34];;
		_oncopyclick = (String)states[35];;
		_ondblclick = (String)states[36];;
		_ondownclick = (String)states[37];;
		_onfocus = (String)states[38];;
		_onlistchange = (String)states[39];;
		_onlistchanged = (String)states[40];;
		_onmousemove = (String)states[41];;
		_onmouseout = (String)states[42];;
		_onmouseover = (String)states[43];;
		_onorderchange = (String)states[44];;
		_onorderchanged = (String)states[45];;
		_onremoveallclick = (String)states[46];;
		_onremoveclick = (String)states[47];;
		_ontopclick = (String)states[48];;
		_onupclick = (String)states[49];;
		_orderControlsVisible = ((Boolean)states[50]).booleanValue();
		_orderControlsVisibleSet = ((Boolean)states[51]).booleanValue();
		_removeAllControlClass = (String)states[52];;
		_removeAllControlLabel = (String)states[53];;
		_removeAllTitle = (String)states[54];;
		_removeControlClass = (String)states[55];;
		_removeControlLabel = (String)states[56];;
		_removeTitle = (String)states[57];;
		_required = ((Boolean)states[58]).booleanValue();
		_requiredSet = ((Boolean)states[59]).booleanValue();
		_requiredMessage = (String)states[60];;
		_rowClasses = (String)states[61];;
		_showButtonLabels = ((Boolean)states[62]).booleanValue();
		_showButtonLabelsSet = ((Boolean)states[63]).booleanValue();
		_sourceCaptionLabel = (String)states[64];;
		_sourceListWidth = (String)states[65];;
		_sourceRequired = ((Boolean)states[66]).booleanValue();
		_sourceRequiredSet = ((Boolean)states[67]).booleanValue();
		_style = (String)states[68];;
		_styleClass = (String)states[69];;
		_switchByClick = ((Boolean)states[70]).booleanValue();
		_switchByClickSet = ((Boolean)states[71]).booleanValue();
		_switchByDblClick = ((Boolean)states[72]).booleanValue();
		_switchByDblClickSet = ((Boolean)states[73]).booleanValue();
		_targetCaptionLabel = (String)states[74];;
		_targetListWidth = (String)states[75];;
		_targetRequired = ((Boolean)states[76]).booleanValue();
		_targetRequiredSet = ((Boolean)states[77]).booleanValue();
		_topControlClass = (String)states[78];;
		_topControlLabel = (String)states[79];;
		_topTitle = (String)states[80];;
		_upControlClass = (String)states[81];;
		_upControlLabel = (String)states[82];;
		_upTitle = (String)states[83];;
		_valid = ((Boolean)states[84]).booleanValue();
		_validSet = ((Boolean)states[85]).booleanValue();
		_validatorMessage = (String)states[86];;
		_valueChangeListener = (MethodBinding)restoreAttachedState(context, states[87]);
	
}

}
