/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.html.ProgressBarStateEncoder;

enum ProgressBarState {
    initialState{

        @Override
        public String getStateClientId(FacesContext context, UIComponent component) {
            return component.getClientId(context) + ".init";
        }

        @Override
        public String getStyleClass(FacesContext context, UIComponent component) {
            return HtmlUtil.concatClasses("rf-pb-init", component.getAttributes().get("initialClass"));
        }

        @Override
        public void encodeContent(FacesContext context, UIComponent component) throws IOException {
            component.getFacet("initial").encodeAll(context);
        }

        @Override
        public boolean hasContent(FacesContext context, UIComponent component) {
            UIComponent facet = component.getFacet("initial");
            return facet != null && facet.isRendered();
        }

        @Override
        public void encodeStateForMetaComponent(FacesContext context, UIComponent component, ProgressBarStateEncoder encoder) throws IOException {
            encoder.encodeInitialState(context, component, this);
        }
    }
    ,
    progressState{

        @Override
        public String getStateClientId(FacesContext context, UIComponent component) {
            return component.getClientId(context) + ".lbl";
        }

        @Override
        public String getStyleClass(FacesContext context, UIComponent component) {
            return "rf-pb-lbl";
        }

        @Override
        public void encodeContent(FacesContext context, UIComponent component) throws IOException {
            Object label;
            ResponseWriter responseWriter = context.getResponseWriter();
            if (component.getChildCount() > 0) {
                for (UIComponent child : component.getChildren()) {
                    child.encodeAll(context);
                }
            }
            if ((label = component.getAttributes().get("label")) != null) {
                responseWriter.writeText(label, null);
            }
        }

        @Override
        public boolean hasContent(FacesContext context, UIComponent component) {
            return true;
        }

        @Override
        public void encodeStateForMetaComponent(FacesContext context, UIComponent component, ProgressBarStateEncoder encoder) throws IOException {
            encoder.encodeProgressStateContent(context, component, this);
        }
    }
    ,
    finishState{

        @Override
        public String getStateClientId(FacesContext context, UIComponent component) {
            return component.getClientId(context) + ".fin";
        }

        @Override
        public String getStyleClass(FacesContext context, UIComponent component) {
            return HtmlUtil.concatClasses("rf-pb-fin", component.getAttributes().get("finishClass"));
        }

        @Override
        public void encodeContent(FacesContext context, UIComponent component) throws IOException {
            UIComponent facet = component.getFacet("finish");
            if (facet != null) {
                facet.encodeAll(context);
            }
        }

        @Override
        public boolean hasContent(FacesContext context, UIComponent component) {
            UIComponent facet = component.getFacet("finish");
            return facet != null && facet.isRendered();
        }

        @Override
        public void encodeStateForMetaComponent(FacesContext context, UIComponent component, ProgressBarStateEncoder encoder) throws IOException {
            encoder.encodeCompleteState(context, component, this);
        }
    };


    public abstract String getStateClientId(FacesContext var1, UIComponent var2);

    public abstract String getStyleClass(FacesContext var1, UIComponent var2);

    public abstract void encodeContent(FacesContext var1, UIComponent var2) throws IOException;

    public abstract boolean hasContent(FacesContext var1, UIComponent var2);

    public abstract void encodeStateForMetaComponent(FacesContext var1, UIComponent var2, ProgressBarStateEncoder var3) throws IOException;
}

