package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIContextMenu;

public class ContextMenu extends UIContextMenu{

final public static  String COMPONENT_FAMILY = "org.richfaces.ContextMenu";

final public static  String COMPONENT_TYPE = "org.richfaces.ContextMenu";

/*
* Defines the timing when the menu is attached to the target element. Default value is "onavailable".
*/
private  String _attachTiming = null;

/*
* Client identifier of the component or id of the existing DOM element that is a source
				for a given event. If attachTo is defined, the event is attached on the client according
				to the AttachTiming attribute.
				If both attached and attachTo attributes are defined, and attribute attached has value
				'false', it is considered to have higher priority.
*/
private  String _attachTo = null;

/*
* If the value of the "attached" attribute is true, the component is attached to the component,
                specified in the "attachTo" attribute or to the parent component,
                if "attachTo" is not defined.  Default value is "true".
*/
private  boolean _attached = true;

private  boolean _attachedSet = false;

/*
* Forbids default handling for adjusted event. Default value "true".
*/
private  boolean _disableDefaultMenu = true;

private  boolean _disableDefaultMenuSet = false;

/*
* Space-separated list of CSS style class(es) that are be applied to disabled item of this component
*/
private  String _disabledItemClass = null;

/*
* CSS style(s) is/are to be applied to disabled item when this component is rendered.
*/
private  String _disabledItemStyle = null;

/*
* Defines an event on the parent element to display  the menu. Default value is  "oncontextmenu".
*/
private  String _event = null;

/*
* Delay between losing focus and menu closing. Default value is "800".
*/
private  Integer _hideDelay = null;

/*
* Space-separated list of CSS style class(es) that are be applied to item of this component
*/
private  String _itemClass = null;

/*
* CSS style(s) is/are to be applied to item when this component is rendered.
*/
private  String _itemStyle = null;

/*
* Event must occurs on menu closure
*/
private  String _oncollapse = null;

/*
* Event must occurs on menu opening
*/
private  String _onexpand = null;

/*
* HTML: script expression; some group was activated
*/
private  String _ongroupactivate = null;

/*
* HTML: script expression; some item was selected
*/
private  String _onitemselect = null;

/*
* HTML: script expression; a pointer was moved within
*/
private  String _onmousemove = null;

/*
* HTML: script expression; a pointer was moved away
*/
private  String _onmouseout = null;

/*
* HTML: script expression; a pointer was moved onto
*/
private  String _onmouseover = null;

/*
* Set minimal width for the all of the lists that will appear
*/
private  String _popupWidth = null;

/*
* Space-separated list of CSS style class(es) that are be applied to selected item of this component.
*/
private  String _selectItemClass = null;

/*
* CSS style(s) is/are to be applied to selected item when this component is rendered.
*/
private  String _selectItemStyle = null;

/*
* Delay between event and menu showing. Default value is "50".
*/
private  Integer _showDelay = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* Sets the submission mode for all menu items of the menu except
                those where this attribute redefined. Possible value are "ajax","server", "none". Default value is "server".
*/
private  String _submitMode = null;


public ContextMenu(){
setRendererType("org.richfaces.DropDownMenuRenderer");
}

public String getAttachTiming(){
	if (this._attachTiming != null) {
		return this._attachTiming;
	}
	ValueExpression ve = getValueExpression("attachTiming");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "onavailable";
	

}

public void setAttachTiming(String _attachTiming){
this._attachTiming = _attachTiming;
}

public String getAttachTo(){
	if (this._attachTo != null) {
		return this._attachTo;
	}
	ValueExpression ve = getValueExpression("attachTo");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setAttachTo(String _attachTo){
this._attachTo = _attachTo;
}

public boolean isAttached(){
	if (this._attachedSet) {
	    return (this._attached);
	}
	ValueExpression ve = getValueExpression("attached");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._attached);
	    }
	    
	    return value;
	} else {
	    return (this._attached);
	}

}

public void setAttached(boolean _attached){
this._attached = _attached;
this._attachedSet = true;
}

public boolean isDisableDefaultMenu(){
	if (this._disableDefaultMenuSet) {
	    return (this._disableDefaultMenu);
	}
	ValueExpression ve = getValueExpression("disableDefaultMenu");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._disableDefaultMenu);
	    }
	    
	    return value;
	} else {
	    return (this._disableDefaultMenu);
	}

}

public void setDisableDefaultMenu(boolean _disableDefaultMenu){
this._disableDefaultMenu = _disableDefaultMenu;
this._disableDefaultMenuSet = true;
}

public String getDisabledItemClass(){
	if (this._disabledItemClass != null) {
		return this._disabledItemClass;
	}
	ValueExpression ve = getValueExpression("disabledItemClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setDisabledItemClass(String _disabledItemClass){
this._disabledItemClass = _disabledItemClass;
}

public String getDisabledItemStyle(){
	if (this._disabledItemStyle != null) {
		return this._disabledItemStyle;
	}
	ValueExpression ve = getValueExpression("disabledItemStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setDisabledItemStyle(String _disabledItemStyle){
this._disabledItemStyle = _disabledItemStyle;
}

public String getEvent(){
	if (this._event != null) {
		return this._event;
	}
	ValueExpression ve = getValueExpression("event");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "oncontextmenu";
	

}

public void setEvent(String _event){
this._event = _event;
}

public Integer getHideDelay(){
	if (this._hideDelay != null) {
		return this._hideDelay;
	}
	ValueExpression ve = getValueExpression("hideDelay");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return new Integer(800);
	

}

public void setHideDelay(Integer _hideDelay){
this._hideDelay = _hideDelay;
}

public String getItemClass(){
	if (this._itemClass != null) {
		return this._itemClass;
	}
	ValueExpression ve = getValueExpression("itemClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setItemClass(String _itemClass){
this._itemClass = _itemClass;
}

public String getItemStyle(){
	if (this._itemStyle != null) {
		return this._itemStyle;
	}
	ValueExpression ve = getValueExpression("itemStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setItemStyle(String _itemStyle){
this._itemStyle = _itemStyle;
}

public String getOncollapse(){
	if (this._oncollapse != null) {
		return this._oncollapse;
	}
	ValueExpression ve = getValueExpression("oncollapse");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOncollapse(String _oncollapse){
this._oncollapse = _oncollapse;
}

public String getOnexpand(){
	if (this._onexpand != null) {
		return this._onexpand;
	}
	ValueExpression ve = getValueExpression("onexpand");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnexpand(String _onexpand){
this._onexpand = _onexpand;
}

public String getOngroupactivate(){
	if (this._ongroupactivate != null) {
		return this._ongroupactivate;
	}
	ValueExpression ve = getValueExpression("ongroupactivate");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOngroupactivate(String _ongroupactivate){
this._ongroupactivate = _ongroupactivate;
}

public String getOnitemselect(){
	if (this._onitemselect != null) {
		return this._onitemselect;
	}
	ValueExpression ve = getValueExpression("onitemselect");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnitemselect(String _onitemselect){
this._onitemselect = _onitemselect;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getPopupWidth(){
	if (this._popupWidth != null) {
		return this._popupWidth;
	}
	ValueExpression ve = getValueExpression("popupWidth");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setPopupWidth(String _popupWidth){
this._popupWidth = _popupWidth;
}

public String getSelectItemClass(){
	if (this._selectItemClass != null) {
		return this._selectItemClass;
	}
	ValueExpression ve = getValueExpression("selectItemClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setSelectItemClass(String _selectItemClass){
this._selectItemClass = _selectItemClass;
}

public String getSelectItemStyle(){
	if (this._selectItemStyle != null) {
		return this._selectItemStyle;
	}
	ValueExpression ve = getValueExpression("selectItemStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSelectItemStyle(String _selectItemStyle){
this._selectItemStyle = _selectItemStyle;
}

public Integer getShowDelay(){
	if (this._showDelay != null) {
		return this._showDelay;
	}
	ValueExpression ve = getValueExpression("showDelay");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return new Integer(50);
	

}

public void setShowDelay(Integer _showDelay){
this._showDelay = _showDelay;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getSubmitMode(){
	if (this._submitMode != null) {
		return this._submitMode;
	}
	ValueExpression ve = getValueExpression("submitMode");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "server";
	

}

public void setSubmitMode(String _submitMode){
this._submitMode = _submitMode;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[27];
state[0] = super.saveState(context);
state[1] = _attachTiming;
state[2] = _attachTo;
state[3] = Boolean.valueOf(_attached);
state[4] = Boolean.valueOf(_attachedSet);
state[5] = Boolean.valueOf(_disableDefaultMenu);
state[6] = Boolean.valueOf(_disableDefaultMenuSet);
state[7] = _disabledItemClass;
state[8] = _disabledItemStyle;
state[9] = _event;
state[10] = _hideDelay;
state[11] = _itemClass;
state[12] = _itemStyle;
state[13] = _oncollapse;
state[14] = _onexpand;
state[15] = _ongroupactivate;
state[16] = _onitemselect;
state[17] = _onmousemove;
state[18] = _onmouseout;
state[19] = _onmouseover;
state[20] = _popupWidth;
state[21] = _selectItemClass;
state[22] = _selectItemStyle;
state[23] = _showDelay;
state[24] = _style;
state[25] = _styleClass;
state[26] = _submitMode;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_attachTiming = (String)states[1];;
		_attachTo = (String)states[2];;
		_attached = ((Boolean)states[3]).booleanValue();
		_attachedSet = ((Boolean)states[4]).booleanValue();
		_disableDefaultMenu = ((Boolean)states[5]).booleanValue();
		_disableDefaultMenuSet = ((Boolean)states[6]).booleanValue();
		_disabledItemClass = (String)states[7];;
		_disabledItemStyle = (String)states[8];;
		_event = (String)states[9];;
		_hideDelay = (Integer)states[10];;
		_itemClass = (String)states[11];;
		_itemStyle = (String)states[12];;
		_oncollapse = (String)states[13];;
		_onexpand = (String)states[14];;
		_ongroupactivate = (String)states[15];;
		_onitemselect = (String)states[16];;
		_onmousemove = (String)states[17];;
		_onmouseout = (String)states[18];;
		_onmouseover = (String)states[19];;
		_popupWidth = (String)states[20];;
		_selectItemClass = (String)states[21];;
		_selectItemStyle = (String)states[22];;
		_showDelay = (Integer)states[23];;
		_style = (String)states[24];;
		_styleClass = (String)states[25];;
		_submitMode = (String)states[26];;
	
}

}
