/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.resource.InternetResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.UIScrollableDataTable;
import org.richfaces.component.util.ColumnUtil;
import org.richfaces.event.scroll.ScrollEvent;
import org.richfaces.event.sort.SortEvent;
import org.richfaces.model.SortField;
import org.richfaces.model.SortOrder;
import org.richfaces.renderkit.CompositeRenderer;
import org.richfaces.renderkit.RendererContributor;
import org.richfaces.renderkit.ScriptOptions;
import org.richfaces.renderkit.html.AjaxFunctionBuilder;
import org.richfaces.renderkit.html.ColumnVisitor;
import org.richfaces.renderkit.html.ColumnWalker;
import org.richfaces.renderkit.html.ExtendedColumnVisitor;
import org.richfaces.renderkit.html.HTMLEncodingContributor;
import org.richfaces.renderkit.html.ScrollableDataTableOptions;
import org.richfaces.renderkit.html.ScrollableDataTableRendererState;
import org.richfaces.renderkit.html.ScrollableDataTableScrollData;
import org.richfaces.renderkit.html.ScrollableDataTableUtils;
import org.richfaces.renderkit.html.SelectionRendererContributor;
import org.richfaces.utils.TemplateLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScrollableDataTableBaseRenderer
extends HeaderResourcesRendererBase {
    public static final String PARTIAL_UPDATE = "partialUpdate";
    public static final String UPDATE_HEADER = "updateHeader";
    public static final String FOOTER_PART = "footer";
    public static final String HEADER_PART = "header";
    private static final String COLUMN_FROZEN_TYPE = "frozen";
    private static final String COLUMN_NORMAL_TYPE = "normal";
    private static final String PERSENTAGE_SUPPORT_ERROR_MSG = "columnsWidth property: Percentage values are not supported";
    private RendererBase cellTemplate = null;
    private RendererBase headerCellTemplate = null;
    private RendererBase footerCellTemplate = null;
    private RendererBase headerItselfTemplate = null;
    private CompositeRendererEnabler composite = new CompositeRendererEnabler();
    private final Log log = LogFactory.getLog(ScrollableDataTableBaseRenderer.class);
    private final ColumnVisitor columnsWidthCounter = new ColumnVisitor(){

        public int visit(FacesContext context, UIComponent column, ResponseWriter writer, ScrollableDataTableRendererState state) throws IOException {
            int prevWidth = 0;
            int width = 0;
            String widthPx = ScrollableDataTableBaseRenderer.this.getColumnWidth(column);
            widthPx = ScrollableDataTableBaseRenderer.this.getFormattedWidth(widthPx);
            prevWidth = state.getSumWidth();
            width = prevWidth + Integer.parseInt(widthPx);
            state.setSumWidth(width);
            return 1;
        }
    };
    private final ColumnVisitor headerCellRenderer = new ExtendedColumnVisitor(){

        public void renderContent(FacesContext context, UIComponent column, ResponseWriter writer, ScrollableDataTableRendererState state) throws IOException {
            int cell_index = state.getCellIndex();
            String client_id = state.getClientId();
            state.addId(column.getId());
            ScrollableDataTableBaseRenderer.this.headerCellTemplate = ScrollableDataTableBaseRenderer.this.getHeaderCellTemplate();
            ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)ScrollableDataTableBaseRenderer.this.headerCellTemplate, (UIComponent)column);
            String widthPx = ScrollableDataTableBaseRenderer.this.getColumnWidth(column);
            widthPx = ScrollableDataTableBaseRenderer.this.getFormattedWidth(widthPx);
            int width = Integer.parseInt(widthPx);
            int sepOffset = 0;
            if (state.isFrozenColumn()) {
                sepOffset = state.getSepOffset() + width;
            } else {
                sepOffset = state.getSepOffset() + width + 1;
                state.setSepOffset(new Integer(sepOffset));
            }
            variables.setVariable("client_id", (Object)client_id);
            variables.setVariable("cell_index", (Object)new Integer(cell_index));
            variables.setVariable("sepOffset", (Object)new Integer(sepOffset));
            variables.setVariable("headerColumnClass", (Object)state.getColumnClass());
            variables.setVariable("columnWidth", (Object)width);
            Boolean sorting = ScrollableDataTableBaseRenderer.this.getColumnSorting(state.getGrid(), column.getId());
            if (sorting != null) {
                if (sorting.booleanValue()) {
                    variables.setVariable("headerColumnSortClass", (Object)"rich-sdt-header-sort-up");
                } else {
                    variables.setVariable("headerColumnSortClass", (Object)"rich-sdt-header-sort-down");
                }
            }
            ScrollableDataTableBaseRenderer.this.headerCellTemplate.encodeBegin(context, column);
            ScrollableDataTableBaseRenderer.this.headerRenderer.visit(context, column, writer, state);
            ScrollableDataTableBaseRenderer.this.headerCellTemplate.encodeEnd(context, column);
        }
    };
    private final ColumnVisitor headerRenderer = new ColumnVisitor(){

        public int visit(FacesContext context, UIComponent column, ResponseWriter writer, ScrollableDataTableRendererState state) throws IOException {
            ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)ScrollableDataTableBaseRenderer.this.getHeaderItselfTemplate(), (UIComponent)column);
            int cell_index = state.getCellIndex();
            String client_id = state.getClientId();
            Boolean sorting = ScrollableDataTableBaseRenderer.this.getColumnSorting(state.getGrid(), column.getId());
            if (sorting != null) {
                if (sorting.booleanValue()) {
                    variables.setVariable("sortAscending", (Object)Boolean.TRUE);
                } else {
                    variables.setVariable("sortDescending", (Object)Boolean.TRUE);
                }
            }
            variables.setVariable("client_id", (Object)client_id);
            variables.setVariable("cell_index", (Object)new Integer(cell_index));
            ScrollableDataTableBaseRenderer.this.getHeaderItselfTemplate().encodeBegin(context, column);
            UIComponent header = column.getFacet(ScrollableDataTableBaseRenderer.HEADER_PART);
            if (header != null) {
                ScrollableDataTableBaseRenderer.this.renderChild(context, header);
            }
            ScrollableDataTableBaseRenderer.this.getHeaderItselfTemplate().encodeEnd(context, column);
            return 0;
        }
    };
    private final ColumnVisitor footerCellRenderer = new ExtendedColumnVisitor(){

        public void renderContent(FacesContext context, UIComponent column, ResponseWriter writer, ScrollableDataTableRendererState state) throws IOException {
            UIComponent component;
            int cell_index = state.getCellIndex();
            String client_id = state.getClientId();
            ScrollableDataTableBaseRenderer.this.footerCellTemplate = ScrollableDataTableBaseRenderer.this.getFooterCellTemplate();
            ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)ScrollableDataTableBaseRenderer.this.footerCellTemplate, (UIComponent)column);
            variables.setVariable("client_id", (Object)client_id);
            variables.setVariable("cell_index", (Object)new Integer(cell_index));
            variables.setVariable("footerColumnClass", (Object)state.getColumnClass());
            Boolean sorting = ScrollableDataTableBaseRenderer.this.getColumnSorting(state.getGrid(), column.getId());
            if (sorting != null) {
                if (sorting.booleanValue()) {
                    variables.setVariable("footerColumnSortClass", (Object)"rich-sdt-footer-sort-up");
                } else {
                    variables.setVariable("footerColumnSortClass", (Object)"rich-sdt-footer-sort-down");
                }
            }
            if ((component = column.getFacet(ScrollableDataTableBaseRenderer.FOOTER_PART)) != null) {
                ScrollableDataTableBaseRenderer.this.footerCellTemplate.encodeBegin(context, column);
                ScrollableDataTableBaseRenderer.this.renderChild(context, component);
                ScrollableDataTableBaseRenderer.this.footerCellTemplate.encodeEnd(context, column);
            }
        }
    };
    private final ColumnVisitor cellRenderer = new ExtendedColumnVisitor(){

        public void renderContent(FacesContext context, UIComponent column, ResponseWriter writer, ScrollableDataTableRendererState state) throws IOException {
            String cell_id = state.getRowIndex() + "_" + state.getCellIndex();
            if (ScrollableDataTableBaseRenderer.this.log.isTraceEnabled()) {
                ScrollableDataTableBaseRenderer.this.log.trace((Object)("cell_index: " + cell_id));
            }
            String client_id = state.getClientId();
            int cell_index = state.getCellIndex();
            ScrollableDataTableBaseRenderer.this.cellTemplate = ScrollableDataTableBaseRenderer.this.getCellTemplate();
            ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)ScrollableDataTableBaseRenderer.this.cellTemplate, (UIComponent)column);
            variables.setVariable("cell_id", (Object)cell_id);
            variables.setVariable("client_id", (Object)client_id);
            variables.setVariable("cell_index", (Object)new Integer(cell_index));
            variables.setVariable("columnClass", (Object)state.getColumnClass());
            Boolean sorting = ScrollableDataTableBaseRenderer.this.getColumnSorting(state.getGrid(), column.getId());
            if (sorting != null) {
                if (sorting.booleanValue()) {
                    variables.setVariable("columnSortClass", (Object)"rich-sdt-column-sort-up");
                } else {
                    variables.setVariable("columnSortClass", (Object)"rich-sdt-column-sort-down");
                }
            }
            ScrollableDataTableBaseRenderer.this.cellTemplate.encodeBegin(context, column);
            if (!state.isFake()) {
                ScrollableDataTableBaseRenderer.this.renderChildren(context, column);
            }
            ScrollableDataTableBaseRenderer.this.cellTemplate.encodeEnd(context, column);
        }
    };
    private final DataVisitor rowsRenderer = new DataVisitor(){

        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
            ScrollableDataTableRendererState state = (ScrollableDataTableRendererState)argument;
            UIScrollableDataTable grid = state.getGrid();
            grid.setRowKey(rowKey);
            if (grid.isRowAvailable() || state.isFake()) {
                int index = state.getRowIndex();
                String baseClientId = grid.getBaseClientId(context);
                String row_id = state.isFrozenPart() ? baseClientId + ":f:" + index : baseClientId + ":n:" + index;
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement("tr", (UIComponent)grid);
                state.setFrozenColumnCount(ScrollableDataTableUtils.getFrozenColumnsCount(grid));
                ScrollableDataTableBaseRenderer.this.getUtils().writeAttribute(writer, "id", (Object)row_id);
                ScrollableDataTableBaseRenderer.this.getUtils().writeAttribute(writer, "class", (Object)("dr-sdt-rb rich-sdt-row " + state.getRowClass()));
                ScrollableDataTableBaseRenderer.this.addRowJavascriptEvents(writer, (UIComponent)grid);
                if (ScrollableDataTableBaseRenderer.this.log.isDebugEnabled()) {
                    ScrollableDataTableBaseRenderer.this.log.debug((Object)("rowIndex : " + index));
                }
                ColumnWalker.iterateOverColumns(context, (UIComponent)grid, ScrollableDataTableBaseRenderer.this.cellRenderer, writer, state);
                if (!state.isFrozenPart()) {
                    writer.startElement("td", (UIComponent)grid);
                    ScrollableDataTableBaseRenderer.this.getUtils().writeAttribute(writer, "class", (Object)("dr-sdt-bc dr-sdt-c-f rich-sdt-column-cell " + state.getColumnClass(state.getCellIndex())));
                    writer.startElement("div", (UIComponent)grid);
                    ScrollableDataTableBaseRenderer.this.getUtils().writeAttribute(writer, "class", (Object)"dr-sdt-cbody");
                    writer.endElement("div");
                    writer.endElement("td");
                }
                writer.endElement("tr");
                state.nextRow();
                state.setCellIndex(0);
            }
        }
    };
    private final DataVisitor ajaxRowsRenderer = new DataVisitor(){

        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
            int columnsCount = 0;
            boolean frozenTRRendered = false;
            boolean normalTRRendered = false;
            ScrollableDataTableRendererState state = (ScrollableDataTableRendererState)argument;
            AjaxContext ajaxContext = state.getAjaxContext();
            ajaxContext.getResponseData();
            UIScrollableDataTable grid = state.getGrid();
            Collection<String> collection = grid.getResponseData();
            grid.setRowKey(rowKey);
            ResponseWriter writer = context.getResponseWriter();
            state.setFrozenColumnCount(ScrollableDataTableUtils.getFrozenColumnsCount(grid));
            String row_id = null;
            String baseClientId = grid.getBaseClientId(context);
            for (UIComponent kid : grid.getChildren()) {
                if (!kid.isRendered() || !(kid instanceof UIColumn)) continue;
                if (state.isFrozenColumn() && !frozenTRRendered && state.getFrozenColumnCount() > 0) {
                    state.setFrozenPart(true);
                    frozenTRRendered = true;
                    row_id = baseClientId + ":f:" + state.getRowIndex();
                    writer.startElement("tr", (UIComponent)grid);
                    ScrollableDataTableBaseRenderer.this.getUtils().writeAttribute(writer, "class", (Object)("dr-sdt-rb rich-sdt-row " + state.getRowClass()));
                    ScrollableDataTableBaseRenderer.this.getUtils().writeAttribute(writer, "id", (Object)row_id);
                    ScrollableDataTableBaseRenderer.this.addRowJavascriptEvents(writer, (UIComponent)grid);
                    collection.add(row_id);
                } else if (!state.isFrozenColumn() && !normalTRRendered) {
                    this.writeNormalTr(frozenTRRendered, state, grid, collection, writer, baseClientId);
                    normalTRRendered = true;
                }
                columnsCount += ScrollableDataTableBaseRenderer.this.cellRenderer.visit(context, kid, writer, state);
                state.nextCell();
            }
            if (!normalTRRendered) {
                this.writeNormalTr(frozenTRRendered, state, grid, collection, writer, baseClientId);
            }
            writer.startElement("td", (UIComponent)grid);
            ScrollableDataTableBaseRenderer.this.getUtils().writeAttribute(writer, "class", (Object)("dr-sdt-bc dr-sdt-c-f rich-sdt-column-cell " + state.getColumnClass(state.getCellIndex())));
            writer.startElement("div", (UIComponent)grid);
            ScrollableDataTableBaseRenderer.this.getUtils().writeAttribute(writer, "class", (Object)"dr-sdt-cbody");
            writer.endElement("div");
            writer.endElement("td");
            writer.endElement("tr");
            state.setCellIndex(0);
            state.nextRow();
        }

        private void writeNormalTr(boolean frozenTRRendered, ScrollableDataTableRendererState state, UIScrollableDataTable grid, Collection<String> collection, ResponseWriter writer, String baseClientId) throws IOException {
            if (frozenTRRendered) {
                writer.endElement("tr");
            }
            state.setFrozenPart(false);
            String row_id = baseClientId + ":n:" + state.getRowIndex();
            writer.startElement("tr", (UIComponent)grid);
            ScrollableDataTableBaseRenderer.this.getUtils().writeAttribute(writer, "id", (Object)row_id);
            ScrollableDataTableBaseRenderer.this.getUtils().writeAttribute(writer, "class", (Object)("dr-sdt-rb rich-sdt-row " + state.getRowClass()));
            ScrollableDataTableBaseRenderer.this.addRowJavascriptEvents(writer, (UIComponent)grid);
            collection.add(row_id);
        }
    };

    protected InternetResource[] getScripts() {
        return this.composite.getScripts();
    }

    protected InternetResource[] getStyles() {
        return this.composite.getStyles();
    }

    public String getFormattedWidth(String receivedWidth) throws IOException {
        String formattedWidth = receivedWidth;
        if (formattedWidth.endsWith("%")) {
            throw new FacesException(PERSENTAGE_SUPPORT_ERROR_MSG);
        }
        if (formattedWidth.endsWith("px")) {
            formattedWidth = formattedWidth.substring(0, formattedWidth.indexOf("px"));
        }
        return formattedWidth;
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return UIScrollableDataTable.class;
    }

    public static String getJavaScriptVarName(FacesContext context, UIScrollableDataTable grid) {
        String name = grid.getScriptVar();
        if (name == null) {
            String id = grid.getBaseClientId(context);
            name = "Richfaces_ScrollableGrid_" + id.replaceAll("[^A-Za-z0-9_]", "_");
        }
        return "window." + name;
    }

    public String createClientScrollableGrid(FacesContext context, UIScrollableDataTable grid) {
        ScrollableDataTableOptions options = new ScrollableDataTableOptions(grid);
        this.composite.mergeScriptOptions(options, context, (UIComponent)grid);
        JSFunction function = new JSFunction("new ClientUI.controls.grid.ScrollableGrid", new Object[0]);
        function.addParameter((Object)options);
        return function.toScript();
    }

    protected String getScriptContributions(FacesContext context, UIScrollableDataTable grid) {
        return this.composite.getScriptContributions(ScrollableDataTableBaseRenderer.getJavaScriptVarName(context, grid), context, (UIComponent)grid);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void renderGridBody(FacesContext context, UIScrollableDataTable grid, boolean isFrozen) throws IOException {
        ScrollableDataTableRendererState state = ScrollableDataTableRendererState.getRendererState(context);
        if (isFrozen) {
            state.setColumType(COLUMN_FROZEN_TYPE);
        } else {
            state.setColumType(COLUMN_NORMAL_TYPE);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"ScrollableDataTableBaseRenderer.renderGridBody(context, grid, isFrozen)");
        }
        state.setFrozenColumnCount(ScrollableDataTableUtils.getFrozenColumnsCount(grid));
        state.setFrozenPart(isFrozen);
        state.setClientId(grid.getClientId(context));
        if (!isFrozen || state.getFrozenColumnCount() > 0) {
            grid.walk(context, this.rowsRenderer, state);
            int fakeRowsCount = grid.getRows() - grid.getRowCount();
            state.setFake(true);
            for (int i = 0; i < fakeRowsCount; ++i) {
                this.rowsRenderer.process(context, null, (Object)state);
            }
            state.setFake(false);
        }
        state.setRowIndex(0);
        grid.setRowKey(null);
    }

    public void renderHeaders(FacesContext context, UIScrollableDataTable grid, boolean isFrozen) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ScrollableDataTableRendererState state = ScrollableDataTableRendererState.getRendererState(context);
        if (isFrozen) {
            state.setColumType(COLUMN_FROZEN_TYPE);
        } else {
            state.setColumType(COLUMN_NORMAL_TYPE);
        }
        state.setClientId(grid.getClientId(context));
        state.setPart(HEADER_PART);
        state.setFrozenColumnCount(ScrollableDataTableUtils.getFrozenColumnsCount(grid));
        state.setFrozenPart(isFrozen);
        state.setClientId(grid.getClientId(context));
        state.setSepOffset(new Integer(0));
        ColumnWalker.iterateOverColumns(context, (UIComponent)grid, this.headerCellRenderer, writer, state);
    }

    public void renderFooters(FacesContext context, UIScrollableDataTable grid, boolean isFrozen) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ScrollableDataTableRendererState state = ScrollableDataTableRendererState.getRendererState(context);
        if (isFrozen) {
            state.setColumType(COLUMN_FROZEN_TYPE);
        } else {
            state.setColumType(COLUMN_NORMAL_TYPE);
        }
        state.setClientId(grid.getClientId(context));
        state.setFrozenColumnCount(ScrollableDataTableUtils.getFrozenColumnsCount(grid));
        state.setFrozenPart(isFrozen);
        int colsCount = ColumnWalker.iterateOverColumns(context, (UIComponent)grid, this.footerCellRenderer, writer, state);
        int rowsCount = grid.getRowCount();
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)grid);
        variables.setVariable("rows_count", (Object)new Integer(rowsCount));
        variables.setVariable("columns_count", (Object)new Integer(colsCount));
    }

    public void setUpState(FacesContext context, UIScrollableDataTable grid) {
        ScrollableDataTableRendererState.createState(context, grid);
    }

    public void tearDownState(FacesContext context, UIScrollableDataTable grid) {
        ScrollableDataTableRendererState.restoreState(context);
    }

    public String getRowsAjaxUpdate(FacesContext context, UIScrollableDataTable grid) {
        JSFunction function = AjaxRendererUtils.buildAjaxFunction((UIComponent)grid, (FacesContext)context);
        Map options = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)grid);
        options.put("oncomplete", AjaxFunctionBuilder.getOnComplete(context, grid, 1));
        Map parametersMap = (Map)options.get("parameters");
        parametersMap.put(grid.getBaseClientId(context) + ":scroll", "");
        function.addParameter((Object)options);
        String completeFunction = function.toScript() + "; return false;";
        return completeFunction;
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        this.composite.decode(context, component);
        component.getAttributes().remove(PARTIAL_UPDATE);
        component.getAttributes().remove(UPDATE_HEADER);
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        if (component instanceof UIScrollableDataTable) {
            String submitedState;
            UIScrollableDataTable grid = (UIScrollableDataTable)component;
            ExternalContext externalContext = context.getExternalContext();
            String clientId = grid.getClientId(context);
            boolean sorted = false;
            Map parameters = externalContext.getRequestParameterMap();
            String s_id = clientId + ":si";
            grid.resetReqRowsCount();
            if (parameters.containsKey(s_id)) {
                String options = (String)parameters.get(s_id);
                grid.setScrollPos(options);
                if (options.length() > 0) {
                    grid.setFirst(Integer.parseInt(options.split(",")[1]));
                }
            }
            if (parameters.containsKey(clientId + ":sortColumn") && parameters.containsKey(clientId + ":sortStartRow") && parameters.containsKey(clientId + ":sortIndex")) {
                UIComponent column;
                String sortColumn = (String)parameters.get(clientId + ":sortColumn");
                int sortDataIndex = Integer.parseInt((String)parameters.get(clientId + ":sortIndex"));
                Integer sortStartRow = Integer.valueOf((String)parameters.get(clientId + ":sortStartRow"));
                String sortOrderString = (String)parameters.get(clientId + ":sortOrder");
                Boolean so = null;
                if (sortOrderString != null && sortOrderString.length() > 0) {
                    if ((sortOrderString = sortOrderString.toLowerCase()).startsWith("a")) {
                        so = Boolean.TRUE;
                    } else if (sortOrderString.startsWith("d")) {
                        so = Boolean.FALSE;
                    }
                }
                if (ColumnUtil.isSortable((UIComponent)(column = grid.findComponent(sortColumn)))) {
                    sorted = true;
                    SortEvent sortEvent = new SortEvent((UIComponent)grid, sortColumn, grid.getRows(), sortDataIndex);
                    sortEvent.setProposedOrder(so);
                    sortEvent.setAttribute("clientIndex", (Object)sortStartRow);
                    if (ajaxContext.isAjaxRequest()) {
                        sortEvent.setAttribute(PARTIAL_UPDATE, (Object)Boolean.TRUE);
                        sortEvent.setAttribute(UPDATE_HEADER, (Object)Boolean.TRUE);
                    }
                    sortEvent.queue();
                }
            }
            if (parameters.containsKey(clientId + ":scroll") && !sorted && (submitedState = (String)parameters.get(clientId + "_state_input")) != null) {
                boolean isEmpty = true;
                String[] values = submitedState.split(",");
                for (int i = 0; i < values.length; ++i) {
                    isEmpty = isEmpty && values[i].equals("");
                }
                int rows = 0;
                int first = 0;
                if (!isEmpty) {
                    rows = Integer.parseInt(values[0]);
                    first = Integer.parseInt(values[1]);
                    ScrollEvent scrollEvent = new ScrollEvent((UIComponent)grid, rows, first);
                    scrollEvent.setAttribute("clientIndex", (Object)Integer.valueOf(values[2]));
                    if (ajaxContext.isAjaxRequest()) {
                        scrollEvent.setAttribute(PARTIAL_UPDATE, (Object)Boolean.TRUE);
                    }
                    scrollEvent.queue();
                }
            }
        }
    }

    public void renderAjaxChildren(FacesContext context, UIComponent component) throws IOException {
        UIScrollableDataTable grid = (UIScrollableDataTable)component;
        ScrollableDataTableRendererState state = ScrollableDataTableRendererState.createState(context, grid);
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        String client_id = grid.getClientId(context);
        state.setClientId(client_id);
        state.setAjaxContext(ajaxContext);
        state.setRowIndex(ScrollableDataTableUtils.getClientRowIndex(grid));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ScrollableDataTableBaseRenderer.renderAjaxChildren()");
        }
        grid.getResponseData().clear();
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("table", (UIComponent)grid);
        writer.startElement("tbody", (UIComponent)grid);
        grid.walk(context, this.ajaxRowsRenderer, state);
        int fakeRowsCount = grid.getRows() - grid.getRowCount();
        ScrollableDataTableRendererState.restoreState(context);
        grid.setRowKey(null);
        state.setFake(true);
        for (int i = 0; i < fakeRowsCount; ++i) {
            this.ajaxRowsRenderer.process(context, null, (Object)state);
        }
        state.setFake(false);
        writer.endElement("tbody");
        writer.endElement("table");
        String id = client_id + "_rows_input";
        writer.startElement("input", (UIComponent)grid);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("value", (Object)grid.getRowCount(), null);
        writer.endElement("input");
        ajaxContext.addRenderedArea(id);
        this.renderHiddenScrollInput(context, grid);
        ajaxContext.addRenderedArea(client_id + ":si");
        ajaxContext.setResponseData(grid.getResponseData());
        ajaxContext.getAjaxRenderedAreas().remove(grid.getClientId(context));
        ScrollableDataTableScrollData options = this.createOptions(grid);
        ajaxContext.getResponseDataMap().put("options", options);
        this.contributorsEncodeHere(context, grid);
        if (this.shouldUpdateHeader(component)) {
            ColumnWalker.iterateOverColumns(context, component, this.headerRenderer, writer, new ScrollableDataTableRendererState(context, null, grid));
        }
    }

    private ScrollableDataTableScrollData createOptions(UIScrollableDataTable grid) {
        int index = grid.getFirst();
        int startRow = ScrollableDataTableUtils.getClientRowIndex(grid);
        int count = grid.getRows() == 0 ? grid.getRowCount() : grid.getRows();
        ScrollableDataTableScrollData options = new ScrollableDataTableScrollData(index, startRow, count);
        return options;
    }

    private boolean onlyPartialUpdateNeeded(UIComponent grid) {
        Boolean b = (Boolean)grid.getAttributes().get(PARTIAL_UPDATE);
        return b != null && b != false && AjaxContext.getCurrentInstance().isAjaxRequest();
    }

    private boolean shouldUpdateHeader(UIComponent grid) {
        Boolean b = (Boolean)grid.getAttributes().get(UPDATE_HEADER);
        return b != null && b != false && AjaxContext.getCurrentInstance().isAjaxRequest();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (this.onlyPartialUpdateNeeded(component)) {
            this.renderAjaxChildren(context, component);
        } else {
            super.encodeChildren(context, component);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (component instanceof UIScrollableDataTable) {
            UIScrollableDataTable grid = (UIScrollableDataTable)component;
            this.setUpState(context, grid);
        }
        if (!this.onlyPartialUpdateNeeded(component)) {
            super.encodeBegin(context, component);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (component instanceof UIScrollableDataTable && !this.onlyPartialUpdateNeeded(component)) {
            super.encodeEnd(context, component);
        }
    }

    public void setUpColumnsWidth(FacesContext context, UIScrollableDataTable grid) throws IOException {
        ScrollableDataTableRendererState state = ScrollableDataTableRendererState.getRendererState(context);
        state.setFrozenColumnCount(ScrollableDataTableUtils.getFrozenColumnsCount(grid));
        ColumnWalker.iterateOverColumns(context, (UIComponent)grid, this.columnsWidthCounter, null, state);
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)grid);
        int sumWidth = state.getSumWidth() + 200;
        variables.setVariable("sumWidth", (Object)new Integer(sumWidth));
    }

    private RendererBase getCellTemplate() {
        if (this.cellTemplate == null) {
            this.cellTemplate = TemplateLoader.loadTemplate("org.richfaces.renderkit.html.ScrollableDataTableCellRenderer");
        }
        return this.cellTemplate;
    }

    private RendererBase getHeaderCellTemplate() {
        if (this.headerCellTemplate == null) {
            this.headerCellTemplate = TemplateLoader.loadTemplate("org.richfaces.renderkit.html.ScrollableDataTableHeaderCellRenderer");
        }
        return this.headerCellTemplate;
    }

    private RendererBase getFooterCellTemplate() {
        if (this.footerCellTemplate == null) {
            this.footerCellTemplate = TemplateLoader.loadTemplate("org.richfaces.renderkit.html.ScrollableDataTableFooterCellRenderer");
        }
        return this.footerCellTemplate;
    }

    private RendererBase getHeaderItselfTemplate() {
        if (this.headerItselfTemplate == null) {
            this.headerItselfTemplate = TemplateLoader.loadTemplate("org.richfaces.renderkit.html.ScrollableDataTableHeaderItselfRenderer");
        }
        return this.headerItselfTemplate;
    }

    public void renderHiddenScrollInput(FacesContext context, UIScrollableDataTable grid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = grid.getClientId(context) + ":si";
        writer.startElement("input", (UIComponent)grid);
        this.getUtils().writeAttribute(writer, "type", (Object)"hidden");
        this.getUtils().writeAttribute(writer, "name", (Object)id);
        this.getUtils().writeAttribute(writer, "id", (Object)id);
        this.getUtils().writeAttribute(writer, "value", (Object)grid.getScrollPos());
        writer.endElement("input");
    }

    public void contributorsEncodeHere(FacesContext context, UIScrollableDataTable grid) throws IOException {
        RendererContributor[] contribs = this.composite.getContributors();
        if (contribs != null) {
            for (int i = 0; i < contribs.length; ++i) {
                RendererContributor rendererContributor = contribs[i];
                if (!(rendererContributor instanceof HTMLEncodingContributor)) continue;
                ((HTMLEncodingContributor)rendererContributor).encode(context, (UIComponent)grid);
            }
        }
    }

    private void addRowJavascriptEvents(ResponseWriter writer, UIComponent component) {
        String attribute = (String)component.getAttributes().get("onRowClick");
        if (attribute != null) {
            try {
                this.getUtils().writeAttribute(writer, "onclick", (Object)attribute);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((attribute = (String)component.getAttributes().get("onRowMouseDown")) != null) {
            try {
                this.getUtils().writeAttribute(writer, "onmousedown", (Object)attribute);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((attribute = (String)component.getAttributes().get("onRowMouseUp")) != null) {
            try {
                this.getUtils().writeAttribute(writer, "onmouseup", (Object)attribute);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((attribute = (String)component.getAttributes().get("onRowDblClick")) != null) {
            try {
                this.getUtils().writeAttribute(writer, "ondblclick", (Object)attribute);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Boolean getColumnSorting(UIScrollableDataTable grid, String sortColumn) {
        SortField[] sortFields;
        Boolean sorting = null;
        UIComponent column = grid.findComponent(sortColumn);
        String name = ColumnUtil.getColumnSorting((UIComponent)column);
        SortOrder sortOrder = grid.getSortOrder();
        if (sortOrder != null && (sortFields = sortOrder.getFields()) != null) {
            for (int i = 0; i < sortFields.length && sorting == null; ++i) {
                SortField sortField = sortFields[i];
                if (name == null || !name.equals(sortField.getName())) continue;
                sorting = sortField.getAscending();
            }
        }
        return sorting;
    }

    private String getColumnWidth(UIComponent column) {
        String width = (String)column.getAttributes().get("width");
        if (width == null) {
            width = "100px";
        }
        return width;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompositeRendererEnabler
    extends CompositeRenderer {
        public CompositeRendererEnabler() {
            this.addContributor(new SelectionRendererContributor());
        }

        protected Class<? extends UIComponent> getComponentClass() {
            return ScrollableDataTableBaseRenderer.this.getComponentClass();
        }

        public void mergeScriptOptions(ScriptOptions scriptOptions, FacesContext context, UIComponent component) {
            super.mergeScriptOptions(scriptOptions, context, component);
        }

        public String getScriptContributions(String varString, FacesContext context, UIComponent component) {
            return super.getScriptContributions(varString, context, component);
        }

        public RendererContributor[] getContributors() {
            return super.getContributors();
        }

        public InternetResource[] getScripts() {
            return super.getScripts();
        }

        public InternetResource[] getStyles() {
            return super.getStyles();
        }
    }
}

