/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.UIModalPanel;
import org.richfaces.renderkit.InputRendererBase;

public class ModalPanelRendererBase
extends InputRendererBase {
    private static final int sizeA = 10;
    private static final int DEFAULT_WIDTH = 300;
    private static final int DEFAULT_HEIGHT = 200;
    private static final String STATE_OPTION_SUFFIX = "StateOption_";
    protected static final String[] RESIZERS = new String[]{"N", "E", "S", "W", "NWU", "NEU", "NEL", "SEU", "SEL", "SWL", "SWU", "NWL"};
    private static final Set<String> ALLOWED_ATTACHMENT_OPTIONS = new HashSet<String>();

    protected void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        UIModalPanel panel = (UIModalPanel)component;
        ExternalContext exCtx = context.getExternalContext();
        Map rqMap = exCtx.getRequestParameterMap();
        Object panelOpenState = rqMap.get(panel.getClientId(context) + "OpenedState");
        if (panel.isKeepVisualState() && null != panelOpenState) {
            boolean showWhenRendered = panel.isShowWhenRendered() || Boolean.parseBoolean((String)panelOpenState);
            panel.setShowWhenRendered(showWhenRendered);
            Map visualOptions = (Map)panel.getVisualOptions();
            for (Map.Entry entry : rqMap.entrySet()) {
                int suffixPos = ((String)entry.getKey()).toString().indexOf(STATE_OPTION_SUFFIX);
                if (-1 == suffixPos) continue;
                String key = ((String)entry.getKey()).toString().substring(suffixPos + STATE_OPTION_SUFFIX.length());
                visualOptions.put(key, entry.getValue());
            }
        }
    }

    protected Class getComponentClass() {
        return UIModalPanel.class;
    }

    public void checkOptions(FacesContext context, UIModalPanel panel) {
        if (panel.isAutosized() && panel.isResizeable()) {
            throw new IllegalArgumentException("Autosized modal panel can't be resizeable.");
        }
        String domElementAttachment = panel.getDomElementAttachment();
        if (domElementAttachment != null && domElementAttachment.trim().length() != 0 && !ALLOWED_ATTACHMENT_OPTIONS.contains(domElementAttachment)) {
            throw new IllegalArgumentException("Value '" + domElementAttachment + "' of domElementAttachment attribute is illegal. " + "Allowed values are: " + ALLOWED_ATTACHMENT_OPTIONS);
        }
        if (panel.getMinHeight() != -1 && panel.getMinHeight() < 10) {
            throw new IllegalArgumentException();
        }
        if (panel.getMinWidth() != -1 && panel.getMinWidth() < 10) {
            throw new IllegalArgumentException();
        }
    }

    public void initializeResources(FacesContext context, UIModalPanel panel) throws IOException {
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)panel);
        String onshow = ScriptUtils.toScript(panel.getAttributes().get("onshow"));
        variables.setVariable("onshow", (Object)onshow);
        String onhide = ScriptUtils.toScript(panel.getAttributes().get("onhide"));
        variables.setVariable("onhide", (Object)onhide);
        String onbeforeshow = ScriptUtils.toScript(panel.getAttributes().get("onbeforeshow"));
        variables.setVariable("onbeforeshow", (Object)onbeforeshow);
        String onbeforehide = ScriptUtils.toScript(panel.getAttributes().get("onbeforehide"));
        variables.setVariable("onbeforehide", (Object)onbeforehide);
        String onmove = ScriptUtils.toScript(panel.getAttributes().get("onmove"));
        variables.setVariable("onmove", (Object)onmove);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public String getShowScript(FacesContext context, UIModalPanel panel) {
        StringBuffer result = new StringBuffer();
        if (panel.isShowWhenRendered()) {
            result.append("Richfaces.showModalPanel('" + panel.getClientId(context) + "', {");
            Iterator it = ((Map)panel.getVisualOptions()).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                result.append((String)entry.getKey() + ": '" + entry.getValue() + "'");
                if (!it.hasNext()) continue;
                result.append(", ");
            }
            result.append("});");
        }
        return result.toString();
    }

    public void writeEventHandlerFunction(FacesContext context, UIComponent component, String eventName) throws IOException {
        RendererUtils.writeEventHandlerFunction((FacesContext)context, (UIComponent)component, (String)eventName);
    }

    public void writeVisualOptions(FacesContext context, UIModalPanel panel) throws IOException {
        StringBuffer result = new StringBuffer();
        ResponseWriter writer = context.getResponseWriter();
        Iterator it = ((Map)panel.getVisualOptions()).entrySet().iterator();
        if (it.hasNext()) {
            result.append(",\n");
        }
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            result.append((String)entry.getKey() + ": '" + entry.getValue() + "'");
            if (!it.hasNext()) continue;
            result.append(",\n");
        }
        writer.writeText((Object)result, null);
    }

    static {
        ALLOWED_ATTACHMENT_OPTIONS.add("body");
        ALLOWED_ATTACHMENT_OPTIONS.add("parent");
        ALLOWED_ATTACHMENT_OPTIONS.add("form");
    }
}

