/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.el;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELBuilder {
    Log log = LogFactory.getLog(ELBuilder.class);
    String[] orig;
    StringBuffer res = new StringBuffer();
    int l;
    String var;
    String index;
    String varReplacement;
    String indexReplacement;
    int varL;
    int indexL;
    boolean isLiteral;
    String postFix;

    public ELBuilder(String orig, String var, String index, String varR, String indexR) {
        this.orig = orig.split("#");
        this.var = var;
        this.index = index;
        this.varReplacement = varR;
        this.indexReplacement = indexR;
        this.varL = var.length();
        this.indexL = index.length();
    }

    public String parse() {
        try {
            for (String s : this.orig) {
                if (s == null || s.trim().length() <= 0) continue;
                String trim = this.trimEL(s);
                if (!this.isLiteral) {
                    this.l = trim.length();
                    this.res.append("#{");
                    this.internalParse(trim);
                    this.res.append("}");
                    this.res.append(this.postFix);
                    continue;
                }
                this.res.append(s);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error occured during ValueExpression parsing. Keep old expression. " + e));
            this.res.append(this.orig);
        }
        return this.res.toString();
    }

    public static ValueExpression createValueExpression(String expr, Class<?> expectedType, ExpressionFactory factory, ELContext elContext, String var, String index, String varR, String indexR) {
        ELBuilder builder = new ELBuilder(expr, var, index, varR, indexR);
        String newExpr = builder.parse();
        return factory.createValueExpression(elContext, newExpr, expectedType);
    }

    private String trimEL(String orig) {
        int end = orig.lastIndexOf("}");
        if (orig.startsWith("{") && end != -1) {
            this.isLiteral = false;
            this.postFix = end + 1 < orig.length() ? orig.substring(end + 1) : "";
            return orig.substring(1, end);
        }
        this.isLiteral = true;
        return orig;
    }

    public static String getVarReplacement(String expr) {
        int start = 0;
        int end = 0;
        int l = expr.length();
        boolean f = false;
        boolean f2 = true;
        for (int i = 0; i < l; ++i) {
            char c = expr.charAt(i);
            if (c == '#') {
                f = true;
                continue;
            }
            if (c == '}') {
                end = i;
                continue;
            }
            if (c != '{' || !f || !f2) continue;
            start = i + 1 < l ? i + 1 : i;
            f2 = false;
        }
        return end > start ? expr.substring(start, end) : null;
    }

    private int internalParse(String s) {
        char firstVar = this.var.charAt(0);
        char firstIndex = this.index.charAt(0);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == firstIndex) {
                i = this.parseIndex(s, i, c);
                continue;
            }
            if (c == firstVar) {
                i = this.parseVar(s, i, c);
                continue;
            }
            if (this.isQuote(Character.valueOf(c))) {
                i = this.parseString(s, i, c);
                continue;
            }
            this.res.append(c);
        }
        return 0;
    }

    private int parseIndex(String s, int i, char c) {
        if (s.indexOf(this.index, i) == i) {
            Character after;
            Character before = i != 0 ? Character.valueOf(s.charAt(i - 1)) : null;
            Character c2 = after = i + this.indexL < this.l ? Character.valueOf(s.charAt(i + this.indexL)) : null;
            if (this.isIndex(Character.valueOf(c), before, after)) {
                this.res.append(this.indexReplacement);
                return i + this.indexL - 1;
            }
            this.res.append(c);
            return i++;
        }
        this.res.append(c);
        return i;
    }

    private int parseVar(String s, int i, char c) {
        if (s.indexOf(this.var, i) == i) {
            Character after;
            Character before = i != 0 ? Character.valueOf(s.charAt(i - 1)) : null;
            Character c2 = after = i + this.varL < this.l ? Character.valueOf(s.charAt(i + this.varL)) : null;
            if (this.isVar(Character.valueOf(c), before, after)) {
                this.res.append(this.varReplacement);
                return i + this.varL - 1;
            }
            this.res.append(c);
            return i++;
        }
        this.res.append(c);
        return i;
    }

    private int parseString(String s, int i, char c) {
        int j;
        this.res.append(s.charAt(i));
        for (j = i++; j < this.l && !this.isQuote(Character.valueOf(s.charAt(j))); ++j) {
            this.res.append(s.charAt(j));
        }
        return j;
    }

    private boolean isIndex(Character c, Character before, Character after) {
        boolean ret;
        boolean bl = ret = before == null || Character.isWhitespace(before.charValue()) || this.isMath(before) || before.charValue() == '[' || before.charValue() == '(' || before.charValue() == '{';
        if (ret) {
            ret = after == null || Character.isWhitespace(after.charValue()) || this.isMath(after) || after.charValue() == ']' || before.charValue() == ')' || before.charValue() == '}';
        }
        return ret;
    }

    private boolean isVar(Character c, Character before, Character after) {
        boolean ret;
        boolean bl = ret = before == null || Character.isWhitespace(before.charValue()) || before.charValue() == '(' || before.charValue() == '{';
        if (ret) {
            ret = after == null || Character.isWhitespace(after.charValue()) || after.charValue() == ')' || after.charValue() == '(' || after.charValue() == ']' || after.charValue() == '[' || after.charValue() == '.';
        }
        return ret;
    }

    private boolean isMath(Character c) {
        return c.charValue() == '+' || c.charValue() == '*' || c.charValue() == '-' || c.charValue() == '/' || c.charValue() == '%' || c.charValue() == '(' || c.charValue() == ')';
    }

    private boolean isQuote(Character c) {
        return c.charValue() == '\'' || c.charValue() == '\"';
    }
}

