/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.ContextCallback;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.StateHolder;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.render.Renderer;
import org.ajax4jsf.component.AjaxDataEncoder;
import org.ajax4jsf.component.IterationStateHolder;
import org.ajax4jsf.model.DataComponentState;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.ExtendedDataModel;
import org.ajax4jsf.model.SerializableDataModel;
import org.ajax4jsf.renderkit.AjaxChildrenRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIDataAdaptor
extends UIData
implements AjaxDataEncoder {
    public static final String COMPONENT_STATE_ATTRIBUTE = "componentState";
    public static final DataModel EMPTY_MODEL = new ListDataModel(Collections.EMPTY_LIST);
    private static final Log _log = LogFactory.getLog(UIDataAdaptor.class);
    protected ComponentVisitor decodeVisitor = new ComponentVisitor(){

        public void processComponent(FacesContext context, UIComponent c, Object argument) {
            c.processDecodes(context);
        }
    };
    protected ComponentVisitor validateVisitor = new ComponentVisitor(){

        public void processComponent(FacesContext context, UIComponent c, Object argument) {
            c.processValidators(context);
        }
    };
    protected ComponentVisitor updateVisitor = new ComponentVisitor(){

        public void processComponent(FacesContext context, UIComponent c, Object argument) {
            c.processUpdates(context);
        }
    };
    private Set<String> _encoded;
    private Map<String, ExtendedDataModel> _modelsMap = new HashMap<String, ExtendedDataModel>();
    private ExtendedDataModel _currentModel = null;
    private Map<String, DataComponentState> _statesMap = new HashMap<String, DataComponentState>();
    private DataComponentState _currentState = null;
    private String _stateVar;
    private String _rowKeyVar;
    private Object _rowKey = null;
    private Converter _rowKeyConverter = null;
    private Set<Object> _ajaxKeys = null;
    private Set<Object> _ajaxRequestKeys = null;
    private Object _ajaxRowKey = null;
    private Map<String, Object> _ajaxRowKeysMap = new HashMap<String, Object>();
    private static final AjaxChildrenRenderer _childrenRenderer = new AjaxChildrenRenderer(){

        @Override
        protected Class<? extends UIComponent> getComponentClass() {
            return UIDataAdaptor.class;
        }
    };
    private String _clientId = null;
    private String _baseClientId = null;
    private Object origValue;
    private Map<String, Map<String, SavedState>> childState;
    private static final SavedState NullState = new SavedState();

    public String getStateVar() {
        return this._stateVar;
    }

    public void setStateVar(String varStatus) {
        this._stateVar = varStatus;
    }

    public String getRowKeyVar() {
        return this._rowKeyVar;
    }

    public void setRowKeyVar(String rowKeyVar) {
        this._rowKeyVar = rowKeyVar;
    }

    public int getRowCount() {
        return this.getExtendedDataModel().getRowCount();
    }

    public Object getRowData() {
        return this.getExtendedDataModel().getRowData();
    }

    public boolean isRowAvailable() {
        return this.getExtendedDataModel().isRowAvailable();
    }

    public void setRowIndex(int index) {
        FacesContext faces = FacesContext.getCurrentInstance();
        ExtendedDataModel localModel = this.getExtendedDataModel();
        boolean rowAvailable = this.isRowAvailable();
        this.saveChildState(faces);
        localModel.setRowIndex(index);
        rowAvailable = this.isRowAvailable();
        this._rowKey = localModel.getRowKey();
        this._clientId = null;
        boolean rowSelected = this._rowKey != null && rowAvailable;
        this.setupVariable(faces, (DataModel)localModel, rowSelected);
        this.restoreChildState(faces);
    }

    public int getRowIndex() {
        return this.getExtendedDataModel().getRowIndex();
    }

    public Object getRowKey() {
        return this._rowKey;
    }

    public void setRowKey(Object key) {
        this.setRowKey(FacesContext.getCurrentInstance(), key);
    }

    public void setRowKey(FacesContext faces, Object key) {
        ExtendedDataModel localModel = this.getExtendedDataModel();
        boolean rowAvailable = this.isRowAvailable();
        this.saveChildState(faces);
        this._rowKey = key;
        this._clientId = null;
        localModel.setRowKey(key);
        rowAvailable = this.isRowAvailable();
        boolean rowSelected = key != null && rowAvailable;
        this.setupVariable(faces, (DataModel)localModel, rowSelected);
        this.restoreChildState(faces);
    }

    public Converter getRowKeyConverter() {
        ValueExpression ve;
        Converter converter = this._rowKeyConverter;
        if (null == converter && null != (ve = this.getValueExpression("rowKeyConverter"))) {
            converter = (Converter)ve.getValue(this.getFacesContext().getELContext());
        }
        return converter;
    }

    public void setRowKeyConverter(Converter rowKeyConverter) {
        this._rowKeyConverter = rowKeyConverter;
    }

    public Set<Object> getAjaxKeys() {
        HashSet<Object> keys = null;
        if (this._ajaxKeys != null) {
            keys = this._ajaxKeys;
        } else {
            ValueExpression vb = this.getValueExpression("ajaxKeys");
            if (vb != null) {
                keys = (HashSet<Object>)vb.getValue(this.getFacesContext().getELContext());
            } else if (null != this._ajaxRowKey) {
                keys = new HashSet<Object>(1);
                keys.add(this._ajaxRowKey);
            }
        }
        return keys;
    }

    public Set<Object> getAllAjaxKeys() {
        Set<Object> ajaxKeys = this.getAjaxKeys();
        HashSet<Object> allAjaxKeys = null;
        if (ajaxKeys != null) {
            allAjaxKeys = new HashSet<Object>();
            allAjaxKeys.addAll(ajaxKeys);
        }
        if (this._ajaxRequestKeys != null) {
            if (allAjaxKeys == null) {
                allAjaxKeys = new HashSet();
            }
            allAjaxKeys.addAll(this._ajaxRequestKeys);
        }
        return allAjaxKeys;
    }

    public void setAjaxKeys(Set<Object> ajaxKeys) {
        this._ajaxKeys = ajaxKeys;
    }

    public void encodeAjaxChild(FacesContext context, String path, final Set<String> ids, final Set<String> renderedAreas) throws IOException {
        Renderer renderer = this.getRenderer(context);
        if (null != renderer && renderer instanceof AjaxChildrenRenderer) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Component " + this.getClientId(context) + " has delegated Encode children components by AjaxChildrenRenderer for path " + path));
            }
            AjaxChildrenRenderer childrenRenderer = (AjaxChildrenRenderer)renderer;
            childrenRenderer.encodeAjaxChildren(context, (UIComponent)this, path, ids, renderedAreas);
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Component " + this.getClientId(context) + "  do Encode children components  for path " + path));
            }
            final AjaxChildrenRenderer childrenRenderer = this.getChildrenRenderer();
            final String childrenPath = path + this.getId() + ':';
            ComponentVisitor ajaxVisitor = new ComponentVisitor(){

                public void processComponent(FacesContext context, UIComponent c, Object argument) throws IOException {
                    childrenRenderer.encodeAjaxComponent(context, c, childrenPath, ids, renderedAreas);
                }
            };
            Set<Object> ajaxKeys = this.getAllAjaxKeys();
            if (null != ajaxKeys) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Component " + this.getClientId(context) + "  Encode children components for a keys " + ajaxKeys));
                }
                this.captureOrigValue();
                Object savedKey = this.getRowKey();
                this.setRowKey(context, null);
                Iterator<UIComponent> fixedChildren = this.fixedChildren();
                while (fixedChildren.hasNext()) {
                    UIComponent component = fixedChildren.next();
                    ajaxVisitor.processComponent(context, component, null);
                }
                for (Object key : ajaxKeys) {
                    ajaxVisitor.process(context, key, null);
                }
                this.setRowKey(context, savedKey);
                this.restoreOrigValue(context);
            } else {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Component " + this.getClientId(context) + " children components  for all rows"));
                }
                this.iterate(context, ajaxVisitor, null);
            }
        }
    }

    protected AjaxChildrenRenderer getChildrenRenderer() {
        return _childrenRenderer;
    }

    protected Set<String> getEncodedIds() {
        if (this._encoded == null) {
            this._encoded = new HashSet<String>();
        }
        return this._encoded;
    }

    protected void setupVariable(FacesContext faces, DataModel localModel, boolean rowSelected) {
        Map attrs = faces.getExternalContext().getRequestMap();
        if (rowSelected) {
            this.setupVariable(this.getVar(), attrs, localModel.getRowData());
            this.setupVariable(this.getStateVar(), attrs, this.getComponentState());
            this.setupVariable(this.getRowKeyVar(), attrs, this.getRowKey());
        } else {
            this.removeVariable(this.getVar(), attrs);
            this.removeVariable(this.getStateVar(), attrs);
            this.removeVariable(this.getRowKeyVar(), attrs);
        }
    }

    private void setupVariable(String var, Map<String, Object> attrs, Object rowData) {
        if (var != null) {
            attrs.put(var, rowData);
        }
    }

    private void removeVariable(String var, Map<String, Object> attrs) {
        if (var != null) {
            attrs.remove(var);
        }
    }

    protected void resetDataModel() {
        this._currentModel = null;
        this._modelsMap.clear();
    }

    protected void setExtendedDataModel(ExtendedDataModel model) {
        this._currentModel = model;
        this._modelsMap.put(this.getBaseClientId(this.getFacesContext()), model);
    }

    protected ExtendedDataModel getExtendedDataModel() {
        if (this._currentModel == null) {
            String baseClientId = this.getBaseClientId(this.getFacesContext());
            ExtendedDataModel model = this._modelsMap.get(baseClientId);
            if (null == model) {
                model = this.createDataModel();
                this._modelsMap.put(baseClientId, model);
            }
            this._currentModel = model;
        }
        return this._currentModel;
    }

    protected abstract ExtendedDataModel createDataModel();

    public void setComponentState(DataComponentState state) {
        this._currentState = state;
        this._statesMap.put(this.getBaseClientId(this.getFacesContext()), this._currentState);
    }

    public DataComponentState getComponentState() {
        DataComponentState state = null;
        if (this._currentState == null) {
            ValueExpression valueBinding = this.getValueExpression(COMPONENT_STATE_ATTRIBUTE);
            FacesContext facesContext = this.getFacesContext();
            ELContext elContext = facesContext.getELContext();
            if (null != valueBinding) {
                state = (DataComponentState)valueBinding.getValue(elContext);
                if (null == state) {
                    state = this.createComponentState();
                    if (!valueBinding.isReadOnly(elContext)) {
                        valueBinding.setValue(elContext, (Object)state);
                    }
                }
            } else {
                String baseClientId = this.getBaseClientId(facesContext);
                state = this._statesMap.get(baseClientId);
                if (null == state) {
                    state = this.createComponentState();
                    this._statesMap.put(baseClientId, state);
                }
                this._currentState = state;
            }
        } else {
            state = this._currentState;
        }
        return state;
    }

    protected abstract DataComponentState createComponentState();

    public String getClientId(FacesContext faces) {
        if (null == this._clientId) {
            Renderer renderer;
            StringBuilder id = new StringBuilder(this.getBaseClientId(faces));
            Object rowKey = this.getRowKey();
            if (rowKey != null) {
                String rowKeyString;
                Converter rowKeyConverter = this.getRowKeyConverter();
                if (null == rowKeyConverter && null != (rowKeyConverter = faces.getApplication().createConverter(rowKey.getClass()))) {
                    this.setRowKeyConverter(rowKeyConverter);
                }
                if (null != rowKeyConverter) {
                    this._clientId = id.toString();
                    rowKeyString = rowKeyConverter.getAsString(faces, (UIComponent)this, rowKey);
                } else {
                    rowKeyString = rowKey.toString();
                }
                id.append(':').append(rowKeyString);
            }
            this._clientId = null != (renderer = this.getRenderer(faces)) ? renderer.convertClientId(faces, id.toString()) : id.toString();
        }
        return this._clientId;
    }

    public String getBaseClientId(FacesContext faces) {
        if (this._baseClientId == null) {
            String id;
            UIDataAdaptor ancestorContainer = this;
            StringBuilder parentIds = new StringBuilder();
            while (null != (ancestorContainer = ancestorContainer.getParent())) {
                if (!(ancestorContainer instanceof NamingContainer)) continue;
                String containerClientId = ancestorContainer.getContainerClientId(faces);
                if (containerClientId == null) break;
                parentIds.append(containerClientId).append(':');
                break;
            }
            if (null != (id = this.getId())) {
                this._baseClientId = parentIds.append(id).toString();
            } else {
                id = faces.getViewRoot().createUniqueId();
                super.setId(id);
                this._baseClientId = parentIds.append(this.getId()).toString();
            }
        }
        return this._baseClientId;
    }

    public void setId(String id) {
        boolean haveId = null != super.getId();
        super.setId(id);
        this._baseClientId = null;
        this._clientId = null;
        if (haveId) {
            String baseClientId = this.getBaseClientId(this.getFacesContext());
            this._currentState = this._statesMap.get(baseClientId);
            this._currentModel = this._modelsMap.get(baseClientId);
            if (null != this._currentModel) {
                this._rowKey = this._currentModel.getRowKey();
            }
            this._ajaxRowKey = this._ajaxRowKeysMap.get(baseClientId);
        }
    }

    public void captureOrigValue() {
        this.captureOrigValue(FacesContext.getCurrentInstance());
    }

    public void captureOrigValue(FacesContext faces) {
        String var = this.getVar();
        if (var != null) {
            Map attrs = faces.getExternalContext().getRequestMap();
            this.origValue = attrs.get(var);
        }
    }

    public void restoreOrigValue() {
        this.restoreOrigValue(FacesContext.getCurrentInstance());
    }

    public void restoreOrigValue(FacesContext faces) {
        String var = this.getVar();
        if (var != null) {
            Map attrs = faces.getExternalContext().getRequestMap();
            if (this.origValue != null) {
                attrs.put(var, this.origValue);
            } else {
                attrs.remove(var);
            }
        }
    }

    protected Map<String, SavedState> getChildState(FacesContext faces) {
        String baseClientId;
        Map<String, SavedState> currentChildState;
        if (this.childState == null) {
            this.childState = new HashMap<String, Map<String, SavedState>>();
        }
        if (null == (currentChildState = this.childState.get(baseClientId = this.getBaseClientId(faces)))) {
            currentChildState = new HashMap<String, SavedState>();
            this.childState.put(baseClientId, currentChildState);
        }
        return currentChildState;
    }

    protected void saveChildState(FacesContext faces) {
        Iterator<UIComponent> itr = this.dataChildren();
        Map<String, SavedState> childState = this.getChildState(faces);
        while (itr.hasNext()) {
            this.saveChildState(faces, itr.next(), childState);
        }
    }

    private void saveChildState(FacesContext faces, UIComponent c, Map<String, SavedState> childState) {
        if (!c.isTransient() && (c instanceof EditableValueHolder || c instanceof IterationStateHolder)) {
            String clientId = c.getClientId(faces);
            SavedState ss = childState.get(clientId);
            if (ss == null) {
                ss = new SavedState();
                childState.put(clientId, ss);
            }
            if (c instanceof EditableValueHolder) {
                ss.populate((EditableValueHolder)c);
            }
            if (c instanceof IterationStateHolder) {
                ss.populate((IterationStateHolder)c);
            }
        }
        Iterator<Object> itr = c.getChildren().iterator();
        while (itr.hasNext()) {
            this.saveChildState(faces, (UIComponent)itr.next(), childState);
        }
        itr = c.getFacets().values().iterator();
        while (itr.hasNext()) {
            this.saveChildState(faces, (UIComponent)itr.next(), childState);
        }
    }

    protected void restoreChildState(FacesContext faces) {
        Iterator<UIComponent> itr = this.dataChildren();
        Map<String, SavedState> childState = this.getChildState(faces);
        while (itr.hasNext()) {
            this.restoreChildState(faces, itr.next(), childState);
        }
    }

    private void restoreChildState(FacesContext faces, UIComponent c, Map<String, SavedState> childState) {
        String id = c.getId();
        c.setId(id);
        if (c instanceof EditableValueHolder || c instanceof IterationStateHolder) {
            String clientId = c.getClientId(faces);
            SavedState ss = childState.get(clientId);
            if (ss == null) {
                ss = NullState;
            }
            if (c instanceof EditableValueHolder) {
                EditableValueHolder evh = (EditableValueHolder)c;
                ss.apply(evh);
            }
            if (c instanceof IterationStateHolder) {
                IterationStateHolder ish = (IterationStateHolder)c;
                ss.apply(ish);
            }
        }
        for (UIComponent child : c.getChildren()) {
            this.restoreChildState(faces, child, childState);
        }
        for (UIComponent facet : c.getFacets().values()) {
            this.restoreChildState(faces, facet, childState);
        }
    }

    protected boolean keepSaved(FacesContext context) {
        FacesMessage.Severity sev = context.getMaximumSeverity();
        return sev != null && FacesMessage.SEVERITY_ERROR.compareTo((Object)sev) >= 0;
    }

    protected void iterate(FacesContext faces, ComponentVisitor visitor, Object argument) {
        if (!this.isRendered()) {
            return;
        }
        this.captureOrigValue(faces);
        this.setRowKey(faces, null);
        try {
            Iterator<UIComponent> fixedChildren = this.fixedChildren();
            while (fixedChildren.hasNext()) {
                UIComponent component = fixedChildren.next();
                visitor.processComponent(faces, component, argument);
            }
            this.walk(faces, visitor, argument);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            this.setRowKey(faces, null);
            this.restoreOrigValue(faces);
        }
    }

    protected String extractKeySegment(FacesContext context, String tailId) {
        int indexOfSecondColon = tailId.indexOf(58);
        return indexOfSecondColon > 0 ? tailId.substring(0, indexOfSecondColon) : null;
    }

    protected Iterator<UIComponent> invocableChildren() {
        return this.getFacetsAndChildren();
    }

    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        if (null == context || null == clientId || null == callback) {
            throw new NullPointerException();
        }
        boolean found = false;
        Object oldRowKey = this.getRowKey();
        String baseClientId = this.getBaseClientId(context);
        if (clientId.equals(baseClientId)) {
            try {
                if (null != oldRowKey) {
                    this.captureOrigValue(context);
                    this.setRowKey(context, null);
                }
                callback.invokeContextCallback(context, (UIComponent)this);
                found = true;
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
            finally {
                if (null != oldRowKey) {
                    try {
                        this.setRowKey(context, oldRowKey);
                        this.restoreOrigValue(context);
                    }
                    catch (Exception e) {
                        context.getExternalContext().log(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        String baseId = baseClientId + ':';
        if (clientId.startsWith(baseId)) {
            Converter keyConverter;
            Object newRowKey = null;
            String rowKeyString = this.extractKeySegment(context, clientId.substring(baseId.length()));
            if (rowKeyString != null && null != (keyConverter = this.getRowKeyConverter())) {
                try {
                    newRowKey = keyConverter.getAsObject(context, (UIComponent)this, rowKeyString);
                }
                catch (ConverterException e) {
                    // empty catch block
                }
            }
            if (null != oldRowKey || null != newRowKey) {
                this.captureOrigValue(context);
                this.setRowKey(newRowKey);
            }
            Iterator<UIComponent> itr = this.invocableChildren();
            while (itr.hasNext() && !found) {
                found = itr.next().invokeOnComponent(context, clientId, callback);
            }
            if (null != oldRowKey || null != newRowKey) {
                this.setRowKey(oldRowKey);
                this.restoreOrigValue(context);
            }
        }
        return found;
    }

    public void walk(FacesContext faces, DataVisitor visitor, Object argument) throws IOException {
        this.getExtendedDataModel().walk(faces, visitor, this.getComponentState().getRange(), argument);
    }

    protected void processDecodes(FacesContext faces, Object argument) {
        if (!this.isRendered()) {
            return;
        }
        this.iterate(faces, this.decodeVisitor, argument);
        this.decode(faces);
    }

    public void processDecodes(FacesContext faces) {
        this.processDecodes(faces, null);
    }

    protected void resetComponent(FacesContext faces) {
        if (null != this.childState) {
            this.childState.remove(this.getBaseClientId(faces));
        }
        this._encoded = null;
    }

    protected void processUpdates(FacesContext faces, Object argument) {
        if (!this.isRendered()) {
            return;
        }
        this.iterate(faces, this.updateVisitor, argument);
        ExtendedDataModel dataModel = this.getExtendedDataModel();
        if (dataModel instanceof SerializableDataModel && !this.keepSaved(faces)) {
            SerializableDataModel serializableModel = (SerializableDataModel)dataModel;
            serializableModel.update();
        }
    }

    public void processUpdates(FacesContext faces) {
        this.processUpdates(faces, null);
    }

    protected void processValidators(FacesContext faces, Object argument) {
        if (!this.isRendered()) {
            return;
        }
        this.iterate(faces, this.validateVisitor, argument);
    }

    public void processValidators(FacesContext faces) {
        this.processValidators(faces, null);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.getEncodedIds().add(this.getBaseClientId(context));
        super.encodeBegin(context);
    }

    protected abstract Iterator<UIComponent> fixedChildren();

    protected abstract Iterator<UIComponent> dataChildren();

    protected void addAjaxKeyEvent(FacesEvent event) {
        Object eventRowKey = this.getRowKey();
        if (null != eventRowKey) {
            this._ajaxRowKey = eventRowKey;
            this._ajaxRowKeysMap.put(this.getBaseClientId(this.getFacesContext()), eventRowKey);
        }
    }

    public void queueEvent(FacesEvent event) {
        UIComponent parent;
        if (event.getComponent() != this) {
            if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
                this.addAjaxKeyEvent(event);
            }
            event = new IndexedEvent(this, event, this.getRowKey());
        }
        if ((parent = this.getParent()) == null) {
            throw new IllegalStateException("No parent component for queue event");
        }
        parent.queueEvent(event);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (!(event instanceof IndexedEvent)) {
            if (!this.broadcastLocal(event)) {
                super.broadcast(event);
            }
            return;
        }
        IndexedEvent revent = (IndexedEvent)event;
        Object oldRowKey = this.getRowKey();
        FacesContext faces = FacesContext.getCurrentInstance();
        this.captureOrigValue(faces);
        Object eventRowKey = revent.getKey();
        this.setRowKey(faces, eventRowKey);
        FacesEvent rowEvent = revent.getTarget();
        rowEvent.getComponent().broadcast(rowEvent);
        this.setRowKey(faces, oldRowKey);
        this.restoreOrigValue(faces);
    }

    protected boolean broadcastLocal(FacesEvent event) {
        return false;
    }

    public void restoreState(FacesContext faces, Object object) {
        DataState state = (DataState)object;
        super.restoreState(faces, state.superState);
        this._ajaxKeys = state.ajaxKeys;
        this._statesMap = new HashMap<String, DataComponentState>();
        this._rowKeyVar = state.rowKeyVar;
        this._stateVar = state.stateVar;
        this.childState = state.childStates;
        if (null != state.rowKeyConverter) {
            this._rowKeyConverter = (Converter)UIDataAdaptor.restoreAttachedState((FacesContext)faces, (Object)state.rowKeyConverter);
        }
        for (Map.Entry stateEntry : state.componentStates.entrySet()) {
            DataComponentState compState;
            PerIdState idState = (PerIdState)stateEntry.getValue();
            if (idState.stateInHolder) {
                compState = this.createComponentState();
                ((StateHolder)compState).restoreState(faces, idState.componentState);
            } else {
                compState = (DataComponentState)idState.componentState;
            }
            String key = (String)stateEntry.getKey();
            this._statesMap.put(key, compState);
            this._modelsMap.put(key, (ExtendedDataModel)idState.model);
        }
    }

    public Object saveState(FacesContext faces) {
        DataState state = new DataState();
        state.superState = super.saveState(faces);
        state.ajaxKeys = this._ajaxKeys;
        state.rowKeyVar = this._rowKeyVar;
        state.stateVar = this._stateVar;
        state.childStates = this.childState;
        if (null != this._rowKeyConverter) {
            state.rowKeyConverter = UIDataAdaptor.saveAttachedState((FacesContext)faces, (Object)this._rowKeyConverter);
        }
        Set<String> encodedIds = this.getEncodedIds();
        for (Map.Entry<String, DataComponentState> stateEntry : this._statesMap.entrySet()) {
            DataComponentState dataComponentState = stateEntry.getValue();
            String stateKey = stateEntry.getKey();
            if (!encodedIds.isEmpty() && !encodedIds.contains(stateKey)) continue;
            PerIdState idState = new PerIdState();
            if (null == dataComponentState) {
                idState.componentState = null;
            } else {
                if (dataComponentState instanceof Serializable) {
                    idState.componentState = dataComponentState;
                } else if (dataComponentState instanceof StateHolder) {
                    idState.componentState = ((StateHolder)dataComponentState).saveState(faces);
                    idState.stateInHolder = true;
                }
                ExtendedDataModel extendedDataModel = this._modelsMap.get(stateKey);
                if (null != extendedDataModel) {
                    idState.model = extendedDataModel.getSerializableModel(dataComponentState.getRange());
                }
            }
            if (null == idState.model && null == idState.componentState) continue;
            state.componentStates.put(stateKey, idState);
        }
        return state;
    }

    public void setParent(UIComponent parent) {
        super.setParent(parent);
        this._clientId = null;
        this._baseClientId = null;
    }

    public void addRequestKey(Object key) {
        if (this._ajaxRequestKeys == null) {
            this._ajaxRequestKeys = new HashSet<Object>();
        }
        this._ajaxRequestKeys.add(key);
    }

    public void removeRequestKey(Object key) {
        if (this._ajaxRequestKeys != null && key != null) {
            this._ajaxRequestKeys.remove(key);
        }
    }

    public boolean containsRequestKey(Object key) {
        if (this._ajaxRequestKeys != null && key != null) {
            return this._ajaxRequestKeys.contains(key);
        }
        return false;
    }

    public void clearRequestKeysSet() {
        this._ajaxRequestKeys = null;
    }

    public Object getValue() {
        return super.getValue();
    }

    public void setValue(Object value) {
        this.setExtendedDataModel(null);
        super.setValue(value);
    }

    public void beforeRenderResponse(FacesContext context) {
        this.resetDataModel();
        this._encoded = null;
        if (null != this.childState && !this.keepSaved(context)) {
            this.childState.clear();
        }
    }

    private static class PerIdState
    implements Serializable {
        private static final long serialVersionUID = 9037454770537726418L;
        private boolean stateInHolder = false;
        private Object componentState;
        private SerializableDataModel model;

        private PerIdState() {
        }
    }

    private static class DataState
    implements Serializable {
        private static final long serialVersionUID = 17070532L;
        private Object superState;
        private Map<String, PerIdState> componentStates = new HashMap<String, PerIdState>();
        private Set<Object> ajaxKeys;
        public String rowKeyVar;
        public String stateVar;
        private Map<String, Map<String, SavedState>> childStates;
        public Object rowKeyConverter;

        private DataState() {
        }
    }

    protected static final class IndexedEvent
    extends FacesEvent {
        private static final long serialVersionUID = -8318895390232552385L;
        private final FacesEvent target;
        private final Object key;

        public IndexedEvent(UIDataAdaptor owner, FacesEvent target, Object key) {
            super((UIComponent)owner);
            this.target = target;
            this.key = key;
        }

        public PhaseId getPhaseId() {
            return this.target.getPhaseId();
        }

        public void setPhaseId(PhaseId phaseId) {
            this.target.setPhaseId(phaseId);
        }

        public boolean isAppropriateListener(FacesListener listener) {
            return this.target.isAppropriateListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processListener(FacesListener listener) {
            UIDataAdaptor owner = (UIDataAdaptor)this.getComponent();
            Object prevIndex = owner._rowKey;
            try {
                owner.setRowKey(this.key);
                this.target.processListener(listener);
            }
            finally {
                owner.setRowKey(prevIndex);
            }
        }

        public Object getKey() {
            return this.key;
        }

        public FacesEvent getTarget() {
            return this.target;
        }
    }

    private static final class SavedState
    implements Serializable {
        private Object submittedValue;
        private Object iterationState;
        private static final long serialVersionUID = 2920252657338389849L;
        private boolean valid = true;
        private Object value;
        private boolean localValueSet;

        private SavedState() {
        }

        Object getSubmittedValue() {
            return this.submittedValue;
        }

        void setSubmittedValue(Object submittedValue) {
            this.submittedValue = submittedValue;
        }

        boolean isValid() {
            return this.valid;
        }

        void setValid(boolean valid) {
            this.valid = valid;
        }

        Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        boolean isLocalValueSet() {
            return this.localValueSet;
        }

        public void setLocalValueSet(boolean localValueSet) {
            this.localValueSet = localValueSet;
        }

        public Object getIterationState() {
            return this.iterationState;
        }

        public void setIterationState(Object iterationState) {
            this.iterationState = iterationState;
        }

        public String toString() {
            return "submittedValue: " + this.submittedValue + " value: " + this.value + " localValueSet: " + this.localValueSet;
        }

        public void populate(EditableValueHolder evh) {
            this.value = evh.getLocalValue();
            this.valid = evh.isValid();
            this.submittedValue = evh.getSubmittedValue();
            this.localValueSet = evh.isLocalValueSet();
        }

        public void populate(IterationStateHolder ish) {
            this.iterationState = ish.getIterationState();
        }

        public void apply(EditableValueHolder evh) {
            evh.setValue(this.value);
            evh.setValid(this.valid);
            evh.setSubmittedValue(this.submittedValue);
            evh.setLocalValueSet(this.localValueSet);
        }

        public void apply(IterationStateHolder ish) {
            ish.setIterationState(this.iterationState);
        }
    }

    protected abstract class ComponentVisitor
    implements DataVisitor {
        protected ComponentVisitor() {
        }

        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
            UIDataAdaptor.this.setRowKey(context, rowKey);
            if (UIDataAdaptor.this.isRowAvailable()) {
                Iterator<UIComponent> childIterator = UIDataAdaptor.this.dataChildren();
                while (childIterator.hasNext()) {
                    UIComponent component = childIterator.next();
                    if (UIColumn.class.equals(component.getClass())) {
                        for (UIComponent children : component.getChildren()) {
                            this.processComponent(context, children, argument);
                        }
                        continue;
                    }
                    this.processComponent(context, component, argument);
                }
            }
        }

        public abstract void processComponent(FacesContext var1, UIComponent var2, Object var3) throws IOException;
    }
}

