/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.event;

import java.util.Collection;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.richfaces.event.RenderPhaseComponentVisitor;
import org.richfaces.util.RenderPhaseComponentVisitorUtils;

public class RenderPhaseComponentListener
implements PhaseListener {
    private static final long serialVersionUID = -2437433246178955788L;

    public void afterPhase(PhaseEvent event) {
    }

    private void processComponents(PhaseEvent event, UIComponent component, RenderPhaseComponentVisitor[] handlers, Object[] states) {
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i].beforeComponent(component, event, states[i]);
        }
        Collection facets = component.getFacets().values();
        for (UIComponent facet : facets) {
            this.processComponents(event, facet, handlers, states);
        }
        List children = component.getChildren();
        for (UIComponent child : children) {
            this.processComponents(event, child, handlers, states);
        }
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i].afterComponent(component, event, states[i]);
        }
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        RenderPhaseComponentVisitor[] handlers = RenderPhaseComponentVisitorUtils.getVisitors(facesContext);
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot != null && handlers != null) {
            int i;
            Object[] states = new Object[handlers.length];
            for (i = 0; i < handlers.length; ++i) {
                states[i] = handlers[i].beforeRoot(event);
            }
            this.processComponents(event, (UIComponent)viewRoot, handlers, states);
            for (i = 0; i < handlers.length; ++i) {
                handlers[i].afterRoot(event, states[i]);
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }
}

