package org.ajax4jsf.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.UILoadBundle;

public class AjaxLoadBundle extends UILoadBundle{

final static public  String COMPONENT_FAMILY = "org.ajax4jsf.Bundle";

final static public  String COMPONENT_TYPE = "org.ajax4jsf.Bundle";

/*
* Base name of the resource bundle to be loaded.
*/
private  String _basename = null;

/*
* Name of a request scope attribute under which the
				resource bundle will be exposed as a Map.
*/
private  String _var = null;


public AjaxLoadBundle(){

}

public String getBasename(){
	if (this._basename != null) {
		return this._basename;
	}
	ValueExpression ve = getValueExpression("basename");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setBasename(String _basename){
this._basename = _basename;
}

public String getVar(){
return _var;
}

public void setVar(String _var){
this._var = _var;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[3];
state[0] = super.saveState(context);
state[1] = _basename;
state[2] = _var;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_basename = (String)states[1];;
		_var = (String)states[2];;
	
}

}
