package org.ajax4jsf.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.UIResource;

public class HtmlLoadScript extends UIResource{

final static public  String COMPONENT_FAMILY = "org.ajax4jsf.LoadScript";

final static public  String COMPONENT_TYPE = "org.ajax4jsf.LoadScript";

/*
* name of JavaScript resource to load.
*/
private  Object _src = null;


public HtmlLoadScript(){
setRendererType("org.ajax4jsf.LoadScriptRenderer");
}

public Object getSrc(){
	if (this._src != null) {
		return this._src;
	}
	ValueExpression ve = getValueExpression("src");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSrc(Object _src){
this._src = _src;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[2];
state[0] = super.saveState(context);
state[1] = saveAttachedState(context, _src);
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_src = (Object)restoreAttachedState(context, states[1]);
	
}

}
