/*
 * Decompiled with CFR 0.152.
 */
package org.exadel.jsf;

import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;

public class PhaseTracker
implements PhaseListener {
    private static final String PHASE_PARAM = "org.exadel.helper.phaseTracker.cphase";
    private static final Logger logger = Logger.getLogger("org.exadel.helper");
    private static String cphase = null;

    public void setPhase(String string) {
        cphase = string;
    }

    public PhaseId getPhaseId() {
        PhaseId phaseId = PhaseId.ANY_PHASE;
        if (cphase == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext == null) {
                return phaseId;
            }
            cphase = facesContext.getExternalContext().getInitParameter(PHASE_PARAM);
        }
        if (cphase != null) {
            if ("RESTORE_VIEW".equals(cphase)) {
                phaseId = PhaseId.RESTORE_VIEW;
            } else if ("APPLY_REQUEST_VALUES".equals(cphase)) {
                phaseId = PhaseId.APPLY_REQUEST_VALUES;
            } else if ("PROCESS_VALIDATIONS".equals(cphase)) {
                phaseId = PhaseId.PROCESS_VALIDATIONS;
            } else if ("UPDATE_MODEL_VALUES".equals(cphase)) {
                phaseId = PhaseId.UPDATE_MODEL_VALUES;
            } else if ("INVOKE_APPLICATION".equals(cphase)) {
                phaseId = PhaseId.INVOKE_APPLICATION;
            } else if ("RENDER_RESPONSE".equals(cphase)) {
                phaseId = PhaseId.RENDER_RESPONSE;
            } else if ("ANY_PHASE".equals(cphase)) {
                phaseId = PhaseId.ANY_PHASE;
            }
        }
        return phaseId;
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        logger.info("BEFORE " + phaseEvent.getPhaseId());
    }

    public void afterPhase(PhaseEvent phaseEvent) {
        logger.info("AFTER " + phaseEvent.getPhaseId());
    }
}

