/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import javax.faces.component.UIComponent;
import javax.faces.component.UIColumn;
import java.util.List;
import java.util.Iterator;
import org.richfaces.component.Column;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResource;
//
//
//


import org.richfaces.renderkit.html.ScrollableDataTableBaseRenderer;



/**
 * Renderer for component class org.richfaces.renderkit.html.ScrollableDataTableRenderer
 */
public class ScrollableDataTableRenderer extends ScrollableDataTableBaseRenderer {

	public ScrollableDataTableRenderer () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] styles = {
						getResource("/org/richfaces/renderkit/html/css/scrollable-data-table.xcss")
	};

private InternetResource[] stylesAll = null;

protected InternetResource[] getStyles() {
	synchronized (this) {
		if (stylesAll == null) {
			InternetResource[] rsrcs = super.getStyles();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = styles == null || styles.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					stylesAll = new InternetResource[0];	
				} else {
					stylesAll = styles;
				}
			} else {
				if (ignoreThis) {
					stylesAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < styles.length; i++ ) {
						rsrcsSet.add(styles[i]);
					}

					stylesAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return stylesAll;
}
	private final InternetResource[] scripts = {
						new org.ajax4jsf.javascript.PrototypeScript()
						,
				new org.ajax4jsf.javascript.AjaxScript()
						,
				getResource("/org/richfaces/renderkit/html/scripts/common-scrollable-data-table.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/controls-scrollable-data-table.js")
	};

private InternetResource[] scriptsAll = null;

protected InternetResource[] getScripts() {
	synchronized (this) {
		if (scriptsAll == null) {
			InternetResource[] rsrcs = super.getScripts();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = scripts == null || scripts.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					scriptsAll = new InternetResource[0];	
				} else {
					scriptsAll = scripts;
				}
			} else {
				if (ignoreThis) {
					scriptsAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < scripts.length; i++ ) {
						rsrcsSet.add(scripts[i]);
					}

					scriptsAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return scriptsAll;
}
	// 
	// 
	//

	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIScrollableDataTable.class;
	}


	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIScrollableDataTable component, ComponentVariables variables) throws IOException {
	  java.lang.String clientId = component.getClientId(context);
setUpColumnsWidth(context, component);


     	
			List children = component.getChildren();
			String hStyle, fStyle;
			boolean footer = false;
			boolean header = false;
	
			for (Iterator iterator = children.iterator(); iterator.hasNext();) {
				UIComponent column = (UIComponent) iterator.next();
				if(column instanceof UIColumn){
					UIComponent hFacet = ((UIColumn) column).getHeader(); 
					UIComponent fFacet = ((UIColumn) column).getFooter();
					if(hFacet != null){
						if(!header)
							header = true;
					}
					if(fFacet != null){
						if(!footer)
							footer = true;
					}
				}
			}
			
			if(header){
				hStyle = "";
			}else{
				hStyle = "display: none";
			}
			if(footer){
				fStyle = "";
			}else{;
				fStyle = "display: none";
			}
			
			variables.setVariable("fStyle", fStyle);
			variables.setVariable("hStyle", hStyle);
			variables.setVariable("normalizedId", getNormalizedId(context, component));
		
	
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "rich-sdt " + convertToString(component.getAttributes().get("styleClass")) );
						getUtils().writeAttribute(writer, "id", clientId );
						getUtils().writeAttribute(writer, "style", "width: " + convertToString(component.getAttributes().get("width")) + "; height: " + convertToString(component.getAttributes().get("height")) + "; " + convertToString(component.getAttributes().get("style")) );
			
writer.startElement("tbody", component);


	     						
					UIComponent facet = component.getFacet("header");
					if (null != facet && facet .isRendered()) {
					
			
writer.startElement("tr", component);

writer.startElement("td", component);

UIComponent indexChildren_32 = component.getFacet("header");
if (null != indexChildren_32 && indexChildren_32 .isRendered()) {
	renderChild(context, indexChildren_32);
}

writer.endElement("td");
writer.endElement("tr");

	     						
					}
					
			
writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "id", variables.getVariable("normalizedId") );
						getUtils().writeAttribute(writer, "style", "height: 100%;" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":c" );
						getUtils().writeAttribute(writer, "style", "height: 100%; position: relative;" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-sdt-hsplit" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":cs" );
						getUtils().writeAttribute(writer, "style", "display: none;" );
			
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-sdt-inlinebox" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "_GridHeaderTemplate" );
						getUtils().writeAttribute(writer, "style", convertToString(variables.getVariable("hStyle")) + "; width: " + convertToString(component.getAttributes().get("width")) + ";" );
			
writer.startElement("iframe", component);
			getUtils().writeAttribute(writer, "class", "rich-sdt-substrate" );
						getUtils().writeAttribute(writer, "frameborder", "0" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":hs" );
						getUtils().writeAttribute(writer, "scrolling", "no" );
						getUtils().writeAttribute(writer, "src", "javascript:\'\'" );
			
writer.startElement("br", component);

writer.endElement("br");
writer.endElement("iframe");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "style", "display: block; left: 0px; top: 0px; width: " + convertToString(variables.getVariable("sumWidth")) + "px;" );
			
writer.startElement("style", component);

renderStyle(context, component);

writer.endElement("style");
writer.startElement("span", component);
			getUtils().writeAttribute(writer, "class", "rich-sdt-fb" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":header:FrozenBox" );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "style", "border-collapse:collapse;" );
			
writer.startElement("thead", component);

writer.startElement("tr", component);
			getUtils().writeAttribute(writer, "class", "rich-std-header-row " + convertToString(component.getAttributes().get("headerClass")) );
			

								                   		
															renderHeaders(context, component, true);
														
													
writer.endElement("tr");
writer.endElement("thead");
writer.endElement("table");
writer.endElement("span");
writer.startElement("span", component);
			getUtils().writeAttribute(writer, "class", "rich-sdt-nb" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":header:NormalBox" );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "style", "border-collapse:collapse;" );
			
writer.startElement("thead", component);

writer.startElement("tr", component);
			getUtils().writeAttribute(writer, "class", "rich-std-header-row " + convertToString(component.getAttributes().get("headerClass")) );
			

								                   		
															renderHeaders(context, component, false);
														
													
writer.startElement("th", component);
			getUtils().writeAttribute(writer, "class", "rich-sdt-c-f rich-sdt-header-cell" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-sdt-header-cell-body" );
			
writer.endElement("div");
writer.endElement("th");
writer.endElement("tr");
writer.endElement("thead");
writer.endElement("table");
writer.endElement("span");
writer.endElement("div");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-sdt-inlinebox" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "_GridBodyTemplate" );
						getUtils().writeAttribute(writer, "style", "overflow: auto; width: " + convertToString(component.getAttributes().get("width")) + "; height: " + convertToString(component.getAttributes().get("height")) + ";" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":scb" );
						getUtils().writeAttribute(writer, "style", "position: absolute; z-index: 0;" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":sb" );
						getUtils().writeAttribute(writer, "style", "position: absolute;" );
			
writer.startElement("br", component);

writer.endElement("br");
writer.endElement("div");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":bc" );
						getUtils().writeAttribute(writer, "style", "display: block; width:  " + convertToString(variables.getVariable("sumWidth")) + "px;" );
			
writer.startElement("span", component);
			getUtils().writeAttribute(writer, "class", "rich-sdt-fb" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":body:FrozenBox" );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":f" );
						getUtils().writeAttribute(writer, "style", "border-collapse:collapse;" );
			
writer.startElement("tbody", component);


								                
													renderGridBody(context, component, true);	
												
											
writer.endElement("tbody");
writer.endElement("table");
writer.startElement("span", component);
			getUtils().writeAttribute(writer, "class", "rich-sdt-ho" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":fho" );
			
writer.startElement("br", component);

writer.endElement("br");
writer.endElement("span");
writer.endElement("span");
writer.startElement("span", component);
			getUtils().writeAttribute(writer, "class", "rich-sdt-nb" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":body:NormalBox" );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":n" );
						getUtils().writeAttribute(writer, "style", "border-collapse:collapse;" );
			
writer.startElement("tbody", component);


							                	
													renderGridBody(context, component, false);	
												
											
writer.endElement("tbody");
writer.endElement("table");
writer.startElement("span", component);
			getUtils().writeAttribute(writer, "class", "rich-sdt-ho" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":nho" );
			
writer.startElement("br", component);

writer.endElement("br");
writer.endElement("span");
writer.endElement("span");
writer.endElement("div");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-sdt-inlinebox" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "_GridFooterTemplate" );
						getUtils().writeAttribute(writer, "style", convertToString(variables.getVariable("fStyle")) + "; width: " + convertToString(component.getAttributes().get("width")) + ";" );
			
writer.startElement("iframe", component);
			getUtils().writeAttribute(writer, "class", "rich-sdt-substrate" );
						getUtils().writeAttribute(writer, "frameborder", "0" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":fs" );
						getUtils().writeAttribute(writer, "scrolling", "no" );
						getUtils().writeAttribute(writer, "src", "javascript:\'\'" );
			
writer.startElement("br", component);

writer.endElement("br");
writer.endElement("iframe");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "style", "display: block; width: width: " + convertToString(variables.getVariable("sumWidth")) + "px;" );
			
writer.startElement("span", component);
			getUtils().writeAttribute(writer, "class", "rich-sdt-fb" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":footer:FrozenBox" );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "style", "border-collapse:collapse;" );
			
writer.startElement("tfoot", component);

writer.startElement("tr", component);
			getUtils().writeAttribute(writer, "class", "rich-std-footer-row " + convertToString(component.getAttributes().get("footerClass")) );
			

								        	        
														renderFooters(context, component,true);	
													
												
writer.endElement("tr");
writer.endElement("tfoot");
writer.endElement("table");
writer.endElement("span");
writer.startElement("span", component);
			getUtils().writeAttribute(writer, "class", "rich-sdt-nb" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":footer:NormalBox" );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "style", "border-collapse:collapse;" );
			
writer.startElement("tfoot", component);

writer.startElement("tr", component);
			getUtils().writeAttribute(writer, "class", "rich-std-footer-row " + convertToString(component.getAttributes().get("footerClass")) );
			

								        	        
														renderFooters(context, component,false);	
													
												
writer.startElement("th", component);
			getUtils().writeAttribute(writer, "class", "rich-sdt-c-f rich-sdt-footer-cell" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-sdt-footer-cell-body" );
			
writer.endElement("div");
writer.endElement("th");
writer.endElement("tr");
writer.endElement("tfoot");
writer.endElement("table");
writer.endElement("span");
writer.endElement("div");
writer.endElement("div");
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "autocomplete", "off" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "_hc" );
						getUtils().writeAttribute(writer, "name", convertToString(clientId) + "_hc" );
						getUtils().writeAttribute(writer, "type", "hidden" );
			
writer.endElement("input");
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "autocomplete", "off" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "_state_input" );
						getUtils().writeAttribute(writer, "name", convertToString(clientId) + "_state_input" );
						getUtils().writeAttribute(writer, "type", "hidden" );
			
writer.endElement("input");
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "autocomplete", "off" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "_options_input" );
						getUtils().writeAttribute(writer, "name", convertToString(clientId) + "_options_input" );
						getUtils().writeAttribute(writer, "type", "hidden" );
			
writer.endElement("input");
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "autocomplete", "off" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "_rows_input" );
						getUtils().writeAttribute(writer, "name", convertToString(variables.getVariable("clienId")) + "_rows_input" );
						getUtils().writeAttribute(writer, "type", "hidden" );
						getUtils().writeAttribute(writer, "value", variables.getVariable("rows_count") );
			
writer.endElement("input");
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "_submit_input" );
						getUtils().writeAttribute(writer, "name", convertToString(clientId) + "_submit_input" );
						getUtils().writeAttribute(writer, "onclick", getRowsAjaxUpdate(context,component) );
						getUtils().writeAttribute(writer, "style", "display:none" );
						getUtils().writeAttribute(writer, "type", "button" );
			
writer.endElement("input");

						   
								renderHiddenScrollInput(context, component);	
							
						
contributorsEncodeHere(context, component);

writer.endElement("div");
writer.endElement("td");
writer.endElement("tr");
writer.startElement("tr", component);


		     						
						facet = component.getFacet("footer");
						if (null == facet || !facet.isRendered()) {
							getUtils().writeAttribute(writer, "style", "display:none;" );							
						}
						
				
writer.startElement("td", component);

UIComponent indexChildren_33 = component.getFacet("footer");
if (null != indexChildren_33 && indexChildren_33 .isRendered()) {
	renderChild(context, indexChildren_33);
}

writer.startElement("script", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "_grid_create_scripts" );
						getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString("//"),null);

     writer.write("<![CDATA[");
     writer.write(convertToString("\n					\n					" + convertToString(getJavaScriptVarName(context,component)) + " = " + convertToString(createClientScrollableGrid(context,component)) + ";\n					" + convertToString(getScriptContributions(context,component)) + ";\n			\n					//		"));
     writer.write("]]>");

writer.endElement("script");
tearDownState(context, component);

writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIScrollableDataTable)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
