/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.convert.seamtext.tags;

import org.richfaces.convert.seamtext.tags.HtmlTag;

class LineTag
extends HtmlTag {
    private static final long serialVersionUID = 6972613670825989225L;
    private String startTag;
    protected boolean isHtml = false;

    protected LineTag(String name) {
        super(name);
    }

    public LineTag(String name, String startTag) {
        super(name);
        this.setStartTag(startTag);
    }

    public String printStart() {
        return this.startTag;
    }

    public String printPlain() {
        this.isHtml = true;
        return super.printPlain();
    }

    public void appendBody(String str) {
        super.appendBody(this.removeNewLineChars(str));
    }

    private String removeNewLineChars(String str) {
        char[] text = str.toCharArray();
        char[] result = new char[text.length];
        int resultSize = 0;
        for (int textIndex = 0; textIndex < text.length; ++textIndex) {
            if (text[textIndex] == '\r' || text[textIndex] == '\n') continue;
            result[resultSize] = text[textIndex];
            ++resultSize;
        }
        return new String(result, 0, resultSize);
    }

    protected void appendChildTag(StringBuilder res, HtmlTag child) {
        if (child instanceof LineTag) {
            res.append(((LineTag)child).printPlain());
        } else {
            res.append(child);
        }
    }

    protected String printBody() {
        while (!this.isBodyEmpty() && this.isBreakLineChild(this.body.getLast())) {
            this.body.removeLast();
        }
        return super.printBody();
    }

    public String printEnd() {
        return "\n";
    }

    public String getStartTag() {
        return this.startTag;
    }

    public void setStartTag(String startTag) {
        this.startTag = startTag;
    }
}

