/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.android.internal;

import android.view.Display;
import android.view.DisplayInfo;
import java.util.Arrays;
import libcore.util.Objects;
import org.robolectric.RuntimeEnvironment;

public final class DisplayConfig {
    public int layerStack;
    public int flags;
    public int type;
    public String address;
    public String name;
    public String uniqueId;
    public int appWidth;
    public int appHeight;
    public int smallestNominalAppWidth;
    public int smallestNominalAppHeight;
    public int largestNominalAppWidth;
    public int largestNominalAppHeight;
    public int logicalWidth;
    public int logicalHeight;
    public int overscanLeft;
    public int overscanTop;
    public int overscanRight;
    public int overscanBottom;
    public int rotation;
    public int modeId;
    public int defaultModeId;
    public Display.Mode[] supportedModes = new Display.Mode[0];
    public int colorMode;
    public int[] supportedColorModes = new int[]{0};
    public Display.HdrCapabilities hdrCapabilities;
    public int logicalDensityDpi;
    public float physicalXDpi;
    public float physicalYDpi;
    public long appVsyncOffsetNanos;
    public long presentationDeadlineNanos;
    public int state;
    public int ownerUid;
    public String ownerPackageName;
    public int removeMode = 0;

    public DisplayConfig() {
    }

    public DisplayConfig(DisplayConfig other) {
        this.copyFrom(other);
    }

    public DisplayConfig(DisplayInfo other) {
        this.layerStack = other.layerStack;
        this.flags = other.flags;
        this.type = other.type;
        this.address = other.address;
        this.name = other.name;
        if (RuntimeEnvironment.getApiLevel() >= 22) {
            this.uniqueId = other.uniqueId;
        }
        this.appWidth = other.appWidth;
        this.appHeight = other.appHeight;
        this.smallestNominalAppWidth = other.smallestNominalAppWidth;
        this.smallestNominalAppHeight = other.smallestNominalAppHeight;
        this.largestNominalAppWidth = other.largestNominalAppWidth;
        this.largestNominalAppHeight = other.largestNominalAppHeight;
        this.logicalWidth = other.logicalWidth;
        this.logicalHeight = other.logicalHeight;
        if (RuntimeEnvironment.getApiLevel() >= 18) {
            this.overscanLeft = other.overscanLeft;
            this.overscanTop = other.overscanTop;
            this.overscanRight = other.overscanRight;
            this.overscanBottom = other.overscanBottom;
        }
        this.rotation = other.rotation;
        if (RuntimeEnvironment.getApiLevel() >= 23) {
            this.modeId = other.modeId;
            this.defaultModeId = other.defaultModeId;
            this.supportedModes = Arrays.copyOf(other.supportedModes, other.supportedModes.length);
        }
        if (RuntimeEnvironment.getApiLevel() >= 25) {
            this.colorMode = other.colorMode;
            this.supportedColorModes = Arrays.copyOf(other.supportedColorModes, other.supportedColorModes.length);
        }
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            this.hdrCapabilities = other.hdrCapabilities;
        }
        this.logicalDensityDpi = other.logicalDensityDpi;
        this.physicalXDpi = other.physicalXDpi;
        this.physicalYDpi = other.physicalYDpi;
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            this.appVsyncOffsetNanos = other.appVsyncOffsetNanos;
            this.presentationDeadlineNanos = other.presentationDeadlineNanos;
            this.state = other.state;
        }
        if (RuntimeEnvironment.getApiLevel() >= 19) {
            this.ownerUid = other.ownerUid;
            this.ownerPackageName = other.ownerPackageName;
        }
        if (RuntimeEnvironment.getApiLevel() >= 26) {
            this.removeMode = other.removeMode;
        }
    }

    public boolean equals(Object o) {
        return o instanceof DisplayConfig && this.equals((DisplayConfig)o);
    }

    public boolean equals(DisplayConfig other) {
        return other != null && this.layerStack == other.layerStack && this.flags == other.flags && this.type == other.type && Objects.equal((Object)this.address, (Object)other.address) && Objects.equal((Object)this.uniqueId, (Object)other.uniqueId) && this.appWidth == other.appWidth && this.appHeight == other.appHeight && this.smallestNominalAppWidth == other.smallestNominalAppWidth && this.smallestNominalAppHeight == other.smallestNominalAppHeight && this.largestNominalAppWidth == other.largestNominalAppWidth && this.largestNominalAppHeight == other.largestNominalAppHeight && this.logicalWidth == other.logicalWidth && this.logicalHeight == other.logicalHeight && this.overscanLeft == other.overscanLeft && this.overscanTop == other.overscanTop && this.overscanRight == other.overscanRight && this.overscanBottom == other.overscanBottom && this.rotation == other.rotation && this.modeId == other.modeId && this.defaultModeId == other.defaultModeId && this.colorMode == other.colorMode && Arrays.equals(this.supportedColorModes, other.supportedColorModes) && Objects.equal((Object)this.hdrCapabilities, (Object)other.hdrCapabilities) && this.logicalDensityDpi == other.logicalDensityDpi && this.physicalXDpi == other.physicalXDpi && this.physicalYDpi == other.physicalYDpi && this.appVsyncOffsetNanos == other.appVsyncOffsetNanos && this.presentationDeadlineNanos == other.presentationDeadlineNanos && this.state == other.state && this.ownerUid == other.ownerUid && Objects.equal((Object)this.ownerPackageName, (Object)other.ownerPackageName) && this.removeMode == other.removeMode;
    }

    public int hashCode() {
        return 0;
    }

    public void copyFrom(DisplayConfig other) {
        this.layerStack = other.layerStack;
        this.flags = other.flags;
        this.type = other.type;
        this.address = other.address;
        this.name = other.name;
        this.uniqueId = other.uniqueId;
        this.appWidth = other.appWidth;
        this.appHeight = other.appHeight;
        this.smallestNominalAppWidth = other.smallestNominalAppWidth;
        this.smallestNominalAppHeight = other.smallestNominalAppHeight;
        this.largestNominalAppWidth = other.largestNominalAppWidth;
        this.largestNominalAppHeight = other.largestNominalAppHeight;
        this.logicalWidth = other.logicalWidth;
        this.logicalHeight = other.logicalHeight;
        this.overscanLeft = other.overscanLeft;
        this.overscanTop = other.overscanTop;
        this.overscanRight = other.overscanRight;
        this.overscanBottom = other.overscanBottom;
        this.rotation = other.rotation;
        this.modeId = other.modeId;
        this.defaultModeId = other.defaultModeId;
        this.supportedModes = Arrays.copyOf(other.supportedModes, other.supportedModes.length);
        this.colorMode = other.colorMode;
        this.supportedColorModes = Arrays.copyOf(other.supportedColorModes, other.supportedColorModes.length);
        this.hdrCapabilities = other.hdrCapabilities;
        this.logicalDensityDpi = other.logicalDensityDpi;
        this.physicalXDpi = other.physicalXDpi;
        this.physicalYDpi = other.physicalYDpi;
        this.appVsyncOffsetNanos = other.appVsyncOffsetNanos;
        this.presentationDeadlineNanos = other.presentationDeadlineNanos;
        this.state = other.state;
        this.ownerUid = other.ownerUid;
        this.ownerPackageName = other.ownerPackageName;
        this.removeMode = other.removeMode;
    }

    public void copyTo(DisplayInfo other) {
        other.layerStack = this.layerStack;
        other.flags = this.flags;
        other.type = this.type;
        other.address = this.address;
        other.name = this.name;
        if (RuntimeEnvironment.getApiLevel() >= 22) {
            other.uniqueId = this.uniqueId;
        }
        other.appWidth = this.appWidth;
        other.appHeight = this.appHeight;
        other.smallestNominalAppWidth = this.smallestNominalAppWidth;
        other.smallestNominalAppHeight = this.smallestNominalAppHeight;
        other.largestNominalAppWidth = this.largestNominalAppWidth;
        other.largestNominalAppHeight = this.largestNominalAppHeight;
        other.logicalWidth = this.logicalWidth;
        other.logicalHeight = this.logicalHeight;
        if (RuntimeEnvironment.getApiLevel() >= 18) {
            other.overscanLeft = this.overscanLeft;
            other.overscanTop = this.overscanTop;
            other.overscanRight = this.overscanRight;
            other.overscanBottom = this.overscanBottom;
        }
        other.rotation = this.rotation;
        if (RuntimeEnvironment.getApiLevel() >= 23) {
            other.modeId = this.modeId;
            other.defaultModeId = this.defaultModeId;
            other.supportedModes = Arrays.copyOf(this.supportedModes, this.supportedModes.length);
        }
        if (RuntimeEnvironment.getApiLevel() >= 25) {
            other.colorMode = this.colorMode;
            other.supportedColorModes = Arrays.copyOf(this.supportedColorModes, this.supportedColorModes.length);
        }
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            other.hdrCapabilities = this.hdrCapabilities;
        }
        other.logicalDensityDpi = this.logicalDensityDpi;
        other.physicalXDpi = this.physicalXDpi;
        other.physicalYDpi = this.physicalYDpi;
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            other.appVsyncOffsetNanos = this.appVsyncOffsetNanos;
            other.presentationDeadlineNanos = this.presentationDeadlineNanos;
            other.state = this.state;
        }
        if (RuntimeEnvironment.getApiLevel() >= 19) {
            other.ownerUid = this.ownerUid;
            other.ownerPackageName = this.ownerPackageName;
        }
        if (RuntimeEnvironment.getApiLevel() >= 26) {
            other.removeMode = this.removeMode;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DisplayConfig{\"");
        sb.append(this.name);
        sb.append("\", uniqueId \"");
        sb.append(this.uniqueId);
        sb.append("\", app ");
        sb.append(this.appWidth);
        sb.append(" x ");
        sb.append(this.appHeight);
        sb.append(", real ");
        sb.append(this.logicalWidth);
        sb.append(" x ");
        sb.append(this.logicalHeight);
        if (this.overscanLeft != 0 || this.overscanTop != 0 || this.overscanRight != 0 || this.overscanBottom != 0) {
            sb.append(", overscan (");
            sb.append(this.overscanLeft);
            sb.append(",");
            sb.append(this.overscanTop);
            sb.append(",");
            sb.append(this.overscanRight);
            sb.append(",");
            sb.append(this.overscanBottom);
            sb.append(")");
        }
        sb.append(", largest app ");
        sb.append(this.largestNominalAppWidth);
        sb.append(" x ");
        sb.append(this.largestNominalAppHeight);
        sb.append(", smallest app ");
        sb.append(this.smallestNominalAppWidth);
        sb.append(" x ");
        sb.append(this.smallestNominalAppHeight);
        sb.append(", mode ");
        sb.append(this.modeId);
        sb.append(", defaultMode ");
        sb.append(this.defaultModeId);
        sb.append(", modes ");
        sb.append(Arrays.toString(this.supportedModes));
        sb.append(", colorMode ");
        sb.append(this.colorMode);
        sb.append(", supportedColorModes ");
        sb.append(Arrays.toString(this.supportedColorModes));
        sb.append(", hdrCapabilities ");
        sb.append(this.hdrCapabilities);
        sb.append(", rotation ");
        sb.append(this.rotation);
        sb.append(", density ");
        sb.append(this.logicalDensityDpi);
        sb.append(" (");
        sb.append(this.physicalXDpi);
        sb.append(" x ");
        sb.append(this.physicalYDpi);
        sb.append(") dpi, layerStack ");
        sb.append(this.layerStack);
        sb.append(", appVsyncOff ");
        sb.append(this.appVsyncOffsetNanos);
        sb.append(", presDeadline ");
        sb.append(this.presentationDeadlineNanos);
        sb.append(", type ");
        sb.append(Display.typeToString((int)this.type));
        if (this.address != null) {
            sb.append(", address ").append(this.address);
        }
        sb.append(", state ");
        sb.append(Display.stateToString((int)this.state));
        if (this.ownerUid != 0 || this.ownerPackageName != null) {
            sb.append(", owner ").append(this.ownerPackageName);
            sb.append(" (uid ").append(this.ownerUid).append(")");
        }
        sb.append(DisplayConfig.flagsToString(this.flags));
        sb.append(", removeMode ");
        sb.append(this.removeMode);
        sb.append("}");
        return sb.toString();
    }

    private static String flagsToString(int flags) {
        StringBuilder result = new StringBuilder();
        if ((flags & 2) != 0) {
            result.append(", FLAG_SECURE");
        }
        if ((flags & 1) != 0) {
            result.append(", FLAG_SUPPORTS_PROTECTED_BUFFERS");
        }
        if ((flags & 4) != 0) {
            result.append(", FLAG_PRIVATE");
        }
        if ((flags & 8) != 0) {
            result.append(", FLAG_PRESENTATION");
        }
        if ((flags & 0x40000000) != 0) {
            result.append(", FLAG_SCALING_DISABLED");
        }
        if ((flags & 0x10) != 0) {
            result.append(", FLAG_ROUND");
        }
        return result.toString();
    }
}

