/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.ActivityManager;
import android.app.IActivityManager;
import android.content.pm.ConfigurationInfo;
import android.os.Process;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=ActivityManager.class)
public class ShadowActivityManager {
    private int memoryClass = 16;
    private String backgroundPackage;
    private ActivityManager.MemoryInfo memoryInfo;
    private final List<ActivityManager.RunningTaskInfo> tasks = new CopyOnWriteArrayList<ActivityManager.RunningTaskInfo>();
    private final List<ActivityManager.RunningServiceInfo> services = new CopyOnWriteArrayList<ActivityManager.RunningServiceInfo>();
    private List<ActivityManager.RunningAppProcessInfo> processes = new CopyOnWriteArrayList<ActivityManager.RunningAppProcessInfo>();
    @RealObject
    private ActivityManager realObject;
    private Boolean isLowRamDeviceOverride = null;

    public ShadowActivityManager() {
        ActivityManager.RunningAppProcessInfo processInfo = new ActivityManager.RunningAppProcessInfo();
        processInfo.pid = Process.myPid();
        processInfo.uid = Process.myUid();
        processInfo.processName = RuntimeEnvironment.application.getPackageName();
        processInfo.pkgList = new String[]{RuntimeEnvironment.application.getPackageName()};
        this.processes.add(processInfo);
    }

    @Implementation
    public int getMemoryClass() {
        return this.memoryClass;
    }

    @Implementation
    public static boolean isUserAMonkey() {
        return false;
    }

    @Implementation
    public List<ActivityManager.RunningTaskInfo> getRunningTasks(int maxNum) {
        return this.tasks;
    }

    @Implementation
    public List<ActivityManager.RunningServiceInfo> getRunningServices(int maxNum) {
        return this.services;
    }

    @Implementation
    public List<ActivityManager.RunningAppProcessInfo> getRunningAppProcesses() {
        if (this.processes.isEmpty()) {
            return null;
        }
        return this.processes;
    }

    @Implementation
    public void killBackgroundProcesses(String packageName) {
        this.backgroundPackage = packageName;
    }

    @Implementation
    public void getMemoryInfo(ActivityManager.MemoryInfo outInfo) {
        if (this.memoryInfo != null) {
            outInfo.availMem = this.memoryInfo.availMem;
            outInfo.lowMemory = this.memoryInfo.lowMemory;
            outInfo.threshold = this.memoryInfo.threshold;
            outInfo.totalMem = this.memoryInfo.totalMem;
        }
    }

    @Implementation
    public ConfigurationInfo getDeviceConfigurationInfo() {
        return new ConfigurationInfo();
    }

    public void setTasks(List<ActivityManager.RunningTaskInfo> tasks) {
        this.tasks.clear();
        this.tasks.addAll(tasks);
    }

    public void setServices(List<ActivityManager.RunningServiceInfo> services) {
        this.services.clear();
        this.services.addAll(services);
    }

    public void setProcesses(List<ActivityManager.RunningAppProcessInfo> processes) {
        this.processes.clear();
        this.processes.addAll(processes);
    }

    public String getBackgroundPackage() {
        return this.backgroundPackage;
    }

    public void setMemoryClass(int memoryClass) {
        this.memoryClass = memoryClass;
    }

    public void setMemoryInfo(ActivityManager.MemoryInfo memoryInfo) {
        this.memoryInfo = memoryInfo;
    }

    @Implementation
    public static IActivityManager getService() {
        return (IActivityManager)ReflectionHelpers.createNullProxy(IActivityManager.class);
    }

    @Implementation
    public boolean isLowRamDevice() {
        if (this.isLowRamDeviceOverride != null) {
            return this.isLowRamDeviceOverride;
        }
        return (Boolean)Shadow.directlyOn((Object)this.realObject, ActivityManager.class, (String)"isLowRamDevice", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    public ShadowActivityManager setIsLowRamDevice(boolean isLowRamDevice) {
        this.isLowRamDeviceOverride = isLowRamDevice;
        return this;
    }
}

