/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Intent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowPendingIntent;

@Implements(value=AlarmManager.class)
public class ShadowAlarmManager {
    private final List<ScheduledAlarm> scheduledAlarms = new ArrayList<ScheduledAlarm>();

    @Implementation
    public void set(int type, long triggerAtTime, PendingIntent operation) {
        this.internalSet(type, triggerAtTime, 0L, operation, null);
    }

    @Implementation(minSdk=19)
    public void setExact(int type, long triggerAtTime, PendingIntent operation) {
        this.internalSet(type, triggerAtTime, 0L, operation, null);
    }

    @Implementation(minSdk=19)
    public void setWindow(int type, long windowStartMillis, long windowLengthMillis, PendingIntent operation) {
        this.internalSet(type, windowStartMillis, 0L, operation, null);
    }

    @Implementation(minSdk=23)
    public void setAndAllowWhileIdle(int type, long triggerAtTime, PendingIntent operation) {
        this.internalSet(type, triggerAtTime, 0L, operation, null);
    }

    @Implementation(minSdk=23)
    public void setExactAndAllowWhileIdle(int type, long triggerAtTime, PendingIntent operation) {
        this.internalSet(type, triggerAtTime, 0L, operation, null);
    }

    @Implementation
    public void setRepeating(int type, long triggerAtTime, long interval, PendingIntent operation) {
        this.internalSet(type, triggerAtTime, interval, operation, null);
    }

    @Implementation
    public void setInexactRepeating(int type, long triggerAtMillis, long intervalMillis, PendingIntent operation) {
        this.internalSet(type, triggerAtMillis, intervalMillis, operation, null);
    }

    @Implementation(minSdk=21)
    public void setAlarmClock(AlarmManager.AlarmClockInfo info, PendingIntent operation) {
        this.internalSet(0, info.getTriggerTime(), 0L, operation, info.getShowIntent());
    }

    @Implementation(minSdk=21)
    public AlarmManager.AlarmClockInfo getNextAlarmClock() {
        for (ScheduledAlarm scheduledAlarm : this.scheduledAlarms) {
            AlarmManager.AlarmClockInfo alarmClockInfo = scheduledAlarm.getAlarmClockInfo();
            if (alarmClockInfo == null) continue;
            return alarmClockInfo;
        }
        return null;
    }

    private void internalSet(int type, long triggerAtTime, long interval, PendingIntent operation, PendingIntent showIntent) {
        this.cancel(operation);
        this.scheduledAlarms.add(new ScheduledAlarm(type, triggerAtTime, interval, operation, showIntent));
        Collections.sort(this.scheduledAlarms);
    }

    public ScheduledAlarm getNextScheduledAlarm() {
        if (this.scheduledAlarms.isEmpty()) {
            return null;
        }
        return this.scheduledAlarms.remove(0);
    }

    public ScheduledAlarm peekNextScheduledAlarm() {
        if (this.scheduledAlarms.isEmpty()) {
            return null;
        }
        return this.scheduledAlarms.get(0);
    }

    public List<ScheduledAlarm> getScheduledAlarms() {
        return this.scheduledAlarms;
    }

    @Implementation
    public void cancel(PendingIntent operation) {
        ShadowPendingIntent shadowPendingIntent = Shadows.shadowOf(operation);
        Intent toRemove = shadowPendingIntent.getSavedIntent();
        int requestCode = shadowPendingIntent.getRequestCode();
        for (ScheduledAlarm scheduledAlarm : this.scheduledAlarms) {
            ShadowPendingIntent scheduledShadowPendingIntent = Shadows.shadowOf(scheduledAlarm.operation);
            Intent scheduledIntent = scheduledShadowPendingIntent.getSavedIntent();
            int scheduledRequestCode = scheduledShadowPendingIntent.getRequestCode();
            if (!scheduledIntent.filterEquals(toRemove) || scheduledRequestCode != requestCode) continue;
            this.scheduledAlarms.remove(scheduledAlarm);
            break;
        }
    }

    public static class ScheduledAlarm
    implements Comparable<ScheduledAlarm> {
        public final int type;
        public final long triggerAtTime;
        public final long interval;
        public final PendingIntent operation;
        public final PendingIntent showIntent;

        public ScheduledAlarm(int type, long triggerAtTime, PendingIntent operation, PendingIntent showIntent) {
            this(type, triggerAtTime, 0L, operation, showIntent);
        }

        public ScheduledAlarm(int type, long triggerAtTime, long interval, PendingIntent operation, PendingIntent showIntent) {
            this.type = type;
            this.triggerAtTime = triggerAtTime;
            this.operation = operation;
            this.interval = interval;
            this.showIntent = showIntent;
        }

        @TargetApi(value=21)
        public AlarmManager.AlarmClockInfo getAlarmClockInfo() {
            return this.showIntent == null ? null : new AlarmManager.AlarmClockInfo(this.triggerAtTime, this.showIntent);
        }

        @Override
        public int compareTo(ScheduledAlarm scheduledAlarm) {
            return Long.compare(this.triggerAtTime, scheduledAlarm.triggerAtTime);
        }
    }
}

