/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.ParcelFileDescriptor;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.util.TypedValue;
import com.google.common.collect.Ordering;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.android.XmlResourceParserImpl;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.res.AttrData;
import org.robolectric.res.AttributeResource;
import org.robolectric.res.EmptyStyle;
import org.robolectric.res.FileTypedResource;
import org.robolectric.res.Fs;
import org.robolectric.res.FsFile;
import org.robolectric.res.ResName;
import org.robolectric.res.ResType;
import org.robolectric.res.ResourceIds;
import org.robolectric.res.ResourceTable;
import org.robolectric.res.Style;
import org.robolectric.res.StyleData;
import org.robolectric.res.StyleResolver;
import org.robolectric.res.ThemeStyleSet;
import org.robolectric.res.TypedResource;
import org.robolectric.res.android.ResTable_config;
import org.robolectric.res.builder.XmlBlock;
import org.robolectric.shadows.Converter;
import org.robolectric.shadows.ShadowTypedArray;
import org.robolectric.util.Logger;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AssetManager.class)
public class ShadowAssetManager {
    public static final int STYLE_NUM_ENTRIES = 6;
    public static final int STYLE_TYPE = 0;
    public static final int STYLE_DATA = 1;
    public static final int STYLE_ASSET_COOKIE = 2;
    public static final int STYLE_RESOURCE_ID = 3;
    public static final int STYLE_CHANGING_CONFIGURATIONS = 4;
    public static final int STYLE_DENSITY = 5;
    public static final Ordering<String> ATTRIBUTE_TYPE_PRECIDENCE = Ordering.explicit((Object)"reference", (Object[])new String[]{"color", "boolean", "integer", "fraction", "dimension", "float", "enum", "flag", "string"});
    boolean strictErrors = false;
    private static long nextInternalThemeId = 1000L;
    private static final Map<Long, NativeTheme> nativeThemes = new HashMap<Long, NativeTheme>();
    private ResourceTable resourceTable;
    ResTable_config config = new ResTable_config();
    private Set<FsFile> assetDirs = new CopyOnWriteArraySet<FsFile>();
    @RealObject
    AssetManager realObject;

    private void convertAndFill(AttributeResource attribute, TypedValue outValue, ResTable_config config, boolean resolveRefs) {
        if (attribute.isNull()) {
            outValue.type = 0;
            outValue.data = 0;
            return;
        }
        if (attribute.isEmpty()) {
            outValue.type = 0;
            outValue.data = 1;
            return;
        }
        outValue.assetCookie = Converter.getNextStringCookie();
        outValue.changingConfigurations = 0;
        if (attribute.isStyleReference()) {
            return;
        }
        while (attribute.isResourceReference()) {
            ResName resName = attribute.getResourceReference();
            Integer resourceId = attribute.getReferenceResId() != null ? attribute.getReferenceResId() : this.resourceTable.getResourceId(resName);
            if (resourceId == null) {
                throw new Resources.NotFoundException("unknown resource " + resName);
            }
            outValue.type = 1;
            if (!resolveRefs) {
                outValue.data = resourceId;
                return;
            }
            outValue.resourceId = resourceId;
            TypedResource dereferencedRef = this.resourceTable.getValue(resName, config);
            if (dereferencedRef == null) {
                Logger.strict((String)"couldn't resolve %s from %s", (Object[])new Object[]{resName.getFullyQualifiedName(), attribute});
                return;
            }
            if (dereferencedRef.isFile()) {
                outValue.type = 3;
                outValue.data = 0;
                outValue.assetCookie = Converter.getNextStringCookie();
                outValue.string = dereferencedRef.asString();
                return;
            }
            if (!(dereferencedRef.getData() instanceof String)) break;
            attribute = new AttributeResource(attribute.resName, dereferencedRef.asString(), resName.packageName);
            if (attribute.isResourceReference()) continue;
            if (!resolveRefs) break;
            Converter.getConverter(dereferencedRef.getResType()).fillTypedValue(attribute.value, outValue);
            return;
        }
        if (attribute.isNull()) {
            outValue.type = 0;
            return;
        }
        TypedResource attrTypeData = this.resourceTable.getValue(attribute.resName, config);
        if (attrTypeData != null) {
            AttrData attrData = (AttrData)attrTypeData.getData();
            String format = attrData.getFormat();
            String[] types = format.split("\\|");
            Arrays.sort(types, ATTRIBUTE_TYPE_PRECIDENCE);
            for (String type : types) {
                Converter converter;
                if ("reference".equals(type) || (converter = Converter.getConverterFor(attrData, type)) == null || !converter.fillTypedValue(attribute.value, outValue)) continue;
                return;
            }
        } else {
            ResType resType = ResType.inferFromValue((String)attribute.value);
            Converter.getConverter(resType).fillTypedValue(attribute.value, outValue);
        }
    }

    @Implementation
    public void __constructor__() {
        this.resourceTable = RuntimeEnvironment.getAppResourceTable();
    }

    @Implementation
    public void __constructor__(boolean isSystem) {
        this.resourceTable = isSystem ? RuntimeEnvironment.getSystemResourceTable() : RuntimeEnvironment.getAppResourceTable();
    }

    public ResourceTable getResourceTable() {
        return this.resourceTable;
    }

    @HiddenApi
    @Implementation
    public CharSequence getResourceText(int ident) {
        TypedResource value = this.getAndResolve(ident, this.config, true);
        if (value == null) {
            return null;
        }
        return (CharSequence)value.getData();
    }

    @HiddenApi
    @Implementation
    public CharSequence getResourceBagText(int ident, int bagEntryId) {
        throw new UnsupportedOperationException();
    }

    @HiddenApi
    @Implementation
    public String[] getResourceStringArray(int id) {
        CharSequence[] resourceTextArray = this.getResourceTextArray(id);
        if (resourceTextArray == null) {
            return null;
        }
        String[] strings = new String[resourceTextArray.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = resourceTextArray[i].toString();
        }
        return strings;
    }

    @HiddenApi
    @Implementation
    public int getResourceIdentifier(String name, String defType, String defPackage) {
        Integer resourceId = this.resourceTable.getResourceId(ResName.qualifyResName((String)name, (String)defPackage, (String)defType));
        return resourceId == null ? 0 : resourceId;
    }

    @HiddenApi
    @Implementation
    public boolean getResourceValue(int ident, int density, TypedValue outValue, boolean resolveRefs) {
        TypedResource value = this.getAndResolve(ident, this.config, resolveRefs);
        if (value == null) {
            return false;
        }
        this.getConverter(value).fillTypedValue(value.getData(), outValue);
        return true;
    }

    private Converter getConverter(TypedResource value) {
        if (value instanceof FileTypedResource.Image || value instanceof FileTypedResource && ((FileTypedResource)value).getFsFile().getName().endsWith(".xml")) {
            return new Converter.FromFilePath();
        }
        return Converter.getConverter(value.getResType());
    }

    @HiddenApi
    @Implementation
    public CharSequence[] getResourceTextArray(int resId) {
        TypedResource value = this.getAndResolve(resId, this.config, true);
        if (value == null) {
            return null;
        }
        List<TypedResource> items = this.getConverter(value).getItems(value);
        CharSequence[] charSequences = new CharSequence[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            TypedResource typedResource = this.resolve(items.get(i), this.config, resId);
            charSequences[i] = this.getConverter(typedResource).asCharSequence(typedResource);
        }
        return charSequences;
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public boolean getThemeValue(int themePtr, int ident, TypedValue outValue, boolean resolveRefs) {
        return this.getThemeValue((long)themePtr, ident, outValue, resolveRefs);
    }

    @HiddenApi
    @Implementation(minSdk=21)
    public boolean getThemeValue(long themePtr, int ident, TypedValue outValue, boolean resolveRefs) {
        ResName resName = this.resourceTable.getResName(ident);
        ThemeStyleSet themeStyleSet = ShadowAssetManager.getNativeTheme(themePtr).themeStyleSet;
        AttributeResource attrValue = themeStyleSet.getAttrValue(resName);
        while (attrValue != null && attrValue.isStyleReference()) {
            ResName attrResName = attrValue.getStyleReference();
            if (attrValue.resName.equals((Object)attrResName)) {
                Logger.info((String)"huh... circular reference for %s?", (Object[])new Object[]{attrResName.getFullyQualifiedName()});
                return false;
            }
            attrValue = themeStyleSet.getAttrValue(attrResName);
        }
        if (attrValue != null) {
            this.convertAndFill(attrValue, outValue, this.config, resolveRefs);
            return true;
        }
        return false;
    }

    @HiddenApi
    @Implementation
    public void ensureStringBlocks() {
    }

    @Implementation
    public final InputStream open(String fileName) throws IOException {
        return this.findAssetFile(fileName).getInputStream();
    }

    @Implementation
    public final InputStream open(String fileName, int accessMode) throws IOException {
        return this.findAssetFile(fileName).getInputStream();
    }

    @Implementation
    public final AssetFileDescriptor openFd(String fileName) throws IOException {
        File file = new File(this.findAssetFile(fileName).getPath());
        if (file.getPath().startsWith("jar")) {
            file = ShadowAssetManager.getFileFromZip(file);
        }
        ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        return new AssetFileDescriptor(parcelFileDescriptor, 0L, file.length());
    }

    private FsFile findAssetFile(String fileName) throws IOException {
        for (FsFile assetDir : this.getAllAssetsDirectories()) {
            FsFile assetFile = assetDir.join(new String[]{fileName});
            if (!assetFile.exists()) continue;
            return assetFile;
        }
        throw new FileNotFoundException("Asset file " + fileName + " not found");
    }

    private static File getFileFromZip(File file) {
        File fileFromZip = null;
        String pathString = file.getPath();
        String zipFile = pathString.substring(pathString.lastIndexOf(":") + 1, pathString.indexOf("!"));
        String filePathInsideZip = pathString.split("!")[1].substring(1);
        byte[] buffer = new byte[1024];
        try {
            File outputDir = Files.createTempDirectory("robolectric_assets", new FileAttribute[0]).toFile();
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                String currentFilename = ze.getName();
                if (!currentFilename.equals(filePathInsideZip)) {
                    ze = zis.getNextEntry();
                    continue;
                }
                fileFromZip = new File(outputDir + File.separator + currentFilename);
                new File(fileFromZip.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(fileFromZip);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                break;
            }
            zis.closeEntry();
            zis.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return fileFromZip;
    }

    @Implementation
    public final String[] list(String path) throws IOException {
        ArrayList assetFiles = new ArrayList();
        for (FsFile assetsDir : this.getAllAssetsDirectories()) {
            FsFile file = path.isEmpty() ? assetsDir : assetsDir.join(new String[]{path});
            if (!file.isDirectory()) continue;
            Collections.addAll(assetFiles, file.listFileNames());
        }
        return assetFiles.toArray(new String[assetFiles.size()]);
    }

    @HiddenApi
    @Implementation
    public final InputStream openNonAsset(int cookie, String fileName, int accessMode) throws IOException {
        ResName resName = this.qualifyFromNonAssetFileName(fileName);
        FileTypedResource typedResource = (FileTypedResource)this.resourceTable.getValue(resName, this.config);
        if (typedResource == null) {
            throw new IOException("Unable to find resource for " + fileName);
        }
        if (accessMode == 2) {
            return typedResource.getFsFile().getInputStream();
        }
        return new ByteArrayInputStream(typedResource.getFsFile().getBytes());
    }

    private ResName qualifyFromNonAssetFileName(String fileName) {
        if (fileName.startsWith("jar:") && !fileName.contains("resource_files.zip")) {
            return ResName.qualifyFromFilePath((String)"android", (String)fileName.replaceFirst("jar:", ""));
        }
        return ResName.qualifyFromFilePath((String)RuntimeEnvironment.application.getPackageName(), (String)fileName);
    }

    @HiddenApi
    @Implementation
    public final AssetFileDescriptor openNonAssetFd(int cookie, String fileName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Implementation
    public final XmlResourceParser openXmlResourceParser(int cookie, String fileName) throws IOException {
        XmlBlock xmlBlock = XmlBlock.create((FsFile)Fs.fileFromPath((String)fileName), (String)this.resourceTable.getPackageName());
        if (xmlBlock == null) {
            throw new Resources.NotFoundException(fileName);
        }
        return this.getXmlResourceParser(this.resourceTable, xmlBlock, this.resourceTable.getPackageName());
    }

    public XmlResourceParser loadXmlResourceParser(int resId, String type) throws Resources.NotFoundException {
        ResName resName = this.getResName(resId);
        ResName resolvedResName = this.resolveResName(resName, this.config);
        if (resolvedResName == null) {
            throw new RuntimeException("couldn't resolve " + resName.getFullyQualifiedName());
        }
        resName = resolvedResName;
        XmlBlock block = this.resourceTable.getXml(resName, this.config);
        if (block == null) {
            throw new Resources.NotFoundException(resName.getFullyQualifiedName());
        }
        ResourceTable resourceProvider = ResourceIds.isFrameworkResource((int)resId) ? RuntimeEnvironment.getSystemResourceTable() : RuntimeEnvironment.getCompileTimeResourceTable();
        return this.getXmlResourceParser(resourceProvider, block, resName.packageName);
    }

    private XmlResourceParser getXmlResourceParser(ResourceTable resourceProvider, XmlBlock block, String packageName) {
        return new XmlResourceParserImpl(block.getDocument(), block.getFilename(), block.getPackageName(), packageName, resourceProvider);
    }

    @HiddenApi
    @Implementation
    public int addAssetPath(String path) {
        this.assetDirs.add(this.getFsFileFromPath(path));
        return 1;
    }

    private FsFile getFsFileFromPath(String property) {
        if (property.startsWith("jar")) {
            try {
                URL url = new URL(property);
                return Fs.fromURL((URL)url);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return Fs.fileFromPath((String)property);
    }

    @HiddenApi
    @Implementation
    public boolean isUpToDate() {
        return true;
    }

    @HiddenApi
    @Implementation
    public void setLocale(String locale) {
    }

    @Implementation
    public String[] getLocales() {
        return new String[0];
    }

    @HiddenApi
    @Implementation(maxSdk=25)
    public void setConfiguration(int mcc, int mnc, String locale, int orientation, int touchscreen, int density, int keyboard, int keyboardHidden, int navigation, int screenWidth, int screenHeight, int smallestScreenWidthDp, int screenWidthDp, int screenHeightDp, int screenLayout, int uiMode, int majorVersion) {
        this.setConfiguration(mcc, mnc, locale, orientation, touchscreen, density, keyboard, keyboardHidden, navigation, screenWidth, screenHeight, smallestScreenWidthDp, screenWidthDp, screenHeightDp, screenLayout, uiMode, 0, majorVersion);
    }

    @HiddenApi
    @Implementation(minSdk=26)
    public void setConfiguration(int mcc, int mnc, String locale, int orientation, int touchscreen, int density, int keyboard, int keyboardHidden, int navigation, int screenWidth, int screenHeight, int smallestScreenWidthDp, int screenWidthDp, int screenHeightDp, int screenLayout, int uiMode, int colorMode, int majorVersion) {
        ResTable_config config = new ResTable_config();
        int kScreenLayoutRoundMask = 768;
        int kScreenLayoutRoundShift = 8;
        config.mcc = mcc;
        config.mnc = mnc;
        config.orientation = orientation;
        config.touchscreen = touchscreen;
        config.density = density;
        config.keyboard = keyboard;
        config.inputFlags = keyboardHidden;
        config.navigation = navigation;
        config.screenWidth = screenWidth;
        config.screenHeight = screenHeight;
        config.smallestScreenWidthDp = smallestScreenWidthDp;
        config.screenWidthDp = screenWidthDp;
        config.screenHeightDp = screenHeightDp;
        config.screenLayout = screenLayout;
        config.uiMode = uiMode;
        config.sdkVersion = majorVersion;
        config.minorVersion = 0;
        config.screenLayout2 = (byte)((screenLayout & 0x300) >> 8);
        if (locale != null) {
            config.setBcp47Locale(locale);
        }
        this.config = config;
    }

    @HiddenApi
    @Implementation
    public int[] getArrayIntResource(int resId) {
        TypedResource value = this.getAndResolve(resId, this.config, true);
        if (value == null) {
            return null;
        }
        List<TypedResource> items = this.getConverter(value).getItems(value);
        int[] ints = new int[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            TypedResource typedResource = this.resolve(items.get(i), this.config, resId);
            ints[i] = this.getConverter(typedResource).asInt(typedResource);
        }
        return ints;
    }

    protected TypedArray getTypedArrayResource(Resources resources, int resId) {
        TypedResource value = this.getAndResolve(resId, this.config, true);
        if (value == null) {
            return null;
        }
        List<TypedResource> items = this.getConverter(value).getItems(value);
        return this.getTypedArray(resources, items, resId);
    }

    private TypedArray getTypedArray(Resources resources, List<TypedResource> typedResources, int resId) {
        CharSequence[] stringData = new CharSequence[typedResources.size()];
        int totalLen = typedResources.size() * 6;
        int[] data = new int[totalLen];
        for (int i = 0; i < typedResources.size(); ++i) {
            String reference;
            int offset = i * 6;
            TypedResource typedResource = typedResources.get(i);
            int type = this.getResourceType(typedResource);
            if (type == -1) continue;
            TypedValue typedValue = new TypedValue();
            if (type == 1) {
                reference = typedResource.asString();
                ResName refResName = AttributeResource.getResourceReference((String)reference, (String)typedResource.getXmlContext().getPackageName(), null);
                typedValue.data = typedValue.resourceId = this.resourceTable.getResourceId(refResName).intValue();
                if ((typedResource = this.resolve(typedResource, this.config, typedValue.resourceId)) != null) {
                    type = this.getResourceType(typedResource);
                    if (type == 2) {
                        type = 1;
                    } else if (type == -1) continue;
                }
            }
            if (type == 2) {
                reference = typedResource.asString();
                ResName attrResName = AttributeResource.getStyleReference((String)reference, (String)typedResource.getXmlContext().getPackageName(), (String)"attr");
                typedValue.data = this.resourceTable.getResourceId(attrResName);
            }
            if (typedResource != null && type != 0 && type != 2) {
                this.getConverter(typedResource).fillTypedValue(typedResource.getData(), typedValue);
            }
            data[offset + 0] = type;
            data[offset + 3] = typedValue.resourceId;
            data[offset + 1] = typedValue.data;
            data[offset + 2] = typedValue.assetCookie;
            data[offset + 4] = typedValue.changingConfigurations;
            data[offset + 5] = typedValue.density;
            stringData[i] = typedResource == null ? null : typedResource.asString();
        }
        int[] indices = new int[typedResources.size() + 1];
        return ShadowTypedArray.create(resources, null, data, indices, typedResources.size(), stringData);
    }

    private int getResourceType(TypedResource typedResource) {
        if (typedResource == null) {
            return -1;
        }
        ResType resType = typedResource.getResType();
        int type = typedResource.getData() == null || resType == ResType.NULL ? 0 : (typedResource.isReference() ? 1 : (resType == ResType.STYLE ? 2 : (resType == ResType.CHAR_SEQUENCE || resType == ResType.DRAWABLE ? 3 : (resType == ResType.INTEGER ? 16 : (resType == ResType.FLOAT || resType == ResType.FRACTION ? 4 : (resType == ResType.BOOLEAN ? 18 : (resType == ResType.DIMEN ? 5 : (resType == ResType.COLOR ? 28 : (resType == ResType.TYPED_ARRAY || resType == ResType.CHAR_SEQUENCE_ARRAY ? 1 : -1)))))))));
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HiddenApi
    @Implementation
    public Number createTheme() {
        Map<Long, NativeTheme> map = nativeThemes;
        synchronized (map) {
            long nativePtr = nextInternalThemeId++;
            nativeThemes.put(nativePtr, new NativeTheme(new ThemeStyleSet()));
            return RuntimeEnvironment.castNativePtr(nativePtr);
        }
    }

    private static NativeTheme getNativeTheme(Resources.Theme theme) {
        return ShadowAssetManager.getNativeTheme(Shadows.shadowOf(theme).getNativePtr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NativeTheme getNativeTheme(long themePtr) {
        NativeTheme nativeTheme;
        Map<Long, NativeTheme> map = nativeThemes;
        synchronized (map) {
            nativeTheme = nativeThemes.get(themePtr);
        }
        if (nativeTheme == null) {
            throw new RuntimeException("no theme " + themePtr + " found in AssetManager");
        }
        return nativeTheme;
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public void releaseTheme(int themePtr) {
        this.releaseTheme((long)themePtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HiddenApi
    @Implementation(minSdk=21)
    public void releaseTheme(long themePtr) {
        Map<Long, NativeTheme> map = nativeThemes;
        synchronized (map) {
            nativeThemes.remove(themePtr);
        }
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void applyThemeStyle(int themePtr, int styleRes, boolean force) {
        ShadowAssetManager.applyThemeStyle((long)themePtr, styleRes, force);
    }

    @HiddenApi
    @Implementation(minSdk=21)
    public static void applyThemeStyle(long themePtr, int styleRes, boolean force) {
        NativeTheme nativeTheme = ShadowAssetManager.getNativeTheme(themePtr);
        Style style = nativeTheme.getShadowAssetManager().resolveStyle(styleRes, null);
        nativeTheme.themeStyleSet.apply(style, force);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void copyTheme(int destPtr, int sourcePtr) {
        ShadowAssetManager.copyTheme((long)destPtr, (long)sourcePtr);
    }

    @HiddenApi
    @Implementation(minSdk=21)
    public static void copyTheme(long destPtr, long sourcePtr) {
        NativeTheme destNativeTheme = ShadowAssetManager.getNativeTheme(destPtr);
        NativeTheme sourceNativeTheme = ShadowAssetManager.getNativeTheme(sourcePtr);
        destNativeTheme.themeStyleSet = sourceNativeTheme.themeStyleSet.copy();
    }

    Style resolveStyle(int resId, Style themeStyleSet) {
        return this.resolveStyle(this.getResName(resId), themeStyleSet);
    }

    private Style resolveStyle(@Nonnull ResName themeStyleName, Style themeStyleSet) {
        TypedResource themeStyleResource = this.resourceTable.getValue(themeStyleName, this.config);
        if (themeStyleResource == null) {
            return null;
        }
        StyleData themeStyleData = (StyleData)themeStyleResource.getData();
        if (themeStyleSet == null) {
            themeStyleSet = new ThemeStyleSet();
        }
        return new StyleResolver(this.resourceTable, Shadows.shadowOf(AssetManager.getSystem()).getResourceTable(), themeStyleData, themeStyleSet, themeStyleName, this.config);
    }

    private TypedResource getAndResolve(int resId, ResTable_config config, boolean resolveRefs) {
        TypedResource value = this.resourceTable.getValue(resId, config);
        if (resolveRefs) {
            value = this.resolve(value, config, resId);
        }
        return value;
    }

    TypedResource resolve(TypedResource value, ResTable_config config, int resId) {
        return this.resolveResourceValue(value, config, resId);
    }

    public ResName resolveResName(ResName resName, ResTable_config config) {
        TypedResource value = this.resourceTable.getValue(resName, config);
        return this.resolveResource(value, config, resName);
    }

    private ResName resolveResource(TypedResource value, ResTable_config config, ResName resName) {
        while (value != null && value.isReference()) {
            String s = value.asString();
            if (AttributeResource.isNull((String)s) || AttributeResource.isEmpty((String)s)) {
                value = null;
                continue;
            }
            String refStr = s.substring(1).replace("+", "");
            resName = ResName.qualifyResName((String)refStr, (ResName)resName);
            value = this.resourceTable.getValue(resName, config);
        }
        return resName;
    }

    private TypedResource resolveResourceValue(TypedResource value, ResTable_config config, ResName resName) {
        while (value != null && value.isReference()) {
            String s = value.asString();
            if (AttributeResource.isNull((String)s) || AttributeResource.isEmpty((String)s)) {
                value = null;
                continue;
            }
            String refStr = s.substring(1).replace("+", "");
            resName = ResName.qualifyResName((String)refStr, (ResName)resName);
            value = this.resourceTable.getValue(resName, config);
        }
        return value;
    }

    public TypedResource resolveResourceValue(TypedResource value, ResTable_config config, int resId) {
        ResName resName = this.getResName(resId);
        return this.resolveResourceValue(value, config, resName);
    }

    private TypedValue buildTypedValue(AttributeSet set, int resId, int defStyleAttr, Style themeStyleSet, int defStyleRes) {
        ResName defStyleName;
        AttributeResource defStyleAttribute;
        Style defStyleFromAttr = null;
        Style defStyleFromRes = null;
        Style styleAttrStyle = null;
        if (defStyleAttr != 0 && (defStyleAttribute = themeStyleSet.getAttrValue(defStyleName = this.getResName(defStyleAttr))) != null) {
            while (defStyleAttribute.isStyleReference()) {
                AttributeResource other = themeStyleSet.getAttrValue(defStyleAttribute.getStyleReference());
                if (other == null) {
                    throw new RuntimeException("couldn't dereference " + defStyleAttribute);
                }
                defStyleAttribute = other;
            }
            if (defStyleAttribute.isResourceReference()) {
                ResName defStyleResName = defStyleAttribute.getResourceReference();
                defStyleFromAttr = this.resolveStyle(defStyleResName, themeStyleSet);
            }
        }
        if (set != null && set.getStyleAttribute() != 0) {
            ResName styleAttributeResName = this.getResName(set.getStyleAttribute());
            while (styleAttributeResName.type.equals("attr")) {
                AttributeResource attrValue = themeStyleSet.getAttrValue(styleAttributeResName);
                if (attrValue == null) {
                    throw new RuntimeException("no value for " + styleAttributeResName.getFullyQualifiedName() + " in " + themeStyleSet);
                }
                if (attrValue.isResourceReference()) {
                    styleAttributeResName = attrValue.getResourceReference();
                    continue;
                }
                if (!attrValue.isStyleReference()) continue;
                styleAttributeResName = attrValue.getStyleReference();
            }
            styleAttrStyle = this.resolveStyle(styleAttributeResName, themeStyleSet);
        }
        if (defStyleRes != 0) {
            AttributeResource attributeValue;
            ResName resName = this.getResName(defStyleRes);
            if (resName.type.equals("attr") && (attributeValue = this.findAttributeValue(defStyleRes, set, styleAttrStyle, defStyleFromAttr, defStyleFromAttr, themeStyleSet)) != null) {
                if (attributeValue.isStyleReference()) {
                    resName = themeStyleSet.getAttrValue(attributeValue.getStyleReference()).getResourceReference();
                } else if (attributeValue.isResourceReference()) {
                    resName = attributeValue.getResourceReference();
                }
            }
            defStyleFromRes = this.resolveStyle(resName, themeStyleSet);
        }
        AttributeResource attribute = this.findAttributeValue(resId, set, styleAttrStyle, defStyleFromAttr, defStyleFromRes, themeStyleSet);
        while (attribute != null && attribute.isStyleReference()) {
            ResName otherAttrName = attribute.getStyleReference();
            if (attribute.resName.equals((Object)otherAttrName)) {
                Logger.info((String)"huh... circular reference for %s?", (Object[])new Object[]{attribute.resName.getFullyQualifiedName()});
                return null;
            }
            ResName resName = this.resourceTable.getResName(resId);
            AttributeResource otherAttr = themeStyleSet.getAttrValue(otherAttrName);
            if (otherAttr == null) {
                this.strictError("no such attr %s in %s while resolving value for %s", attribute.value, themeStyleSet, resName.getFullyQualifiedName());
                attribute = null;
                continue;
            }
            attribute = new AttributeResource(resName, otherAttr.value, otherAttr.contextPackageName);
        }
        if (attribute == null || attribute.isNull()) {
            return null;
        }
        TypedValue typedValue = new TypedValue();
        this.convertAndFill(attribute, typedValue, this.config, true);
        return typedValue;
    }

    private void strictError(String message, Object ... args) {
        if (this.strictErrors) {
            throw new RuntimeException(String.format(message, args));
        }
        Logger.strict((String)message, (Object[])args);
    }

    TypedArray attrsToTypedArray(Resources resources, AttributeSet set, int[] attrs, int defStyleAttr, long nativeTheme, int defStyleRes) {
        CharSequence[] stringData = new CharSequence[attrs.length];
        int[] data = new int[attrs.length * 6];
        int[] indices = new int[attrs.length + 1];
        int nextIndex = 0;
        EmptyStyle themeStyleSet = nativeTheme == 0L ? new EmptyStyle() : ShadowAssetManager.getNativeTheme(nativeTheme).themeStyleSet;
        for (int i = 0; i < attrs.length; ++i) {
            int offset = i * 6;
            TypedValue typedValue = this.buildTypedValue(set, attrs[i], defStyleAttr, (Style)themeStyleSet, defStyleRes);
            if (typedValue == null) continue;
            data[offset + 0] = typedValue.type;
            data[offset + 1] = typedValue.type == 3 ? i : typedValue.data;
            data[offset + 2] = typedValue.assetCookie;
            data[offset + 3] = typedValue.resourceId;
            data[offset + 4] = typedValue.changingConfigurations;
            data[offset + 5] = typedValue.density;
            stringData[i] = typedValue.string;
            indices[nextIndex + 1] = i;
            ++nextIndex;
        }
        indices[0] = nextIndex;
        TypedArray typedArray = ShadowTypedArray.create(resources, attrs, data, indices, nextIndex, stringData);
        if (set != null) {
            Shadows.shadowOf((TypedArray)typedArray).positionDescription = set.getPositionDescription();
        }
        return typedArray;
    }

    private AttributeResource findAttributeValue(int resId, AttributeSet attributeSet, Style styleAttrStyle, Style defStyleFromAttr, Style defStyleFromRes, @Nonnull Style themeStyleSet) {
        AttributeResource attribute;
        ResName attrName;
        if (attributeSet != null) {
            for (int i = 0; i < attributeSet.getAttributeCount(); ++i) {
                if (attributeSet.getAttributeNameResource(i) != resId || attributeSet.getAttributeValue(i) == null) continue;
                String defaultPackageName = ResourceIds.isFrameworkResource((int)resId) ? "android" : RuntimeEnvironment.application.getPackageName();
                ResName resName = ResName.qualifyResName((String)attributeSet.getAttributeName(i), (String)defaultPackageName, (String)"attr");
                Integer referenceResId = null;
                if (AttributeResource.isResourceReference((String)attributeSet.getAttributeValue(i))) {
                    referenceResId = attributeSet.getAttributeResourceValue(i, -1);
                }
                return new AttributeResource(resName, attributeSet.getAttributeValue(i), "fixme!!!", referenceResId);
            }
        }
        if ((attrName = this.resourceTable.getResName(resId)) == null) {
            return null;
        }
        if (styleAttrStyle != null && (attribute = styleAttrStyle.getAttrValue(attrName)) != null) {
            return attribute;
        }
        if (defStyleFromAttr != null && (attribute = defStyleFromAttr.getAttrValue(attrName)) != null) {
            return attribute;
        }
        if (defStyleFromRes != null && (attribute = defStyleFromRes.getAttrValue(attrName)) != null) {
            return attribute;
        }
        return themeStyleSet.getAttrValue(attrName);
    }

    Collection<FsFile> getAllAssetsDirectories() {
        return this.assetDirs;
    }

    @Nonnull
    private ResName getResName(int id) {
        ResName resName = this.resourceTable.getResName(id);
        if (resName == null) {
            throw new Resources.NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(id) + " in packages " + this.resourceTable);
        }
        return resName;
    }

    @Implementation
    public String getResourceName(int resid) {
        return this.getResName(resid).getFullyQualifiedName();
    }

    @Implementation
    public String getResourcePackageName(int resid) {
        return this.getResName((int)resid).packageName;
    }

    @Implementation
    public String getResourceTypeName(int resid) {
        return this.getResName((int)resid).type;
    }

    @Implementation
    public String getResourceEntryName(int resid) {
        return this.getResName((int)resid).name;
    }

    @Implementation
    public final SparseArray<String> getAssignedPackageIdentifiers() {
        return new SparseArray();
    }

    @Resetter
    public static void reset() {
        ReflectionHelpers.setStaticField(AssetManager.class, (String)"sSystem", null);
    }

    class NativeTheme {
        private ThemeStyleSet themeStyleSet;

        public NativeTheme(ThemeStyleSet themeStyleSet) {
            this.themeStyleSet = themeStyleSet;
        }

        public ShadowAssetManager getShadowAssetManager() {
            return ShadowAssetManager.this;
        }
    }
}

