/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.location.Address;
import android.location.Geocoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=Geocoder.class)
public final class ShadowGeocoder {
    private static boolean isPresent = true;
    private List<Address> fromLocation = new ArrayList<Address>();

    @Implementation
    public static boolean isPresent() {
        return isPresent;
    }

    @Implementation
    protected List<Address> getFromLocation(double latitude, double longitude, int maxResults) throws IOException {
        return this.fromLocation.subList(0, Math.min(maxResults, this.fromLocation.size()));
    }

    public static void setIsPresent(boolean value) {
        isPresent = value;
    }

    public void setFromLocation(List<Address> list) {
        this.fromLocation = list;
    }

    @Resetter
    public static void reset() {
        isPresent = true;
    }
}

