/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.IBinder;
import android.os.ResultReceiver;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.google.common.base.Optional;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;

@Implements(value=InputMethodManager.class, callThroughByDefault=false)
public class ShadowInputMethodManager {
    private boolean softInputVisible;
    private Optional<SoftInputVisibilityChangeHandler> visibilityChangeHandler = Optional.absent();

    @HiddenApi
    @Implementation
    public static InputMethodManager peekInstance() {
        return (InputMethodManager)Shadow.newInstanceOf(InputMethodManager.class);
    }

    @Implementation
    public boolean showSoftInput(View view, int flags) {
        return this.showSoftInput(view, flags, null);
    }

    @Implementation
    public boolean showSoftInput(View view, int flags, ResultReceiver resultReceiver) {
        this.setSoftInputVisibility(true);
        return true;
    }

    @Implementation
    public boolean hideSoftInputFromWindow(IBinder windowToken, int flags) {
        return this.hideSoftInputFromWindow(windowToken, flags, null);
    }

    @Implementation
    public boolean hideSoftInputFromWindow(IBinder windowToken, int flags, ResultReceiver resultReceiver) {
        this.setSoftInputVisibility(false);
        return true;
    }

    @Implementation
    public void toggleSoftInput(int showFlags, int hideFlags) {
        this.setSoftInputVisibility(!this.isSoftInputVisible());
    }

    public boolean isSoftInputVisible() {
        return this.softInputVisible;
    }

    public void setSoftInputVisibilityHandler(SoftInputVisibilityChangeHandler visibilityChangeHandler) {
        this.visibilityChangeHandler = Optional.of((Object)visibilityChangeHandler);
    }

    private void setSoftInputVisibility(boolean visible) {
        if (visible == this.softInputVisible) {
            return;
        }
        this.softInputVisible = visible;
        if (this.visibilityChangeHandler.isPresent()) {
            ((SoftInputVisibilityChangeHandler)this.visibilityChangeHandler.get()).handleSoftInputVisibilityChange(this.softInputVisible);
        }
    }

    public static interface SoftInputVisibilityChangeHandler {
        public void handleSoftInputVisibilityChange(boolean var1);
    }
}

