/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Activity;
import android.app.KeyguardManager;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;

@Implements(value=KeyguardManager.class)
public class ShadowKeyguardManager {
    @RealObject
    private KeyguardManager realKeyguardManager;
    private KeyguardManager.KeyguardLock keyguardLock = (KeyguardManager.KeyguardLock)Shadow.newInstanceOf(KeyguardManager.KeyguardLock.class);
    private boolean inRestrictedInputMode;
    private boolean isKeyguardLocked;
    private boolean isDeviceLocked;
    private boolean isKeyguardSecure;
    private boolean isDeviceSecure;
    private KeyguardManager.KeyguardDismissCallback callback;

    @Implementation
    protected boolean inKeyguardRestrictedInputMode() {
        return this.inRestrictedInputMode;
    }

    @Implementation(minSdk=26)
    protected void requestDismissKeyguard(Activity activity, KeyguardManager.KeyguardDismissCallback callback) {
        if (this.isKeyguardLocked) {
            if (this.callback != null) {
                callback.onDismissError();
            }
            this.callback = callback;
        } else {
            callback.onDismissError();
        }
    }

    @Implementation
    protected boolean isKeyguardLocked() {
        return this.isKeyguardLocked;
    }

    public void setKeyguardLocked(boolean isKeyguardLocked) {
        this.isKeyguardLocked = isKeyguardLocked;
        if (this.callback != null) {
            if (isKeyguardLocked) {
                this.callback.onDismissCancelled();
            } else {
                this.callback.onDismissSucceeded();
            }
            this.callback = null;
        }
    }

    @Implementation
    protected KeyguardManager.KeyguardLock newKeyguardLock(String tag) {
        return this.keyguardLock;
    }

    @Deprecated
    public void setinRestrictedInputMode(boolean restricted) {
        this.inRestrictedInputMode = restricted;
    }

    public void setInRestrictedInputMode(boolean restricted) {
        this.inRestrictedInputMode = restricted;
    }

    @Implementation
    protected boolean isKeyguardSecure() {
        return this.isKeyguardSecure;
    }

    public void setIsKeyguardSecure(boolean secure) {
        this.isKeyguardSecure = secure;
    }

    @Implementation(minSdk=23)
    protected boolean isDeviceSecure() {
        return this.isDeviceSecure;
    }

    public void setIsDeviceSecure(boolean isDeviceSecure) {
        this.isDeviceSecure = isDeviceSecure;
    }

    public void setIsDeviceLocked(boolean isDeviceLocked) {
        this.isDeviceLocked = isDeviceLocked;
    }

    @Implementation(minSdk=22)
    protected boolean isDeviceLocked() {
        return this.isDeviceLocked;
    }

    @Implements(value=KeyguardManager.KeyguardLock.class)
    public static class ShadowKeyguardLock {
        private boolean keyguardEnabled = true;

        @Implementation
        protected void disableKeyguard() {
            this.keyguardEnabled = false;
        }

        @Implementation
        protected void reenableKeyguard() {
            this.keyguardEnabled = true;
        }

        public boolean isEnabled() {
            return this.keyguardEnabled;
        }
    }
}

