/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Path;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=Path.class)
public class ShadowPath {
    private List<Point> points = new ArrayList<Point>();
    private Point wasMovedTo;
    private String quadDescription = "";

    @Implementation
    public void __constructor__(Path path) {
        this.points = new ArrayList<Point>(Shadows.shadowOf(path).getPoints());
        this.wasMovedTo = Shadows.shadowOf((Path)path).wasMovedTo;
        this.quadDescription = Shadows.shadowOf((Path)path).quadDescription;
    }

    @Implementation
    public void moveTo(float x, float y) {
        Point p = new Point(x, y, Point.Type.MOVE_TO);
        this.points.add(p);
        this.wasMovedTo = p;
    }

    @Implementation
    public void lineTo(float x, float y) {
        Point point = new Point(x, y, Point.Type.LINE_TO);
        this.points.add(point);
    }

    @Implementation
    public void quadTo(float x1, float y1, float x2, float y2) {
        this.quadDescription = "Add a quadratic bezier from last point, approaching (" + x1 + "," + y1 + "), ending at (" + x2 + "," + y2 + ")";
    }

    @Implementation
    public void reset() {
        this.points.clear();
        this.wasMovedTo = null;
        this.quadDescription = "";
    }

    @Implementation
    public float[] approximate(float acceptableError) {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public String getQuadDescription() {
        return this.quadDescription;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public Point getWasMovedTo() {
        return this.wasMovedTo;
    }

    public static class Point {
        private final float x;
        private final float y;
        private final Type type;

        public Point(float x, float y, Type type) {
            this.x = x;
            this.y = y;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Point)) {
                return false;
            }
            Point point = (Point)o;
            if (Float.compare(point.x, this.x) != 0) {
                return false;
            }
            if (Float.compare(point.y, this.y) != 0) {
                return false;
            }
            return this.type == point.type;
        }

        public int hashCode() {
            int result = this.x != 0.0f ? Float.floatToIntBits(this.x) : 0;
            result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Point(" + this.x + "," + this.y + "," + (Object)((Object)this.type) + ")";
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public Type getType() {
            return this.type;
        }

        public static enum Type {
            MOVE_TO,
            LINE_TO;

        }
    }
}

