/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.content.pm.UserInfo;
import android.os.Bundle;
import android.os.IUserManager;
import android.os.Process;
import android.os.UserHandle;
import android.os.UserManager;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=UserManager.class, minSdk=17)
public class ShadowUserManager {
    private boolean userUnlocked = true;
    private boolean managedProfile = false;
    private boolean isDemoUser = false;
    private Map<UserHandle, Bundle> userRestrictions = new HashMap<UserHandle, Bundle>();
    private BiMap<UserHandle, Long> userProfiles = HashBiMap.create();
    private Map<String, Bundle> applicationRestrictions = new HashMap<String, Bundle>();
    private long nextUserSerial = 0L;
    private Map<UserHandle, UserState> userState = new HashMap<UserHandle, UserState>();
    private Context context;
    private boolean enforcePermissions;

    @Implementation
    protected void __constructor__(Context context, IUserManager service) {
        this.context = context;
    }

    public ShadowUserManager() {
        this.addUserProfile(Process.myUserHandle());
    }

    @Implementation(minSdk=18)
    protected Bundle getApplicationRestrictions(String packageName) {
        Bundle bundle = this.applicationRestrictions.get(packageName);
        return bundle != null ? bundle : new Bundle();
    }

    public void setApplicationRestrictions(String packageName, Bundle restrictions) {
        this.applicationRestrictions.put(packageName, restrictions);
    }

    public long addUserProfile(UserHandle userHandle) {
        long serialNumber = this.nextUserSerial++;
        this.userProfiles.put((Object)userHandle, (Object)serialNumber);
        return serialNumber;
    }

    @Implementation(minSdk=21)
    protected List<UserHandle> getUserProfiles() {
        return ImmutableList.copyOf((Collection)this.userProfiles.keySet());
    }

    @Implementation(minSdk=24)
    protected boolean isUserUnlocked() {
        return this.userUnlocked;
    }

    public void setUserUnlocked(boolean userUnlocked) {
        this.userUnlocked = userUnlocked;
    }

    @Implementation(minSdk=21)
    protected boolean isManagedProfile() {
        if (this.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("You need MANAGE_USERS permission to: check if specified user a managed profile outside your profile group");
        }
        return this.managedProfile;
    }

    public void enforcePermissionChecks(boolean enforcePermissions) {
        this.enforcePermissions = enforcePermissions;
    }

    public void setManagedProfile(boolean managedProfile) {
        this.managedProfile = managedProfile;
    }

    @Implementation(minSdk=21)
    protected boolean hasUserRestriction(String restrictionKey, UserHandle userHandle) {
        Bundle bundle = this.userRestrictions.get(userHandle);
        return bundle != null && bundle.getBoolean(restrictionKey);
    }

    public void setUserRestriction(UserHandle userHandle, String restrictionKey, boolean value) {
        Bundle bundle = this.getUserRestrictionsForUser(userHandle);
        bundle.putBoolean(restrictionKey, value);
    }

    public void clearUserRestrictions(UserHandle userHandle) {
        if (this.userRestrictions.containsKey(userHandle)) {
            this.userRestrictions.remove(userHandle);
        }
    }

    @Implementation(minSdk=18)
    protected Bundle getUserRestrictions(UserHandle userHandle) {
        return this.getUserRestrictionsForUser(userHandle);
    }

    private Bundle getUserRestrictionsForUser(UserHandle userHandle) {
        Bundle bundle = this.userRestrictions.get(userHandle);
        if (bundle == null) {
            bundle = new Bundle();
            this.userRestrictions.put(userHandle, bundle);
        }
        return bundle;
    }

    @Implementation
    protected long getSerialNumberForUser(UserHandle userHandle) {
        Long result = (Long)this.userProfiles.get((Object)userHandle);
        return result == null ? -1L : result;
    }

    @Deprecated
    public void setSerialNumberForUser(UserHandle userHandle, long serialNumber) {
        this.userProfiles.put((Object)userHandle, (Object)serialNumber);
    }

    @Implementation
    protected UserHandle getUserForSerialNumber(long serialNumber) {
        return (UserHandle)this.userProfiles.inverse().get((Object)serialNumber);
    }

    private boolean hasManageUsersPermission() {
        return this.context.getPackageManager().checkPermission("android.permission.MANAGE_USERS", this.context.getPackageName()) == 0;
    }

    private void checkPermissions() {
    }

    @Implementation(minSdk=25)
    protected boolean isDemoUser() {
        return this.isDemoUser;
    }

    public void setIsDemoUser(boolean isDemoUser) {
        this.isDemoUser = isDemoUser;
    }

    @Implementation
    protected boolean isUserRunning(UserHandle handle) {
        this.checkPermissions();
        UserState state = this.userState.get(handle);
        return state == UserState.STATE_RUNNING_LOCKED || state == UserState.STATE_RUNNING_UNLOCKED || state == UserState.STATE_RUNNING_UNLOCKING;
    }

    @Implementation
    protected boolean isUserRunningOrStopping(UserHandle handle) {
        this.checkPermissions();
        UserState state = this.userState.get(handle);
        return state == UserState.STATE_RUNNING_LOCKED || state == UserState.STATE_RUNNING_UNLOCKED || state == UserState.STATE_RUNNING_UNLOCKING || state == UserState.STATE_STOPPING;
    }

    public void setUserState(UserHandle handle, UserState state) {
        this.userState.put(handle, state);
    }

    @Implementation
    protected List<UserInfo> getUsers() {
        return ImmutableList.of();
    }

    public static enum UserState {
        STATE_BOOTING,
        STATE_RUNNING_LOCKED,
        STATE_RUNNING_UNLOCKING,
        STATE_RUNNING_UNLOCKED,
        STATE_STOPPING,
        STATE_SHUTDOWN;

    }
}

