/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import com.android.internal.util.VirtualRefBasePtr;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=VirtualRefBasePtr.class, isInAndroidSdk=false)
public class ShadowVirtualRefBasePtr {
    private static final Map<Long, RefHolder> POINTERS = new HashMap<Long, RefHolder>();
    private static long nextNativeObj = 10000L;

    public static synchronized <T> long put(T object) {
        long nativePtr = nextNativeObj++;
        POINTERS.put(nativePtr, new RefHolder<T>(object));
        return nativePtr;
    }

    public static synchronized <T> T get(long nativePtr, Class<T> clazz) {
        return clazz.cast(ShadowVirtualRefBasePtr.POINTERS.get((Object)Long.valueOf((long)nativePtr)).nativeThing);
    }

    @Implementation
    public static synchronized void nIncStrong(long ptr) {
        if (ptr == 0L) {
            return;
        }
        POINTERS.get(ptr).incr();
    }

    @Implementation
    public static synchronized void nDecStrong(long ptr) {
        if (ptr == 0L) {
            return;
        }
        if (POINTERS.get(ptr).decr()) {
            POINTERS.remove(ptr);
        }
    }

    private static class RefHolder<T> {
        T nativeThing;
        int refCount;

        public RefHolder(T object) {
            this.nativeThing = object;
        }

        public synchronized void incr() {
            ++this.refCount;
        }

        public synchronized boolean decr() {
            --this.refCount;
            return this.refCount == 0;
        }
    }
}

