/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal;

import java.util.Locale;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.rythmengine.RythmEngine;
import org.rythmengine.conf.RythmConfiguration;
import org.rythmengine.exception.FastRuntimeException;
import org.rythmengine.exception.ParseException;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.internal.CodeBuilder;
import org.rythmengine.internal.IBlockHandler;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IDialect;
import org.rythmengine.internal.TemplateTokenizer;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.compiler.TemplateClass;
import org.rythmengine.internal.dialect.DialectManager;
import org.rythmengine.internal.parser.build_in.SectionParser;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.resource.TemplateResourceManager;

public class TemplateParser
implements IContext {
    private static final ILogger logger = Logger.get(TemplateParser.class);
    private final CodeBuilder cb;
    private final RythmEngine engine;
    private final RythmConfiguration conf;
    private final boolean compactMode;
    private String template;
    private int totalLines;
    int cursor = 0;
    private IDialect dialect = null;
    private Stack<IBlockHandler> blocks = new Stack();
    private Stack<Boolean> compactStack = new Stack();
    private Stack<IContext.Break> breakStack = new Stack();
    private Stack<IContext.Continue> continueStack = new Stack();
    private Stack<Boolean> inBodyStack = new Stack();
    private Stack<Boolean> inBodyStack2 = new Stack();
    private boolean insideDirectiveComment = false;
    private Stack<ICodeType> codeTypeStack = new Stack();
    private Stack<Locale> localeStack = new Stack();

    public TemplateParser(CodeBuilder cb) {
        this.template = cb.template();
        this.totalLines = StringUtils.countMatches((CharSequence)this.template, (CharSequence)"\n") + 1;
        this.cb = cb;
        this.engine = cb.engine();
        this.conf = this.engine.conf();
        this.compactMode = this.conf.compactModeEnabled();
        this.pushCodeType(cb.templateDefLang);
    }

    void parse() {
        DialectManager dm = this.engine.dialectManager();
        while (true) {
            this.breakStack.clear();
            this.codeTypeStack.clear();
            this.pushCodeType(this.cb.templateDefLang);
            this.inBodyStack.clear();
            this.inBodyStack2.clear();
            this.compactStack.clear();
            this.continueStack.clear();
            this.localeStack.clear();
            this.insideDirectiveComment = false;
            this.blocks.clear();
            this.cursor = 0;
            this.cb.rewind();
            dm.beginParse(this);
            TemplateResourceManager.setUpTmpBlackList();
            try {
                TemplateTokenizer tt = new TemplateTokenizer(this);
                for (Token builder : tt) {
                    this.cb.addBuilder(builder);
                }
                dm.endParse(this);
            }
            catch (ExitInstruction e) {
                dm.endParse(this);
            }
            catch (RewindableException e) {
                dm.endParse(this);
                if (null == this.cb.requiredDialect) continue;
                throw e;
            }
            catch (RuntimeException e) {
                dm.endParse(this);
                throw e;
            }
            break;
        }
    }

    @Override
    public TemplateClass getTemplateClass() {
        return this.cb.getTemplateClass();
    }

    @Override
    public CodeBuilder getCodeBuilder() {
        return this.cb;
    }

    @Override
    public IDialect getDialect() {
        return this.dialect;
    }

    @Override
    public void setDialect(IDialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public String getRemain() {
        return this.cursor < this.template.length() ? this.template.substring(this.cursor) : "";
    }

    @Override
    public int cursor() {
        return this.cursor;
    }

    @Override
    public boolean hasRemain() {
        return this.cursor < this.template.length();
    }

    @Override
    public char peek() {
        if (!this.hasRemain()) {
            return '\u0000';
        }
        return this.template.charAt(this.cursor);
    }

    @Override
    public char pop() {
        if (!this.hasRemain()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        char c = this.template.charAt(this.cursor);
        this.step(1);
        return c;
    }

    @Override
    public void step(int i) {
        this.cursor += i;
    }

    @Override
    public String getTemplateSource(int start, int end) {
        return this.template.substring(start, end);
    }

    @Override
    public void openBlock(IBlockHandler bh) {
        bh.openBlock();
        this.blocks.push(bh);
    }

    @Override
    public IBlockHandler currentBlock() {
        return this.blocks.isEmpty() ? null : this.blocks.peek();
    }

    @Override
    public String closeBlock() throws ParseException {
        if (this.blocks.isEmpty()) {
            throw new ParseException(this.getEngine(), this.cb.getTemplateClass(), this.currentLine(), "No open block found", new Object[0]);
        }
        IBlockHandler bh = this.blocks.pop();
        return null == bh ? "" : bh.closeBlock();
    }

    @Override
    public String currentSection() {
        int len = this.blocks.size();
        for (int i = len - 1; i >= 0; --i) {
            IBlockHandler h = (IBlockHandler)this.blocks.get(i);
            if (!(h instanceof SectionParser.SectionToken)) continue;
            return ((SectionParser.SectionToken)h).section();
        }
        return null;
    }

    @Override
    public int currentLine() {
        if (null == this.template) {
            return -1;
        }
        if (this.cursor >= this.template.length()) {
            return this.totalLines;
        }
        return StringUtils.countMatches((CharSequence)this.template.substring(0, this.cursor), (CharSequence)"\n") + 1;
    }

    @Override
    public RythmEngine getEngine() {
        return this.engine;
    }

    @Override
    public boolean compactMode() {
        if (!this.compactStack.empty()) {
            return this.compactStack.peek();
        }
        return this.compactMode;
    }

    @Override
    public void pushCompact(Boolean compact) {
        this.compactStack.push(compact);
    }

    @Override
    public Boolean peekCompact() {
        if (this.compactStack.empty()) {
            return null;
        }
        return this.compactStack.peek();
    }

    @Override
    public Boolean popCompact() {
        if (this.compactStack.empty()) {
            return null;
        }
        return this.compactStack.pop();
    }

    @Override
    public void pushBreak(IContext.Break b) {
        this.breakStack.push(b);
    }

    @Override
    public IContext.Break peekBreak() {
        if (this.breakStack.empty()) {
            return null;
        }
        return this.breakStack.peek();
    }

    @Override
    public IContext.Break popBreak() {
        if (this.breakStack.empty()) {
            return null;
        }
        return this.breakStack.pop();
    }

    @Override
    public void pushContinue(IContext.Continue b) {
        this.continueStack.push(b);
    }

    @Override
    public IContext.Continue peekContinue() {
        if (this.continueStack.empty()) {
            return null;
        }
        return this.continueStack.peek();
    }

    @Override
    public IContext.Continue popContinue() {
        if (this.continueStack.empty()) {
            return null;
        }
        return this.continueStack.pop();
    }

    @Override
    public boolean insideBody() {
        if (!this.inBodyStack.empty()) {
            return this.inBodyStack.peek();
        }
        return false;
    }

    @Override
    public void pushInsideBody(Boolean b) {
        this.inBodyStack.push(b);
    }

    @Override
    public Boolean peekInsideBody() {
        if (this.inBodyStack.empty()) {
            return false;
        }
        return this.inBodyStack.peek();
    }

    @Override
    public Boolean popInsideBody() {
        if (this.inBodyStack.empty()) {
            return null;
        }
        return this.inBodyStack.pop();
    }

    @Override
    public boolean insideBody2() {
        if (!this.inBodyStack2.empty()) {
            return this.inBodyStack2.peek();
        }
        return false;
    }

    @Override
    public void pushInsideBody2(Boolean b) {
        this.inBodyStack2.push(b);
    }

    @Override
    public Boolean peekInsideBody2() {
        if (this.inBodyStack2.empty()) {
            return false;
        }
        return this.inBodyStack2.peek();
    }

    @Override
    public Boolean popInsideBody2() {
        if (this.inBodyStack2.empty()) {
            return null;
        }
        return this.inBodyStack2.pop();
    }

    @Override
    public boolean insideDirectiveComment() {
        return this.insideDirectiveComment;
    }

    @Override
    public void enterDirectiveComment() {
        this.insideDirectiveComment = true;
    }

    @Override
    public void leaveDirectiveComment() {
        this.insideDirectiveComment = false;
    }

    @Override
    public ICodeType peekCodeType() {
        if (this.codeTypeStack.isEmpty()) {
            return null;
        }
        return this.codeTypeStack.peek();
    }

    @Override
    public void pushCodeType(ICodeType type) {
        ICodeType cur = this.peekCodeType();
        if (null != cur) {
            type.setParent(cur);
        }
        this.codeTypeStack.push(type);
    }

    @Override
    public ICodeType popCodeType() {
        ICodeType cur = this.peekCodeType();
        if (null == cur) {
            return null;
        }
        cur.setParent(null);
        this.codeTypeStack.pop();
        return cur;
    }

    @Override
    public Locale peekLocale() {
        return this.localeStack.isEmpty() ? null : this.localeStack.peek();
    }

    @Override
    public void pushLocale(Locale locale) {
        this.localeStack.push(locale);
    }

    @Override
    public Locale popLocale() {
        return this.localeStack.isEmpty() ? null : this.localeStack.pop();
    }

    public void shutdown() {
        this.dialect = null;
    }

    private TemplateParser(String s) {
        this.template = s;
        this.totalLines = this.template.split("(\\r\\n|\\n|\\r)").length + 1;
        this.cb = null;
        this.engine = null;
        this.conf = null;
        this.compactMode = true;
    }

    public static class TypeDeclarationException
    extends RewindableException {
        public TypeDeclarationException(IContext ctx) {
            super(ctx, "Type declaration not allowed in current dialect[%s]", ctx.getDialect());
        }
    }

    public static class ComplexExpressionException
    extends RewindableException {
        public ComplexExpressionException(IContext ctx) {
            super(ctx, "Complex expression not allowed in current dialect[%s]", ctx.getDialect());
        }
    }

    public static class ScriptingDisabledException
    extends RewindableException {
        public ScriptingDisabledException(IContext ctx) {
            super(ctx, "Scripting not allowed in current dialect[%s]", ctx.getDialect());
        }
    }

    public static class NoFreeLoopException
    extends RewindableException {
        public NoFreeLoopException(IContext ctx) {
            super(ctx, "Free loop style (@for(;;)) not allowed in current dialect[%s]", ctx.getDialect());
        }
    }

    private static abstract class RewindableException
    extends ParseException {
        public RewindableException(IContext ctx, String msg, Object ... args) {
            super(ctx.getEngine(), ctx.getTemplateClass(), ctx.currentLine(), msg, args);
        }
    }

    public static class ExitInstruction
    extends FastRuntimeException {
    }
}

