/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.compiler;

import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.exception.CompileException;
import org.rythmengine.exception.RythmException;
import org.rythmengine.extension.IByteCodeEnhancer;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.extension.ITemplateResourceLoader;
import org.rythmengine.internal.CodeBuilder;
import org.rythmengine.internal.IDialect;
import org.rythmengine.internal.RythmEvents;
import org.rythmengine.internal.compiler.ClassReloadException;
import org.rythmengine.internal.compiler.ParamTypeInferencer;
import org.rythmengine.internal.compiler.TemplateClassLoader;
import org.rythmengine.internal.compiler.TemplateClassManager;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.resource.ITemplateResource;
import org.rythmengine.resource.StringTemplateResource;
import org.rythmengine.template.ITemplate;
import org.rythmengine.template.TagBase;
import org.rythmengine.template.TemplateBase;
import org.rythmengine.utils.S;

public class TemplateClass {
    private static final ILogger logger = Logger.get(TemplateClass.class);
    public static final String CN_SUFFIX = "__R_T_C__";
    private static final String NO_INCLUDE_CLASS = "NO_INCLUDE_CLASS";
    private static final ITemplate NULL_TEMPLATE = new TagBase(){

        @Override
        public ITemplate __cloneMe(RythmEngine engine, ITemplate caller) {
            return null;
        }
    };
    private TemplateClass root;
    private boolean inner = false;
    private RythmEngine engine = null;
    private boolean enhancing = false;
    private transient List<TemplateClass> embeddedClasses = new ArrayList<TemplateClass>();
    private String name;
    private TemplateClass extendedTemplateClass;
    private Set<TemplateClass> includedTemplateClasses = new HashSet<TemplateClass>();
    private String includeTemplateClassNames = null;
    private Map<String, String> includeTagTypes = new HashMap<String, String>();
    private String tagName;
    private String javaSource;
    private byte[] javaByteCode;
    private byte[] enhancedByteCode;
    private Set<String> importPaths;
    private Class<ITemplate> javaClass;
    private Package javaPackage;
    private ICodeType codeType;
    private boolean compiled;
    private int sigChecksum;
    private boolean isValid = true;
    private CodeBuilder codeBuilder;
    private TemplateBase templateInstance;
    private String resourceLoaderClass;
    private ITemplateResource templateResource;
    private final ReadWriteLock mutationLock = new ReentrantReadWriteLock();
    private transient IDialect dialect;
    private String magic = S.random(4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateClass root() {
        Lock lock = this.mutationLock.readLock();
        lock.lock();
        try {
            TemplateClass templateClass = this.root;
            return templateClass;
        }
        finally {
            lock.unlock();
        }
    }

    private TemplateClass() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInner() {
        Lock lock = this.mutationLock.readLock();
        lock.lock();
        try {
            boolean bl = this.inner;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private RythmEngine engine() {
        return null == this.engine ? Rythm.engine() : this.engine;
    }

    public String name0() {
        return this.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String name() {
        Lock lock = this.mutationLock.readLock();
        lock.lock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncludeTemplateClass(TemplateClass tc) {
        Lock lock = this.mutationLock.writeLock();
        lock.lock();
        try {
            this.includedTemplateClasses.add(tc);
            this.includeTagTypes.putAll(tc.includeTagTypes);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String refreshIncludeTemplateClassNames() {
        Lock lock = this.mutationLock.writeLock();
        lock.lock();
        try {
            if (this.includedTemplateClasses.isEmpty()) {
                this.includeTemplateClassNames = NO_INCLUDE_CLASS;
                String string = NO_INCLUDE_CLASS;
                return string;
            }
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (TemplateClass tc : this.includedTemplateClasses) {
                if (!first) {
                    sb.append(",");
                } else {
                    first = false;
                }
                sb.append(tc.tagName);
            }
            this.includeTemplateClassNames = sb.toString();
            String string = sb.toString();
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTagType(String tagName, String type) {
        Lock lock = this.mutationLock.writeLock();
        lock.lock();
        try {
            this.includeTagTypes.put(tagName, type);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean returnObject(String tagName) {
        Lock lock = this.mutationLock.readLock();
        lock.lock();
        try {
            String retType = this.includeTagTypes.get(tagName);
            if (null != retType) {
                boolean bl = !"void".equals(retType);
                return bl;
            }
            if (null != this.extendedTemplateClass) {
                boolean bl = this.extendedTemplateClass.returnObject(tagName);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serializeIncludeTagTypes() {
        Lock lock = this.mutationLock.readLock();
        lock.lock();
        try {
            if (this.includeTagTypes.isEmpty()) {
                String string = "";
                return string;
            }
            StringBuilder sb = new StringBuilder();
            boolean empty = true;
            for (Map.Entry<String, String> entry : this.includeTagTypes.entrySet()) {
                if (!empty) {
                    sb.append(";");
                } else {
                    empty = false;
                }
                sb.append(entry.getKey()).append(":").append(entry.getValue());
            }
            String string = sb.toString();
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserializeIncludeTagTypes(String s) {
        Lock lock = this.mutationLock.readLock();
        lock.lock();
        try {
            String[] sa;
            this.includeTagTypes = new HashMap<String, String>();
            if (S.isEmpty(s)) {
                return;
            }
            for (String s0 : sa = s.split(";")) {
                String[] sa0 = s0.split(":");
                if (sa0.length != 2) {
                    throw new IllegalArgumentException("Unknown include tag types string: " + s);
                }
                this.includeTagTypes.put(sa0[0], sa0[1]);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTagName() {
        Lock lock = this.mutationLock.readLock();
        lock.lock();
        try {
            String string = this.tagName;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    public String getTemplateSource() {
        return this.getTemplateSource(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTemplateSource(boolean includeRoot) {
        Lock lock = this.mutationLock.readLock();
        lock.lock();
        try {
            if (null != this.templateResource) {
                String string = this.templateResource.asTemplateContent();
                return string;
            }
            if (!includeRoot) {
                String string = "";
                return string;
            }
            TemplateClass parent = this.root;
            while (null != parent && parent.isInner()) {
                parent = parent.root;
            }
            String string = null == parent ? "" : parent.getTemplateSource();
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isStringTemplate() {
        return this.templateResource instanceof StringTemplateResource;
    }

    public String getResourceLoaderClass() {
        return this.resourceLoaderClass;
    }

    private TemplateClass(RythmEngine engine) {
        this.engine = null == engine ? null : (engine.isSingleton() ? null : engine);
    }

    public TemplateClass(File file, RythmEngine engine) {
        this(engine.resourceManager().get(file), engine);
    }

    public TemplateClass(String template, RythmEngine engine) {
        this(engine.resourceManager().get(template), engine);
    }

    public TemplateClass(String template, RythmEngine engine, IDialect dialect) {
        this(engine.resourceManager().get(template), engine, dialect);
    }

    public TemplateClass(ITemplateResource resource, RythmEngine engine) {
        this(resource, engine, false);
    }

    public TemplateClass(ITemplateResource resource, RythmEngine engine, IDialect dialect) {
        this(resource, engine, false, dialect);
    }

    public TemplateClass(ITemplateResource resource, RythmEngine engine, boolean noRefresh) {
        this(engine);
        if (null == resource) {
            throw new NullPointerException();
        }
        this.templateResource = resource;
        if (!noRefresh) {
            this.refresh_(false);
        }
    }

    public TemplateClass(ITemplateResource resource, RythmEngine engine, boolean noRefresh, IDialect dialect) {
        this(engine);
        if (null == resource) {
            throw new NullPointerException();
        }
        this.templateResource = resource;
        this.dialect = dialect;
        if (!noRefresh) {
            this.refresh_(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKey() {
        Lock lock = this.mutationLock.readLock();
        lock.lock();
        try {
            String string = null == this.templateResource ? this.name : this.templateResource.getKey().toString();
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    private String getKey_() {
        return null == this.templateResource ? this.name : this.templateResource.getKey().toString();
    }

    private Class<?> loadJavaClass() throws Exception {
        RythmEngine engine;
        TemplateClassLoader cl;
        if (null == this.javaSource && null == this.javaSource) {
            this.refresh_(false);
        }
        if (null == (cl = (engine = this.engine()).classLoader())) {
            throw new NullPointerException();
        }
        Class<?> c = cl.loadClass(this.name, true);
        if (null == this.javaClass) {
            this.javaClass = c;
        }
        return c;
    }

    private ITemplate templateInstance_(RythmEngine engine) {
        if (!this.isValid) {
            return NULL_TEMPLATE;
        }
        if (null == this.templateInstance) {
            try {
                Class<?> clz = this.loadJavaClass();
                TemplateBase tmpl = (TemplateBase)clz.newInstance();
                tmpl.__setTemplateClass(this);
                engine.registerTemplate(tmpl);
                this.templateInstance = tmpl;
            }
            catch (RythmException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Error load template instance for " + this.getKey_(), e);
            }
        }
        if (!engine.isProdMode()) {
            engine.registerTemplate(this.templateInstance);
            Class<?> c = this.templateInstance.getClass();
            Class<?> pc = c.getSuperclass();
            if (null != pc && !Modifier.isAbstract(pc.getModifiers())) {
                engine.classes().getByClassName(pc.getName());
            }
        }
        return this.templateInstance;
    }

    private ITemplate asTemplate(ICodeType type, Locale locale, RythmEngine engine) {
        if (null == this.name || engine.isDevMode()) {
            this.refresh_(false);
        }
        TemplateBase tmpl = (TemplateBase)this.templateInstance_(engine).__cloneMe(this.engine(), null);
        tmpl.__prepareRender(type, locale, engine);
        return tmpl;
    }

    public ITemplate asTemplate(RythmEngine engine) {
        return this.asTemplate(null, null, engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITemplate asTemplate(ITemplate caller, RythmEngine engine) {
        Lock lock = this.mutationLock.readLock();
        lock.lock();
        try {
            ITemplate iTemplate = this.asTemplate_(caller, engine);
            return iTemplate;
        }
        finally {
            lock.unlock();
        }
    }

    private ITemplate asTemplate_(ITemplate caller, RythmEngine engine) {
        TemplateBase tb = (TemplateBase)caller;
        TemplateBase tmpl = (TemplateBase)this.templateInstance_(engine).__cloneMe(engine, caller);
        tmpl.__prepareRender(tb.__curCodeType(), tb.__curLocale(), engine);
        return tmpl;
    }

    public boolean refresh() {
        return this.refresh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildSourceCode(String includingClassName) {
        Lock lock = this.mutationLock.writeLock();
        lock.lock();
        try {
            long start = System.currentTimeMillis();
            this.importPaths = new HashSet<String>();
            if (null != this.codeBuilder) {
                this.codeBuilder.clear();
            }
            this.codeBuilder = new CodeBuilder(this.templateResource.asTemplateContent(), this.name, this.tagName, this, this.engine, this.dialect);
            this.codeBuilder.includingCName = includingClassName;
            this.codeBuilder.build();
            this.extendedTemplateClass = this.codeBuilder.getExtendedTemplateClass();
            this.javaSource = this.codeBuilder.toString();
            if (logger.isTraceEnabled()) {
                logger.trace("%s ms to generate java source for template: %s", System.currentTimeMillis() - start, this.getKey_());
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void buildSourceCode_() {
        long start = System.currentTimeMillis();
        this.importPaths = new HashSet<String>();
        if (null != this.codeBuilder) {
            this.codeBuilder.clear();
        }
        this.codeBuilder = null == this.dialect ? new CodeBuilder(this.templateResource.asTemplateContent(), this.name, this.tagName, this, this.engine, null) : this.dialect.createCodeBuilder(this.templateResource.asTemplateContent(), this.name, this.tagName, this, this.engine);
        this.codeBuilder.build();
        this.extendedTemplateClass = this.codeBuilder.getExtendedTemplateClass();
        this.javaSource = this.codeBuilder.toString();
        this.engine();
        if (RythmEngine.insideSandbox()) {
            this.javaSource = CodeBuilder.preventInfiniteLoop(this.javaSource);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("%s ms to generate java source for template: %s", System.currentTimeMillis() - start, this.getKey_());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildSourceCode() {
        Lock lock = this.mutationLock.writeLock();
        lock.lock();
        try {
            this.buildSourceCode_();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImportPath(String path) {
        Lock lock = this.mutationLock.writeLock();
        lock.lock();
        try {
            if (path == null || path.isEmpty()) {
                return;
            }
            this.importPaths.add(path);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceImportPath(Set<String> paths) {
        Lock lock = this.mutationLock.writeLock();
        lock.lock();
        try {
            this.importPaths = paths;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean refresh_(boolean forceRefresh) {
        boolean refresh;
        if (this.inner) {
            return false;
        }
        ITemplateResource templateResource = this.templateResource;
        RythmEngine engine = this.engine();
        if (!templateResource.isValid()) {
            this.isValid = false;
            engine.classes().remove(this);
            return false;
        }
        ICodeType type = engine.renderSettings.codeType();
        if (null == type) {
            type = templateResource.codeType(this.engine());
        }
        if (null == type || ICodeType.DefImpl.RAW == type) {
            type = engine.conf().defaultCodeType();
        }
        this.codeType = type;
        if (null == this.name) {
            ITemplateResourceLoader loader;
            this.root = this;
            this.name = TemplateClass.canonicalClassName(templateResource.getSuggestedClassName()) + CN_SUFFIX;
            if (engine.conf().typeInferenceEnabled()) {
                this.name = this.name + ParamTypeInferencer.uuid();
            }
            if (null != (loader = this.engine().resourceManager().whichLoader(templateResource))) {
                Object k = templateResource.getKey();
                this.tagName = TemplateClass.toCanonicalName(k.toString(), loader.getResourceLoaderRoot());
            }
            engine.registerTemplateClass(this);
        }
        if (null == this.javaSource) {
            Pattern p;
            Matcher m;
            engine.classCache().loadTemplateClass(this);
            if (null != this.javaSource && (m = (p = Pattern.compile(".*extends\\s+([a-zA-Z0-9_]+)\\s*\\{\\s*\\/\\/<extended_resource_key\\>(.*)\\<\\/extended_resource_key\\>.*", 32)).matcher(this.javaSource)).matches()) {
                String extended = m.group(1);
                TemplateClassManager tcm = this.engine().classes();
                this.extendedTemplateClass = tcm.getByClassName(extended);
                if (null == this.extendedTemplateClass) {
                    String extendedResourceKey = m.group(2);
                    this.extendedTemplateClass = tcm.getByTemplate(extendedResourceKey);
                    if (null == this.extendedTemplateClass) {
                        this.extendedTemplateClass = new TemplateClass(extendedResourceKey, this.engine());
                        this.extendedTemplateClass.refresh();
                    }
                }
                engine.addExtendRelationship(this.extendedTemplateClass, this);
            }
        }
        boolean extendedTemplateChanged = false;
        if (this.extendedTemplateClass != null) {
            extendedTemplateChanged = this.extendedTemplateClass.refresh(forceRefresh);
        }
        boolean includedTemplateChanged = false;
        boolean includedTemplateClassesIsEmpty = this.includedTemplateClasses.isEmpty();
        if (includedTemplateClassesIsEmpty && !S.isEmpty(this.includeTemplateClassNames) && !NO_INCLUDE_CLASS.equals(this.includeTemplateClassNames)) {
            for (String tcName : this.includeTemplateClassNames.split(",")) {
                if (S.isEmpty(tcName)) continue;
                tcName = tcName.trim();
                String fullName = this.engine().testTemplate(tcName, this, null);
                if (null == fullName) {
                    logger.warn("Unable to load included template class from name: %s", tcName);
                    continue;
                }
                TemplateClass tc = this.engine().getRegisteredTemplateClass(fullName);
                if (null == tc) {
                    logger.warn("Unable to load included template class from name: %s", tcName);
                    continue;
                }
                this.includedTemplateClasses.add(tc);
            }
        }
        for (TemplateClass tc : this.includedTemplateClasses) {
            if (!tc.refresh(forceRefresh)) continue;
            includedTemplateChanged = true;
            break;
        }
        if (extendedTemplateChanged && !forceRefresh) {
            this.reset_();
            this.compiled = false;
            this.engine().restart(new ClassReloadException("extended class changed"));
            this.refresh_(forceRefresh);
            return true;
        }
        boolean resourceChanged = templateResource.refresh();
        boolean bl = refresh = resourceChanged || forceRefresh || null == this.javaSource || includedTemplateChanged || extendedTemplateChanged;
        if (!refresh) {
            return false;
        }
        this.reset_();
        this.buildSourceCode_();
        this.engine().classCache().cacheTemplateClassSource(this);
        if (!this.codeBuilder.isRythmTemplate()) {
            this.isValid = false;
            this.engine().classes().remove(this);
            return false;
        }
        this.isValid = true;
        this.compiled = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refresh(boolean forceRefresh) {
        Lock lock = this.mutationLock.writeLock();
        lock.lock();
        try {
            boolean bl = this.refresh_(forceRefresh);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDefinable() {
        Lock lock = this.mutationLock.readLock();
        lock.lock();
        try {
            boolean bl = this.compiled && this.javaClass != null;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Lock lock = this.mutationLock.writeLock();
        lock.lock();
        try {
            this.reset_();
        }
        finally {
            lock.unlock();
        }
    }

    private void reset_() {
        this.javaByteCode = null;
        this.enhancedByteCode = null;
        this.javaSource = null;
        this.templateInstance = null;
        for (TemplateClass tc : this.embeddedClasses) {
            tc.reset();
            this.engine().classes().remove(tc);
        }
        this.embeddedClasses.clear();
        this.engine().classCache().deleteCache(this);
        this.engine().invalidate(this);
        this.javaClass = null;
    }

    private String magic() {
        return this.name + this.magic;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] compile_() {
        byte[] byArray;
        long start;
        block14: {
            start = System.currentTimeMillis();
            if (null == this.javaByteCode) break block14;
            byte[] byArray2 = this.javaByteCode;
            if (logger.isTraceEnabled()) {
                logger.trace("%sms to compile template class %s", System.currentTimeMillis() - start, this.getKey_());
            }
            return byArray2;
        }
        try {
            if (null == this.javaSource) {
                throw new IllegalStateException("Cannot find java source when compiling " + this.getKey_());
            }
            this.engine().classes().compiler.compile(new String[]{this.name});
            if (logger.isTraceEnabled()) {
                logger.trace("%sms to compile template: %s", System.currentTimeMillis() - start, this.getKey_());
            }
            byArray = this.javaByteCode;
        }
        catch (CompileException.CompilerException e) {
            try {
                TemplateClass tc;
                String cn = e.className;
                TemplateClass templateClass = tc = S.isEqual(cn, this.name) ? this : this.engine().classes().getByClassName(cn);
                if (null == tc) {
                    tc = this;
                }
                CompileException ce = new CompileException(this.engine(), tc, e.javaLineNumber, e.message);
                this.javaSource = null;
                throw ce;
                catch (NullPointerException e2) {
                    String clazzName = this.name;
                    tc = this.engine().classes().getByClassName(clazzName);
                    if (this != tc) {
                        logger.error("tc is not this", new Object[0]);
                    }
                    if (!this.equals(tc)) {
                        logger.error("tc not match this", new Object[0]);
                    }
                    logger.error("NPE encountered when compiling template class:" + this.name, new Object[0]);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                if (logger.isTraceEnabled()) {
                    logger.trace("%sms to compile template class %s", System.currentTimeMillis() - start, this.getKey_());
                }
                throw throwable;
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("%sms to compile template class %s", System.currentTimeMillis() - start, this.getKey_());
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] compile() {
        Lock lock = this.mutationLock.writeLock();
        lock.lock();
        try {
            byte[] byArray = this.compile_();
            return byArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delayedEnhance(TemplateClass root) {
        Lock lock = this.mutationLock.writeLock();
        lock.lock();
        try {
            this.enhancedByteCode = this.javaByteCode;
            root.embeddedClasses.add(this);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] enhance() {
        Lock lock = this.mutationLock.writeLock();
        lock.lock();
        try {
            if (this.enhancing) {
                throw new IllegalStateException("reenter enhance() call");
            }
            this.enhancing = true;
            try {
                byte[] bytes = this.enhancedByteCode;
                if (null == bytes) {
                    bytes = this.javaByteCode;
                    if (null == bytes) {
                        bytes = this.compile_();
                    }
                    long start = System.currentTimeMillis();
                    IByteCodeEnhancer en = this.engine().conf().byteCodeEnhancer();
                    if (null != en) {
                        try {
                            bytes = en.enhance(this.name, bytes);
                        }
                        catch (Exception e) {
                            logger.warn(e, "Error enhancing template class: %s", this.getKey_());
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace("%sms to enhance template class %s", System.currentTimeMillis() - start, this.getKey_());
                        }
                    }
                    this.enhancedByteCode = bytes;
                    this.engine().classCache().cacheTemplateClass(this);
                }
                for (TemplateClass embedded : this.embeddedClasses) {
                    embedded.enhancedByteCode = null;
                    embedded.enhance();
                }
                byte[] byArray = bytes;
                this.enhancing = false;
                return byArray;
            }
            catch (Throwable throwable) {
                this.enhancing = false;
                throw throwable;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uncompile() {
        Lock lock = this.mutationLock.writeLock();
        lock.lock();
        try {
            this.javaClass = null;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isClass() {
        return !this.name.endsWith("package-info");
    }

    public String getPackage() {
        int dot = this.name.lastIndexOf(46);
        return dot > -1 ? this.name.substring(0, dot) : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCachedByteCode(byte[] code) {
        Lock lock = this.mutationLock.writeLock();
        lock.lock();
        try {
            this.enhancedByteCode = code;
        }
        finally {
            lock.unlock();
        }
    }

    public void compiled(byte[] code) {
        this.javaByteCode = code;
        this.compiled = true;
        RythmEvents.COMPILED.trigger(this.engine(), code);
        this.enhance();
    }

    public String toString() {
        return "(compiled:" + this.compiled + ") " + this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TemplateClass) {
            TemplateClass that = (TemplateClass)o;
            return that.getKey_().equals(this.getKey_());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey_().hashCode();
    }

    private static String canonicalClassName(String name) {
        if (S.empty(name)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char[] ca = name.toCharArray();
        int len = ca.length;
        char c = ca[0];
        if (!Character.isJavaIdentifierStart(c)) {
            sb.append('_');
        } else {
            sb.append(c);
        }
        for (int i = 1; i < len; ++i) {
            c = ca[i];
            if (!Character.isJavaIdentifierPart(c)) {
                sb.append('_');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String toCanonicalName(String key, String root) {
        if (key.startsWith("/") || key.startsWith("\\")) {
            key = key.substring(1);
        }
        if (key.startsWith(root)) {
            key = key.replace(root, "");
        }
        if (key.startsWith("/") || key.startsWith("\\")) {
            key = key.substring(1);
        }
        key = key.replace('/', '.').replace('\\', '.');
        return key;
    }

    public static TemplateClass createInnerClass(String className, byte[] byteCode, TemplateClass parent) {
        TemplateClass tc = new TemplateClass();
        tc.name = className;
        tc.javaByteCode = byteCode;
        tc.inner = true;
        tc.root = parent.root();
        return tc;
    }

    public ITemplateResource getTemplateResource() {
        return this.templateResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICodeType getCodeType() {
        Lock lock = this.mutationLock.readLock();
        lock.lock();
        try {
            ICodeType iCodeType = this.codeType;
            return iCodeType;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getImportPaths() {
        Lock lock = this.mutationLock.readLock();
        lock.lock();
        try {
            if (null == this.importPaths) {
                Set<String> set = Collections.emptySet();
                return set;
            }
            Set<String> set = Collections.unmodifiableSet(this.importPaths);
            return set;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJavaSource() {
        Lock lock = this.mutationLock.readLock();
        lock.lock();
        try {
            String string = this.javaSource;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setJavaPackage(Package javaPackage) {
        Lock lock = this.mutationLock.writeLock();
        lock.lock();
        try {
            this.javaPackage = javaPackage;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setJavaClass(Class<ITemplate> javaClass) {
        Lock lock = this.mutationLock.writeLock();
        lock.lock();
        try {
            this.javaClass = javaClass;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeBuilder getCodeBuilder() {
        Lock lock = this.mutationLock.readLock();
        lock.lock();
        try {
            CodeBuilder codeBuilder = this.codeBuilder;
            return codeBuilder;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<ITemplate> getJavaClass() {
        Lock lock = this.mutationLock.readLock();
        lock.lock();
        try {
            Class<ITemplate> clazz = this.javaClass;
            return clazz;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getEnhancedByteCode() {
        Lock lock = this.mutationLock.readLock();
        lock.lock();
        try {
            byte[] byArray = this.enhancedByteCode;
            return byArray;
        }
        finally {
            lock.unlock();
        }
    }

    public byte[] getJavaByteCode() {
        return this.javaByteCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSigChecksum() {
        Lock lock = this.mutationLock.readLock();
        lock.lock();
        try {
            int n = this.sigChecksum;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setJavaSource(String javaSource) {
        Lock lock = this.mutationLock.writeLock();
        lock.lock();
        try {
            this.javaSource = javaSource;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setExtendedTemplateClass(TemplateClass extendedTemplateClass) {
        Lock lock = this.mutationLock.writeLock();
        lock.lock();
        try {
            this.extendedTemplateClass = extendedTemplateClass;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIncludeTemplateClassNames(String includeTemplateClassNames) {
        Lock lock = this.mutationLock.writeLock();
        lock.lock();
        try {
            this.includeTemplateClassNames = includeTemplateClassNames;
        }
        finally {
            lock.unlock();
        }
    }
}

