/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.compiler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.Set;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.conf.RythmConfiguration;
import org.rythmengine.conf.RythmConfigurationKey;
import org.rythmengine.internal.compiler.TemplateClass;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.utils.TextBuilder;

public class TemplateClassCache {
    private static final ILogger logger = Logger.get(TemplateClassCache.class);
    private final RythmEngine engine;
    private final RythmConfiguration conf;
    private final Rythm.Mode mode;

    public TemplateClassCache(RythmEngine engine) {
        if (null == engine) {
            throw new NullPointerException();
        }
        this.engine = engine;
        this.conf = engine.conf();
        this.mode = engine.mode();
    }

    private boolean readEnabled() {
        return (this.mode.isDev() || this.conf.loadPrecompiled()) && !RythmEngine.insideSandbox();
    }

    private boolean writeEnabled() {
        return (this.mode.isDev() || !this.conf.disableFileWrite() || this.conf.precompileMode()) && !RythmEngine.insideSandbox();
    }

    public void deleteCache(TemplateClass tc) {
        if (!this.writeEnabled()) {
            return;
        }
        try {
            File f = this.getCacheFile(tc);
            if (f.exists() && !f.delete()) {
                f.deleteOnExit();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public void loadTemplateClass(TemplateClass tc) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 17[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void cacheTemplateClassSource(TemplateClass tc) {
        if (!this.writeEnabled()) {
            return;
        }
        try {
            File f = this.getCacheSourceFile(tc);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
            ((OutputStream)os).write(tc.getJavaSource().getBytes("utf-8"));
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void cacheTemplateClass(TemplateClass tc) {
        if (!this.writeEnabled()) {
            return;
        }
        String hash = this.hash(tc);
        try {
            File f = this.getCacheFile(tc);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
            ((OutputStream)os).write(hash.getBytes("utf-8"));
            ((OutputStream)os).write(0);
            if (null != tc.getJavaSource()) {
                TextBuilder tb = new TextBuilder();
                tb.p(tc.getJavaSource());
                tb.p("__INCLUDED_TAG_TYPES__").p(tc.serializeIncludeTagTypes());
                tb.p("__INCULDED_TEMPLATE_CLASS_NAME_LIST__").p(tc.refreshIncludeTemplateClassNames()).p("__IMPORT_PATH_LIST__");
                Set<Object> importPaths = new HashSet();
                if (tc.getImportPaths().isEmpty()) {
                    tc.addImportPath("java.lang");
                } else {
                    importPaths = tc.getImportPaths();
                }
                boolean first = true;
                for (String string : importPaths) {
                    if (!first) {
                        tb.p(";");
                    } else {
                        first = false;
                    }
                    tb.p(string);
                }
                ((OutputStream)os).write(tb.toString().getBytes("utf-8"));
            }
            ((OutputStream)os).write(0);
            ((OutputStream)os).write(tc.getEnhancedByteCode());
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    String hash(TemplateClass tc) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update((this.engine.version() + tc.getTemplateSource(true)).getBytes("utf-8"));
            byte[] digest = messageDigest.digest();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < digest.length; ++i) {
                int value = digest[i];
                if (value < 0) {
                    value += 256;
                }
                builder.append(Integer.toHexString(value));
            }
            return builder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    String cacheFileName(TemplateClass tc, String suffix) {
        return tc.name0() + suffix;
    }

    private File getCacheFile(String fileName) {
        RythmConfiguration conf = this.engine.conf();
        if (conf.loadPrecompiled() || conf.precompileMode()) {
            URI uri = (URI)conf.get(RythmConfigurationKey.HOME_PRECOMPILED);
            File precompileDir = new File(uri);
            return new File(precompileDir, fileName);
        }
        File f = new File(conf.tmpDir(), fileName);
        return f;
    }

    File getCacheFile(TemplateClass tc) {
        String id = this.cacheFileName(tc, ".rythm");
        return this.getCacheFile(id);
    }

    File getCacheSourceFile(TemplateClass tc) {
        String id = this.cacheFileName(tc, ".java");
        return this.getCacheFile(id);
    }
}

