/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.exception.ParseException;
import org.rythmengine.internal.CodeBuilder;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.TemplateParser;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.dialect.BasicRythm;
import org.rythmengine.internal.parser.BlockCodeToken;
import org.rythmengine.internal.parser.build_in.ExpressionParser;
import org.rythmengine.utils.S;

public class ForEachCodeToken
extends BlockCodeToken {
    private String type;
    private String iterableType = "Iterable";
    private String varname;
    private String iterable;
    private String joinSep;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ForEachCodeToken(String type, String varname, String iterable, IContext context, int lineNo, String joinSep) {
        super(null, context);
        this.line = lineNo;
        this.joinSep = joinSep;
        if (null == iterable) {
            throw new NullPointerException();
        }
        iterable = iterable.trim();
        iterable = ExpressionParser.processPositionPlaceHolder(iterable);
        iterable = Token.processRythmExpression(iterable, context);
        if (null != type) {
            type = type.trim();
        }
        this.type = this.objectType(type);
        String string = this.varname = null == varname ? "_" : varname.trim();
        if (iterable.contains("..") || iterable.contains(" to ") || iterable.contains(" till ")) {
            iterable = "org.rythmengine.utils.Range.valueOf(\"" + iterable + "\")";
            this.iterableType = "Range";
        }
        this.iterable = iterable;
        IContext ctx = context;
        ctx.pushBreak(IContext.Break.BREAK);
        ctx.pushContinue(IContext.Continue.CONTINUE);
        CodeBuilder cb = context.getCodeBuilder();
        boolean isBasic = ctx.getDialect() instanceof BasicRythm;
        if (S.isEmpty(type) || "Object".equals(type)) {
            String itrType = cb.getRenderArgType(iterable);
            if (null != itrType) {
                Regex r = new Regex(".*((?@<>))");
                if (r.search(itrType)) {
                    type = r.stringMatched(1);
                    this.type = S.strip(type, "<", ">");
                    boolean key = iterable.endsWith("keySet()");
                    boolean val = iterable.endsWith("values()");
                    if (key || val) {
                        r = new Regex("([a-zA-Z0-9\\[\\]_]+(?@<>)?)\\s*\\,\\s*([a-zA-Z0-9\\[\\]_]+(?@<>)?)");
                        if (!r.search(this.type)) throw new ParseException(ctx.getEngine(), ctx.getTemplateClass(), this.line, "Invalid for loop iterator type declaration: %s", itrType);
                        this.type = key ? r.stringMatched(1) : r.stringMatched(2);
                    }
                } else if (itrType.endsWith("]")) {
                    int pos = itrType.lastIndexOf("[");
                    this.type = itrType.substring(0, pos);
                } else {
                    this.type = "java.lang.Object";
                }
                if (S.isEqual(this.type, this.varname)) {
                    this.varname = "_";
                }
            } else {
                this.type = "java.lang.Object";
            }
        } else if (isBasic) {
            throw new TemplateParser.TypeDeclarationException(ctx);
        }
        if (!isBasic) return;
        ExpressionParser.assertBasic(iterable, context);
        context.getCodeBuilder().addRenderArgsIfNotDeclared(this.line, "Iterable<?>", iterable);
    }

    private String objectType(String type) {
        if (null == type) {
            return "";
        }
        if ("int".equals(type)) {
            return "Integer";
        }
        if ("float".equals(type)) {
            return "Float";
        }
        if ("double".equals(type)) {
            return "Double";
        }
        if ("boolean".equals(type)) {
            return "Boolean";
        }
        if ("char".equals(type)) {
            return "Character";
        }
        if ("long".equals(type)) {
            return "Long";
        }
        if ("byte".equals(type)) {
            return "Byte";
        }
        if ("short".equals(type)) {
            return "Integer";
        }
        return type;
    }

    @Override
    public void output() {
        String prefix = "_".equals(this.varname) ? "" : this.varname + "";
        CodeBuilder cb = this.ctx.getCodeBuilder();
        String varId = prefix + "_index";
        String varIsOdd = prefix + "_isOdd";
        String varSize = prefix + "_size";
        String varParity = prefix + "_parity";
        String varIsFirst = prefix + "_isFirst";
        String varIsLast = prefix + "_isLast";
        String varSep = prefix + "_sep";
        String varWithSep = prefix + "__sep";
        String varUtils = prefix + "_utils";
        String varWithUtils = prefix + "__utils";
        String varItr = cb.newVarName();
        if ("java.lang.Object".equals(this.type)) {
            this.p("{\n__Itr ").p(varItr).p(" = __Itr.of(").p(this.iterable).p(");");
        } else if ("Range".equals(this.iterableType)) {
            this.p("{\n__Itr<").p(this.type).p("> ").p(varItr).p(" = __Itr.ofRange(").p(this.iterable).p(");");
        } else {
            this.p("{\n__Itr<").p(this.type).p("> ").p(varItr).p(" = __Itr.valueOf(").p(this.iterable).p(");");
        }
        this.pline();
        this.p("int ").p(varSize).p(" = ").p(varItr).p(".size();");
        this.pline();
        this.p("if (").p(varSize).p(" > 0) {");
        this.pline();
        this.p("int ").p(varId).p(" = 0;");
        this.pline();
        this.p("for(").p("?".equals(this.type) ? "java.lang.Object" : this.type).p(" ").p(this.varname).p(" : ").p(varItr).p(") {");
        this.pline();
        if (null != this.joinSep) {
            this.p("if (").p(varId).p("++ > 0) {p(").p(this.joinSep).p(");}");
        } else {
            this.p(varId).p("++;");
        }
        this.pline();
        this.p("boolean ").p(varIsOdd).p(" = ").p(varId).p(" % 2 == 1;");
        this.pline();
        this.p("java.lang.String ").p(varParity).p(" = ").p(varIsOdd).p(" ? \"odd\" : \"even\";");
        this.pline();
        this.p("boolean ").p(varIsFirst).p(" = ").p(varId).p(" == 1;");
        this.pline();
        this.p("boolean ").p(varIsLast).p(" = ").p(varId).p(" >= ").p(varSize).p(";");
        this.pline();
        this.p("org.rythmengine.utils.RawData ").p(varSep).p(" = new org.rythmengine.utils.RawData(").p(varIsLast).p(" ? \"\" : \",\");");
        this.pline();
        this.p("org.rythmengine.utils.RawData ").p(varWithSep).p(" = new org.rythmengine.utils.RawData(org.rythmengine.utils.S.escape(").p(this.varname).p(")+(").p(varIsLast).p(" ? \"\" : \",\"));");
        this.pline();
        this.p("org.rythmengine.internal.LoopUtil ").p(varUtils).p(" = new org.rythmengine.internal.LoopUtil(").p(varIsFirst).p(", ").p(varIsLast).p(");");
        this.pline();
        this.p("org.rythmengine.internal.LoopUtil ").p(varWithUtils).p(" = new org.rythmengine.internal.LoopUtil(").p(varIsFirst).p(", ").p(varIsLast).p(", ").p(this.varname).p(");");
        this.pline();
        this.p("__pushItrVar(\"").p(this.varname).p("\", ").p(this.varname).p(");");
        this.pline();
    }

    @Override
    public String closeBlock() {
        return "\n\t__popItrVar();\n\t}\n}\n}\n";
    }
}

