/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import java.util.ArrayList;
import org.rythmengine.internal.ExtensionManager;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IDialect;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.CodeToken;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.internal.parser.build_in.CaretParserFactoryBase;
import org.rythmengine.utils.S;

public class NullableExpressionParser
extends CaretParserFactoryBase {
    @Override
    public IParser create(IContext ctx) {
        final IDialect dialect = ctx.getDialect();
        return new ParserBase(ctx){

            @Override
            public Token go() {
                String s0;
                String exp;
                String caret_ = dialect.a();
                Regex r1 = new Regex(String.format(NullableExpressionParser.this.patternStr1(), caret_));
                Regex r2 = new Regex(String.format(NullableExpressionParser.this.patternStr2(), caret_));
                Regex r3 = new Regex(NullableExpressionParser.this.patternStr3());
                Regex r4 = new Regex(NullableExpressionParser.this.patternStr4());
                String s = this.remain();
                int step = 0;
                if (r1.search(s)) {
                    exp = r1.stringMatched(2);
                    step = r1.stringMatched(1).length();
                } else if (r2.search(s)) {
                    exp = r2.stringMatched(2);
                    exp = S.stripBrace(exp);
                    step = r2.stringMatched().length();
                } else {
                    return null;
                }
                exp = exp.trim();
                if (!exp.contains("?")) {
                    return null;
                }
                if (!r4.search(exp)) {
                    return null;
                }
                this.step(step);
                StringBuilder curExp = new StringBuilder();
                final ArrayList<String> statements = new ArrayList<String>();
                ExtensionManager jem = this.ctx().getEngine().extensionManager();
                while (r3.search(exp) && !jem.isJavaExtension(s0 = r3.stringMatched().trim())) {
                    if (s0.endsWith("?.")) {
                        s0 = s0.replace("?.", "");
                        curExp.append(s0);
                        String e = curExp.toString();
                        curExp.append(".");
                        statements.add(e);
                        continue;
                    }
                    if (!s0.endsWith(".")) continue;
                    curExp.append(s0);
                }
                String regex = "(?s)(\"(?>[^\\\\\"]++|\\\\{2}|\\\\.)*\")|\\?";
                exp = exp.replaceAll(regex, "$1");
                return new CodeToken(exp, this.ctx()){

                    @Override
                    public void output() {
                        this.outputExpression(statements);
                    }
                };
            }
        };
    }

    protected String patternStr1() {
        return "^(%s(([a-zA-Z_][\\w]*((?@())(?@[])?|(?@[])(?@())?)?(\\??\\.)?)+)).*";
    }

    protected String patternStr2() {
        return "^(%s((?@())))";
    }

    protected String patternStr3() {
        return "\\G([a-zA-Z_][\\w]*((?@())(?@[])?|(?@[])(?@())?)?(\\??\\.)?)";
    }

    protected String patternStr4() {
        return "^([a-zA-Z_][\\w]*((?@())(?@[])?|(?@[])(?@())?)?(\\??\\.)?)+$";
    }
}

