/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.TemplateParser;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.CodeToken;
import org.rythmengine.internal.parser.RemoveLeadingLineBreakAndSpacesParser;
import org.rythmengine.utils.S;

public class ScriptParser
extends RemoveLeadingLineBreakAndSpacesParser {
    private static final String PTN = "^(%s((?@{}))%s?)";

    public ScriptParser(IContext context) {
        super(context);
    }

    @Override
    public Token go() {
        IContext ctx = this.ctx();
        Regex r = new Regex(String.format(PTN, this.a(), this.a()));
        if (!r.search(ctx.getRemain())) {
            return null;
        }
        if (!ctx.getDialect().enableScripting()) {
            throw new TemplateParser.ScriptingDisabledException(ctx);
        }
        String s = r.stringMatched(1);
        int curLine = ctx.currentLine();
        ctx.step(s.length());
        s = r.stringMatched(2);
        s = s.substring(1);
        s = s.substring(0, s.length() - 1);
        r = new Regex(".*[ \\t\\n\\r\\}]+if[ \\t]*\\(.*");
        boolean hasIfStatement = r.search(" " + s);
        String[] lines = s.split("[\\n\\r]+");
        int len = lines.length;
        StringBuilder sb = new StringBuilder(s.length() * 2);
        String lastLine = "";
        for (int i = 0; i < len; ++i) {
            String line = lines[i];
            if (!S.isEmpty(line)) {
                lastLine = line;
            }
            sb.append(line).append(" //line: ").append(++curLine).append("\n");
        }
        if (!hasIfStatement && !lastLine.trim().endsWith(";")) {
            sb.append(";");
        }
        String code = sb.toString();
        this.checkRestrictedClass(code);
        return new CodeToken(code, ctx);
    }

    public static void main(String[] args) {
        String s = "adfs\n\tif (sdfs) {\n...}\n";
        Regex r = new Regex(".*[ \\t\\n\\r\\}]+if[ \\t]*\\(.*");
        ScriptParser.p(s, r);
    }
}

