/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.logger;

import java.util.HashMap;
import java.util.Map;
import org.rythmengine.Rythm;
import org.rythmengine.extension.ILoggerFactory;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.JDKLogger;

public class Logger {
    private static Map<Class<?>, ILogger> loggers = new HashMap();
    private static ILoggerFactory userFact = null;
    private static final ILoggerFactory fact = new ILoggerFactory(){
        private ILoggerFactory defFact = new JDKLogger.Factory();

        @Override
        public ILogger getLogger(Class<?> clazz) {
            return null == userFact ? this.defFact.getLogger(clazz) : userFact.getLogger(clazz);
        }
    };
    private static ILogger def = null;

    public static ILogger get(Class<?> clazz) {
        ILogger logger = loggers.get(clazz);
        if (null == logger) {
            logger = new Proxy(clazz);
            loggers.put(clazz, logger);
        }
        return logger;
    }

    private static ILogger def() {
        if (null == def) {
            def = Logger.get(Rythm.class);
        }
        return def;
    }

    public static void registerLoggerFactory(ILoggerFactory fact) {
        Logger.reset();
        userFact = fact;
    }

    public static void reset() {
        userFact = null;
        def = null;
        loggers.clear();
    }

    public static boolean isTraceEnabled() {
        return Logger.def().isTraceEnabled();
    }

    public static void trace(String format, Object ... args) {
        Logger.def().trace(format, args);
    }

    public static void trace(Throwable t, String format, Object ... args) {
        Logger.def().trace(t, format, args);
    }

    public static boolean isDebugEnabled() {
        return Logger.def().isDebugEnabled();
    }

    public static void debug(String format, Object ... args) {
        Logger.def().debug(format, args);
    }

    public static void debug(Throwable t, String format, Object ... args) {
        Logger.def().debug(t, format, args);
    }

    public static boolean isInfoEnabled() {
        return Logger.def().isInfoEnabled();
    }

    public static void info(String format, Object ... arg) {
        Logger.def().info(format, arg);
    }

    public static void info(Throwable t, String format, Object ... args) {
        Logger.def().info(t, format, args);
    }

    public static boolean isWarnEnabled() {
        return Logger.def().isWarnEnabled();
    }

    public static void warn(String format, Object ... arg) {
        Logger.def().warn(format, arg);
    }

    public static void warn(Throwable t, String format, Object ... args) {
        Logger.def().warn(t, format, args);
    }

    public static boolean isErrorEnabled() {
        return Logger.def().isErrorEnabled();
    }

    public static void error(String format, Object ... arg) {
        Logger.def().error(format, arg);
    }

    public static void error(Throwable t, String format, Object ... args) {
        Logger.def().error(t, format, args);
    }

    private static class Proxy
    implements ILogger {
        private Class<?> c_;
        private ILogger l_;

        Proxy(Class<?> clazz) {
            this.c_ = clazz;
        }

        ILogger impl() {
            if (null == this.l_) {
                this.l_ = fact.getLogger(this.c_);
            }
            return this.l_;
        }

        @Override
        public boolean isTraceEnabled() {
            return this.impl().isTraceEnabled();
        }

        @Override
        public void trace(String format, Object ... args) {
            this.impl().trace(format, args);
        }

        @Override
        public void trace(Throwable t, String format, Object ... args) {
            this.impl().trace(t, format, args);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.impl().isDebugEnabled();
        }

        @Override
        public void debug(String format, Object ... args) {
            this.impl().debug(format, args);
        }

        @Override
        public void debug(Throwable t, String format, Object ... args) {
            this.impl().debug(t, format, args);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.impl().isInfoEnabled();
        }

        @Override
        public void info(String format, Object ... arg) {
            this.impl().info(format, arg);
        }

        @Override
        public void info(Throwable t, String format, Object ... args) {
            this.impl().info(t, format, args);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.impl().isWarnEnabled();
        }

        @Override
        public void warn(String format, Object ... args) {
            this.impl().warn(format, args);
        }

        @Override
        public void warn(Throwable t, String format, Object ... args) {
            this.impl().warn(t, format, args);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.impl().isErrorEnabled();
        }

        @Override
        public void error(String format, Object ... arg) {
            this.impl().error(format, arg);
        }

        @Override
        public void error(Throwable t, String format, Object ... args) {
            this.impl().error(t, format, args);
        }
    }
}

