/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.resource;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import org.rythmengine.extension.ITemplateResourceLoader;
import org.rythmengine.internal.compiler.TemplateClassLoader;
import org.rythmengine.resource.ITemplateResource;
import org.rythmengine.resource.TemplateResourceBase;
import org.rythmengine.utils.IO;

public class ClasspathTemplateResource
extends TemplateResourceBase
implements ITemplateResource {
    private static final long serialVersionUID = -164305020378609839L;
    private URL url;
    private String key;

    ClasspathTemplateResource(String path, ITemplateResourceLoader loader) {
        super(loader);
        TemplateClassLoader cl = loader.getEngine().classLoader();
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.url = cl.getResource(path);
        if (!this.isValid()) {
            this.url = cl.getResource(loader.getResourceLoaderRoot() + "/" + path);
        }
        this.key = path;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String reload() {
        return IO.readContentAsString(this.url);
    }

    @Override
    protected long lastModified() {
        String fileName;
        if (this.getEngine().isProdMode()) {
            return 0L;
        }
        if ("file".equals(this.url.getProtocol())) {
            fileName = this.url.getFile();
        } else if ("jar".equals(this.url.getProtocol())) {
            try {
                JarURLConnection jarUrl = (JarURLConnection)this.url.openConnection();
                fileName = jarUrl.getJarFile().getName();
            }
            catch (Exception e) {
                return System.currentTimeMillis() + 1L;
            }
        } else {
            return System.currentTimeMillis() + 1L;
        }
        File file = new File(fileName);
        return file.lastModified();
    }

    @Override
    public boolean isValid() {
        return null != this.url;
    }

    @Override
    protected long defCheckInterval() {
        return -1L;
    }

    @Override
    protected Long userCheckInterval() {
        return 5000L;
    }

    @Override
    public String getSuggestedClassName() {
        return ClasspathTemplateResource.path2CN(this.key);
    }
}

