/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.resource;

import java.util.ArrayList;
import java.util.Arrays;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.extension.ITemplateResourceLoader;
import org.rythmengine.internal.compiler.TemplateClass;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.resource.ITemplateResource;
import org.rythmengine.resource.TemplateResourceBase;
import org.rythmengine.resource.TemplateResourceManager;
import org.rythmengine.utils.S;

public abstract class ResourceLoaderBase
implements ITemplateResourceLoader {
    protected static ILogger logger = Logger.get(ResourceLoaderBase.class);
    private RythmEngine engine;

    @Override
    public RythmEngine getEngine() {
        return this.engine;
    }

    @Override
    public void setEngine(RythmEngine engine) {
        this.engine = engine;
    }

    public String getFullName(TemplateClass tc) {
        int pos;
        String root;
        String key = tc.getKey().toString();
        if (key.startsWith("/") || key.startsWith("\\")) {
            key = key.substring(1);
        }
        if (key.startsWith(root = this.getResourceLoaderRoot())) {
            key = key.replace(root, "");
        }
        if (key.startsWith("/") || key.startsWith("\\")) {
            key = key.substring(1);
        }
        if (-1 != (pos = key.lastIndexOf("."))) {
            key = key.substring(0, pos);
        }
        key = key.replace('/', '.').replace('\\', '.');
        key = key + tc.getCodeType().resourceNameSuffix();
        return key;
    }

    protected RythmEngine getDefaultEngine() {
        return Rythm.engine();
    }

    @Override
    public TemplateClass tryLoadTemplate(String tmplName, RythmEngine engine, TemplateClass callerClass, ICodeType codeType) {
        return this.tryLoadTemplate(tmplName, engine, callerClass, codeType, true);
    }

    private TemplateClass tryLoadTemplate(String tmplName, RythmEngine engine, TemplateClass callerClass, ICodeType codeType, boolean processTagName) {
        TemplateClass tc;
        if (null == engine) {
            engine = this.getDefaultEngine();
        }
        if (engine.templateRegistered(tmplName)) {
            return null;
        }
        String rythmSuffix = engine.conf().resourceNameSuffix();
        ArrayList<String> suffixes = new ArrayList<String>(Arrays.asList(".html", ".json", ".js", ".css", ".csv", ".tag", ".xml", ".txt", ".rythm"));
        if (null == codeType) {
            codeType = TemplateResourceBase.getTypeOfPath(engine, tmplName);
        }
        if (ICodeType.DefImpl.RAW == codeType) {
            codeType = callerClass.getCodeType();
        }
        String tagNameOrigin = tmplName;
        boolean hasSuffix = false;
        String suffix = "";
        if (processTagName) {
            boolean withRythmSuffix = S.notEmpty(rythmSuffix);
            for (String s : suffixes) {
                if (tmplName.endsWith(s)) {
                    tmplName = tmplName.substring(0, tmplName.lastIndexOf(s));
                    suffix = s;
                    hasSuffix = true;
                    break;
                }
                if (!withRythmSuffix || !tmplName.endsWith(s) && !tmplName.endsWith(s + rythmSuffix)) continue;
                tmplName = tmplName.substring(0, tmplName.lastIndexOf(s));
                suffix = s + rythmSuffix;
                hasSuffix = true;
                break;
            }
        }
        tmplName = tmplName.replace('.', '/');
        String sfx = codeType.resourceNameSuffix();
        if (S.notEmpty(sfx) && !((String)suffixes.get(0)).equals(sfx)) {
            suffixes.remove(sfx);
            suffixes.add(0, sfx);
        }
        ArrayList<String> roots = new ArrayList<String>();
        String root0 = this.getResourceLoaderRoot().replace('\\', '/');
        if (root0.endsWith("/")) {
            root0 = root0.substring(0, root0.length() - 1);
        }
        roots.add(root0);
        String currentPath = callerClass.getKey().toString();
        int pos = currentPath.lastIndexOf("/");
        if (-1 != pos) {
            if ((currentPath = currentPath.substring(0, pos)).startsWith(root0)) {
                if (currentPath.length() > root0.length()) {
                    roots.add(0, currentPath);
                }
            } else {
                if (currentPath.startsWith("/")) {
                    currentPath = currentPath.substring(1);
                }
                if (!currentPath.startsWith(root0)) {
                    currentPath = root0 + "/" + currentPath;
                }
                roots.add(0, currentPath);
            }
        }
        if (null != callerClass.getImportPaths()) {
            for (String s : callerClass.getImportPaths()) {
                if (s.startsWith("java")) continue;
                roots.add(0, root0 + "/" + s.replace('.', '/'));
            }
        }
        String tmplName0 = tmplName;
        for (String root : roots) {
            String tmplName1 = tmplName0;
            if (root.startsWith("/") && !tmplName1.startsWith("/")) {
                tmplName1 = "/" + tmplName0;
            }
            String string = tmplName = tmplName1.startsWith(root) ? tmplName1 : root + "/" + tmplName0;
            if (hasSuffix) {
                ITemplateResource resource = this.load(tmplName + suffix);
                if (null == resource || !resource.isValid()) continue;
                TemplateClass tc2 = engine.resourceManager().resourceLoaded(resource, false);
                return tc2;
            }
            for (String suffix0 : suffixes) {
                String path = tmplName + suffix0;
                ITemplateResource resource = this.load(path);
                if (null == resource || !resource.isValid()) continue;
                TemplateClass tc3 = engine.resourceManager().resourceLoaded(resource, false);
                return tc3;
            }
        }
        TemplateClass templateClass = tc = processTagName ? this.tryLoadTemplate(tagNameOrigin, engine, callerClass, codeType, false) : null;
        if (null == tc) {
            TemplateResourceManager.reportNonResource(tmplName);
        }
        return tc;
    }

    @Override
    public void scan(TemplateResourceManager manager) {
        logger.warn("Resource scan not supported by %s", this.getClass().getName());
    }
}

