/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.utils;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.commons.lang3.StringEscapeUtils;
import org.rythmengine.RythmEngine;
import org.rythmengine.conf.RythmConfiguration;
import org.rythmengine.extension.IFormatter;
import org.rythmengine.extension.II18nMessageResolver;
import org.rythmengine.extension.Transformer;
import org.rythmengine.internal.CacheKey;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.template.ITemplate;
import org.rythmengine.utils.Escape;
import org.rythmengine.utils.F;
import org.rythmengine.utils.I18N;
import org.rythmengine.utils.Range;
import org.rythmengine.utils.RawData;

public class S {
    public static final S INSTANCE = new S();
    public static final String EMPTY_STR = "";
    private static final ILogger logger = Logger.get(S.class);
    public static final int IGNORECASE = 4096;
    public static final int IGNORESPACE = 8192;
    private static final Range<Integer> digits = F.R(48, 58);
    private static final Range<Integer> uppers = F.R(65, 91);
    private static final Range<Integer> lowers = F.R(97, 123);

    public static boolean isEmpty(String s) {
        return null == s || EMPTY_STR.equals(s.trim());
    }

    public static boolean empty(String s) {
        return null == s || EMPTY_STR.equals(s.trim());
    }

    public static boolean isNotEmpty(String s) {
        return !S.isEmpty(s);
    }

    public static boolean notEmpty(String s) {
        return !S.isEmpty(s);
    }

    public static boolean isEmpty(Object o) {
        return null == o || EMPTY_STR.equals(o.toString().trim());
    }

    public static boolean empty(Object o) {
        return null == o || EMPTY_STR.equals(S.str(o).trim());
    }

    public static boolean isNotEmpty(Object o) {
        return !S.isEmpty(o);
    }

    public static boolean notEmpty(Object o) {
        return !S.isEmpty(o);
    }

    public static boolean isEqual(String s1, String s2) {
        return S.isEqual(s1, s2, 0);
    }

    public static boolean isNotEqual(String s1, String s2) {
        return !S.isEqual(s1, s2, 0);
    }

    @Transformer
    public static boolean eq(String s1, String s2) {
        return S.isEqual(s1, s2, 0);
    }

    @Transformer
    public static boolean ne(String s1, String s2) {
        return !S.isEqual(s1, s2, 0);
    }

    public static boolean isEqual(Object o1, Object o2) {
        return S.isEqual(S.str(o1), S.str(o2));
    }

    public static boolean isNotEqual(Object o1, Object o2) {
        return !S.isEqual(S.str(o1), S.str(o2));
    }

    public static boolean eq(Object o1, Object o2) {
        return S.isEqual(S.str(o1), S.str(o2), 0);
    }

    public static boolean ne(Object o1, Object o2) {
        return S.isEqual(S.str(o1), S.str(o2), 0);
    }

    public static boolean eq(String s1, String s2, int modifier) {
        return S.isEqual(s1, s2, modifier);
    }

    public static boolean ne(String s1, String s2, int modifier) {
        return !S.isEqual(s1, s2, modifier);
    }

    public static boolean isEqual(String s1, String s2, int modifier) {
        if (s1 == s2) {
            return true;
        }
        if (null == s1) {
            return s2 == null;
        }
        if (null == s2) {
            return false;
        }
        if ((modifier & 0x2000) != 0) {
            s1 = s1.trim();
            s2 = s2.trim();
        }
        if ((modifier & 0x1000) != 0) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }

    public static boolean isNotEqual(String s1, String s2, int modifier) {
        return !S.isEqual(s1, s2, modifier);
    }

    public static String str(Object o) {
        return null == o ? EMPTY_STR : o.toString();
    }

    public static String string(Object o) {
        return null == o ? EMPTY_STR : o.toString();
    }

    public static String toString(Object o) {
        return null == o ? EMPTY_STR : o.toString();
    }

    public static String removeAllLineBreaks(Object o) {
        String s = S.str(o);
        return s.replaceAll("[\n\r]+", " ");
    }

    @Transformer
    public static RawData raw(Object o) {
        return new RawData(o);
    }

    @Transformer(requireTemplate=true)
    public static RawData escape(Object o) {
        return S.escape(null, o);
    }

    public static RawData escape(ITemplate template, Object o) {
        RythmEngine engine;
        if (S.empty(o)) {
            return RawData.NULL;
        }
        Escape escape = null != template ? template.__curEscape() : (null != (engine = RythmEngine.get()) ? engine.conf().defaultCodeType().escape() : Escape.RAW);
        return escape.apply(o);
    }

    @Transformer
    public static RawData escape(Object o, Object escape) {
        if (S.isEmpty(o)) {
            return RawData.NULL;
        }
        if (o instanceof RawData) {
            return (RawData)o;
        }
        if (escape instanceof Escape) {
            return ((Escape)((Object)escape)).apply(o);
        }
        if (S.isEmpty(escape)) {
            return S.escape(o);
        }
        String se = escape.toString();
        if ("json".equalsIgnoreCase(se)) {
            return S.escapeJson(o);
        }
        if ("xml".equalsIgnoreCase(se)) {
            return S.escapeXml(o);
        }
        if ("javascript".equalsIgnoreCase(se) || "js".equalsIgnoreCase(se)) {
            return S.escapeJavaScript(o);
        }
        if ("csv".equalsIgnoreCase(se)) {
            return S.escapeCsv(o);
        }
        if ("html".equalsIgnoreCase(se)) {
            return S.escapeHtml(o);
        }
        if ("raw".equalsIgnoreCase(se)) {
            return S.raw(o);
        }
        throw new IllegalArgumentException("Unknown escape scheme: " + se);
    }

    @Transformer
    public static RawData escapeHTML(Object o) {
        if (null == o) {
            return RawData.NULL;
        }
        if (o instanceof RawData) {
            return (RawData)o;
        }
        return new RawData(StringEscapeUtils.escapeHtml4((String)o.toString()));
    }

    public static RawData escapeHtml(Object o) {
        return S.escapeHTML(o);
    }

    @Transformer
    public static RawData escapeCSV(Object o) {
        if (null == o) {
            return RawData.NULL;
        }
        if (o instanceof RawData) {
            return (RawData)o;
        }
        return Escape.CSV.apply_(o.toString());
    }

    public static RawData escapeCsv(Object o) {
        return S.escapeCSV(o);
    }

    @Transformer
    public static RawData escapeJSON(Object o) {
        if (null == o) {
            return RawData.NULL;
        }
        if (o instanceof RawData) {
            return (RawData)o;
        }
        String s0 = o.toString();
        s0 = StringEscapeUtils.escapeJson((String)s0);
        return new RawData(s0);
    }

    public static RawData escapeJson(Object o) {
        return S.escapeJSON(o);
    }

    @Transformer
    public static RawData escapeJavaScript(Object o) {
        if (null == o) {
            return RawData.NULL;
        }
        if (o instanceof RawData) {
            return (RawData)o;
        }
        return new RawData(StringEscapeUtils.escapeEcmaScript((String)o.toString()));
    }

    public static RawData escapeJavascript(Object o) {
        return S.escapeJavaScript(o);
    }

    @Transformer
    public static RawData escapeJS(Object o) {
        return S.escapeJavaScript(o);
    }

    public static RawData escapeJava(Object o) {
        if (null == o) {
            return RawData.NULL;
        }
        if (o instanceof RawData) {
            return (RawData)o;
        }
        return new RawData(StringEscapeUtils.escapeJava((String)o.toString()));
    }

    @Transformer
    public static RawData escapeXML(Object o) {
        if (null == o) {
            return RawData.NULL;
        }
        if (o instanceof RawData) {
            return (RawData)o;
        }
        return new RawData(StringEscapeUtils.escapeXml((String)o.toString()));
    }

    public static RawData escapeXml(Object o) {
        if (null == o) {
            return RawData.NULL;
        }
        if (o instanceof RawData) {
            return (RawData)o;
        }
        return new RawData(StringEscapeUtils.escapeXml((String)o.toString()));
    }

    public static RawData escapeRegex(Object o) {
        if (null == o) {
            return RawData.NULL;
        }
        if (o instanceof RawData) {
            return (RawData)o;
        }
        String s = o.toString();
        return new RawData(s.replaceAll("([\\/\\*\\{\\}\\<\\>\\-\\\\\\!])", "\\\\$1"));
    }

    public static String strip(Object o, String prefix, String suffix) {
        if (null == o) {
            return EMPTY_STR;
        }
        String s = o.toString();
        if ((s = s.trim()).startsWith(prefix)) {
            s = s.substring(prefix.length());
        }
        if (s.endsWith(suffix)) {
            s = s.substring(0, s.length() - suffix.length());
        }
        return s;
    }

    public static String stripBrace(Object o) {
        return S.strip(o, "(", ")");
    }

    public static String stripQuotation(Object o) {
        return S.strip(S.strip(o, "\"", "\""), "'", "'");
    }

    public static String stripBraceAndQuotation(Object o) {
        if (null == o) {
            return EMPTY_STR;
        }
        String s = S.stripBrace(o);
        s = S.stripQuotation(s);
        return s;
    }

    public static String shrinkSpace(Object o) {
        if (null == o) {
            return EMPTY_STR;
        }
        return o.toString().replaceAll("[\r\n]+", "\n").replaceAll("[ \\t\\x0B\\f]+", " ");
    }

    public static boolean isDigitsOrAlphabetic(char c) {
        char i = c;
        return digits.include(Integer.valueOf(i)) || uppers.include(Integer.valueOf(i)) || lowers.include(Integer.valueOf(i));
    }

    @Transformer
    public static String capitalizeWords(Object o) {
        if (null == o) {
            return EMPTY_STR;
        }
        String source = o.toString();
        char prevc = ' ';
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c != ' ' && !S.isDigitsOrAlphabetic(prevc)) {
                sb.append(Character.toUpperCase(c));
            } else {
                sb.append(c);
            }
            prevc = c;
        }
        return sb.toString();
    }

    @Transformer
    public static String noAccents(Object o) {
        if (null == o) {
            return EMPTY_STR;
        }
        String string = o.toString();
        return Normalizer.normalize(string, Normalizer.Form.NFKC).replaceAll("[\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u0101\u0105\u0103]", "a").replaceAll("[\u00e7\u0107\u010d\u0109\u010b]", "c").replaceAll("[\u010f\u0111\u00f0]", "d").replaceAll("[\u00e8\u00e9\u00ea\u00eb\u0113\u0119\u011b\u0115\u0117]", "e").replaceAll("[\u0192\u017f]", "f").replaceAll("[\u011d\u011f\u0121\u0123]", "g").replaceAll("[\u0125\u0127]", "h").replaceAll("[\u00ec\u00ed\u00ee\u00ef\u012b\u0129\u012d\u012f\u0131]", "i").replaceAll("[\u0133\u0135]", "j").replaceAll("[\u0137\u0138]", "k").replaceAll("[\u0142\u013e\u013a\u013c\u0140]", "l").replaceAll("[\u00f1\u0144\u0148\u0146\u0149\u014b]", "n").replaceAll("[\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u014d\u0151\u014f\u0153]", "o").replaceAll("[\u00de\u00fe]", "p").replaceAll("[\u0155\u0159\u0157]", "r").replaceAll("[\u015b\u0161\u015f\u015d\u0219]", "s").replaceAll("[\u0165\u0163\u0167\u021b]", "t").replaceAll("[\u00f9\u00fa\u00fb\u00fc\u016b\u016f\u0171\u016d\u0169\u0173]", "u").replaceAll("[\u0175]", "w").replaceAll("[\u00fd\u00ff\u0177]", "y").replaceAll("[\u017e\u017c\u017a]", "z").replaceAll("[\u00e6]", "ae").replaceAll("[\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u0100\u0104\u0102]", "A").replaceAll("[\u00c7\u0106\u010c\u0108\u010a]", "C").replaceAll("[\u010e\u0110\u00d0]", "D").replaceAll("[\u00c8\u00c9\u00ca\u00cb\u0112\u0118\u011a\u0114\u0116]", "E").replaceAll("[\u011c\u011e\u0120\u0122]", "G").replaceAll("[\u0124\u0126]", "H").replaceAll("[\u00cc\u00cd\u00ce\u00cf\u012a\u0128\u012c\u012e\u0130]", "I").replaceAll("[\u0134]", "J").replaceAll("[\u0136]", "K").replaceAll("[\u0141\u013d\u0139\u013b\u013f]", "L").replaceAll("[\u00d1\u0143\u0147\u0145\u014a]", "N").replaceAll("[\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u014c\u0150\u014e]", "O").replaceAll("[\u0154\u0158\u0156]", "R").replaceAll("[\u015a\u0160\u015e\u015c\u0218]", "S").replaceAll("[\u00d9\u00da\u00db\u00dc\u016a\u016e\u0170\u016c\u0168\u0172]", "U").replaceAll("[\u0174]", "W").replaceAll("[\u00dd\u0176\u0178]", "Y").replaceAll("[\u0179\u017d\u017b]", "Z").replaceAll("[\u00df]", "ss");
    }

    @Transformer
    public static String lowerFirst(Object o) {
        if (null == o) {
            return EMPTY_STR;
        }
        String string = o.toString();
        if (string.length() == 0) {
            return string;
        }
        return (EMPTY_STR + string.charAt(0)).toLowerCase() + string.substring(1);
    }

    @Transformer
    public static String capFirst(Object o) {
        if (null == o) {
            return EMPTY_STR;
        }
        String string = o.toString();
        if (string.length() == 0) {
            return string;
        }
        return (EMPTY_STR + string.charAt(0)).toUpperCase() + string.substring(1);
    }

    @Transformer
    public static String camelCase(Object obj) {
        if (null == obj) {
            return EMPTY_STR;
        }
        String string = obj.toString();
        StringBuilder result = new StringBuilder(string.length());
        String[] sa = string.split(" ");
        int l = sa.length;
        for (int i = 0; i < l; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            for (String s : sa[i].split("_")) {
                result.append(S.capFirst(s));
            }
        }
        return result.toString();
    }

    @Transformer
    public static String[] divide(Object o, String sep) {
        return S.str(o).split(sep);
    }

    @Transformer
    public static String lowerCase(Object o) {
        return S.str(o).toLowerCase();
    }

    @Transformer
    public static String upperCase(Object o) {
        return S.str(o).toUpperCase();
    }

    @Transformer
    public static int len(Object o) {
        if (o instanceof Collection) {
            return ((Collection)o).size();
        }
        if (o instanceof Map) {
            return ((Map)o).size();
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o);
        }
        return S.str(o).length();
    }

    @Transformer
    public static RawData nl2br(RawData data) {
        return new RawData(data.toString().replace("\n", "<br/>"));
    }

    public static RawData nl2br(Object data) {
        return new RawData(StringEscapeUtils.escapeHtml4((String)S.str(data)).replace("\n", "<br/>"));
    }

    @Transformer
    public static RawData sp2nbsp(RawData data) {
        return new RawData(data.toString().replace(" ", "&nbsp;"));
    }

    public static RawData sp2nbsp(Object data) {
        return new RawData(StringEscapeUtils.escapeHtml4((String)S.str(data)).replace(" ", "&nbsp;"));
    }

    @Transformer
    public static String urlEncode(Object data) {
        if (null == data) {
            return EMPTY_STR;
        }
        String entity = data.toString();
        try {
            String encoding = "utf-8";
            return URLEncoder.encode(entity, encoding);
        }
        catch (UnsupportedEncodingException e) {
            Logger.error(e, entity, new Object[0]);
            return entity;
        }
    }

    public static String format(Number number) {
        return S.format(null, number, null, null);
    }

    public static String format(ITemplate template, Number number) {
        return S.format(template, number, null, null);
    }

    @Transformer(requireTemplate=true)
    public static String format(Number number, String pattern, Locale locale) {
        return S.format(null, number, pattern, locale);
    }

    public static String format(ITemplate template, Number number, String pattern, Locale locale) {
        NumberFormat nf;
        if (null == number) {
            number = 0;
        }
        if (null == locale) {
            locale = I18N.locale(template);
        }
        if (null == pattern) {
            nf = NumberFormat.getNumberInstance(locale);
        } else {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            nf = new DecimalFormat(pattern, symbols);
        }
        return nf.format(number);
    }

    @Transformer(requireTemplate=true)
    public static String format(Number number, String pattern) {
        return S.format(null, number, pattern, null);
    }

    public static String format(ITemplate template, Number number, String pattern) {
        return S.format(template, number, pattern, null);
    }

    public static String format(Object o) {
        if (null == o) {
            return EMPTY_STR;
        }
        return S.format(null, o, null, null, null);
    }

    @Transformer(requireTemplate=true)
    public static String format(Date date) {
        return S.format(date, null, null, null);
    }

    public static String format(ITemplate template, Object o) {
        if (null == o) {
            return EMPTY_STR;
        }
        return S.format(template, o, null, null, null);
    }

    public static String format(ITemplate template, Date date) {
        return S.format(template, date, null, null, null);
    }

    @Transformer(requireTemplate=true)
    public static String format(Date date, String pattern) {
        return S.format(date, pattern, null, null);
    }

    public static String format(Object o, String pattern) {
        if (null == o) {
            return EMPTY_STR;
        }
        return S.format(null, o, pattern, null, null);
    }

    public static String format(ITemplate template, Date date, String pattern) {
        return S.format(template, date, pattern, null, null);
    }

    public static String format(ITemplate template, Object o, String pattern) {
        if (null == o) {
            return EMPTY_STR;
        }
        return S.format(template, o, pattern, null, null);
    }

    @Transformer(requireTemplate=true)
    public static String format(Date date, String pattern, Locale locale) {
        return S.format(date, pattern, locale, null);
    }

    public static String format(Object o, String pattern, Locale locale) {
        if (null == o) {
            return EMPTY_STR;
        }
        return S.format(null, o, pattern, locale, null);
    }

    public static String format(ITemplate template, Date date, String pattern, Locale locale) {
        return S.format(template, date, pattern, locale, null);
    }

    public static String format(ITemplate template, Object o, String pattern, Locale locale) {
        if (null == o) {
            return EMPTY_STR;
        }
        return S.format(template, o, pattern, locale, null);
    }

    @Transformer(requireTemplate=true)
    public static String format(Date date, String pattern, Locale locale, String timezone) {
        return S.format(null, date, pattern, locale, timezone);
    }

    public static String format(Object o, String pattern, Locale locale, String timezone) {
        if (null == o) {
            return EMPTY_STR;
        }
        return S.format(null, o, pattern, locale, timezone);
    }

    public static String format(ITemplate template, Date date, String pattern, Locale locale, String timezone) {
        if (null == date) {
            date = new Date(0L);
        }
        if (null == locale) {
            locale = I18N.locale(template);
        }
        DateFormat df = null != pattern ? new SimpleDateFormat(pattern, locale) : DateFormat.getDateInstance(2, locale);
        if (null != timezone) {
            df.setTimeZone(TimeZone.getTimeZone(timezone));
        }
        return df.format(date);
    }

    public static String format(ITemplate template, Object o, String pattern, Locale locale, String timezone) {
        RythmEngine engine;
        if (null == o) {
            return EMPTY_STR;
        }
        if (o instanceof Date) {
            return S.format(template, (Date)o, pattern, locale, timezone);
        }
        if (o instanceof Number) {
            return S.format(template, (Number)o, pattern, locale);
        }
        if (null == locale) {
            locale = I18N.locale(template);
        }
        RythmEngine rythmEngine = engine = null == template ? RythmEngine.get() : template.__engine();
        if (null == engine) {
            return o.toString();
        }
        for (IFormatter fmt : engine.extensionManager().formatters()) {
            String s = fmt.format(o, pattern, locale, timezone);
            if (null == s) continue;
            return s;
        }
        return o.toString();
    }

    @Transformer
    public static String formatSize(Object data) {
        if (null == data) {
            throw new NullPointerException();
        }
        Long bytes = data instanceof Number ? (data instanceof Long ? (Long)data : Long.valueOf(((Number)data).longValue())) : Long.valueOf(data.toString());
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return bytes / 1024L + "KB";
        }
        if (bytes < 0x40000000L) {
            return bytes / 0x100000L + "MB";
        }
        return bytes / 0x40000000L + "GB";
    }

    @Transformer(requireTemplate=true)
    public static String formatCurrency(Object data) {
        return S.formatCurrency(null, data, null, null);
    }

    public static String formatCurrency(ITemplate template, Object data) {
        return S.formatCurrency(template, data, null, null);
    }

    @Transformer(requireTemplate=true)
    public static String formatCurrency(Object data, String currencyCode) {
        return S.formatCurrency(null, data, currencyCode, null);
    }

    public static String formatCurrency(ITemplate template, Object data, String currencyCode) {
        return S.formatCurrency(template, data, currencyCode, null);
    }

    public static String formatCurrency(Object data, String currencyCode, Locale locale) {
        return S.formatCurrency(null, data, currencyCode, locale);
    }

    public static String formatCurrency(ITemplate template, Object data, String currencyCode, Locale locale) {
        if (null == data) {
            throw new NullPointerException();
        }
        Number number = data instanceof Number ? (Number)((Number)data) : (Number)Double.parseDouble(data.toString());
        if (null == locale) {
            locale = I18N.locale(template);
        }
        if (null == locale.getCountry() || locale.getCountry().length() != 2) {
            String lan = locale.getLanguage();
            if (S.eq(lan, "en")) {
                if (null != currencyCode) {
                    if (S.eq("AUD", currencyCode)) {
                        locale = new Locale(lan, "AU");
                    } else if (S.eq("USD", currencyCode)) {
                        locale = Locale.US;
                    } else if (S.eq("GBP", currencyCode)) {
                        locale = Locale.UK;
                    }
                }
            } else if (S.eq(lan, "zh")) {
                locale = Locale.SIMPLIFIED_CHINESE;
            }
        }
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(locale);
        Currency currency = null;
        if (null == currencyCode) {
            String country = locale.getCountry();
            if (null != country && country.length() == 2) {
                currency = Currency.getInstance(locale);
            }
            if (null == currency) {
                currencyCode = "$";
            }
        }
        if (null == currency && currencyCode.length() == 3) {
            currency = Currency.getInstance(currencyCode);
        }
        if (null != currency) {
            numberFormat.setCurrency(currency);
            numberFormat.setMaximumFractionDigits(currency.getDefaultFractionDigits());
        } else {
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setCurrencySymbol(currencyCode);
            ((DecimalFormat)numberFormat).setDecimalFormatSymbols(dfs);
        }
        String s = numberFormat.format(number);
        if (null != currency) {
            s = s.replace(currency.getCurrencyCode(), currency.getSymbol(locale));
        }
        return s;
    }

    private static String getMessage(ITemplate template, ResourceBundle bundle, String key, Locale locale, Object ... args) {
        if (null == locale) {
            locale = I18N.locale(template);
        }
        String s = key;
        try {
            s = bundle.getString(key);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        int argLen = args.length;
        if (argLen > 0) {
            MessageFormat fmt = new MessageFormat(s, locale);
            Object[] argsResolved = new Object[argLen];
            for (int i = 0; i < argLen; ++i) {
                Object arg = args[i];
                if (arg instanceof String) {
                    arg = S.i18n(template, (Object)((String)arg), new Object[0]);
                }
                argsResolved[i] = arg;
            }
            return fmt.format(argsResolved);
        }
        return s;
    }

    public static String i18n(ITemplate template, Object key, Object ... args) {
        Serializable cached;
        Object arg0;
        II18nMessageResolver resolver;
        String k = S.string(key);
        if (null != template && null != (resolver = template.__engine().conf().i18nMessageResolver()) && II18nMessageResolver.DefaultImpl.INSTANCE != resolver) {
            return resolver.getMessage(template, k, args);
        }
        boolean useFormat = args.length > 0;
        Locale locale = null;
        if (useFormat && (arg0 = args[0]) instanceof Locale) {
            locale = (Locale)arg0;
            Object[] args0 = new Object[args.length - 1];
            System.arraycopy(args, 1, args0, 0, args.length - 1);
            args = args0;
            boolean bl = useFormat = args.length > 0;
        }
        if (null == locale) {
            locale = I18N.locale(template);
        }
        RythmEngine engine = null == template ? RythmEngine.get() : template.__engine();
        String cacheKey = null;
        if (null != template && null != locale && S.notEmpty(cached = engine.cached(cacheKey = CacheKey.i18nMsg(template, k, useFormat, locale), new Object[0]))) {
            return S.str(cached);
        }
        for (String msgSrc : RythmConfiguration.get().messageSources()) {
            String data;
            ResourceBundle bundle = I18N.bundle(template, msgSrc, locale);
            if (null == bundle || null == (data = S.getMessage(template, bundle, k, locale, args))) continue;
            if (null != engine) {
                engine.cache(cacheKey, (Object)data, -1, new Object[0]);
            }
            return data;
        }
        return k;
    }

    @Transformer(requireTemplate=true)
    public static String i18n(Object key, Object ... args) {
        return S.i18n(null, key, args);
    }

    @Transformer(requireTemplate=true)
    public static String i18n(Object key) {
        return S.i18n(null, key, new Object[0]);
    }

    @Transformer
    public static String toJSON(Object data) {
        return JSON.toJSONString((Object)data);
    }

    public static String random(int len) {
        char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '$', '#', '^', '&', '_', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '~', '!', '@'};
        int max = chars.length;
        Random r = new Random();
        StringBuilder sb = new StringBuilder(len);
        while (len-- > 0) {
            int i = r.nextInt(max);
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    public static String random() {
        return S.random(8);
    }

    @Transformer
    public static String join(Iterable itr) {
        return S.join(",", itr);
    }

    @Transformer(lastParam=true)
    public static String join(String sep, Iterable itr) {
        return S.join(sep, itr.iterator());
    }

    public static String join(String sep, Iterator i) {
        StringBuilder sb = new StringBuilder();
        if (!i.hasNext()) {
            return EMPTY_STR;
        }
        sb.append(i.next());
        while (i.hasNext()) {
            sb.append(sep);
            sb.append(i.next());
        }
        return sb.toString();
    }

    public static String join(String sep, Object obj) {
        if (null == obj) {
            return EMPTY_STR;
        }
        if (obj instanceof Iterable) {
            return S.join(sep, (Iterable)obj);
        }
        if (obj instanceof Iterator) {
            return S.join(sep, (Iterator)obj);
        }
        if (obj.getClass().isArray()) {
            int n = Array.getLength(obj);
            if (n == 0) {
                return EMPTY_STR;
            }
            StringBuilder sb = new StringBuilder(n);
            sb.append(Array.get(obj, 0));
            for (int i = 1; i < n; ++i) {
                sb.append(sep).append(Array.get(obj, i));
            }
            return sb.toString();
        }
        return obj.toString();
    }

    public static String join(char sep, Iterable itr) {
        return S.join(String.valueOf(sep), itr);
    }

    public static String join(Character[] a) {
        return S.join(",", a);
    }

    public static String join(String sep, Character[] a) {
        int len = a.length;
        if (len == 0) {
            return EMPTY_STR;
        }
        StringBuilder sb = new StringBuilder(String.valueOf(a[0]));
        for (int i = 1; i < len; ++i) {
            sb.append(sep).append(a[i]);
        }
        return sb.toString();
    }

    public static String join(char sep, Character[] a) {
        return S.join(String.valueOf(sep), a);
    }

    public static String join(Integer[] a) {
        return S.join(",", a);
    }

    public static String join(String sep, Integer[] a) {
        int len = a.length;
        if (len == 0) {
            return EMPTY_STR;
        }
        StringBuilder sb = new StringBuilder(String.valueOf(a[0]));
        for (int i = 1; i < len; ++i) {
            sb.append(sep).append(a[i]);
        }
        return sb.toString();
    }

    public static String join(char sep, Integer[] a) {
        return S.join(String.valueOf(sep), a);
    }

    public static String join(Long[] a) {
        return S.join(",", a);
    }

    public static String join(String sep, Long[] a) {
        int len = a.length;
        if (len == 0) {
            return EMPTY_STR;
        }
        StringBuilder sb = new StringBuilder(String.valueOf(a[0]));
        for (int i = 1; i < len; ++i) {
            sb.append(sep).append(a[i]);
        }
        return sb.toString();
    }

    public static String join(char sep, Long[] a) {
        return S.join(String.valueOf(sep), a);
    }

    public static String join(Float[] a) {
        return S.join(",", a);
    }

    public static String join(String sep, Float[] a) {
        int len = a.length;
        if (len == 0) {
            return EMPTY_STR;
        }
        StringBuilder sb = new StringBuilder(String.valueOf(a[0]));
        for (int i = 1; i < len; ++i) {
            sb.append(sep).append(a[i]);
        }
        return sb.toString();
    }

    public static String join(char sep, Float[] a) {
        return S.join(String.valueOf(sep), a);
    }

    public static String join(Double[] a) {
        return S.join(",", a);
    }

    public static String join(String sep, Double[] a) {
        int len = a.length;
        if (len == 0) {
            return EMPTY_STR;
        }
        StringBuilder sb = new StringBuilder(String.valueOf(a[0]));
        for (int i = 1; i < len; ++i) {
            sb.append(sep).append(a[i]);
        }
        return sb.toString();
    }

    public static String join(char sep, Double[] a) {
        return S.join(String.valueOf(sep), a);
    }
}

