/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal;

import com.stevesoft.pat.Regex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.Sandbox;
import org.rythmengine.conf.RythmConfiguration;
import org.rythmengine.conf.RythmConfigurationKey;
import org.rythmengine.exception.ParseException;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.extension.ISourceCodeEnhancer;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IDialect;
import org.rythmengine.internal.IDirective;
import org.rythmengine.internal.RythmEvents;
import org.rythmengine.internal.TemplateParser;
import org.rythmengine.internal.ToStringTemplateBase;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.compiler.ParamTypeInferencer;
import org.rythmengine.internal.compiler.TemplateClass;
import org.rythmengine.internal.dialect.BasicRythm;
import org.rythmengine.internal.dialect.SimpleRythm;
import org.rythmengine.internal.parser.BlockCodeToken;
import org.rythmengine.internal.parser.CodeToken;
import org.rythmengine.internal.parser.NotRythmTemplateException;
import org.rythmengine.internal.parser.build_in.BlockToken;
import org.rythmengine.internal.parser.build_in.CompactStateToken;
import org.rythmengine.internal.parser.build_in.InvokeTemplateParser;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.resource.ITemplateResource;
import org.rythmengine.resource.StringTemplateResource;
import org.rythmengine.template.JavaTagBase;
import org.rythmengine.template.TagBase;
import org.rythmengine.template.TemplateBase;
import org.rythmengine.utils.HashCode;
import org.rythmengine.utils.S;
import org.rythmengine.utils.TextBuilder;

public class CodeBuilder
extends TextBuilder {
    protected static final ILogger logger = Logger.get(CodeBuilder.class);
    private int renderArgCounter = 0;
    private RythmEngine engine;
    private RythmConfiguration conf;
    private TemplateParser parser;
    private TemplateClass templateClass;
    private boolean isNotRythmTemplate = false;
    public ICodeType templateDefLang;
    protected String tmpl;
    private String cName;
    public String includingCName;
    private String pName;
    String tagName;
    private String initCode = null;
    private String finalCode = null;
    private Set<InlineClass> inlineClasses = new HashSet<InlineClass>();
    private List<String> staticCodes = new ArrayList<String>();
    private String extended;
    private TemplateClass extendedTemplateClass;
    private InvokeTemplateParser.ParameterDeclarationList extendArgs = null;
    public Set<String> imports = new HashSet<String>();
    private int extendDeclareLineNo = -1;
    public Map<String, RenderArgDeclaration> renderArgs = new LinkedHashMap<String, RenderArgDeclaration>();
    private List<Token> builders = new ArrayList<Token>();
    public transient IDialect requiredDialect = null;
    private Map<String, Integer> importLineMap = new HashMap<String, Integer>();
    private Set<InlineTag> inlineTags = new HashSet<InlineTag>();
    private Stack<List<Token>> inlineTagBodies = new Stack();
    protected boolean logTime = false;
    private Map<String, List<Token>> macros = new HashMap<String, List<Token>>();
    private Stack<String> macroStack = new Stack();
    public boolean removeNextLF = false;
    public String buildBody = null;
    transient Map<Token.StringToken, String> consts = new HashMap<Token.StringToken, String>();
    private RythmEngine.OutputMode outputMode = RythmEngine.outputMode();
    private Set<String> varNames = new HashSet<String>();
    public static final String INTERRUPT_CODE = "\n{if (java.lang.Thread.interrupted()) throw new RuntimeException(\"interrupted\");}";
    private static final Regex R_FOR_0 = new Regex("([\\s;]for\\s*(?@())\\s*\\{(\\s*//\\s*line:\\s*[0-9]+)?)", "${1}\n{if (java.lang.Thread.interrupted()) throw new RuntimeException(\"interrupted\");}${2}\n");
    private static final Regex R_FOR_1 = new Regex("([\\s;]for\\s*(?@()))\\s*([^\\{]+;)", "${1} \\{\n{if (java.lang.Thread.interrupted()) throw new RuntimeException(\"interrupted\");}${2} \n\\}");
    private static final Regex R_WHILE_0 = new Regex("([\\s;]while\\s*(?@())\\s*\\{)", "${1}\n{if (java.lang.Thread.interrupted()) throw new RuntimeException(\"interrupted\");}");
    private static final Regex R_WHILE_1 = new Regex("([\\s;]while\\s*(?@()))\\s*([^\\{]+;)", "${1} \\{\n{if (java.lang.Thread.interrupted()) throw new RuntimeException(\"interrupted\");}${2} \\}");
    private static final Regex R_DO_0 = new Regex("([\\s;]do\\s*\\{)", "${1}\n{if (java.lang.Thread.interrupted()) throw new RuntimeException(\"interrupted\");}");
    private static final Regex R_DO_1 = new Regex("([\\s;]do\\s*)([^\\{\\}]+[\\s;]while[\\s\\(])", "${1} \\{\n{if (java.lang.Thread.interrupted()) throw new RuntimeException(\"interrupted\");}${2}");

    public RythmEngine engine() {
        return this.engine;
    }

    public boolean isRythmTemplate() {
        return !this.isNotRythmTemplate;
    }

    public void setInitCode(String code) {
        this.initCode = S.empty(this.initCode) ? code : this.initCode + ";\n" + code;
    }

    public void setFinalCode(String code) {
        this.finalCode = S.empty(this.finalCode) ? code : this.finalCode + ";\n" + code;
    }

    protected String extended() {
        String defClass = TagBase.class.getName();
        return null == this.extended ? defClass : this.extended;
    }

    private String extendedResourceMark() {
        TemplateClass tc = this.extendedTemplateClass;
        return null == tc ? "" : String.format("//<extended_resource_key>%s</extended_resource_key>", tc.templateResource.getKey());
    }

    public TemplateClass getExtendedTemplateClass() {
        return this.extendedTemplateClass;
    }

    private List<Token> builders() {
        if (this.macroStack.empty()) {
            return this.builders;
        }
        String macro = this.macroStack.peek();
        List<Token> bl = this.macros.get(macro);
        if (null == bl) {
            bl = new ArrayList<Token>();
            this.macros.put(macro, bl);
        }
        return bl;
    }

    public boolean isLastBuilderLiteral() {
        List<Token> bl = this.builders();
        for (int i = bl.size() - 1; i >= 0; --i) {
            Token tb = bl.get(i);
            if (tb instanceof Token.StringToken) {
                if (((Token.StringToken)tb).empty()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public TemplateClass getTemplateClass() {
        return this.templateClass;
    }

    private boolean simpleTemplate() {
        return this.parser.getDialect() instanceof SimpleRythm;
    }

    public boolean basicTemplate() {
        return this.parser.getDialect() instanceof BasicRythm;
    }

    public CodeBuilder(String template, String className, String tagName, TemplateClass templateClass, RythmEngine engine, IDialect requiredDialect) {
        String tmpl;
        ICodeType type;
        this.tmpl = template;
        className = className.replace('/', '.');
        this.tagName = null == tagName ? className : tagName;
        this.cName = className;
        int i = className.lastIndexOf(46);
        if (-1 < i) {
            this.cName = className.substring(i + 1);
            this.pName = className.substring(0, i);
        }
        this.engine = null == engine ? Rythm.engine() : engine;
        this.conf = this.engine.conf();
        this.requiredDialect = requiredDialect;
        this.templateClass = templateClass;
        this.templateDefLang = type = templateClass.codeType;
        this.tmpl = tmpl = RythmEvents.ON_PARSE.trigger(this.engine, this);
        this.parser = new TemplateParser(this);
    }

    public void clear() {
        this.buffer().ensureCapacity(0);
        this.engine = null;
        this.tmpl = null;
        this.cName = null;
        this.pName = null;
        this.tagName = null;
        this.initCode = null;
        this.finalCode = null;
        this.extended = null;
        this.extendedTemplateClass = null;
        if (null != this.extendArgs) {
            this.extendArgs.pl.clear();
        }
        this.imports.clear();
        this.extendDeclareLineNo = 0;
        this.renderArgs.clear();
        this.builders.clear();
        this.parser = null;
        this.templateClass = null;
        this.inlineClasses.clear();
        this.inlineTags.clear();
        this.inlineTagBodies.clear();
        this.importLineMap.clear();
        this.logTime = false;
        this.macros.clear();
        this.macroStack.clear();
        this.buildBody = null;
        this.templateDefLang = null;
        this.staticCodes.clear();
    }

    public void rewind() {
        this.renderArgCounter = 0;
        this.initCode = null;
        this.finalCode = null;
        this.extended = null;
        this.extendedTemplateClass = null;
        if (null != this.extendArgs) {
            this.extendArgs.pl.clear();
        }
        this.imports.clear();
        this.extendDeclareLineNo = 0;
        this.renderArgs.clear();
        this.builders.clear();
        this.inlineClasses.clear();
        this.inlineTags.clear();
        this.inlineTagBodies.clear();
        this.importLineMap.clear();
        this.logTime = false;
        this.macros.clear();
        this.macroStack.clear();
        this.buildBody = null;
        this.staticCodes.clear();
    }

    public void merge(CodeBuilder codeBuilder) {
        if (null == codeBuilder) {
            return;
        }
        this.imports.addAll(codeBuilder.imports);
        for (InlineTag tag : codeBuilder.inlineTags) {
            this.inlineTags.add(tag.clone(this));
        }
        for (InlineClass clz : codeBuilder.inlineClasses) {
            this.inlineClasses.add(clz.clone(this));
        }
        this.initCode = S.toString(this.initCode) + S.toString(codeBuilder.initCode);
        this.finalCode = S.toString(this.finalCode) + S.toString(codeBuilder.finalCode);
        this.renderArgs.putAll(codeBuilder.renderArgs);
        this.importLineMap.putAll(codeBuilder.importLineMap);
        this.staticCodes.addAll(codeBuilder.staticCodes);
        this.renderArgCounter += codeBuilder.renderArgCounter;
    }

    public CodeBuilder() {
    }

    public String className() {
        return this.cName;
    }

    public String includingClassName() {
        return null == this.includingCName ? this.cName : this.includingCName;
    }

    public void addImport(String imprt, int lineNo) {
        this.imports.add(imprt);
        if (imprt.endsWith(".*")) {
            imprt = imprt.substring(0, imprt.lastIndexOf(".*"));
            this.templateClass.importPaths.add(imprt);
        }
        this.importLineMap.put(imprt, lineNo);
    }

    public boolean hasInlineTagWithoutArgument(String tagName) {
        for (InlineTag tag : this.inlineTags) {
            if (!S.eq(tag.tagName, tagName) || !tag.noArgs()) continue;
            return true;
        }
        return false;
    }

    public boolean needsPrint(String tagName) {
        return this.templateClass.returnObject(tagName);
    }

    public void addStaticCode(String codeSnippet) {
        this.staticCodes.add(codeSnippet);
    }

    public InlineClass defClass(String className, String body) {
        InlineClass clz = new InlineClass(className = className.trim(), body);
        if (this.inlineClasses.contains(clz)) {
            throw new ParseException(this.engine, this.templateClass, this.parser.currentLine(), "inline class already defined: %s", className);
        }
        this.inlineClasses.add(clz);
        return clz;
    }

    public InlineTag defTag(String tagName, String retType, String signature, String body) {
        InlineTag tag = new InlineTag(tagName = tagName.trim(), retType, signature, body);
        if (this.inlineTags.contains(tag)) {
            throw new ParseException(this.engine, this.templateClass, this.parser.currentLine(), "inline tag already defined: %s", tagName);
        }
        this.inlineTags.add(tag);
        this.inlineTagBodies.push(this.builders);
        this.builders = tag.builders;
        if ("void".equals(tag.retType)) {
            tag.retType = "org.rythmengine.utils.RawData";
            tag.autoRet = true;
            String code = "StringBuilder __sb = this.getSelfOut();this.setSelfOut(new StringBuilder());";
            this.builders.add(new CodeToken(code, this.parser));
        }
        this.templateClass.setTagType(tagName, tag.retType);
        return tag;
    }

    public void endTag(InlineTag tag) {
        if (this.inlineTagBodies.empty()) {
            throw new ParseException(this.engine, this.templateClass, this.parser.currentLine(), "Unexpected tag definition close", new Object[0]);
        }
        if (tag.autoRet) {
            this.builders.add(new CodeToken("String __s = toString();this.setSelfOut(__sb);return s().raw(__s);", this.parser));
        }
        this.builders = this.inlineTagBodies.pop();
    }

    public String addIncludes(String includes, int lineNo, ICodeType codeType) {
        StringBuilder sb = new StringBuilder();
        for (String s : includes.split("[\\s,;:]+")) {
            sb.append(this.addInclude(s, lineNo, codeType));
        }
        return sb.toString();
    }

    public String addInclude(String include, int lineNo, ICodeType codeType) {
        RythmEngine.TemplateTestResult testResult = this.engine.testTemplate(include, this.templateClass, codeType);
        if (null == testResult) {
            throw new ParseException(this.engine, this.templateClass, lineNo, "include template not found: %s", include);
        }
        if (testResult.getError() != null) {
            String errMsg = testResult.getError().getMessage();
            throw new ParseException(this.engine, this.templateClass, lineNo, errMsg, include);
        }
        String tmplName = testResult.getFullName();
        TemplateBase includeTmpl = (TemplateBase)this.engine.getRegisteredTemplate(tmplName);
        if (includeTmpl instanceof JavaTagBase) {
            throw new ParseException(this.engine, this.templateClass, lineNo, "cannot include Java tag: %s", include);
        }
        if (includeTmpl == null) {
            throw new ParseException(this.engine, this.templateClass, lineNo, "include for template failed: %s ", include);
        }
        TemplateClass includeTc = includeTmpl.__getTemplateClass(false);
        includeTc.buildSourceCode(this.includingClassName());
        this.merge(includeTc.codeBuilder);
        this.templateClass.addIncludeTemplateClass(includeTc);
        return includeTc.codeBuilder.buildBody;
    }

    public String addInlineInclude(String inlineTemplate, int lineNo) {
        TemplateClass includeTc = new TemplateClass((ITemplateResource)new StringTemplateResource(inlineTemplate), this.engine, false);
        includeTc.buildSourceCode(this.includingClassName());
        this.merge(includeTc.codeBuilder);
        return includeTc.codeBuilder.buildBody;
    }

    public void setExtended(Class<? extends TemplateBase> c) {
        this.extended = c.getName();
    }

    public void setExtended(String extended, InvokeTemplateParser.ParameterDeclarationList args, int lineNo) {
        if (this.simpleTemplate()) {
            throw new ParseException(this.engine, this.templateClass, lineNo, "Simple template does not allow to extend layout template", new Object[0]);
        }
        if (null != this.extended) {
            throw new ParseException(this.engine, this.templateClass, lineNo, "Extended template already declared", new Object[0]);
        }
        RythmEngine.TemplateTestResult testResult = this.engine.testTemplate(extended, this.templateClass, null);
        String fullName = testResult.getFullName();
        if (null == fullName) {
            this.setExtended_deprecated(extended, args, lineNo);
            logger.warn("Template[%s]: Extended template declaration \"%s\" is deprecated, please switch to the new style \"%s\"", this.templateClass.getKey(), extended, this.extendedTemplateClass.getTagName());
        } else {
            TemplateBase tb = (TemplateBase)this.engine.getRegisteredTemplate(fullName);
            TemplateClass tc = tb.__getTemplateClass(false);
            this.extended = tc.name();
            this.extendedTemplateClass = tc;
            this.templateClass.extendedTemplateClass = tc;
            this.engine.addExtendRelationship(tc, this.templateClass);
            this.extendArgs = args;
            this.extendDeclareLineNo = lineNo;
        }
    }

    public void setExtended_deprecated(String extended, InvokeTemplateParser.ParameterDeclarationList args, int lineNo) {
        ITemplateResource resource;
        if (null != this.extended) {
            throw new IllegalStateException("Extended template already declared");
        }
        TemplateClass tc = null;
        String origin = extended;
        if (!extended.startsWith("/")) {
            ITemplateResource resource2;
            String me = this.templateClass.getKey().toString();
            int pos = me.lastIndexOf("/");
            if (-1 != pos) {
                extended = me.substring(0, pos) + "/" + extended;
            }
            if (null == (tc = this.engine.classes().getByTemplate(extended)) && (resource2 = this.engine.resourceManager().getResource(extended)).isValid()) {
                tc = new TemplateClass(resource2, this.engine);
            }
        }
        if (null == tc && !extended.startsWith("/")) {
            tc = this.engine.classes().getByClassName(extended);
        }
        if (null == tc && null == (tc = this.engine.classes().getByTemplate(origin)) && (resource = this.engine.resourceManager().getResource(origin)).isValid()) {
            tc = new TemplateClass(resource, this.engine);
        }
        if (null == tc) {
            throw new ParseException(this.engine, this.templateClass, lineNo, "Cannot find extended template by name \"%s\"", origin);
        }
        this.extended = tc.name();
        this.extendedTemplateClass = tc;
        this.templateClass.extendedTemplateClass = tc;
        this.engine.addExtendRelationship(tc, this.templateClass);
        this.extendArgs = args;
        this.extendDeclareLineNo = lineNo;
    }

    public void setLogTime() {
        this.logTime = true;
    }

    public String getRenderArgType(String name) {
        this.addInferencedRenderArgs();
        RenderArgDeclaration rad = this.renderArgs.get(name);
        if (null != rad) {
            return rad.type;
        }
        return null;
    }

    public void addRenderArgs(RenderArgDeclaration declaration) {
        this.renderArgs.put(declaration.name, declaration);
    }

    public void addRenderArgs(int lineNo, String type, String name, String defVal) {
        this.renderArgs.put(name, new RenderArgDeclaration(this.renderArgCounter++, lineNo, type, name, defVal));
    }

    public void addRenderArgs(int lineNo, String type, String name) {
        this.renderArgs.put(name, new RenderArgDeclaration(this.renderArgCounter++, lineNo, type, name));
    }

    public void addRenderArgsIfNotDeclared(int lineNo, String type, String name) {
        if (!this.renderArgs.containsKey(name)) {
            this.renderArgs.put(name, new RenderArgDeclaration(this.renderArgCounter++, lineNo, type, name));
        }
    }

    public void pushMacro(String macro) {
        if (this.macros.containsKey(macro)) {
            throw new ParseException(this.engine, this.templateClass, this.parser.currentLine(), "Macro already defined: %s", macro);
        }
        this.macroStack.push(macro);
        this.macros.put(macro, new ArrayList());
    }

    public void popMacro() {
        if (this.macroStack.empty()) {
            throw new ParseException(this.engine, this.templateClass, this.parser.currentLine(), "no macro found in stack", new Object[0]);
        }
        this.macroStack.pop();
    }

    public boolean hasMacro(String macro) {
        return this.macros.containsKey(macro);
    }

    public List<Token> getMacro(String macro) {
        List<Token> list = this.macros.get(macro);
        if (null == list) {
            throw new NullPointerException();
        }
        return list;
    }

    public boolean lastIsBlockToken() {
        List<Token> bs = this.builders();
        for (int i = bs.size() - 1; i >= 0; --i) {
            Token tb = bs.get(i);
            if (tb instanceof BlockCodeToken) {
                return true;
            }
            if (tb instanceof Token.StringToken) {
                String s = tb.toString();
                if (S.empty(s)) continue;
                return false;
            }
            return false;
        }
        return false;
    }

    public void addBuilder(Token builder) {
        if (builder == Token.EMPTY_TOKEN) {
            return;
        }
        Token token = builder;
        if (this.removeNextLF && token != Token.EMPTY_TOKEN2 && token.removeLeadingLineBreak()) {
            this.removeNextLF = false;
        }
        if (token.removeNextLineBreak) {
            this.removeNextLF = true;
        }
        this.builders().add(builder);
    }

    public void removeSpaceToLastLineBreak(IContext ctx) {
        String s;
        TextBuilder tb;
        int i;
        boolean shouldRemoveSpace = true;
        List<Token> bl = this.builders();
        for (i = bl.size() - 1; i >= 0; --i) {
            tb = bl.get(i);
            if (tb == Token.EMPTY_TOKEN || tb instanceof IDirective) continue;
            if (!tb.getClass().equals(Token.StringToken.class)) break;
            s = tb.toString();
            if (s.matches("[ \\t\\x0B\\f]+")) continue;
            if (s.matches("(\\n\\r|\\r\\n|[\\r\\n])")) break;
            shouldRemoveSpace = false;
            break;
        }
        if (shouldRemoveSpace) {
            for (i = bl.size() - 1; i >= 0; --i) {
                tb = bl.get(i);
                if (tb == Token.EMPTY_TOKEN || tb instanceof IDirective) continue;
                if (!tb.getClass().equals(Token.StringToken.class)) break;
                s = tb.toString();
                if (s.matches("[ \\t\\x0B\\f]+")) {
                    bl.remove(i);
                    continue;
                }
                if (!s.matches("(\\n\\r|\\r\\n|[\\r\\n])")) break;
                bl.remove(i);
                break;
            }
        }
    }

    public void removeSpaceTillLastLineBreak(IContext ctx) {
        String s;
        TextBuilder tb;
        int i;
        boolean shouldRemoveSpace = true;
        List<Token> bl = this.builders();
        for (i = bl.size() - 1; i >= 0; --i) {
            tb = bl.get(i);
            if (tb == Token.EMPTY_TOKEN || tb instanceof IDirective) continue;
            if (!tb.getClass().equals(Token.StringToken.class)) break;
            s = tb.toString();
            if (s.matches("[ \\t\\x0B\\f]+")) continue;
            if (s.matches("(\\n\\r|\\r\\n|[\\r\\n])")) break;
            shouldRemoveSpace = false;
            break;
        }
        if (shouldRemoveSpace) {
            for (i = bl.size() - 1; i >= 0; --i) {
                tb = bl.get(i);
                if (tb == Token.EMPTY_TOKEN || tb instanceof IDirective) continue;
                if (!tb.getClass().equals(Token.StringToken.class) || !(s = tb.toString()).matches("[ \\t\\x0B\\f]+")) break;
                bl.remove(i);
            }
        }
    }

    String template() {
        return this.tmpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TextBuilder build() {
        CodeBuilder codeBuilder;
        long start = 0L;
        if (logger.isTraceEnabled()) {
            logger.trace("Begin to build %s", this.templateClass.getKey());
            start = System.currentTimeMillis();
        }
        try {
            RythmEngine engine = this.engine();
            this.parser.parse();
            String key = this.templateClass.getKey();
            if (!key.endsWith("/__global.rythm")) {
                boolean enableGlobalInclude = true;
                if (null != this.requiredDialect && (this.requiredDialect instanceof BasicRythm || this.requiredDialect instanceof ToStringTemplateBase)) {
                    enableGlobalInclude = false;
                }
                if (enableGlobalInclude && this.conf.hasGlobalInclude()) {
                    String code = this.addInclude("__global.rythm", -1, null);
                    CodeToken ck = new CodeToken(code, this.parser);
                    this.addBuilder(ck);
                }
            }
            this.invokeDirectives();
            RythmEvents.ON_BUILD_JAVA_SOURCE.trigger(engine, this);
            this.pPackage();
            this.pImports();
            this.pClassOpen();
            this.pTagImpl();
            this.pInitCode();
            this.pSetup();
            if (!this.simpleTemplate()) {
                this.pExtendInitArgCode();
            }
            this.pRenderArgs();
            this.pStaticCodes();
            this.pInlineClasses();
            this.pInlineTags();
            this.pBuild();
            this.pFinalCode();
            RythmEvents.ON_CLOSING_JAVA_CLASS.trigger(engine, this);
            this.pClassClose();
            if (this.conf.debugJavaSourceEnabled()) {
                logger.info("java source code for %s: \n%s", this.templateClass, this);
            }
            codeBuilder = this;
        }
        catch (NotRythmTemplateException e) {
            CodeBuilder codeBuilder2;
            block12: {
                try {
                    this.isNotRythmTemplate = true;
                    codeBuilder2 = this;
                    this.parser.shutdown();
                    if (!logger.isTraceEnabled()) break block12;
                }
                catch (Throwable throwable) {
                    this.parser.shutdown();
                    if (logger.isTraceEnabled()) {
                        logger.trace("%sms to build %s", System.currentTimeMillis() - start, this.templateClass.getKey());
                    }
                    throw throwable;
                }
                logger.trace("%sms to build %s", System.currentTimeMillis() - start, this.templateClass.getKey());
            }
            return codeBuilder2;
        }
        this.parser.shutdown();
        if (logger.isTraceEnabled()) {
            logger.trace("%sms to build %s", System.currentTimeMillis() - start, this.templateClass.getKey());
        }
        return codeBuilder;
    }

    private void invokeDirectives() {
        for (TextBuilder textBuilder : this.builders) {
            if (!(textBuilder instanceof IDirective)) continue;
            ((IDirective)((Object)textBuilder)).call();
        }
    }

    protected void pPackage() {
        if (!S.isEmpty(this.pName)) {
            this.p("package ").p(this.pName).pn(";");
        }
    }

    private void pImport(String s, boolean sandbox) {
        String s0;
        if (S.isEmpty(s)) {
            return;
        }
        if (s.startsWith("import ")) {
            s = s.replaceFirst("import ", "");
        }
        if (sandbox && null != (s0 = Sandbox.hasAccessToRestrictedClasses(this.engine, s))) {
            return;
        }
        this.p("import ").p(s).p(';');
        Integer I = this.importLineMap.get(s);
        if (null != I) {
            this.p(" //line: ").pn(I);
        } else {
            this.p("\n");
        }
    }

    protected void pImports() {
        boolean sandbox = Rythm.insideSandbox();
        for (String s : this.imports) {
            this.pImport(s, sandbox);
        }
        this.pn("import java.util.*;");
        this.pn("import org.rythmengine.template.TemplateBase;");
        if (!sandbox) {
            this.pn("import java.io.*;");
        }
    }

    protected void pClassOpen() {
        this.np("public class ").p(this.cName).p(" extends ").p(this.extended()).p(" {").pn(this.extendedResourceMark());
    }

    protected void pClassClose() {
        this.np("}").pn();
    }

    private static String toNonGeneric(String type) {
        Regex regex = new Regex("(?@<>)", "");
        return regex.replaceAll(type);
    }

    private static boolean isGeneric(String type) {
        Regex regex = new Regex(".*(?@<>)");
        return regex.search(type);
    }

    private static boolean isArray(String type) {
        Regex regex = new Regex(".*(?@[])");
        return regex.search(type);
    }

    private void addInferencedRenderArgs() {
        if (this.renderArgs.isEmpty() && this.conf.typeInferenceEnabled()) {
            Map<String, String> tMap = ParamTypeInferencer.getTypeMap();
            ArrayList<String> ls = new ArrayList<String>(tMap.keySet());
            Collections.sort(ls);
            for (String name : ls) {
                String type = tMap.get(name);
                this.addRenderArgs(-1, type, name);
            }
        }
    }

    protected void pRenderArgs() {
        int userDefinedArgNumber;
        RenderArgDeclaration arg;
        this.pn();
        this.addInferencedRenderArgs();
        for (Map.Entry<String, RenderArgDeclaration> entry : this.renderArgs.entrySet()) {
            Iterator<Map.Entry<String, RenderArgDeclaration>> arg2 = entry.getValue();
            this.pt("protected ").p(((RenderArgDeclaration)((Object)arg2)).type).p(" ").p(entry.getKey());
            if (null != ((RenderArgDeclaration)((Object)arg2)).defVal) {
                this.p("=").p(((RenderArgDeclaration)((Object)arg2)).defVal).p(";");
            } else {
                this.p(";");
            }
            if (((RenderArgDeclaration)((Object)arg2)).lineNo > -1) {
                this.p(" //line: ").pn(((RenderArgDeclaration)((Object)arg2)).lineNo);
                continue;
            }
            this.pn();
        }
        ArrayList<RenderArgDeclaration> renderArgList = new ArrayList<RenderArgDeclaration>(this.renderArgs.values());
        this.pn();
        this.ptn("protected java.lang.String __renderArgName(int __pos) {");
        this.p2tn("int __p = 0;");
        boolean first = true;
        for (RenderArgDeclaration arg3 : renderArgList) {
            if (first) {
                first = false;
                this.p2t("");
            } else {
                this.p2t("else ");
            }
            this.p("if (__p++ == __pos) return \"").p(arg3.name).p("\";").pn();
        }
        this.p2tn("throw new ArrayIndexOutOfBoundsException();");
        this.ptn("}");
        this.pn();
        this.ptn("protected java.util.Map<java.lang.String, java.lang.Class> __renderArgTypeMap() {");
        this.p2tn("java.util.Map<java.lang.String, java.lang.Class> __m = new java.util.HashMap<String, Class>();");
        for (Map.Entry<String, RenderArgDeclaration> entry : this.renderArgs.entrySet()) {
            arg = entry.getValue();
            String argType = arg.type;
            boolean isGeneric = CodeBuilder.isGeneric(argType);
            if (isGeneric) {
                this.p2t("__m.put(\"").p(entry.getKey()).p("\", ").p(CodeBuilder.toNonGeneric(argType)).pn(".class);");
                Regex regex = new Regex(".*((?@<>))");
                regex.search(argType);
                String s = regex.stringMatched(1);
                s = S.strip(s, "<", ">");
                if (s.contains("<")) continue;
                String[] sa = s.split(",");
                for (int i = 0; i < sa.length; ++i) {
                    String type = sa[i];
                    if ("?".equals(type)) {
                        type = "Object";
                    }
                    this.p2t("__m.put(\"").p(entry.getKey()).p("__").p(i).p("\", ").p(type).pn(".class);");
                }
                continue;
            }
            Object type = argType;
            if ("?".equals(type)) {
                type = "Object";
            }
            this.p2t("__m.put(\"").p(entry.getKey()).p("\", ").p(type).pn(".class);");
        }
        this.p2tn("return __m;");
        this.ptn("}");
        this.pn();
        this.ptn("@SuppressWarnings(\"unchecked\")\n\tpublic TemplateBase __setRenderArgs(java.util.Map<java.lang.String, java.lang.Object> __args) {");
        this.p2tn("if (null == __args) throw new NullPointerException();\n\t\tif (__args.isEmpty()) return this;");
        this.p2tn("super.__setRenderArgs(__args);");
        first = true;
        for (Map.Entry<String, RenderArgDeclaration> entry : this.renderArgs.entrySet()) {
            arg = entry.getValue();
            this.p2t("if (__args.containsKey(\"").p(entry.getKey()).p("\")) this.").p(entry.getKey()).p(" = __get(__args,\"").p(entry.getKey()).p("\",").p(arg.objectType()).pn(".class);");
        }
        this.p2tn("return this;");
        this.ptn("}");
        ISourceCodeEnhancer ce = (ISourceCodeEnhancer)this.engine.conf().get(RythmConfigurationKey.CODEGEN_SOURCE_CODE_ENHANCER);
        int n = this.basicTemplate() ? this.renderArgs.size() : (userDefinedArgNumber = this.renderArgs.size() - (null == ce ? 0 : ce.getRenderArgDescriptions().size()));
        if (0 < userDefinedArgNumber) {
            this.pn();
            this.ptn("@SuppressWarnings(\"unchecked\") public TemplateBase __setRenderArgs(java.lang.Object... __args) {");
            this.p2tn("int __p = 0, __l = __args.length;");
            int i = userDefinedArgNumber;
            for (RenderArgDeclaration arg4 : renderArgList) {
                this.p2t("if (__p < __l) { \n\t\t\tObject v = __args[__p++]; \n\t\t\t").p(arg4.name).p(" = __safeCast(v, ").p(arg4.objectType()).p(".class); \n\t\t\t__renderArgs.put(\"").p(arg4.name).p("\",").p(arg4.name).p(");\n\t\t}\n");
                if (--i != 0) continue;
                break;
            }
            this.p2tn("return this;");
            this.ptn("}");
            this.pn();
            this.ptn("protected java.lang.Class[] __renderArgTypeArray() {");
            this.p2t("return new java.lang.Class[]{");
            i = userDefinedArgNumber;
            for (RenderArgDeclaration arg5 : renderArgList) {
                this.p(CodeBuilder.toNonGeneric(arg5.type)).p(".class").p(", ");
                if (--i != 0) continue;
                break;
            }
            this.pn("};");
            this.ptn("}");
        }
        this.pn();
        this.ptn("@SuppressWarnings(\"unchecked\") @Override public TemplateBase __setRenderArg(java.lang.String __name, java.lang.Object __arg) {");
        first = true;
        for (RenderArgDeclaration arg6 : renderArgList) {
            if (first) {
                first = false;
                this.p2t("");
            } else {
                this.p2t("else ");
            }
            String argName = arg6.name;
            this.p("if (\"").p(argName).p("\".equals(__name)) this.").p(argName).p(" = __safeCast(__arg, ").p(arg6.objectType()).pn(".class);");
        }
        this.p2t("super.__setRenderArg(__name, __arg);\n\t\treturn this;\n\t}\n");
        this.pn();
        this.ptn("@SuppressWarnings(\"unchecked\") public TemplateBase __setRenderArg(int __pos, java.lang.Object __arg) {");
        this.p2tn("int __p = 0;");
        first = true;
        for (RenderArgDeclaration arg6 : renderArgList) {
            if (first) {
                first = false;
                this.p2t("");
            } else {
                this.p2t("else ");
            }
            this.p2t("if (__p++ == __pos) { \n\t\t\tObject v = __arg; \n\t\t\t").p(arg6.name).p(" = __safeCast(v, ").p(arg6.objectType()).p(".class); \n\t\t\t__renderArgs.put(\"").p(arg6.name).p("\", ").p(arg6.name).p(");\n\t\t}\n");
        }
        this.p2tn("if(0 == __pos) __setRenderArg(\"arg\", __arg);");
        this.p2tn("return this;");
        this.ptn("}");
    }

    protected void pExtendInitArgCode() {
        if (null == this.extendArgs || this.extendArgs.pl.size() < 1) {
            return;
        }
        this.pn();
        this.ptn("protected void __loadExtendingArgs() {");
        for (int i = 0; i < this.extendArgs.pl.size(); ++i) {
            InvokeTemplateParser.ParameterDeclaration pd = this.extendArgs.pl.get(i);
            if (S.isEmpty(pd.nameDef)) {
                this.p2t("__parent.__setRenderArg(").p(i).p(", ").p(pd.valDef).p(");");
            } else {
                this.p2t("__parent.__setRenderArg(\"").p(pd.nameDef).p("\", ").p(pd.valDef).p(");");
            }
            if (this.extendDeclareLineNo != -1) {
                this.p(" //line: ").pn(this.extendDeclareLineNo);
                continue;
            }
            this.pn();
        }
        this.ptn("}");
    }

    protected void pSetup() {
        if (!this.logTime && this.renderArgs.isEmpty()) {
            return;
        }
        this.pn();
        this.ptn("protected void __setup() {");
        if (this.logTime) {
            this.p2tn("__logTime = true;");
        }
        for (Map.Entry<String, RenderArgDeclaration> entry : this.renderArgs.entrySet()) {
            RenderArgDeclaration arg = entry.getValue();
            this.p2t("if (__isDefVal(").p(entry.getKey()).p(")) {");
            this.p(entry.getKey()).p(" = __get(\"").p(entry.getKey()).p("\",").p(arg.objectType()).p(".class) ;}\n");
        }
        this.ptn("}");
    }

    protected void pInitCode() {
        if (S.isEmpty(this.initCode)) {
            return;
        }
        this.pn();
        this.pt("public void __init() {").p(this.initCode).p(";").pn("\n\t}");
    }

    protected void pFinalCode() {
        if (S.isEmpty(this.finalCode)) {
            return;
        }
        this.pn();
        this.pt("public void __finally() {").p(this.finalCode).p(";").pn("\n\t}");
    }

    protected void pTagImpl() {
        this.pn();
        this.pt("public java.lang.String __getName() {\n\t\treturn \"").p(this.tagName).p("\";\n\t}\n");
    }

    private Token.StringToken addConst(Token.StringToken st) {
        String id;
        if (!this.outputMode.writeOutput()) {
            return st;
        }
        if (this.consts.containsKey(st)) {
            st.constId = this.consts.get(st);
            return st;
        }
        st.constId = id = this.newVarName();
        this.consts.put(st, id);
        return st;
    }

    private List<Token> mergeStringTokens(List<Token> builders) {
        ArrayList<Token> merged = new ArrayList<Token>();
        Token.StringToken curTk = new Token.StringToken("", this.parser);
        for (int i = 0; i < builders.size(); ++i) {
            Token tb = builders.get(i);
            if (tb == Token.EMPTY_TOKEN) continue;
            if (tb instanceof Token.StringToken) {
                Token.StringToken tk = (Token.StringToken)tb;
                curTk = curTk.mergeWith(tk);
                continue;
            }
            if (tb instanceof IDirective) continue;
            if (tb instanceof BlockToken.LiteralBlock) {
                BlockToken.LiteralBlock bk = (BlockToken.LiteralBlock)tb;
                curTk = curTk.mergeWith(bk);
                continue;
            }
            if (tb instanceof CompactStateToken) {
                if (null != curTk && curTk.s().length() > 0) {
                    curTk = this.addConst(curTk);
                    curTk.compact();
                    merged.add(curTk);
                }
                curTk = new Token.StringToken("", this.parser);
                merged.add(tb);
                tb.build();
                continue;
            }
            if (null != curTk && curTk.s().length() > 0) {
                curTk = this.addConst(curTk);
                curTk.compact();
                merged.add(curTk);
            }
            curTk = new Token.StringToken("", this.parser);
            merged.add(tb);
        }
        if (null != curTk && curTk.s().length() > 0) {
            curTk = this.addConst(curTk);
            curTk.compact();
            merged.add(curTk);
        }
        return merged;
    }

    protected void pInlineTags() {
        this.pn();
        for (InlineTag tag : this.inlineTags) {
            this.p("\npublic ").p(tag.retType).p(" ").p(tag.tagName).p(tag.signature);
            this.p("{\norg.rythmengine.template.TemplateBase oldParent = this.__parent;\ntry{\nthis.__parent = this;\n");
            boolean isVoid = tag.autoRet;
            if (!isVoid) {
                this.p(tag.body);
            } else {
                List<Token> merged = this.mergeStringTokens(tag.builders);
                for (Token b : merged) {
                    b.build(this.parser);
                }
            }
            this.p("\n}catch(RuntimeException __e){\n throw __e;\n}catch(Exception __e){\nthrow new java.lang.RuntimeException(__e);\n} finally {this.__parent = oldParent;}\n}");
        }
    }

    protected void pStaticCodes() {
        this.pn();
        for (String codeSnippet : this.staticCodes) {
            this.p("\n").p(codeSnippet).p(";\n");
        }
    }

    protected void pInlineClasses() {
        this.pn();
        for (InlineClass clz : this.inlineClasses) {
            this.p("\nprivate class ").p(clz.className).p(" {\n").p(clz.body).p("\n}\n");
        }
    }

    protected void pBuild() {
        this.pn();
        this.pn();
        this.ptn("public org.rythmengine.utils.TextBuilder build(){");
        this.p2t("buffer().ensureCapacity(").p(this.tmpl.length()).p(");").pn();
        StringBuilder sb = new StringBuilder();
        StringBuilder old = this.buffer();
        this.__setBuffer(sb);
        List<Token> merged = this.mergeStringTokens(this.builders);
        for (Token b : merged) {
            b.build();
        }
        this.buildBody = sb.toString();
        this.__setBuffer(old);
        this.p(this.buildBody);
        this.p("\n\t\treturn this;\n\t}\n");
        for (Token.StringToken st : this.consts.keySet()) {
            this.pConst(st);
        }
    }

    private void pConst(Token.StringToken st) {
        String constId = st.constId;
        String s = st.s();
        String s0 = st.compactMode() ? s.replaceAll("(\\r?\\n)+", "\\\\n").replaceAll("\"", "\\\\\"") : s.replaceAll("(\\r?\\n)", "\\\\n").replaceAll("\"", "\\\\\"");
        this.np("private static final org.rythmengine.utils.TextBuilder.StrBuf ").p(constId).p(" = new org.rythmengine.utils.TextBuilder.StrBuf(\"").p(s0);
        TextBuilder.StrBuf sw = new TextBuilder.StrBuf(s);
        if (this.outputMode == RythmEngine.OutputMode.os) {
            this.p("\", new byte[]{");
            byte[] ba = sw.toBinary();
            for (int i = 0; i < ba.length; ++i) {
                this.p(String.valueOf(ba[i]));
                if (i >= ba.length - 1) continue;
                this.p(",");
            }
            this.p("});");
        } else if (this.outputMode == RythmEngine.OutputMode.writer) {
            this.p("\", null);");
        } else {
            throw new AssertionError((Object)"should not go here");
        }
        this.p("// line:").pn(st.getLineNo());
    }

    public String newVarName() {
        int i = 0;
        while (true) {
            String name;
            if (!this.varNames.contains(name = "__v" + i)) {
                this.varNames.add(name);
                return name;
            }
            i += new Random().nextInt(100000);
        }
    }

    public static String preventInfiniteLoop(String code) {
        code = R_FOR_0.replaceAll(code);
        code = R_FOR_1.replaceAll(code);
        code = R_WHILE_0.replaceAll(code);
        code = R_WHILE_1.replaceAll(code);
        code = R_DO_0.replaceAll(code);
        code = R_DO_1.replaceAll(code);
        return code;
    }

    public static class InlineTag {
        String tagName;
        String signature;
        String retType = "void";
        String body;
        boolean autoRet = false;
        List<Token> builders = new ArrayList<Token>();

        InlineTag(String name, String ret, String sig, String body) {
            this.tagName = name;
            this.signature = sig;
            this.retType = null == ret ? "void" : ret;
            this.body = body;
        }

        public boolean noArgs() {
            return S.empty(this.signature) || this.signature.matches("\\(\\s*\\)");
        }

        InlineTag clone(CodeBuilder newCaller) {
            InlineTag tag = new InlineTag(this.tagName, this.retType, this.signature, this.body);
            tag.builders.clear();
            for (Token tb : this.builders) {
                Token newTb = tb.clone(newCaller);
                tag.builders.add(newTb);
            }
            tag.autoRet = this.autoRet;
            return tag;
        }

        public int hashCode() {
            return (37 + this.tagName.hashCode()) * 31 + this.signature.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof InlineTag) {
                InlineTag that = (InlineTag)obj;
                return S.isEqual(that.signature, this.signature) && S.isEqual(that.tagName, this.tagName);
            }
            return false;
        }
    }

    public static class InlineClass {
        String className;
        String body;

        InlineClass(String className, String body) {
            this.className = className;
            this.body = body;
        }

        InlineClass clone(CodeBuilder newCaller) {
            InlineClass clz = new InlineClass(this.className, this.body);
            return clz;
        }

        public int hashCode() {
            return 37 + this.className.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof InlineClass) {
                return ((InlineClass)obj).className.equals(this.className);
            }
            return false;
        }
    }

    public static class RenderArgDeclaration
    implements Comparable<RenderArgDeclaration> {
        public int no;
        public String name;
        public String type;
        public String defVal;
        public int lineNo;
        private static final Map<String, String> byPrimitive;
        private static char DEF_CHAR;
        private static final Map<String, String> nullVals;

        public String objectType() {
            String s = byPrimitive.get(this.type);
            return null != s ? s : CodeBuilder.toNonGeneric(this.type);
        }

        public String nullVal() {
            String s = nullVals.get(this.type);
            return null == s ? "null" : s;
        }

        public RenderArgDeclaration(int lineNo, String type, String name) {
            this(-1, lineNo, type, name);
        }

        public RenderArgDeclaration(int lineNo, String type, String name, String defVal) {
            this(-1, lineNo, type, name, defVal);
        }

        public RenderArgDeclaration(int no, int lineNo, String type, String name) {
            this(no, lineNo, type, name, null);
        }

        public RenderArgDeclaration(int no, int lineNo, String type, String name, String defVal) {
            this.no = no;
            this.lineNo = lineNo;
            this.name = name;
            this.type = ParamTypeInferencer.typeTransform(type);
            defVal = RenderArgDeclaration.defValTransform(type, defVal);
            this.defVal = null == defVal ? RenderArgDeclaration.defVal(type) : defVal;
        }

        private static String defValTransform(String type, String defVal) {
            if (S.isEmpty(defVal)) {
                return null;
            }
            if ("String".equalsIgnoreCase(type) && "null".equalsIgnoreCase(defVal)) {
                return "\"\"";
            }
            if ("boolean".equalsIgnoreCase(type)) {
                defVal = defVal.toLowerCase();
            }
            if ("long".equalsIgnoreCase(type) && defVal.matches("[0-9]+")) {
                return defVal + "L";
            }
            if ("float".equalsIgnoreCase(type) && defVal.matches("[0-9]+")) {
                return defVal + "f";
            }
            if ("double".equalsIgnoreCase(type) && defVal.matches("[0-9]+")) {
                return defVal + "d";
            }
            if ("short".equalsIgnoreCase(type) && defVal.matches("[0-9]+]")) {
                return "((short)" + defVal + ")";
            }
            if ("byte".equalsIgnoreCase(type) && defVal.matches("[0-9]+]")) {
                return "((byte)" + defVal + ")";
            }
            return defVal;
        }

        private static String defVal(String type) {
            if (type.equalsIgnoreCase("String")) {
                return "\"\"";
            }
            if (type.equalsIgnoreCase("boolean")) {
                return "false";
            }
            if (type.equalsIgnoreCase("int")) {
                return "0";
            }
            if (type.equalsIgnoreCase("long")) {
                return "0L";
            }
            if (type.equals("char") || type.equals("Character")) {
                return "(char)0";
            }
            if (type.equalsIgnoreCase("byte")) {
                return "(byte)0";
            }
            if (type.equalsIgnoreCase("short")) {
                return "(short)0";
            }
            if (type.equalsIgnoreCase("float")) {
                return "0f";
            }
            if (type.equalsIgnoreCase("double")) {
                return "0d";
            }
            return "null";
        }

        public int hashCode() {
            return HashCode.hc(this.no, this.name, this.type, this.defVal, this.lineNo);
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        public int compareTo(RenderArgDeclaration o) {
            return this.no - o.no;
        }

        static {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("int", "Integer");
            m.put("long", "Long");
            m.put("short", "Short");
            m.put("byte", "Byte");
            m.put("float", "Float");
            m.put("double", "Double");
            m.put("char", "Character");
            m.put("boolean", "Boolean");
            byPrimitive = m;
            DEF_CHAR = (char)32;
            m = new HashMap();
            m.put("int", "0");
            m.put("long", "0L");
            m.put("short", "0");
            m.put("byte", "0");
            m.put("float", "0f");
            m.put("double", "0d");
            m.put("char", String.valueOf(DEF_CHAR));
            m.put("boolean", "false");
            nullVals = m;
        }
    }
}

