/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.rythmengine.RythmEngine;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.extension.IFormatter;
import org.rythmengine.internal.IExpressionProcessor;
import org.rythmengine.internal.IJavaExtension;
import org.rythmengine.internal.IParserFactory;
import org.rythmengine.utils.S;

public class ExtensionManager {
    private final Set<IJavaExtension> _extensions = new HashSet<IJavaExtension>();
    private final List<IFormatter> _fmts = new ArrayList<IFormatter>();
    private final RythmEngine engine;
    private List<IExpressionProcessor> expressionProcessors = new ArrayList<IExpressionProcessor>();
    private List<ICodeType> codeTypeList = new ArrayList<ICodeType>();

    public ExtensionManager(RythmEngine engine) {
        if (null == engine) {
            throw new NullPointerException();
        }
        this.engine = engine;
    }

    public void registerJavaExtension(IJavaExtension javaExtension) {
        this._extensions.add(javaExtension);
    }

    Iterable<IJavaExtension> javaExtensions() {
        return this._extensions;
    }

    public boolean isJavaExtension(String s) {
        for (IJavaExtension ext : this._extensions) {
            if (!S.isEqual(s, ext.methodName())) continue;
            return true;
        }
        return false;
    }

    public ExtensionManager registerUserDefinedParsers(IParserFactory ... parsers) {
        return this.registerUserDefinedParsers((String)null, parsers);
    }

    public ExtensionManager registerUserDefinedParsers(String dialect, IParserFactory ... parsers) {
        this.engine.dialectManager().registerExternalParsers(dialect, parsers);
        return this;
    }

    public ExtensionManager registerExpressionProcessor(IExpressionProcessor p) {
        if (!this.expressionProcessors.contains(p)) {
            this.expressionProcessors.add(p);
        }
        return this;
    }

    public Iterable<IExpressionProcessor> expressionProcessors() {
        return this.expressionProcessors;
    }

    public ExtensionManager registerCodeType(ICodeType type) {
        this.codeTypeList.add(type);
        return this;
    }

    public Iterable<ICodeType> templateLangs() {
        return this.codeTypeList;
    }

    public boolean hasTemplateLangs() {
        return !this.codeTypeList.isEmpty();
    }

    public ExtensionManager registerFormatter(IFormatter fmt) {
        this._fmts.add(fmt);
        return this;
    }

    public Iterable<IFormatter> formatters() {
        return new Iterable<IFormatter>(){

            @Override
            public Iterator<IFormatter> iterator() {
                return ExtensionManager.this._fmts.iterator();
            }
        };
    }
}

