/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.compiler;

import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rythmengine.Rythm;
import org.rythmengine.RythmEngine;
import org.rythmengine.exception.CompileException;
import org.rythmengine.exception.RythmException;
import org.rythmengine.extension.IByteCodeEnhancer;
import org.rythmengine.extension.ICodeType;
import org.rythmengine.extension.ITemplateResourceLoader;
import org.rythmengine.internal.CodeBuilder;
import org.rythmengine.internal.IDialect;
import org.rythmengine.internal.RythmEvents;
import org.rythmengine.internal.compiler.ClassReloadException;
import org.rythmengine.internal.compiler.ParamTypeInferencer;
import org.rythmengine.internal.compiler.TemplateClassLoader;
import org.rythmengine.internal.compiler.TemplateClassManager;
import org.rythmengine.logger.ILogger;
import org.rythmengine.logger.Logger;
import org.rythmengine.resource.ITemplateResource;
import org.rythmengine.resource.StringTemplateResource;
import org.rythmengine.template.ITemplate;
import org.rythmengine.template.TagBase;
import org.rythmengine.template.TemplateBase;
import org.rythmengine.utils.S;

public class TemplateClass {
    private static final ILogger logger = Logger.get(TemplateClass.class);
    public static final String CN_SUFFIX = "__R_T_C__";
    private static final String NO_INCLUDE_CLASS = "NO_INCLUDE_CLASS";
    private static final ITemplate NULL_TEMPLATE = new TagBase(){

        @Override
        public ITemplate __cloneMe(RythmEngine engine, ITemplate caller) {
            return null;
        }
    };
    private TemplateClass root;
    private boolean inner = false;
    private RythmEngine engine = null;
    private boolean enhancing = false;
    private transient List<TemplateClass> embeddedClasses = new ArrayList<TemplateClass>();
    private String name;
    public TemplateClass extendedTemplateClass;
    private Set<TemplateClass> includedTemplateClasses = new HashSet<TemplateClass>();
    private String includeTemplateClassNames = null;
    private Map<String, String> includeTagTypes = new HashMap<String, String>();
    private String tagName;
    public String javaSource;
    public byte[] javaByteCode;
    public byte[] enhancedByteCode;
    public Set<String> importPaths;
    public Class<ITemplate> javaClass;
    public Package javaPackage;
    public ICodeType codeType;
    private boolean compiled;
    public int sigChecksum;
    private boolean isValid = true;
    public CodeBuilder codeBuilder;
    private TemplateBase templateInstance;
    private String resourceLoaderClass;
    public ITemplateResource templateResource;
    private transient IDialect dialect;
    private String magic = S.random(4);

    public TemplateClass root() {
        return this.root;
    }

    private TemplateClass() {
    }

    public boolean isInner() {
        return this.inner;
    }

    private RythmEngine engine() {
        return null == this.engine ? Rythm.engine() : this.engine;
    }

    public String name0() {
        return this.name();
    }

    public String name() {
        return this.name;
    }

    public void addIncludeTemplateClass(TemplateClass tc) {
        this.includedTemplateClasses.add(tc);
        this.includeTagTypes.putAll(tc.includeTagTypes);
    }

    public String refreshIncludeTemplateClassNames() {
        if (this.includedTemplateClasses.isEmpty()) {
            this.includeTemplateClassNames = NO_INCLUDE_CLASS;
            return NO_INCLUDE_CLASS;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (TemplateClass tc : this.includedTemplateClasses) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append(tc.tagName);
        }
        this.includeTemplateClassNames = sb.toString();
        return sb.toString();
    }

    public void setTagType(String tagName, String type) {
        this.includeTagTypes.put(tagName, type);
    }

    public boolean returnObject(String tagName) {
        String retType = this.includeTagTypes.get(tagName);
        if (null != retType) {
            return !"void".equals(retType);
        }
        if (null != this.extendedTemplateClass) {
            return this.extendedTemplateClass.returnObject(tagName);
        }
        return true;
    }

    public String serializeIncludeTagTypes() {
        if (this.includeTagTypes.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean empty = true;
        for (Map.Entry<String, String> entry : this.includeTagTypes.entrySet()) {
            if (!empty) {
                sb.append(";");
            } else {
                empty = false;
            }
            sb.append(entry.getKey()).append(":").append(entry.getValue());
        }
        return sb.toString();
    }

    public void deserializeIncludeTagTypes(String s) {
        String[] sa;
        this.includeTagTypes = new HashMap<String, String>();
        if (S.isEmpty(s)) {
            return;
        }
        for (String s0 : sa = s.split(";")) {
            String[] sa0 = s0.split(":");
            if (sa0.length != 2) {
                throw new IllegalArgumentException("Unknown include tag types string: " + s);
            }
            this.includeTagTypes.put(sa0[0], sa0[1]);
        }
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getTemplateSource() {
        return this.getTemplateSource(false);
    }

    public String getTemplateSource(boolean includeRoot) {
        if (null != this.templateResource) {
            return this.templateResource.asTemplateContent();
        }
        if (!includeRoot) {
            return "";
        }
        TemplateClass parent = this.root;
        while (null != parent && parent.isInner()) {
            parent = parent.root;
        }
        return null == parent ? "" : parent.getTemplateSource();
    }

    public boolean isStringTemplate() {
        return this.templateResource instanceof StringTemplateResource;
    }

    public String getResourceLoaderClass() {
        return this.resourceLoaderClass;
    }

    private TemplateClass(RythmEngine engine) {
        this.engine = null == engine ? null : (engine.isSingleton() ? null : engine);
    }

    public TemplateClass(File file, RythmEngine engine) {
        this(engine.resourceManager().get(file), engine);
    }

    public TemplateClass(String template, RythmEngine engine) {
        this(engine.resourceManager().get(template), engine);
    }

    public TemplateClass(String template, RythmEngine engine, IDialect dialect) {
        this(engine.resourceManager().get(template), engine, dialect);
    }

    public TemplateClass(ITemplateResource resource, RythmEngine engine) {
        this(resource, engine, false);
    }

    public TemplateClass(ITemplateResource resource, RythmEngine engine, IDialect dialect) {
        this(resource, engine, false, dialect);
    }

    public TemplateClass(ITemplateResource resource, RythmEngine engine, boolean noRefresh) {
        this(engine);
        if (null == resource) {
            throw new NullPointerException();
        }
        this.templateResource = resource;
        if (!noRefresh) {
            this.refresh(false);
        }
    }

    public TemplateClass(ITemplateResource resource, RythmEngine engine, boolean noRefresh, IDialect dialect) {
        this(engine);
        if (null == resource) {
            throw new NullPointerException();
        }
        this.templateResource = resource;
        this.dialect = dialect;
        if (!noRefresh) {
            this.refresh(false);
        }
    }

    public String getKey() {
        return null == this.templateResource ? this.name : this.templateResource.getKey().toString();
    }

    private Class<?> loadJavaClass() throws Exception {
        RythmEngine engine;
        TemplateClassLoader cl;
        if (null == this.javaSource && null == this.javaSource) {
            this.refresh(false);
        }
        if (null == (cl = (engine = this.engine()).classLoader())) {
            throw new NullPointerException();
        }
        Class<?> c = cl.loadClass(this.name, true);
        if (null == this.javaClass) {
            this.javaClass = c;
        }
        return c;
    }

    private ITemplate templateInstance_(RythmEngine engine) {
        if (!this.isValid) {
            return NULL_TEMPLATE;
        }
        if (null == this.templateInstance) {
            try {
                Class<?> clz = this.loadJavaClass();
                TemplateBase tmpl = (TemplateBase)clz.newInstance();
                tmpl.__setTemplateClass(this);
                engine.registerTemplate(tmpl);
                this.templateInstance = tmpl;
            }
            catch (RythmException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Error load template instance for " + this.getKey(), e);
            }
        }
        if (!engine.isProdMode()) {
            engine.registerTemplate(this.templateInstance);
            Class<?> c = this.templateInstance.getClass();
            Class<?> pc = c.getSuperclass();
            if (null != pc && !Modifier.isAbstract(pc.getModifiers())) {
                engine.classes().getByClassName(pc.getName());
            }
        }
        return this.templateInstance;
    }

    public ITemplate asTemplate(ICodeType type, Locale locale, RythmEngine engine) {
        TemplateBase tmpl;
        if (null == this.name || engine.isDevMode()) {
            this.refresh(false);
        }
        if ((tmpl = (TemplateBase)this.templateInstance_(engine).__cloneMe(this.engine(), null)) != null) {
            tmpl.__prepareRender(type, locale, engine);
        }
        return tmpl;
    }

    public ITemplate asTemplate(RythmEngine engine) {
        return this.asTemplate(null, null, engine);
    }

    public ITemplate asTemplate(ITemplate caller, RythmEngine engine) {
        TemplateBase tb = (TemplateBase)caller;
        TemplateBase tmpl = (TemplateBase)this.templateInstance_(engine).__cloneMe(engine, caller);
        tmpl.__prepareRender(tb.__curCodeType(), tb.__curLocale(), engine);
        return tmpl;
    }

    public boolean refresh() {
        return this.refresh(false);
    }

    public void buildSourceCode(String includingClassName) {
        long start = System.currentTimeMillis();
        this.importPaths = new HashSet<String>();
        if (null != this.codeBuilder) {
            this.codeBuilder.clear();
        }
        this.codeBuilder = new CodeBuilder(this.templateResource.asTemplateContent(), this.name(), this.tagName, this, this.engine, this.dialect);
        this.codeBuilder.includingCName = includingClassName;
        this.codeBuilder.build();
        this.extendedTemplateClass = this.codeBuilder.getExtendedTemplateClass();
        this.javaSource = this.codeBuilder.toString();
        if (logger.isTraceEnabled()) {
            logger.trace("%s ms to generate java source for template: %s", System.currentTimeMillis() - start, this.getKey());
        }
    }

    public void buildSourceCode() {
        long start = System.currentTimeMillis();
        this.importPaths = new HashSet<String>();
        if (null != this.codeBuilder) {
            this.codeBuilder.clear();
        }
        this.codeBuilder = null == this.dialect ? new CodeBuilder(this.templateResource.asTemplateContent(), this.name, this.tagName, this, this.engine, null) : this.dialect.createCodeBuilder(this.templateResource.asTemplateContent(), this.name, this.tagName, this, this.engine);
        this.codeBuilder.build();
        this.extendedTemplateClass = this.codeBuilder.getExtendedTemplateClass();
        this.javaSource = this.codeBuilder.toString();
        this.engine();
        if (RythmEngine.insideSandbox()) {
            this.javaSource = CodeBuilder.preventInfiniteLoop(this.javaSource);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("%s ms to generate java source for template: %s", System.currentTimeMillis() - start, this.getKey());
        }
    }

    public void addImportPath(String path) {
        if (path == null || path.isEmpty()) {
            return;
        }
        this.importPaths.add(path);
    }

    public void replaceImportPath(Set<String> paths) {
        this.importPaths = paths;
    }

    public synchronized boolean refresh(boolean forceRefresh) {
        boolean refresh;
        if (this.inner) {
            return false;
        }
        ITemplateResource templateResource = this.templateResource;
        RythmEngine engine = this.engine();
        if (!templateResource.isValid()) {
            this.isValid = false;
            engine.classes().remove(this);
            return false;
        }
        ICodeType type = engine.renderSettings.codeType();
        if (null == type) {
            type = templateResource.codeType(this.engine());
        }
        if (null == type || ICodeType.DefImpl.RAW == type) {
            type = engine.conf().defaultCodeType();
        }
        this.codeType = type;
        if (null == this.name) {
            ITemplateResourceLoader loader;
            this.root = this;
            this.name = TemplateClass.canonicalClassName(templateResource.getSuggestedClassName()) + CN_SUFFIX;
            if (engine.conf().typeInferenceEnabled()) {
                this.name = this.name + ParamTypeInferencer.uuid();
            }
            if (null != (loader = this.engine().resourceManager().whichLoader(templateResource))) {
                Object k = templateResource.getKey();
                this.tagName = TemplateClass.toCanonicalName(k.toString(), loader.getResourceLoaderRoot());
            }
            engine.registerTemplateClass(this);
        }
        if (null == this.javaSource) {
            Pattern p;
            Matcher m;
            engine.classCache().loadTemplateClass(this);
            if (null != this.javaSource && (m = (p = Pattern.compile(".*extends\\s+([a-zA-Z0-9_]+)\\s*\\{\\s*\\/\\/<extended_resource_key\\>(.*)\\<\\/extended_resource_key\\>.*", 32)).matcher(this.javaSource)).matches()) {
                String extended = m.group(1);
                TemplateClassManager tcm = this.engine().classes();
                this.extendedTemplateClass = tcm.getByClassName(extended);
                if (null == this.extendedTemplateClass) {
                    String extendedResourceKey = m.group(2);
                    this.extendedTemplateClass = tcm.getByTemplate(extendedResourceKey);
                    if (null == this.extendedTemplateClass) {
                        this.extendedTemplateClass = new TemplateClass(extendedResourceKey, this.engine());
                        this.extendedTemplateClass.refresh();
                    }
                }
                engine.addExtendRelationship(this.extendedTemplateClass, this);
            }
        }
        boolean extendedTemplateChanged = false;
        if (this.extendedTemplateClass != null) {
            extendedTemplateChanged = this.extendedTemplateClass.refresh(forceRefresh);
        }
        boolean includedTemplateChanged = false;
        boolean includedTemplateClassesIsEmpty = this.includedTemplateClasses.isEmpty();
        if (includedTemplateClassesIsEmpty && !S.isEmpty(this.includeTemplateClassNames) && !NO_INCLUDE_CLASS.equals(this.includeTemplateClassNames)) {
            for (String string : this.includeTemplateClassNames.split(",")) {
                if (S.isEmpty(string)) continue;
                String string2 = string.trim();
                RythmEngine.TemplateTestResult testResult = this.engine().testTemplate(string2, this, null);
                if (null == testResult) {
                    logger.warn("Unable to load included template class from name: %s", string2);
                    continue;
                }
                TemplateClass tc = this.engine().getRegisteredTemplateClass(testResult.getFullName());
                if (null == tc) {
                    logger.warn("Unable to load included template class from name: %s", string2);
                    continue;
                }
                this.includedTemplateClasses.add(tc);
            }
        }
        for (TemplateClass tc : this.includedTemplateClasses) {
            if (!tc.refresh(forceRefresh)) continue;
            includedTemplateChanged = true;
            break;
        }
        if (extendedTemplateChanged && !forceRefresh) {
            this.reset();
            this.compiled = false;
            this.engine().restart(new ClassReloadException("extended class changed"));
            this.refresh(forceRefresh);
            return true;
        }
        boolean resourceChanged = templateResource.refresh();
        boolean bl = refresh = resourceChanged || forceRefresh || null == this.javaSource || includedTemplateChanged || extendedTemplateChanged;
        if (!refresh) {
            return false;
        }
        this.reset();
        this.buildSourceCode();
        this.engine().classCache().cacheTemplateClassSource(this);
        if (!this.codeBuilder.isRythmTemplate()) {
            this.isValid = false;
            this.engine().classes().remove(this);
            return false;
        }
        this.isValid = true;
        this.compiled = false;
        return true;
    }

    public boolean isDefinable() {
        return this.compiled && this.javaClass != null;
    }

    public void reset() {
        this.javaByteCode = null;
        this.enhancedByteCode = null;
        this.javaSource = null;
        this.templateInstance = null;
        for (TemplateClass tc : this.embeddedClasses) {
            tc.reset();
            this.engine().classes().remove(tc);
        }
        this.embeddedClasses.clear();
        this.engine().classCache().deleteCache(this);
        this.engine().invalidate(this);
        this.javaClass = null;
    }

    private String magic() {
        return this.name + this.magic;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized byte[] compile() {
        byte[] byArray;
        long start;
        block16: {
            start = System.currentTimeMillis();
            if (null == this.javaByteCode) break block16;
            byte[] byArray2 = this.javaByteCode;
            if (logger.isTraceEnabled()) {
                logger.trace("%sms to compile template class %s", System.currentTimeMillis() - start, this.getKey());
            }
            return byArray2;
        }
        try {
            if (null == this.javaSource) {
                throw new IllegalStateException("Cannot find java source when compiling " + this.getKey());
            }
            this.engine().classes().compiler.compile(new String[]{this.name});
            if (logger.isTraceEnabled()) {
                logger.trace("%sms to compile template: %s", System.currentTimeMillis() - start, this.getKey());
            }
            byArray = this.javaByteCode;
        }
        catch (CompileException.CompilerException e) {
            try {
                TemplateClass tc;
                String cn = e.className;
                TemplateClass templateClass = tc = S.isEqual(cn, this.name) ? this : this.engine().classes().getByClassName(cn);
                if (null == tc) {
                    tc = this;
                }
                CompileException ce = new CompileException(this.engine(), tc, e.javaLineNumber, e.message);
                this.javaSource = null;
                logger.warn("compile failed for %s at line %d", tc.tagName, e.javaLineNumber);
                Iterator<TemplateClass> iterator = this.includedTemplateClasses.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        throw ce;
                    }
                    TemplateClass itc = iterator.next();
                    logger.info("\tincluded: %s", itc.tagName);
                }
                catch (NullPointerException e2) {
                    String clazzName = this.name;
                    tc = this.engine().classes().getByClassName(clazzName);
                    if (this != tc) {
                        logger.error("tc is not this", new Object[0]);
                    }
                    if (!this.equals(tc)) {
                        logger.error("tc not match this", new Object[0]);
                    }
                    logger.error("NPE encountered when compiling template class:" + this.name, new Object[0]);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                if (logger.isTraceEnabled()) {
                    logger.trace("%sms to compile template class %s", System.currentTimeMillis() - start, this.getKey());
                }
                throw throwable;
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("%sms to compile template class %s", System.currentTimeMillis() - start, this.getKey());
        }
        return byArray;
    }

    public void delayedEnhance(TemplateClass root) {
        this.enhancedByteCode = this.javaByteCode;
        root.embeddedClasses.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] enhance() {
        if (this.enhancing) {
            throw new IllegalStateException("reenter enhance() call");
        }
        this.enhancing = true;
        try {
            byte[] bytes = this.enhancedByteCode;
            if (null == bytes) {
                bytes = this.javaByteCode;
                if (null == bytes) {
                    bytes = this.compile();
                }
                long start = System.currentTimeMillis();
                IByteCodeEnhancer en = this.engine().conf().byteCodeEnhancer();
                if (null != en) {
                    try {
                        bytes = en.enhance(this.name, bytes);
                    }
                    catch (Exception e) {
                        logger.warn(e, "Error enhancing template class: %s", this.getKey());
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("%sms to enhance template class %s", System.currentTimeMillis() - start, this.getKey());
                    }
                }
                this.enhancedByteCode = bytes;
                this.engine().classCache().cacheTemplateClass(this);
            }
            for (TemplateClass embedded : this.embeddedClasses) {
                embedded.enhancedByteCode = null;
                embedded.enhance();
            }
            Object object = bytes;
            return object;
        }
        finally {
            this.enhancing = false;
        }
    }

    public void uncompile() {
        this.javaClass = null;
    }

    public boolean isClass() {
        return !this.name.endsWith("package-info");
    }

    public String getPackage() {
        int dot = this.name.lastIndexOf(46);
        return dot > -1 ? this.name.substring(0, dot) : "";
    }

    public void loadCachedByteCode(byte[] code) {
        this.enhancedByteCode = code;
    }

    public void compiled(byte[] code) {
        this.javaByteCode = code;
        this.compiled = true;
        RythmEvents.COMPILED.trigger(this.engine(), code);
        this.enhance();
    }

    public String toString() {
        return "(compiled:" + this.compiled + ") " + this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TemplateClass) {
            TemplateClass that = (TemplateClass)o;
            return that.getKey().equals(this.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    private static String canonicalClassName(String name) {
        if (S.empty(name)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char[] ca = name.toCharArray();
        int len = ca.length;
        char c = ca[0];
        if (!Character.isJavaIdentifierStart(c)) {
            sb.append('_');
        } else {
            sb.append(c);
        }
        for (int i = 1; i < len; ++i) {
            c = ca[i];
            if (!Character.isJavaIdentifierPart(c)) {
                sb.append('_');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String toCanonicalName(String key, String root) {
        if (key.startsWith("/") || key.startsWith("\\")) {
            key = key.substring(1);
        }
        if (key.startsWith(root)) {
            key = key.replace(root, "");
        }
        if (key.startsWith("/") || key.startsWith("\\")) {
            key = key.substring(1);
        }
        key = key.replace('/', '.').replace('\\', '.');
        return key;
    }

    public static TemplateClass createInnerClass(String className, byte[] byteCode, TemplateClass parent) {
        TemplateClass tc = new TemplateClass();
        tc.name = className;
        tc.javaByteCode = byteCode;
        tc.inner = true;
        tc.root = parent.root();
        return tc;
    }

    public ITemplateResource getTemplateResource() {
        return this.templateResource;
    }

    public ICodeType getCodeType() {
        return this.codeType;
    }

    public Set<String> getImportPaths() {
        if (null == this.importPaths) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.importPaths);
    }

    public String getJavaSource() {
        return this.javaSource;
    }

    @Deprecated
    public void setJavaPackage(Package javaPackage) {
        this.javaPackage = javaPackage;
    }

    @Deprecated
    public void setJavaClass(Class<ITemplate> javaClass) {
        this.javaClass = javaClass;
    }

    public CodeBuilder getCodeBuilder() {
        return this.codeBuilder;
    }

    public Class<ITemplate> getJavaClass() {
        return this.javaClass;
    }

    public byte[] getEnhancedByteCode() {
        return this.enhancedByteCode;
    }

    public byte[] getJavaByteCode() {
        return this.javaByteCode;
    }

    public int getSigChecksum() {
        return this.sigChecksum;
    }

    @Deprecated
    public void setJavaSource(String javaSource) {
        this.javaSource = javaSource;
    }

    @Deprecated
    public void setExtendedTemplateClass(TemplateClass extendedTemplateClass) {
        this.extendedTemplateClass = extendedTemplateClass;
    }

    public void setIncludeTemplateClassNames(String includeTemplateClassNames) {
        this.includeTemplateClassNames = includeTemplateClassNames;
    }
}

