/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.CodeBuilder;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.internal.parser.build_in.BlockToken;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.S;

public class DefTagParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.TAG;
    }

    @Override
    public IParser create(final IContext ctx) {
        return new ParserBase(ctx){

            private Token goClass() {
                String blank;
                Regex r0;
                Regex r = new Regex(String.format(DefTagParser.this.classPatternStr(), this.dialect().a(), DefTagParser.this.keyword()));
                if (!r.search(this.remain())) {
                    return this.goStaticCode();
                }
                String matched = r.stringMatched();
                if (matched.startsWith("\n")) {
                    ctx.getCodeBuilder().addBuilder(new Token.StringToken("\n", ctx));
                    r0 = new Regex("\\n([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                } else {
                    r0 = new Regex("([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                }
                this.step(matched.length());
                String className = r.stringMatched(6);
                r = new Regex("^(\\s*((?@{})))");
                String remain = ctx.getRemain();
                if (!r.search("{" + remain) && !(r = new Regex("^(\\s*((?@@@)))")).search("@" + remain)) {
                    this.raiseParseException("code blocked expected after @def tag", new Object[0]);
                }
                String s = r.stringMatched(1);
                int curLine = this.ctx().currentLine();
                this.ctx().step(s.length() - 1);
                if (s.startsWith("{")) {
                    while (this.ctx().peek() != '}') {
                        this.ctx().step(-1);
                    }
                } else {
                    while (this.ctx().peek() != '@') {
                        this.ctx().step(-1);
                    }
                }
                s = r.stringMatched(2);
                s = s.substring(1);
                s = s.substring(0, s.length() - 1);
                String[] lines = s.split("[\\n\\r]+");
                int len = lines.length;
                StringBuilder sb = new StringBuilder(s.length() * 2);
                for (int i = 0; i < len; ++i) {
                    String line = lines[i];
                    sb.append(line).append(" //line: ").append(curLine++).append("\n");
                }
                return new DefClassToken(className, sb.toString(), this.ctx());
            }

            private Token goStaticCode() {
                String blank;
                Regex r0;
                String matched;
                Regex r = new Regex(String.format(DefTagParser.this.staticCodePatternStr(), this.dialect().a(), DefTagParser.this.keyword()));
                if (!r.search(this.remain())) {
                    this.raiseParseException("Error parsing @def, correct usage: @def (class|[type] tagName)([arguments...])", new Object[0]);
                }
                if ((matched = r.stringMatched()).startsWith("\n")) {
                    ctx.getCodeBuilder().addBuilder(new Token.StringToken("\n", ctx));
                    r0 = new Regex("\\n([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                } else {
                    r0 = new Regex("([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                }
                this.step(matched.length());
                r = new Regex("^(\\s*((?@{})))");
                String remain = ctx.getRemain();
                if (!r.search("{" + remain) && !(r = new Regex("^(\\s*((?@@@)))")).search("@" + remain)) {
                    this.raiseParseException("code blocked expected after @def tag", new Object[0]);
                }
                String s = r.stringMatched(1);
                int curLine = this.ctx().currentLine();
                this.ctx().step(s.length() - 1);
                if (s.startsWith("{")) {
                    while (this.ctx().peek() != '}') {
                        this.ctx().step(-1);
                    }
                } else {
                    while (this.ctx().peek() != '@') {
                        this.ctx().step(-1);
                    }
                }
                s = r.stringMatched(2);
                s = s.substring(1);
                s = s.substring(0, s.length() - 1);
                String[] lines = s.split("[\\n\\r]+");
                int len = lines.length;
                StringBuilder sb = new StringBuilder(s.length() * 2);
                for (int i = 0; i < len; ++i) {
                    String line = lines[i];
                    sb.append(line).append(" //line: ").append(curLine++).append("\n");
                }
                return new DefStaticCodeToken(sb.toString(), this.ctx());
            }

            @Override
            public Token go() {
                String blank;
                Regex r0;
                Regex r = DefTagParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    return this.goClass();
                }
                String matched = r.stringMatched();
                if (matched.startsWith("\n")) {
                    ctx.getCodeBuilder().addBuilder(new Token.StringToken("\n", ctx));
                    r0 = new Regex("\\n([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                } else {
                    r0 = new Regex("([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                }
                this.step(matched.length());
                String retType = r.stringMatched(3);
                String tagName = r.stringMatched(6);
                String signature = r.stringMatched(7);
                if (null != retType && !"void".equals(retType)) {
                    r = new Regex("^(\\s*((?@{})))");
                    String remain = ctx.getRemain();
                    if (!r.search("{" + remain) && !(r = new Regex("^(\\s*((?@@@)))")).search("@" + remain)) {
                        this.raiseParseException("code blocked expected after @def tag", new Object[0]);
                    }
                    String s = r.stringMatched(1);
                    int curLine = this.ctx().currentLine();
                    this.ctx().step(s.length() - 1);
                    if (s.startsWith("{")) {
                        while (this.ctx().peek() != '}') {
                            this.ctx().step(-1);
                        }
                    } else {
                        while (this.ctx().peek() != '@') {
                            this.ctx().step(-1);
                        }
                    }
                    s = r.stringMatched(2);
                    s = s.substring(1);
                    s = s.substring(0, s.length() - 1);
                    r = new Regex(".*[ \\t\\n\\r\\}]+if[ \\t]*\\(.*");
                    boolean hasIfStatement = r.search(" " + s);
                    String[] lines = s.split("[\\n\\r]+");
                    int len = lines.length;
                    StringBuilder sb = new StringBuilder(s.length() * 2);
                    String lastLine = "";
                    for (int i = 0; i < len; ++i) {
                        String line = lines[i];
                        if (!S.isEmpty(line)) {
                            lastLine = line;
                        }
                        sb.append(line).append(" //line: ").append(curLine++).append("\n");
                    }
                    if (!hasIfStatement && !lastLine.trim().endsWith(";")) {
                        sb.append(";");
                    }
                    return new DefTagToken(tagName, retType, signature, sb.toString(), this.ctx());
                }
                return new DefTagToken(tagName, retType, signature, null, this.ctx());
            }
        };
    }

    @Override
    protected String patternStr() {
        return "^\\n?[ \\t\\x0B\\f]*%s%s\\s+(([_a-zA-Z][\\w_\\.$]*(\\s*((?@<>)|(?@[])))?)\\s+)?([_a-zA-Z][\\w_$]*)\\s*((?@()))\\s*{?[ \\t\\x0B\\f]*\\n?";
    }

    protected String classPatternStr() {
        return "^\\n?[ \\t\\x0B\\f]*%s%s\\s+class\\s+(([_a-zA-Z][\\w_\\.$]*(\\s*((?@<>)|(?@[])))?)\\s+)?([_a-zA-Z][\\w_$]*)\\s*{?[ \\t\\x0B\\f]*\\n?";
    }

    protected String staticCodePatternStr() {
        return "^\\n?[ \\t\\x0B\\f]*%s%s\\s+static\\s*{?[ \\t\\x0B\\f]*\\n?";
    }

    private static class DefTagToken
    extends BlockToken {
        String tagName;
        String signature;
        String retType;
        CodeBuilder.InlineTag tag;

        public DefTagToken(String tagName, String retType, String signature, String body, IContext context) {
            super("", context);
            this.retType = retType;
            this.tagName = tagName;
            this.signature = signature;
            this.tag = this.ctx.getCodeBuilder().defTag(tagName, retType, signature, body);
        }

        @Override
        public void openBlock() {
        }

        @Override
        public String closeBlock() {
            this.ctx.getCodeBuilder().endTag(this.tag);
            return "";
        }
    }

    private static class DefClassToken
    extends BlockToken {
        String className;
        CodeBuilder.InlineClass clz;

        public DefClassToken(String className, String body, IContext context) {
            super("", context);
            this.className = className;
            this.clz = this.ctx.getCodeBuilder().defClass(className, body);
        }

        @Override
        public void openBlock() {
        }

        @Override
        public String closeBlock() {
            return "";
        }
    }

    private static class DefStaticCodeToken
    extends BlockToken {
        String code;

        DefStaticCodeToken(String body, IContext context) {
            super("", context);
            this.ctx.getCodeBuilder().addStaticCode(body);
            this.code = body;
        }

        @Override
        public String closeBlock() {
            return "";
        }
    }
}

