/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.TemplateParser;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.RemoveLeadingLineBreakAndSpacesParser;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.S;

public class ExitIfNoClassParser
extends KeywordParserFactory {
    @Override
    public Keyword keyword() {
        return Keyword.EXIT_IF_NO_CLASS;
    }

    @Override
    public IParser create(IContext ctx) {
        return new RemoveLeadingLineBreakAndSpacesParser(ctx){

            @Override
            public Token go() {
                Regex r = ExitIfNoClassParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("error parsing @debug, correct usage: @__exitIfNoClass__(My.Class.Name)", new Object[0]);
                }
                this.step(r.stringMatched().length());
                String s = r.stringMatched(1);
                s = S.stripBraceAndQuotation(s);
                try {
                    this.ctx().getEngine().classLoader().loadClass(s);
                    return new Token("", this.ctx());
                }
                catch (Exception e) {
                    throw new TemplateParser.ExitInstruction();
                }
            }
        };
    }

    @Override
    protected String patternStr() {
        return "%s%s\\s*((?@()))[\\s]+";
    }
}

