/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.resource;

import java.io.File;
import org.rythmengine.RythmEngine;
import org.rythmengine.resource.FileTemplateResource;
import org.rythmengine.resource.ITemplateResource;
import org.rythmengine.resource.ResourceLoaderBase;
import org.rythmengine.resource.TemplateResourceManager;

public class FileResourceLoader
extends ResourceLoaderBase {
    private File root;

    public FileResourceLoader(RythmEngine engine, File root) {
        this.root = root;
        this.setEngine(engine);
    }

    @Override
    public ITemplateResource load(String path) {
        return new FileTemplateResource(path, this);
    }

    @Override
    public String getResourceLoaderRoot() {
        return this.root.getPath();
    }

    public File getRoot() {
        return this.root;
    }

    @Override
    public void scan(TemplateResourceManager manager) {
        File file = new File(this.getResourceLoaderRoot());
        this.scan_(file, manager);
    }

    private void scan_(File file, TemplateResourceManager manager) {
        if (file.isFile() && file.canRead()) {
            this.load_(file, manager);
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (null == files) {
                return;
            }
            for (File f : files) {
                this.scan_(f, manager);
            }
        }
    }

    private void load_(File file, TemplateResourceManager manager) {
        manager.resourceLoaded(new FileTemplateResource(file, this));
    }
}

