/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.client;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.sahli.asciidoc.confluence.publisher.client.ConfluencePublisherListener;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceAttachment;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceClient;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluencePage;
import org.sahli.asciidoc.confluence.publisher.client.http.NotFoundException;
import org.sahli.asciidoc.confluence.publisher.client.metadata.ConfluencePageMetadata;
import org.sahli.asciidoc.confluence.publisher.client.metadata.ConfluencePublisherMetadata;
import org.sahli.asciidoc.confluence.publisher.client.utils.AssertUtils;
import org.sahli.asciidoc.confluence.publisher.client.utils.InputStreamUtils;

public class ConfluencePublisher {
    static final String CONTENT_HASH_PROPERTY_KEY = "content-hash";
    static final int INITIAL_PAGE_VERSION = 1;
    private final ConfluencePublisherMetadata metadata;
    private final ConfluenceClient confluenceClient;
    private final ConfluencePublisherListener confluencePublisherListener;

    public ConfluencePublisher(ConfluencePublisherMetadata metadata, ConfluenceClient confluenceClient) {
        this(metadata, confluenceClient, new NoOpConfluencePublisherListener());
    }

    public ConfluencePublisher(ConfluencePublisherMetadata metadata, ConfluenceClient confluenceClient, ConfluencePublisherListener confluencePublisherListener) {
        this.metadata = metadata;
        this.confluenceClient = confluenceClient;
        this.confluencePublisherListener = confluencePublisherListener;
    }

    public void publish() {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((String)this.metadata.getSpaceKey()), "spaceKey");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((String)this.metadata.getAncestorId()), "ancestorId");
        this.startPublishingUnderAncestorId(this.metadata.getPages(), this.metadata.getSpaceKey(), this.metadata.getAncestorId());
        this.confluencePublisherListener.publishCompleted();
    }

    private void startPublishingUnderAncestorId(List<ConfluencePageMetadata> pages, String spaceKey, String ancestorId) {
        this.deleteConfluencePagesNotPresentUnderAncestor(pages, ancestorId);
        pages.forEach(page -> {
            String content = InputStreamUtils.fileContent(page.getContentFilePath(), StandardCharsets.UTF_8);
            String contentId = this.addOrUpdatePage(spaceKey, ancestorId, (ConfluencePageMetadata)page, content);
            this.deleteConfluenceAttachmentsNotPresentUnderPage(contentId, page.getAttachments());
            this.addAttachments(contentId, page.getAttachments());
            this.startPublishingUnderAncestorId(page.getChildren(), spaceKey, contentId);
        });
    }

    private void deleteConfluencePagesNotPresentUnderAncestor(List<ConfluencePageMetadata> pagesToKeep, String ancestorId) {
        List<ConfluencePage> childPagesOnConfluence = this.confluenceClient.getChildPages(ancestorId);
        List<ConfluencePage> childPagesOnConfluenceToDelete = childPagesOnConfluence.stream().filter(childPageOnConfluence -> pagesToKeep.stream().noneMatch(page -> page.getTitle().equals(childPageOnConfluence.getTitle()))).collect(Collectors.toList());
        childPagesOnConfluenceToDelete.forEach(pageToDelete -> {
            List<ConfluencePage> pageScheduledForDeletionChildPagesOnConfluence = this.confluenceClient.getChildPages(pageToDelete.getContentId());
            pageScheduledForDeletionChildPagesOnConfluence.forEach(parentPageToDelete -> this.deleteConfluencePagesNotPresentUnderAncestor(Collections.emptyList(), pageToDelete.getContentId()));
            this.confluenceClient.deletePage(pageToDelete.getContentId());
            this.confluencePublisherListener.pageDeleted((ConfluencePage)pageToDelete);
        });
    }

    private void deleteConfluenceAttachmentsNotPresentUnderPage(String contentId, Map<String, String> attachments) {
        List<ConfluenceAttachment> confluenceAttachments = this.confluenceClient.getAttachments(contentId);
        List<String> confluenceAttachmentsToDelete = confluenceAttachments.stream().filter(confluenceAttachment -> attachments.keySet().stream().noneMatch(attachmentFileName -> attachmentFileName.equals(confluenceAttachment.getTitle()))).map(ConfluenceAttachment::getId).collect(Collectors.toList());
        confluenceAttachmentsToDelete.forEach(this.confluenceClient::deleteAttachment);
    }

    private String addOrUpdatePage(String spaceKey, String ancestorId, ConfluencePageMetadata page, String content) {
        String contentId;
        try {
            contentId = this.confluenceClient.getPageByTitle(spaceKey, page.getTitle());
            ConfluencePage existingPage = this.confluenceClient.getPageWithContentAndVersionById(contentId);
            String existingContentHash = this.confluenceClient.getPropertyByKey(contentId, CONTENT_HASH_PROPERTY_KEY);
            String newContentHash = ConfluencePublisher.contentHash(content);
            if (ConfluencePublisher.notSameContentHash(existingContentHash, newContentHash)) {
                this.confluenceClient.deletePropertyByKey(contentId, CONTENT_HASH_PROPERTY_KEY);
                int newPageVersion = existingPage.getVersion() + 1;
                this.confluenceClient.updatePage(contentId, ancestorId, page.getTitle(), content, newPageVersion);
                this.confluenceClient.setPropertyByKey(contentId, CONTENT_HASH_PROPERTY_KEY, newContentHash);
                this.confluencePublisherListener.pageUpdated(existingPage, new ConfluencePage(contentId, page.getTitle(), content, newPageVersion));
            }
        }
        catch (NotFoundException e) {
            contentId = this.confluenceClient.addPageUnderAncestor(spaceKey, ancestorId, page.getTitle(), content);
            this.confluenceClient.setPropertyByKey(contentId, CONTENT_HASH_PROPERTY_KEY, ConfluencePublisher.contentHash(content));
            this.confluencePublisherListener.pageAdded(new ConfluencePage(contentId, page.getTitle(), content, 1));
        }
        return contentId;
    }

    private static String contentHash(String content) {
        return DigestUtils.sha256Hex((String)content);
    }

    private void addAttachments(String contentId, Map<String, String> attachments) {
        attachments.forEach((attachmentFileName, attachmentPath) -> this.addOrUpdateAttachment(contentId, (String)attachmentPath, (String)attachmentFileName));
    }

    private void addOrUpdateAttachment(String contentId, String attachmentPath, String attachmentFileName) {
        Path absoluteAttachmentPath = this.absoluteAttachmentPath(attachmentPath);
        try {
            ConfluenceAttachment existingAttachment = this.confluenceClient.getAttachmentByFileName(contentId, attachmentFileName);
            InputStream existingAttachmentContent = this.confluenceClient.getAttachmentContent(existingAttachment.getRelativeDownloadLink());
            if (!ConfluencePublisher.isSameContent(existingAttachmentContent, ConfluencePublisher.fileInputStream(absoluteAttachmentPath))) {
                this.confluenceClient.updateAttachmentContent(contentId, existingAttachment.getId(), ConfluencePublisher.fileInputStream(absoluteAttachmentPath));
            }
        }
        catch (NotFoundException e) {
            this.confluenceClient.addAttachment(contentId, attachmentFileName, ConfluencePublisher.fileInputStream(absoluteAttachmentPath));
        }
    }

    private Path absoluteAttachmentPath(String attachmentPath) {
        return Paths.get(attachmentPath, new String[0]);
    }

    private static boolean notSameContentHash(String actualContentHash, String newContentHash) {
        return actualContentHash == null || !actualContentHash.equals(newContentHash);
    }

    private static boolean isSameContent(InputStream left, InputStream right) {
        String leftHash = ConfluencePublisher.sha256Hash(left);
        String rightHash = ConfluencePublisher.sha256Hash(right);
        return leftHash.equals(rightHash);
    }

    private static String sha256Hash(InputStream content) {
        try {
            String string = DigestUtils.sha256Hex((InputStream)content);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not compute hash from input stream", e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static FileInputStream fileInputStream(Path filePath) {
        try {
            return new FileInputStream(filePath.toFile());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not find attachment ", e);
        }
    }

    private static class NoOpConfluencePublisherListener
    implements ConfluencePublisherListener {
        private NoOpConfluencePublisherListener() {
        }

        @Override
        public void pageAdded(ConfluencePage addedPage) {
        }

        @Override
        public void pageUpdated(ConfluencePage existingPage, ConfluencePage updatedPage) {
        }

        @Override
        public void pageDeleted(ConfluencePage deletedPage) {
        }

        @Override
        public void publishCompleted() {
        }
    }
}

