/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.client;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.sahli.asciidoc.confluence.publisher.client.ConfluencePublisherListener;
import org.sahli.asciidoc.confluence.publisher.client.PublishingStrategy;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceAttachment;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceClient;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluencePage;
import org.sahli.asciidoc.confluence.publisher.client.http.NotFoundException;
import org.sahli.asciidoc.confluence.publisher.client.metadata.ConfluencePageMetadata;
import org.sahli.asciidoc.confluence.publisher.client.metadata.ConfluencePublisherMetadata;
import org.sahli.asciidoc.confluence.publisher.client.utils.AssertUtils;
import org.sahli.asciidoc.confluence.publisher.client.utils.InputStreamUtils;

public class ConfluencePublisher {
    static final String CONTENT_HASH_PROPERTY_KEY = "content-hash";
    static final int INITIAL_PAGE_VERSION = 1;
    private final ConfluencePublisherMetadata metadata;
    private final PublishingStrategy publishingStrategy;
    private final ConfluenceClient confluenceClient;
    private final ConfluencePublisherListener confluencePublisherListener;
    private final String versionMessage;

    public ConfluencePublisher(ConfluencePublisherMetadata metadata, PublishingStrategy publishingStrategy, ConfluenceClient confluenceClient) {
        this(metadata, publishingStrategy, confluenceClient, new NoOpConfluencePublisherListener(), null);
    }

    public ConfluencePublisher(ConfluencePublisherMetadata metadata, PublishingStrategy publishingStrategy, ConfluenceClient confluenceClient, ConfluencePublisherListener confluencePublisherListener, String versionMessage) {
        this.metadata = metadata;
        this.publishingStrategy = publishingStrategy;
        this.confluenceClient = confluenceClient;
        this.confluencePublisherListener = confluencePublisherListener;
        this.versionMessage = versionMessage;
    }

    public void publish() {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((String)this.metadata.getSpaceKey()), "spaceKey");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((String)this.metadata.getAncestorId()), "ancestorId");
        switch (this.publishingStrategy) {
            case APPEND_TO_ANCESTOR: {
                this.startPublishingUnderAncestorId(this.metadata.getPages(), this.metadata.getSpaceKey(), this.metadata.getAncestorId());
                break;
            }
            case REPLACE_ANCESTOR: {
                this.startPublishingReplacingAncestorId(ConfluencePublisher.singleRootPage(this.metadata), this.metadata.getSpaceKey(), this.metadata.getAncestorId());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid publishing strategy '" + (Object)((Object)this.publishingStrategy) + "'");
            }
        }
        this.confluencePublisherListener.publishCompleted();
    }

    private static ConfluencePageMetadata singleRootPage(ConfluencePublisherMetadata metadata) {
        List<ConfluencePageMetadata> rootPages = metadata.getPages();
        if (rootPages.size() > 1) {
            String rootPageTitles = rootPages.stream().map(page -> "'" + page.getTitle() + "'").collect(Collectors.joining(", "));
            throw new IllegalArgumentException("Multiple root pages detected: " + rootPageTitles + ", but '" + (Object)((Object)PublishingStrategy.REPLACE_ANCESTOR) + "' publishing strategy only supports one single root page");
        }
        if (rootPages.size() == 1) {
            return rootPages.get(0);
        }
        return null;
    }

    private void startPublishingReplacingAncestorId(ConfluencePageMetadata rootPage, String spaceKey, String ancestorId) {
        if (rootPage != null) {
            this.updatePage(ancestorId, null, rootPage);
            this.addOrUpdateLabels(ancestorId, rootPage.getLabels());
            this.deleteConfluenceAttachmentsNotPresentUnderPage(ancestorId, rootPage.getAttachments());
            this.addAttachments(ancestorId, rootPage.getAttachments());
            this.startPublishingUnderAncestorId(rootPage.getChildren(), spaceKey, ancestorId);
        }
    }

    private void startPublishingUnderAncestorId(List<ConfluencePageMetadata> pages, String spaceKey, String ancestorId) {
        this.deleteConfluencePagesNotPresentUnderAncestor(pages, ancestorId);
        pages.forEach(page -> {
            String contentId = this.addOrUpdatePageUnderAncestor(spaceKey, ancestorId, (ConfluencePageMetadata)page);
            this.addOrUpdateLabels(contentId, page.getLabels());
            this.deleteConfluenceAttachmentsNotPresentUnderPage(contentId, page.getAttachments());
            this.addAttachments(contentId, page.getAttachments());
            this.startPublishingUnderAncestorId(page.getChildren(), spaceKey, contentId);
        });
    }

    private void deleteConfluencePagesNotPresentUnderAncestor(List<ConfluencePageMetadata> pagesToKeep, String ancestorId) {
        List<ConfluencePage> childPagesOnConfluence = this.confluenceClient.getChildPages(ancestorId);
        List<ConfluencePage> childPagesOnConfluenceToDelete = childPagesOnConfluence.stream().filter(childPageOnConfluence -> pagesToKeep.stream().noneMatch(page -> page.getTitle().equals(childPageOnConfluence.getTitle()))).collect(Collectors.toList());
        childPagesOnConfluenceToDelete.forEach(pageToDelete -> {
            List<ConfluencePage> pageScheduledForDeletionChildPagesOnConfluence = this.confluenceClient.getChildPages(pageToDelete.getContentId());
            pageScheduledForDeletionChildPagesOnConfluence.forEach(parentPageToDelete -> this.deleteConfluencePagesNotPresentUnderAncestor(Collections.emptyList(), pageToDelete.getContentId()));
            this.confluenceClient.deletePage(pageToDelete.getContentId());
            this.confluencePublisherListener.pageDeleted((ConfluencePage)pageToDelete);
        });
    }

    private void deleteConfluenceAttachmentsNotPresentUnderPage(String contentId, Map<String, String> attachments) {
        List<ConfluenceAttachment> confluenceAttachments = this.confluenceClient.getAttachments(contentId);
        confluenceAttachments.stream().filter(confluenceAttachment -> attachments.keySet().stream().noneMatch(attachmentFileName -> attachmentFileName.equals(confluenceAttachment.getTitle()))).forEach(confluenceAttachment -> {
            this.confluenceClient.deletePropertyByKey(contentId, this.getAttachmentHashKey(confluenceAttachment.getTitle()));
            this.confluenceClient.deleteAttachment(confluenceAttachment.getId());
            this.confluencePublisherListener.attachmentDeleted(confluenceAttachment.getTitle(), contentId);
        });
    }

    private String addOrUpdatePageUnderAncestor(String spaceKey, String ancestorId, ConfluencePageMetadata page) {
        String contentId;
        try {
            contentId = this.confluenceClient.getPageByTitle(spaceKey, page.getTitle());
            this.updatePage(contentId, ancestorId, page);
        }
        catch (NotFoundException e) {
            String content = InputStreamUtils.fileContent(page.getContentFilePath(), StandardCharsets.UTF_8);
            contentId = this.confluenceClient.addPageUnderAncestor(spaceKey, ancestorId, page.getTitle(), content, this.versionMessage);
            this.confluenceClient.setPropertyByKey(contentId, CONTENT_HASH_PROPERTY_KEY, ConfluencePublisher.hash(content));
            this.confluencePublisherListener.pageAdded(new ConfluencePage(contentId, page.getTitle(), content, 1));
        }
        return contentId;
    }

    private void updatePage(String contentId, String ancestorId, ConfluencePageMetadata page) {
        String newContentHash;
        String content = InputStreamUtils.fileContent(page.getContentFilePath(), StandardCharsets.UTF_8);
        ConfluencePage existingPage = this.confluenceClient.getPageWithContentAndVersionById(contentId);
        String existingContentHash = this.confluenceClient.getPropertyByKey(contentId, CONTENT_HASH_PROPERTY_KEY);
        if (ConfluencePublisher.notSameHash(existingContentHash, newContentHash = ConfluencePublisher.hash(content)) || !existingPage.getTitle().equals(page.getTitle())) {
            this.confluenceClient.deletePropertyByKey(contentId, CONTENT_HASH_PROPERTY_KEY);
            int newPageVersion = existingPage.getVersion() + 1;
            this.confluenceClient.updatePage(contentId, ancestorId, page.getTitle(), content, newPageVersion, this.versionMessage);
            this.confluenceClient.setPropertyByKey(contentId, CONTENT_HASH_PROPERTY_KEY, newContentHash);
            this.confluencePublisherListener.pageUpdated(existingPage, new ConfluencePage(contentId, page.getTitle(), content, newPageVersion));
        }
    }

    private void addAttachments(String contentId, Map<String, String> attachments) {
        attachments.forEach((attachmentFileName, attachmentPath) -> this.addOrUpdateAttachment(contentId, (String)attachmentPath, (String)attachmentFileName));
    }

    private void addOrUpdateAttachment(String contentId, String attachmentPath, String attachmentFileName) {
        Path absoluteAttachmentPath = this.absoluteAttachmentPath(attachmentPath);
        String newAttachmentHash = ConfluencePublisher.hash(ConfluencePublisher.fileInputStream(absoluteAttachmentPath));
        try {
            ConfluenceAttachment existingAttachment = this.confluenceClient.getAttachmentByFileName(contentId, attachmentFileName);
            String attachmentId = existingAttachment.getId();
            String existingAttachmentHash = this.confluenceClient.getPropertyByKey(contentId, this.getAttachmentHashKey(attachmentFileName));
            if (ConfluencePublisher.notSameHash(existingAttachmentHash, newAttachmentHash)) {
                if (existingAttachmentHash != null) {
                    this.confluenceClient.deletePropertyByKey(contentId, this.getAttachmentHashKey(attachmentFileName));
                }
                this.confluenceClient.updateAttachmentContent(contentId, attachmentId, ConfluencePublisher.fileInputStream(absoluteAttachmentPath));
                this.confluenceClient.setPropertyByKey(contentId, this.getAttachmentHashKey(attachmentFileName), newAttachmentHash);
                this.confluencePublisherListener.attachmentUpdated(attachmentFileName, contentId);
            }
        }
        catch (NotFoundException e) {
            this.confluenceClient.deletePropertyByKey(contentId, this.getAttachmentHashKey(attachmentFileName));
            this.confluenceClient.addAttachment(contentId, attachmentFileName, ConfluencePublisher.fileInputStream(absoluteAttachmentPath));
            this.confluenceClient.setPropertyByKey(contentId, this.getAttachmentHashKey(attachmentFileName), newAttachmentHash);
            this.confluencePublisherListener.attachmentAdded(attachmentFileName, contentId);
        }
    }

    private String getAttachmentHashKey(String attachmentFileName) {
        return attachmentFileName + "-hash";
    }

    private Path absoluteAttachmentPath(String attachmentPath) {
        return Paths.get(attachmentPath, new String[0]);
    }

    private void addOrUpdateLabels(String contentId, List<String> labels) {
        List<String> existingLabels = this.confluenceClient.getLabels(contentId);
        existingLabels.stream().filter(existingLabel -> !labels.contains(existingLabel)).forEach(labelToDelete -> this.confluenceClient.deleteLabel(contentId, (String)labelToDelete));
        List<String> labelsToAdd = labels.stream().filter(label -> !existingLabels.contains(label)).collect(Collectors.toList());
        if (labelsToAdd.size() > 0) {
            this.confluenceClient.addLabels(contentId, labelsToAdd);
        }
    }

    private static boolean notSameHash(String actualHash, String newHash) {
        return actualHash == null || !actualHash.equals(newHash);
    }

    private static String hash(String content) {
        return DigestUtils.sha256Hex((String)content);
    }

    private static String hash(InputStream content) {
        try {
            String string = DigestUtils.sha256Hex((InputStream)content);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not compute hash from input stream", e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static FileInputStream fileInputStream(Path filePath) {
        try {
            return new FileInputStream(filePath.toFile());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not find attachment ", e);
        }
    }

    private static class NoOpConfluencePublisherListener
    implements ConfluencePublisherListener {
        private NoOpConfluencePublisherListener() {
        }

        @Override
        public void pageAdded(ConfluencePage addedPage) {
        }

        @Override
        public void pageUpdated(ConfluencePage existingPage, ConfluencePage updatedPage) {
        }

        @Override
        public void pageDeleted(ConfluencePage deletedPage) {
        }

        @Override
        public void attachmentAdded(String attachmentFileName, String contentId) {
        }

        @Override
        public void attachmentUpdated(String attachmentFileName, String contentId) {
        }

        @Override
        public void attachmentDeleted(String attachmentFileName, String contentId) {
        }

        @Override
        public void publishCompleted() {
        }
    }
}

