/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.client.http;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.sahli.asciidoc.confluence.publisher.client.utils.InputStreamUtils;

public class RequestFailedException
extends RuntimeException {
    RequestFailedException(HttpRequest request, HttpResponse response, Exception reason) {
        super("request failed (request: " + RequestFailedException.requestLog(request) + ", response: " + RequestFailedException.responseLog(response) + (reason != null ? ", reason: '" + reason.getMessage() + "'" : "") + ")", reason);
    }

    private static String requestLog(HttpRequest request) {
        String requestLine = request.getRequestLine().getMethod() + " " + request.getRequestLine().getUri();
        String requestBody = RequestFailedException.requestBody(request);
        return requestLine + " " + requestBody;
    }

    private static String responseLog(HttpResponse response) {
        if (response == null) {
            return "<none>";
        }
        String statusLine = response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase();
        String responseBody = RequestFailedException.responseBody(response);
        return statusLine + " " + responseBody;
    }

    private static String requestBody(HttpRequest request) {
        return request instanceof HttpEntityEnclosingRequest ? RequestFailedException.entityAsString(((HttpEntityEnclosingRequest)request).getEntity()) : "<empty body>";
    }

    private static String responseBody(HttpResponse response) {
        return RequestFailedException.entityAsString(response.getEntity());
    }

    private static String entityAsString(HttpEntity entity) {
        try {
            InputStream content = entity.getContent();
            Charset encoding = entity.getContentEncoding() == null ? Charset.defaultCharset() : Charset.forName(entity.getContentEncoding().getValue());
            String contentString = InputStreamUtils.inputStreamAsString(content, encoding);
            return contentString;
        }
        catch (Exception ignored) {
            return "<empty body>";
        }
    }
}

