/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.client.http;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContextBuilder;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceAttachment;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceClient;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluencePage;
import org.sahli.asciidoc.confluence.publisher.client.http.HttpRequestFactory;
import org.sahli.asciidoc.confluence.publisher.client.http.MultipleResultsException;
import org.sahli.asciidoc.confluence.publisher.client.http.NotFoundException;
import org.sahli.asciidoc.confluence.publisher.client.http.RequestFailedException;
import org.sahli.asciidoc.confluence.publisher.client.utils.AssertUtils;

public class ConfluenceRestClient
implements ConfluenceClient {
    private final CloseableHttpClient httpClient;
    private final String username;
    private final String password;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final HttpRequestFactory httpRequestFactory;

    public ConfluenceRestClient(String rootConfluenceUrl, boolean disableSslVerification, String username, String password) {
        this(rootConfluenceUrl, null, disableSslVerification, username, password);
    }

    public ConfluenceRestClient(String rootConfluenceUrl, ProxyConfiguration proxyConfiguration, boolean disableSslVerification, String username, String password) {
        this(rootConfluenceUrl, ConfluenceRestClient.defaultHttpClient(proxyConfiguration, disableSslVerification), username, password);
    }

    public ConfluenceRestClient(String rootConfluenceUrl, CloseableHttpClient httpClient, String username, String password) {
        AssertUtils.assertMandatoryParameter(httpClient != null, "httpClient");
        this.httpClient = httpClient;
        this.username = username;
        this.password = password;
        this.httpRequestFactory = new HttpRequestFactory(rootConfluenceUrl);
        this.configureObjectMapper();
    }

    private void configureObjectMapper() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    @Override
    public String addPageUnderAncestor(String spaceKey, String ancestorId, String title, String content, String versionMessage) {
        HttpPost addPageUnderSpaceRequest = this.httpRequestFactory.addPageUnderAncestorRequest(spaceKey, ancestorId, title, content, versionMessage);
        return this.sendRequestAndFailIfNot20x((HttpRequestBase)addPageUnderSpaceRequest, response -> {
            String contentId = ConfluenceRestClient.extractIdFromJsonNode(this.parseJsonResponse((HttpResponse)response));
            return contentId;
        });
    }

    @Override
    public void updatePage(String contentId, String ancestorId, String title, String content, int newVersion, String versionMessage) {
        HttpPut updatePageRequest = this.httpRequestFactory.updatePageRequest(contentId, ancestorId, title, content, newVersion, versionMessage);
        this.sendRequestAndFailIfNot20x((HttpRequestBase)updatePageRequest);
    }

    @Override
    public void deletePage(String contentId) {
        HttpDelete deletePageRequest = this.httpRequestFactory.deletePageRequest(contentId);
        this.sendRequestAndFailIfNot20x((HttpRequestBase)deletePageRequest);
    }

    @Override
    public String getPageByTitle(String spaceKey, String title) throws NotFoundException, MultipleResultsException {
        HttpGet pageByTitleRequest = this.httpRequestFactory.getPageByTitleRequest(spaceKey, title);
        return this.sendRequestAndFailIfNot20x((HttpRequestBase)pageByTitleRequest, response -> {
            JsonNode jsonNode = this.parseJsonResponse((HttpResponse)response);
            int numberOfResults = jsonNode.get("size").asInt();
            if (numberOfResults == 0) {
                throw new NotFoundException();
            }
            if (numberOfResults > 1) {
                throw new MultipleResultsException();
            }
            String contentId = ConfluenceRestClient.extractIdFromJsonNode((JsonNode)jsonNode.withArray("results").elements().next());
            return contentId;
        });
    }

    @Override
    public void addAttachment(String contentId, String attachmentFileName, InputStream attachmentContent) {
        HttpPost addAttachmentRequest = this.httpRequestFactory.addAttachmentRequest(contentId, attachmentFileName, attachmentContent);
        this.sendRequestAndFailIfNot20x((HttpRequestBase)addAttachmentRequest, response -> {
            ConfluenceRestClient.closeInputStream(attachmentContent);
            return null;
        });
    }

    @Override
    public void updateAttachmentContent(String contentId, String attachmentId, InputStream attachmentContent) {
        HttpPost updateAttachmentContentRequest = this.httpRequestFactory.updateAttachmentContentRequest(contentId, attachmentId, attachmentContent);
        this.sendRequestAndFailIfNot20x((HttpRequestBase)updateAttachmentContentRequest, response -> {
            ConfluenceRestClient.closeInputStream(attachmentContent);
            return null;
        });
    }

    @Override
    public void deleteAttachment(String attachmentId) {
        HttpDelete deleteAttachmentRequest = this.httpRequestFactory.deleteAttachmentRequest(attachmentId);
        this.sendRequestAndFailIfNot20x((HttpRequestBase)deleteAttachmentRequest);
    }

    @Override
    public ConfluenceAttachment getAttachmentByFileName(String contentId, String attachmentFileName) throws NotFoundException, MultipleResultsException {
        HttpGet attachmentByFileNameRequest = this.httpRequestFactory.getAttachmentByFileNameRequest(contentId, attachmentFileName, "version");
        return this.sendRequestAndFailIfNot20x((HttpRequestBase)attachmentByFileNameRequest, response -> {
            JsonNode jsonNode = this.parseJsonResponse((HttpResponse)response);
            int numberOfResults = jsonNode.get("size").asInt();
            if (numberOfResults == 0) {
                throw new NotFoundException();
            }
            if (numberOfResults > 1) {
                throw new MultipleResultsException();
            }
            ConfluenceAttachment attachmentId = ConfluenceRestClient.extractConfluenceAttachment((JsonNode)jsonNode.withArray("results").elements().next());
            return attachmentId;
        });
    }

    @Override
    public ConfluencePage getPageWithContentAndVersionById(String contentId) {
        HttpGet pageByIdRequest = this.httpRequestFactory.getPageByIdRequest(contentId, "body.storage,version");
        return this.sendRequestAndFailIfNot20x((HttpRequestBase)pageByIdRequest, response -> {
            ConfluencePage confluencePage = ConfluenceRestClient.extractConfluencePageWithContent(this.parseJsonResponse((HttpResponse)response));
            return confluencePage;
        });
    }

    private JsonNode parseJsonResponse(HttpResponse response) {
        try {
            return this.objectMapper.readTree(response.getEntity().getContent());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read JSON response", e);
        }
    }

    private void sendRequestAndFailIfNot20x(HttpRequestBase httpRequest) {
        this.sendRequestAndFailIfNot20x(httpRequest, response -> null);
    }

    private <T> T sendRequestAndFailIfNot20x(HttpRequestBase request, Function<HttpResponse, T> responseHandler) {
        return (T)this.sendRequest(request, response -> {
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() < 200 || statusLine.getStatusCode() > 206) {
                throw new RequestFailedException((HttpRequest)request, (HttpResponse)response, null);
            }
            return responseHandler.apply((HttpResponse)response);
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> T sendRequest(HttpRequestBase httpRequest, Function<HttpResponse, T> responseHandler) {
        httpRequest.addHeader("Authorization", ConfluenceRestClient.basicAuthorizationHeaderValue(this.username, this.password));
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpRequest);){
            HttpResponse httpResponse = responseHandler.apply((HttpResponse)response);
            return (T)httpResponse;
        }
        catch (IOException e) {
            throw new RequestFailedException((HttpRequest)httpRequest, null, e);
        }
    }

    @Override
    public List<ConfluencePage> getChildPages(String contentId) {
        int start = 0;
        int limit = 25;
        ArrayList<ConfluencePage> childPages = new ArrayList<ConfluencePage>();
        boolean fetchMore = true;
        while (fetchMore) {
            List<ConfluencePage> nextChildPages = this.getNextChildPages(contentId, limit, start);
            childPages.addAll(nextChildPages);
            ++start;
            fetchMore = nextChildPages.size() == limit;
        }
        return childPages;
    }

    @Override
    public List<ConfluenceAttachment> getAttachments(String contentId) {
        int start = 0;
        int limit = 25;
        ArrayList<ConfluenceAttachment> attachments = new ArrayList<ConfluenceAttachment>();
        boolean fetchMore = true;
        while (fetchMore) {
            List<ConfluenceAttachment> nextAttachments = this.getNextAttachments(contentId, limit, start);
            attachments.addAll(nextAttachments);
            ++start;
            fetchMore = nextAttachments.size() == limit;
        }
        return attachments;
    }

    private List<ConfluencePage> getNextChildPages(String contentId, int limit, int start) {
        ArrayList pages = new ArrayList(limit);
        HttpGet getChildPagesByIdRequest = this.httpRequestFactory.getChildPagesByIdRequest(contentId, limit, start, "version");
        return this.sendRequestAndFailIfNot20x((HttpRequestBase)getChildPagesByIdRequest, response -> {
            JsonNode jsonNode = this.parseJsonResponse((HttpResponse)response);
            jsonNode.withArray("results").forEach(page -> pages.add(ConfluenceRestClient.extractConfluencePageWithoutContent(page)));
            return pages;
        });
    }

    private List<ConfluenceAttachment> getNextAttachments(String contentId, int limit, int start) {
        ArrayList attachments = new ArrayList(limit);
        HttpGet getAttachmentsRequest = this.httpRequestFactory.getAttachmentsRequest(contentId, limit, start, "version");
        return this.sendRequestAndFailIfNot20x((HttpRequestBase)getAttachmentsRequest, response -> {
            JsonNode jsonNode = this.parseJsonResponse((HttpResponse)response);
            jsonNode.withArray("results").forEach(attachment -> attachments.add(ConfluenceRestClient.extractConfluenceAttachment(attachment)));
            return attachments;
        });
    }

    @Override
    public void setPropertyByKey(String contentId, String key, String value) {
        HttpPost setPropertyByKeyRequest = this.httpRequestFactory.setPropertyByKeyRequest(contentId, key, value);
        this.sendRequestAndFailIfNot20x((HttpRequestBase)setPropertyByKeyRequest);
    }

    @Override
    public String getPropertyByKey(String contentId, String key) {
        HttpGet propertyByKeyRequest = this.httpRequestFactory.getPropertyByKeyRequest(contentId, key);
        return this.sendRequest((HttpRequestBase)propertyByKeyRequest, response -> {
            if (response.getStatusLine().getStatusCode() == 200) {
                return ConfluenceRestClient.extractPropertyValueFromJsonNode(this.parseJsonResponse((HttpResponse)response));
            }
            return null;
        });
    }

    @Override
    public void deletePropertyByKey(String contentId, String key) {
        HttpDelete deletePropertyByKeyRequest = this.httpRequestFactory.deletePropertyByKeyRequest(contentId, key);
        this.sendRequest((HttpRequestBase)deletePropertyByKeyRequest, ignored -> null);
    }

    @Override
    public List<String> getLabels(String contentId) {
        HttpGet getLabelsRequest = this.httpRequestFactory.getLabelsRequest(contentId);
        return this.sendRequest((HttpRequestBase)getLabelsRequest, response -> {
            ArrayList labels = new ArrayList();
            JsonNode jsonNode = this.parseJsonResponse((HttpResponse)response);
            jsonNode.withArray("results").elements().forEachRemaining(n -> labels.add(n.get("name").asText()));
            return labels;
        });
    }

    @Override
    public void addLabels(String contentId, List<String> labels) {
        HttpPost addLabelRequest = this.httpRequestFactory.addLabelsRequest(contentId, labels);
        this.sendRequestAndFailIfNot20x((HttpRequestBase)addLabelRequest);
    }

    @Override
    public void deleteLabel(String contentId, String label) {
        HttpDelete deleteLabelRequest = this.httpRequestFactory.deleteLabelRequest(contentId, label);
        this.sendRequestAndFailIfNot20x((HttpRequestBase)deleteLabelRequest);
    }

    private static ConfluencePage extractConfluencePageWithContent(JsonNode jsonNode) {
        String id = ConfluenceRestClient.extractIdFromJsonNode(jsonNode);
        String title = ConfluenceRestClient.extractTitleFromJsonNode(jsonNode);
        String content = jsonNode.path("body").path("storage").get("value").asText();
        int version = ConfluenceRestClient.extractVersionFromJsonNode(jsonNode);
        return new ConfluencePage(id, title, content, version);
    }

    private static ConfluencePage extractConfluencePageWithoutContent(JsonNode jsonNode) {
        String id = ConfluenceRestClient.extractIdFromJsonNode(jsonNode);
        String title = ConfluenceRestClient.extractTitleFromJsonNode(jsonNode);
        int version = ConfluenceRestClient.extractVersionFromJsonNode(jsonNode);
        return new ConfluencePage(id, title, version);
    }

    private static ConfluenceAttachment extractConfluenceAttachment(JsonNode jsonNode) {
        String id = ConfluenceRestClient.extractIdFromJsonNode(jsonNode);
        String title = ConfluenceRestClient.extractTitleFromJsonNode(jsonNode);
        int version = ConfluenceRestClient.extractVersionFromJsonNode(jsonNode);
        String relativeDownloadLink = jsonNode.path("_links").get("download").asText();
        return new ConfluenceAttachment(id, title, relativeDownloadLink, version);
    }

    private static String extractIdFromJsonNode(JsonNode jsonNode) {
        return jsonNode.get("id").asText();
    }

    private static String extractTitleFromJsonNode(JsonNode jsonNode) {
        return jsonNode.get("title").asText();
    }

    private static int extractVersionFromJsonNode(JsonNode jsonNode) {
        return jsonNode.path("version").get("number").asInt();
    }

    private static String extractPropertyValueFromJsonNode(JsonNode jsonNode) {
        return jsonNode.path("value").asText();
    }

    private static void closeInputStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static CloseableHttpClient defaultHttpClient(ProxyConfiguration proxyConfiguration, boolean disableSslVerification) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(20000).setConnectTimeout(20000).setCookieSpec("standard").build();
        HttpClientBuilder builder = HttpClients.custom().setDefaultRequestConfig(requestConfig);
        if (proxyConfiguration != null && proxyConfiguration.proxyHost() != null) {
            String proxyScheme = proxyConfiguration.proxyScheme() != null ? proxyConfiguration.proxyScheme() : "http";
            String proxyHost = proxyConfiguration.proxyHost();
            int proxyPort = proxyConfiguration.proxyPort() != null ? proxyConfiguration.proxyPort() : 80;
            builder.setProxy(new HttpHost(proxyHost, proxyPort, proxyScheme));
            if (proxyConfiguration.proxyUsername() != null) {
                String proxyUsername = proxyConfiguration.proxyUsername();
                String proxyPassword = proxyConfiguration.proxyPassword();
                builder.setDefaultHeaders(Collections.singletonList(new BasicHeader("Proxy-Authorization", ConfluenceRestClient.basicAuthorizationHeaderValue(proxyUsername, proxyPassword))));
            }
        }
        if (disableSslVerification) {
            builder.setSSLContext(ConfluenceRestClient.trustAllSslContext());
            builder.setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
        }
        return builder.build();
    }

    private static SSLContext trustAllSslContext() {
        try {
            return new SSLContextBuilder().loadTrustMaterial((chain, authType) -> true).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create trust-all SSL context", e);
        }
    }

    private static String basicAuthorizationHeaderValue(String username, String password) {
        return "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8));
    }

    public static class ProxyConfiguration {
        private final String proxyScheme;
        private final String proxyHost;
        private final Integer proxyPort;
        private final String proxyUsername;
        private final String proxyPassword;

        public ProxyConfiguration(String proxyScheme, String proxyHost, Integer proxyPort, String proxyUsername, String proxyPassword) {
            this.proxyScheme = proxyScheme;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.proxyUsername = proxyUsername;
            this.proxyPassword = proxyPassword;
        }

        public String proxyScheme() {
            return this.proxyScheme;
        }

        public String proxyHost() {
            return this.proxyHost;
        }

        public Integer proxyPort() {
            return this.proxyPort;
        }

        public String proxyUsername() {
            return this.proxyUsername;
        }

        public String proxyPassword() {
            return this.proxyPassword;
        }
    }
}

