/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.converter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.ast.Title;
import org.sahli.asciidoc.confluence.publisher.converter.AsciidocPagesStructureProvider;
import org.sahli.asciidoc.confluence.publisher.converter.NoOpPageTitlePostProcessor;
import org.sahli.asciidoc.confluence.publisher.converter.PageTitlePostProcessor;

public class AsciidocConfluencePage {
    private static final Pattern CDATA_PATTERN = Pattern.compile("<!\\[CDATA\\[.*?\\]\\]>", 32);
    private static final Pattern ATTACHMENT_PATH_PATTERN = Pattern.compile("<ri:attachment ri:filename=\"(.*?)\"");
    private static final Pattern PAGE_TITLE_PATTERN = Pattern.compile("<ri:page ri:content-title=\"(.*?)\"");
    private static final Asciidoctor ASCIIDOCTOR = Asciidoctor.Factory.create();
    private final String pageTitle;
    private final String htmlContent;
    private final Map<String, String> attachments;

    private AsciidocConfluencePage(String pageTitle, String htmlContent, Map<String, String> attachments) {
        this.pageTitle = pageTitle;
        this.htmlContent = htmlContent;
        this.attachments = attachments;
    }

    public String content() {
        return this.htmlContent;
    }

    public String pageTitle() {
        return this.pageTitle;
    }

    public Map<String, String> attachments() {
        return Collections.unmodifiableMap(this.attachments);
    }

    public static AsciidocConfluencePage newAsciidocConfluencePage(AsciidocPagesStructureProvider.AsciidocPage asciidocPage, Charset sourceEncoding, Path templatesDir, Path pageAssetsFolder) {
        return AsciidocConfluencePage.newAsciidocConfluencePage(asciidocPage, sourceEncoding, templatesDir, pageAssetsFolder, new NoOpPageTitlePostProcessor());
    }

    public static AsciidocConfluencePage newAsciidocConfluencePage(AsciidocPagesStructureProvider.AsciidocPage asciidocPage, Charset sourceEncoding, Path templatesDir, Path pageAssetsFolder, PageTitlePostProcessor pageTitlePostProcessor) {
        try {
            Path asciidocPagePath = asciidocPage.path();
            String asciidocContent = AsciidocConfluencePage.readIntoString(Files.newInputStream(asciidocPagePath, new OpenOption[0]), sourceEncoding);
            HashMap<String, String> attachmentCollector = new HashMap<String, String>();
            Options options = AsciidocConfluencePage.options(templatesDir, asciidocPagePath.getParent(), pageAssetsFolder);
            String pageContent = AsciidocConfluencePage.convertedContent(asciidocContent, options, asciidocPagePath, attachmentCollector, pageTitlePostProcessor, sourceEncoding);
            String pageTitle = AsciidocConfluencePage.pageTitle(asciidocContent, pageTitlePostProcessor);
            return new AsciidocConfluencePage(pageTitle, pageContent, attachmentCollector);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create asciidoc confluence page", e);
        }
    }

    private static String deriveAttachmentName(String path) {
        return path.contains("/") ? path.substring(path.lastIndexOf(47) + 1) : path;
    }

    private static String convertedContent(String adocContent, Options options, Path pagePath, Map<String, String> attachmentCollector, PageTitlePostProcessor pageTitlePostProcessor, Charset sourceEncoding) {
        String content = ASCIIDOCTOR.convert(adocContent, options);
        String postProcessedContent = AsciidocConfluencePage.postProcessContent(content, AsciidocConfluencePage.replaceCrossReferenceTargets(pagePath, pageTitlePostProcessor, sourceEncoding), AsciidocConfluencePage.collectAndReplaceAttachmentFileNames(attachmentCollector), AsciidocConfluencePage.unescapeCdataHtmlContent());
        return postProcessedContent;
    }

    private static Function<String, String> unescapeCdataHtmlContent() {
        return content -> AsciidocConfluencePage.replaceAll(content, CDATA_PATTERN, matchResult -> StringEscapeUtils.unescapeHtml((String)matchResult.group()));
    }

    private static Function<String, String> collectAndReplaceAttachmentFileNames(Map<String, String> attachmentCollector) {
        return content -> AsciidocConfluencePage.replaceAll(content, ATTACHMENT_PATH_PATTERN, matchResult -> {
            String attachmentPath = matchResult.group(1);
            String attachmentFileName = AsciidocConfluencePage.deriveAttachmentName(attachmentPath);
            attachmentCollector.put(attachmentPath, attachmentFileName);
            return "<ri:attachment ri:filename=\"" + attachmentFileName + "\"";
        });
    }

    private static String replaceAll(String content, Pattern pattern, Function<MatchResult, String> replacer) {
        StringBuffer replacedContent = new StringBuffer();
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            matcher.appendReplacement(replacedContent, Matcher.quoteReplacement(replacer.apply(matcher.toMatchResult())));
        }
        matcher.appendTail(replacedContent);
        return replacedContent.toString();
    }

    @SafeVarargs
    private static String postProcessContent(String initialContent, Function<String, String> ... postProcessors) {
        return Arrays.stream(postProcessors).reduce(initialContent, (accumulator, postProcessor) -> (String)postProcessor.apply(accumulator), AsciidocConfluencePage.unusedCombiner());
    }

    private static String pageTitle(String pageContent, PageTitlePostProcessor pageTitlePostProcessor) {
        return Optional.ofNullable(ASCIIDOCTOR.readDocumentHeader(pageContent).getDocumentTitle()).map(Title::getMain).map(pageTitle -> pageTitlePostProcessor.process((String)pageTitle)).orElseThrow(() -> new RuntimeException("top-level heading or title meta information must be set"));
    }

    private static Options options(Path templatesFolder, Path baseFolder, Path generatedAssetsTargetFolder) {
        if (!Files.exists(templatesFolder, new LinkOption[0])) {
            throw new RuntimeException("templateDir folder does not exist");
        }
        if (!Files.isDirectory(templatesFolder, new LinkOption[0])) {
            throw new RuntimeException("templateDir folder is not a folder");
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("imagesoutdir", generatedAssetsTargetFolder.toString());
        attributes.put("outdir", generatedAssetsTargetFolder.toString());
        return OptionsBuilder.options().backend("xhtml5").safe(SafeMode.UNSAFE).baseDir(baseFolder.toFile()).templateDirs(new File[]{templatesFolder.toFile()}).attributes(attributes).get();
    }

    private static Function<String, String> replaceCrossReferenceTargets(Path pagePath, PageTitlePostProcessor pageTitlePostProcessor, Charset sourceEncoding) {
        return content -> AsciidocConfluencePage.replaceAll(content, PAGE_TITLE_PATTERN, matchResult -> {
            String htmlTarget = matchResult.group(1);
            Path referencedPagePath = pagePath.getParent().resolve(Paths.get(htmlTarget.substring(0, htmlTarget.lastIndexOf(46)) + ".adoc", new String[0]));
            try {
                String referencedPageContent = AsciidocConfluencePage.readIntoString(new FileInputStream(referencedPagePath.toFile()), sourceEncoding);
                String referencedPageTitle = AsciidocConfluencePage.pageTitle(referencedPageContent, pageTitlePostProcessor);
                return "<ri:page ri:content-title=\"" + referencedPageTitle + "\"";
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("unable to find cross-referenced page '" + referencedPagePath + "'", e);
            }
        });
    }

    private static BinaryOperator<String> unusedCombiner() {
        return (a, b) -> a;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readIntoString(InputStream input, Charset encoding) {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input, encoding));){
            String string = buffer.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read file content", e);
        }
    }

    static {
        ASCIIDOCTOR.requireLibrary(new String[]{"asciidoctor-diagram"});
    }
}

