/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.maven.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.sahli.asciidoc.confluence.publisher.client.metadata.ConfluencePageMetadata;
import org.sahli.asciidoc.confluence.publisher.client.metadata.ConfluencePublisherMetadata;
import org.sahli.asciidoc.confluence.publisher.converter.AsciidocConfluencePage;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

final class AsciidocConfluenceConverter {
    private AsciidocConfluenceConverter() {
        throw new UnsupportedOperationException("Instantiation not supported");
    }

    static ConfluencePublisherMetadata convertAndBuildConfluencePages(String asciidocRootFolderPath, String generatedDocOutputPath, String asciidocConfluenceTemplatesPath, String spaceKey, String ancestorId) throws IOException {
        ConfluencePublisherMetadata confluencePublisherMetadata = AsciidocConfluenceConverter.initializeConfluencePublisherMetadata(spaceKey, ancestorId);
        AdocFileVisitor visitor = new AdocFileVisitor(asciidocRootFolderPath, generatedDocOutputPath, asciidocConfluenceTemplatesPath);
        Files.walkFileTree(Paths.get(asciidocRootFolderPath, new String[0]), visitor);
        MultiValueMap<String, ConfluencePageMetadata> confluencePublisherMetadataRegistry = visitor.confluencePageMetadataRegistry();
        List rootPages = (List)confluencePublisherMetadataRegistry.get((Object)generatedDocOutputPath);
        if (rootPages != null) {
            confluencePublisherMetadata.getPages().addAll(rootPages);
            AsciidocConfluenceConverter.buildPageTree(confluencePublisherMetadata.getPages(), confluencePublisherMetadataRegistry, generatedDocOutputPath);
        }
        return confluencePublisherMetadata;
    }

    private static void buildPageTree(List<ConfluencePageMetadata> parentPages, MultiValueMap<String, ConfluencePageMetadata> confluencePageMetadataRegistry, String generatedDocOutputPath) {
        parentPages.forEach(page -> {
            String parentFolder = FilenameUtils.removeExtension((String)Paths.get(generatedDocOutputPath, page.getContentFilePath()).toFile().getAbsolutePath());
            List childPages = (List)confluencePageMetadataRegistry.get((Object)parentFolder);
            if (childPages != null) {
                page.getChildren().addAll(childPages);
                AsciidocConfluenceConverter.buildPageTree(childPages, confluencePageMetadataRegistry, generatedDocOutputPath);
            }
        });
    }

    private static ConfluencePublisherMetadata initializeConfluencePublisherMetadata(String spaceKey, String ancestorId) {
        ConfluencePublisherMetadata confluencePublisherMetadata = new ConfluencePublisherMetadata();
        confluencePublisherMetadata.setSpaceKey(spaceKey);
        if (ancestorId != null) {
            confluencePublisherMetadata.setAncestorId(ancestorId);
        }
        return confluencePublisherMetadata;
    }

    private static class AdocFileVisitor
    implements FileVisitor<Path> {
        private static final String ADOC_FILE_EXTENSION = ".adoc";
        private static final String INCLUDE_FILE_PREFIX = "_";
        private final String asciidocRootFolder;
        private final String generatedDocOutputPath;
        private final String asciidocConfluenceTemplatesPath;
        private final MultiValueMap<String, ConfluencePageMetadata> confluencePageMetadataRegistry = new LinkedMultiValueMap();

        private AdocFileVisitor(String asciidocRootFolder, String generatedDocOutputPath, String asciidocConfluenceTemplatesPath) {
            this.asciidocRootFolder = asciidocRootFolder;
            this.generatedDocOutputPath = generatedDocOutputPath;
            this.asciidocConfluenceTemplatesPath = asciidocConfluenceTemplatesPath;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            String absolutePath = file.toFile().getAbsolutePath();
            String relativePath = absolutePath.substring(this.asciidocRootFolder.length() + 1);
            File targetFile = new File(this.generatedDocOutputPath, relativePath);
            String imagesOutDir = targetFile.getParent();
            this.createMissingDirectories(targetFile);
            if (!this.isIncludeFile(file)) {
                if (this.isAdocFile(file)) {
                    File confluenceHtmlOutputFile = this.replaceFileExtension(targetFile, "html");
                    confluenceHtmlOutputFile.createNewFile();
                    AsciidocConfluencePage asciidocConfluencePage = AsciidocConfluencePage.newAsciidocConfluencePage((InputStream)Files.newInputStream(file, new OpenOption[0]), (String)this.asciidocConfluenceTemplatesPath, (String)imagesOutDir, (Path)file);
                    IOUtils.write((String)asciidocConfluencePage.content(), (OutputStream)new FileOutputStream(confluenceHtmlOutputFile), (String)"UTF-8");
                    ConfluencePageMetadata confluencePageMetadata = new ConfluencePageMetadata();
                    confluencePageMetadata.setTitle(asciidocConfluencePage.pageTitle());
                    confluencePageMetadata.setContentFilePath(Paths.get(this.generatedDocOutputPath, new String[0]).relativize(Paths.get(confluenceHtmlOutputFile.toURI())).toString());
                    confluencePageMetadata.getAttachments().putAll(asciidocConfluencePage.attachments());
                    this.confluencePageMetadataRegistry.add((Object)confluenceHtmlOutputFile.getParent(), (Object)confluencePageMetadata);
                } else {
                    targetFile.createNewFile();
                    IOUtils.copy((InputStream)Files.newInputStream(file, new OpenOption[0]), (OutputStream)new FileOutputStream(targetFile));
                }
            }
            return FileVisitResult.CONTINUE;
        }

        private boolean isAdocFile(Path file) {
            return file.toString().endsWith(ADOC_FILE_EXTENSION);
        }

        private boolean isIncludeFile(Path file) {
            return file.getFileName().toString().startsWith(INCLUDE_FILE_PREFIX);
        }

        private void createMissingDirectories(File file) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
        }

        private File replaceFileExtension(File file, String fileExtension) {
            return new File(file.getParent(), file.getName().substring(0, file.getName().lastIndexOf(".") + 1) + fileExtension);
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        MultiValueMap<String, ConfluencePageMetadata> confluencePageMetadataRegistry() {
            return this.confluencePageMetadataRegistry;
        }
    }
}

