/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.sahli.asciidoc.confluence.publisher.client.ConfluencePublisher;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceClient;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceRestClient;
import org.sahli.asciidoc.confluence.publisher.client.metadata.ConfluencePublisherMetadata;
import org.sahli.asciidoc.confluence.publisher.maven.plugin.AsciidocConfluenceConverter;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Mojo(name="publish")
public class AsciidocConfluencePublisherMojo
extends AbstractMojo {
    private static final String TEMPLATES_CLASSPATH_PATTERN = "org/sahli/asciidoc/confluence/publisher/converter/templates/*";
    @Parameter(defaultValue="${project.build.directory}/confluence-publisher")
    private File generatedDocOutputPath;
    @Parameter(defaultValue="${project.build.directory}/asciidoc2confluence-templates", readonly=true)
    private File asciidocConfluenceTemplates;
    @Parameter(defaultValue="${plugin.artifactMap}", required=true, readonly=true)
    private Map<String, Artifact> pluginArtifactMap;
    @Parameter
    private File asciidocRootFolder;
    @Parameter
    private String rootConfluenceUrl;
    @Parameter(required=true)
    private String spaceKey;
    @Parameter
    private String ancestorId;
    @Parameter
    private String username;
    @Parameter
    private String password;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.extractTemplatesFromJar();
            this.generatedDocOutputPath.mkdirs();
            ConfluencePublisherMetadata confluencePublisherMetadata = AsciidocConfluenceConverter.convertAndBuildConfluencePages(this.asciidocRootFolder.getAbsolutePath(), this.generatedDocOutputPath.getAbsolutePath(), this.asciidocConfluenceTemplates.getAbsolutePath(), this.spaceKey, this.ancestorId);
            this.publish(confluencePublisherMetadata);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Publishing to Confluence failed: " + e.getMessage()));
            throw new MojoExecutionException("Publishing to Confluence failed", e);
        }
    }

    private void publish(ConfluencePublisherMetadata confluencePublisherMetadata) {
        ConfluenceRestClient confluenceRestClient = new ConfluenceRestClient(this.rootConfluenceUrl, AsciidocConfluencePublisherMojo.httpClient(), this.username, this.password);
        ConfluencePublisher confluencePublisher = new ConfluencePublisher(confluencePublisherMetadata, (ConfluenceClient)confluenceRestClient, this.generatedDocOutputPath.getAbsolutePath());
        confluencePublisher.publish();
    }

    private void extractTemplatesFromJar() {
        try {
            this.createTemplatesTargetFolder();
            this.copyTemplatesToTarget(this.templateResources());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Resource> templateResources() throws IOException {
        Artifact artifact = this.pluginArtifactMap.get("org.sahli.asciidoc.confluence.publisher:asciidoc-confluence-publisher-converter");
        URLClassLoader templateClassLoader = new URLClassLoader(new URL[]{artifact.getFile().toURI().toURL()});
        PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver((ResourceLoader)new DefaultResourceLoader((ClassLoader)templateClassLoader));
        return Arrays.asList(pathMatchingResourcePatternResolver.getResources(TEMPLATES_CLASSPATH_PATTERN));
    }

    private void createTemplatesTargetFolder() {
        this.asciidocConfluenceTemplates.mkdir();
    }

    private void copyTemplatesToTarget(List<Resource> resources) {
        resources.forEach(templateResource -> {
            try {
                FileUtils.copyInputStreamToFile((InputStream)templateResource.getInputStream(), (File)new File(this.asciidocConfluenceTemplates, templateResource.getFilename()));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not write template to target file", e);
            }
        });
    }

    private static CloseableHttpClient httpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(20000).setConnectTimeout(20000).build();
        return HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
    }
}

