/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.maven.plugin;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.sahli.asciidoc.confluence.publisher.client.ConfluencePublisher;
import org.sahli.asciidoc.confluence.publisher.client.ConfluencePublisherListener;
import org.sahli.asciidoc.confluence.publisher.client.OrphanRemovalStrategy;
import org.sahli.asciidoc.confluence.publisher.client.PublishingStrategy;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceClient;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluencePage;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceRestClient;
import org.sahli.asciidoc.confluence.publisher.client.metadata.ConfluencePublisherMetadata;
import org.sahli.asciidoc.confluence.publisher.converter.AsciidocConfluenceConverter;
import org.sahli.asciidoc.confluence.publisher.converter.AsciidocPagesStructureProvider;
import org.sahli.asciidoc.confluence.publisher.converter.FolderBasedAsciidocPagesStructureProvider;
import org.sahli.asciidoc.confluence.publisher.converter.PageTitlePostProcessor;
import org.sahli.asciidoc.confluence.publisher.converter.PrefixAndSuffixPageTitlePostProcessor;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

@Mojo(name="publish")
public class AsciidocConfluencePublisherMojo
extends AbstractMojo {
    static final String PREFIX = "asciidoc-confluence-publisher.";
    @Parameter(defaultValue="${project.build.directory}/asciidoc-confluence-publisher", readonly=true)
    private File confluencePublisherBuildFolder;
    @Parameter(property="asciidoc-confluence-publisher.asciidocRootFolder")
    private File asciidocRootFolder;
    @Parameter(property="asciidoc-confluence-publisher.sourceEncoding", defaultValue="UTF-8")
    private String sourceEncoding;
    @Parameter(property="asciidoc-confluence-publisher.rootConfluenceUrl")
    private String rootConfluenceUrl;
    @Parameter(property="asciidoc-confluence-publisher.skipSslVerification", defaultValue="false")
    private boolean skipSslVerification;
    @Parameter(property="asciidoc-confluence-publisher.maxRequestsPerSecond")
    private Double maxRequestsPerSecond;
    @Parameter(property="asciidoc-confluence-publisher.spaceKey", required=true)
    private String spaceKey;
    @Parameter(property="asciidoc-confluence-publisher.ancestorId", required=true)
    private String ancestorId;
    @Parameter(property="asciidoc-confluence-publisher.publishingStrategy", defaultValue="APPEND_TO_ANCESTOR")
    private PublishingStrategy publishingStrategy;
    @Parameter(property="asciidoc-confluence-publisher.orphanRemovalStrategy", defaultValue="REMOVE_ORPHANS")
    private OrphanRemovalStrategy orphanRemovalStrategy;
    @Parameter(property="asciidoc-confluence-publisher.versionMessage")
    private String versionMessage;
    @Parameter(property="asciidoc-confluence-publisher.username")
    private String username;
    @Parameter(property="asciidoc-confluence-publisher.password")
    private String password;
    @Parameter(readonly=true, property="settings")
    protected Settings mavenSettings;
    @Parameter(property="asciidoc-confluence-publisher.serverId")
    private String serverId;
    @Parameter(property="asciidoc-confluence-publisher.pageTitlePrefix")
    private String pageTitlePrefix;
    @Parameter(property="asciidoc-confluence-publisher.pageTitleSuffix")
    private String pageTitleSuffix;
    @Parameter(property="asciidoc-confluence-publisher.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="asciidoc-confluence-publisher.convertOnly", defaultValue="false")
    private boolean convertOnly;
    @Parameter(property="asciidoc-confluence-publisher.proxyScheme")
    private String proxyScheme;
    @Parameter(property="asciidoc-confluence-publisher.proxyHost")
    private String proxyHost;
    @Parameter(property="asciidoc-confluence-publisher.proxyPort")
    private Integer proxyPort;
    @Parameter(property="asciidoc-confluence-publisher.proxyUsername")
    private String proxyUsername;
    @Parameter(property="asciidoc-confluence-publisher.proxyPassword")
    private String proxyPassword;
    @Parameter
    private Map<String, Object> attributes;
    @Component(role=SecDispatcher.class, hint="default")
    private DefaultSecDispatcher securityDispatcher;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Publishing to Confluence skipped ('skip' is enabled)");
            return;
        }
        try {
            PrefixAndSuffixPageTitlePostProcessor pageTitlePostProcessor = new PrefixAndSuffixPageTitlePostProcessor(this.pageTitlePrefix, this.pageTitleSuffix);
            FolderBasedAsciidocPagesStructureProvider asciidocPagesStructureProvider = new FolderBasedAsciidocPagesStructureProvider(this.asciidocRootFolder.toPath(), Charset.forName(this.sourceEncoding));
            AsciidocConfluenceConverter asciidocConfluenceConverter = new AsciidocConfluenceConverter(this.spaceKey, this.ancestorId);
            Map<Object, Object> attributes = this.attributes != null ? this.attributes : Collections.emptyMap();
            ConfluencePublisherMetadata confluencePublisherMetadata = asciidocConfluenceConverter.convert((AsciidocPagesStructureProvider)asciidocPagesStructureProvider, (PageTitlePostProcessor)pageTitlePostProcessor, this.confluencePublisherBuildFolder.toPath(), attributes);
            if (this.username == null || this.password == null) {
                this.applyUsernameAndPasswordFromSettings();
            }
            if (this.convertOnly) {
                this.getLog().info((CharSequence)"Publishing to Confluence skipped ('convert only' is enabled)");
            } else {
                ConfluenceRestClient.ProxyConfiguration proxyConfiguration = new ConfluenceRestClient.ProxyConfiguration(this.proxyScheme, this.proxyHost, this.proxyPort, this.proxyUsername, this.proxyPassword);
                ConfluenceRestClient confluenceRestClient = new ConfluenceRestClient(this.rootConfluenceUrl, proxyConfiguration, this.skipSslVerification, this.maxRequestsPerSecond, this.username, this.password);
                LoggingConfluencePublisherListener confluencePublisherListener = new LoggingConfluencePublisherListener(this.getLog());
                ConfluencePublisher confluencePublisher = new ConfluencePublisher(confluencePublisherMetadata, this.publishingStrategy, this.orphanRemovalStrategy, (ConfluenceClient)confluenceRestClient, (ConfluencePublisherListener)confluencePublisherListener, this.versionMessage);
                confluencePublisher.publish();
            }
        }
        catch (Exception e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Publishing to Confluence failed", (Throwable)e);
            } else {
                this.getLog().error((CharSequence)("Publishing to Confluence failed: " + e.getMessage()));
            }
            throw new MojoExecutionException("Publishing to Confluence failed", e);
        }
    }

    private void applyUsernameAndPasswordFromSettings() throws MojoExecutionException {
        if (this.serverId == null) {
            throw new MojoExecutionException("'serverId' must be set, if username/password are not provided via configuration properties");
        }
        Server server = this.mavenSettings.getServer(this.serverId);
        if (server == null) {
            throw new MojoExecutionException("server with id '" + this.serverId + "' not found in settings.xml");
        }
        if (this.username == null) {
            if (server.getUsername() == null) {
                throw new MojoExecutionException("'username' neither defined by server '" + this.serverId + "' nor provided via configuration properties");
            }
            this.username = server.getUsername();
        }
        try {
            if (this.password == null) {
                if (server.getPassword() == null) {
                    throw new MojoExecutionException("'password' neither defined by server '" + this.serverId + "' nor provided via configuration properties");
                }
                this.securityDispatcher.setConfigurationFile(System.getProperty("user.home") + "/.m2/settings-security.xml");
                this.password = this.securityDispatcher.decrypt(server.getPassword());
            }
        }
        catch (SecDispatcherException ex) {
            throw new MojoExecutionException(ex.getMessage());
        }
    }

    private static class LoggingConfluencePublisherListener
    implements ConfluencePublisherListener {
        private Log log;

        LoggingConfluencePublisherListener(Log log) {
            this.log = log;
        }

        public void pageAdded(ConfluencePage addedPage) {
            this.log.info((CharSequence)("Added page '" + addedPage.getTitle() + "' (id " + addedPage.getContentId() + ")"));
        }

        public void pageUpdated(ConfluencePage existingPage, ConfluencePage updatedPage) {
            this.log.info((CharSequence)("Updated page '" + updatedPage.getTitle() + "' (id " + updatedPage.getContentId() + ", version " + existingPage.getVersion() + " -> " + updatedPage.getVersion() + ")"));
        }

        public void pageDeleted(ConfluencePage deletedPage) {
            this.log.info((CharSequence)("Deleted page '" + deletedPage.getTitle() + "' (id " + deletedPage.getContentId() + ")"));
        }

        public void attachmentAdded(String attachmentFileName, String contentId) {
            this.log.info((CharSequence)("Added attachment '" + attachmentFileName + "' (page id " + contentId + ")"));
        }

        public void attachmentUpdated(String attachmentFileName, String contentId) {
            this.log.info((CharSequence)("Updated attachment '" + attachmentFileName + "' (page id " + contentId + ")"));
        }

        public void attachmentDeleted(String attachmentFileName, String contentId) {
            this.log.info((CharSequence)("Deleted attachment '" + attachmentFileName + "' (page id " + contentId + ")"));
        }

        public void publishCompleted() {
        }
    }
}

