/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.maven.plugin;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.sahli.asciidoc.confluence.publisher.client.ConfluencePublisher;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceClient;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceRestClient;
import org.sahli.asciidoc.confluence.publisher.client.metadata.ConfluencePublisherMetadata;
import org.sahli.asciidoc.confluence.publisher.converter.AsciidocConfluenceConverter;
import org.sahli.asciidoc.confluence.publisher.converter.AsciidocPagesStructureProvider;
import org.sahli.asciidoc.confluence.publisher.converter.FolderBasedAsciidocPagesStructureProvider;

@Mojo(name="publish")
public class AsciidocConfluencePublisherMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/asciidoc-confluence-publisher", readonly=true)
    private File confluencePublisherBuildFolder;
    @Parameter
    private File asciidocRootFolder;
    @Parameter
    private String rootConfluenceUrl;
    @Parameter(required=true)
    private String spaceKey;
    @Parameter(required=true)
    private String ancestorId;
    @Parameter
    private String username;
    @Parameter
    private String password;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            FolderBasedAsciidocPagesStructureProvider asciidocPagesStructureProvider = new FolderBasedAsciidocPagesStructureProvider(this.asciidocRootFolder.toPath());
            AsciidocConfluenceConverter asciidocConfluenceConverter = new AsciidocConfluenceConverter(this.spaceKey, this.ancestorId);
            ConfluencePublisherMetadata confluencePublisherMetadata = asciidocConfluenceConverter.convert((AsciidocPagesStructureProvider)asciidocPagesStructureProvider, this.confluencePublisherBuildFolder.toPath());
            ConfluenceRestClient confluenceRestClient = new ConfluenceRestClient(this.rootConfluenceUrl, this.username, this.password);
            ConfluencePublisher confluencePublisher = new ConfluencePublisher(confluencePublisherMetadata, (ConfluenceClient)confluenceRestClient);
            confluencePublisher.publish();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Publishing to Confluence failed: " + e.getMessage()));
            throw new MojoExecutionException("Publishing to Confluence failed", e);
        }
    }
}

