/*
 * Decompiled with CFR 0.152.
 */
package mdoc.internal.cli;

import com.vladsch.flexmark.util.options.MutableDataSet;
import io.methvin.watcher.DirectoryChangeEvent;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import mdoc.Reporter;
import mdoc.internal.cli.Exit;
import mdoc.internal.cli.Exit$;
import mdoc.internal.cli.FileException;
import mdoc.internal.cli.InputFile;
import mdoc.internal.cli.MainOps$;
import mdoc.internal.cli.Messages$;
import mdoc.internal.cli.Settings;
import mdoc.internal.cli.Timer;
import mdoc.internal.io.IO$;
import mdoc.internal.io.MdocFileListener;
import mdoc.internal.io.MdocFileListener$;
import mdoc.internal.livereload.LiveReload;
import mdoc.internal.livereload.UndertowLiveReload;
import mdoc.internal.livereload.UndertowLiveReload$;
import mdoc.internal.markdown.DocumentLinks;
import mdoc.internal.markdown.DocumentLinks$;
import mdoc.internal.markdown.LinkHygiene$;
import mdoc.internal.markdown.Markdown$;
import mdoc.internal.pos.DiffUtils$;
import metaconfig.Configured;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.meta.inputs.Input;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.io.PathIO$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001\u0002\u000e\u001c\u0005\tB\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!AQ\b\u0001B\u0001B\u0003%a\bC\u0003C\u0001\u0011\u00051\tC\u0004I\u0001\u0001\u0007I\u0011B%\t\u000fI\u0003\u0001\u0019!C\u0005'\"1\u0011\f\u0001Q!\n)CQA\u0017\u0001\u0005\nmCQ\u0001\u0018\u0001\u0005\u0002mCQ!\u0018\u0001\u0005\u0002yCQa\u001a\u0001\u0005\u0002!DQA\u001b\u0001\u0005\u0002-DQ!\u001c\u0001\u0005\u00029DQ! \u0001\u0005\u0002yDQa \u0001\u0005\u0002yDq!!\u0001\u0001\t\u0003\t\u0019\u0001\u0003\u0004\u0002\u001e\u0001!\ta\u0017\u0005\u0007\u0003?\u0001A\u0011A.\t\r\u0005\u0005\u0002\u0001\"\u0001\\\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!a\u000f\u0001\t\u0003\tidB\u0004\u0002BmA\t!a\u0011\u0007\riY\u0002\u0012AA#\u0011\u0019\u0011u\u0003\"\u0001\u0002H!9\u0011\u0011J\f\u0005\u0002\u0005-#aB'bS:|\u0005o\u001d\u0006\u00039u\t1a\u00197j\u0015\tqr$\u0001\u0005j]R,'O\\1m\u0015\u0005\u0001\u0013\u0001B7e_\u000e\u001c\u0001a\u0005\u0002\u0001GA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\f\u0001b]3ui&twm\u001d\t\u0003W1j\u0011aG\u0005\u0003[m\u0011\u0001bU3ui&twm]\u0001\t[\u0006\u00148\u000eZ8x]B\u0011\u0001gO\u0007\u0002c)\u0011!gM\u0001\b_B$\u0018n\u001c8t\u0015\t!T'\u0001\u0003vi&d'B\u0001\u001c8\u0003!1G.\u001a=nCJ\\'B\u0001\u001d:\u0003\u001d1H.\u00193tG\"T\u0011AO\u0001\u0004G>l\u0017B\u0001\u001f2\u00059iU\u000f^1cY\u0016$\u0015\r^1TKR\f\u0001B]3q_J$XM\u001d\t\u0003\u007f\u0001k\u0011aH\u0005\u0003\u0003~\u0011\u0001BU3q_J$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0011+ei\u0012\t\u0003W\u0001AQ!\u000b\u0003A\u0002)BQA\f\u0003A\u0002=BQ!\u0010\u0003A\u0002y\n!\u0002\\5wKJ,Gn\\1e+\u0005Q\u0005c\u0001\u0013L\u001b&\u0011A*\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00059\u0003V\"A(\u000b\u0005!k\u0012BA)P\u0005)a\u0015N^3SK2|\u0017\rZ\u0001\u000fY&4XM]3m_\u0006$w\fJ3r)\t!v\u000b\u0005\u0002%+&\u0011a+\n\u0002\u0005+:LG\u000fC\u0004Y\r\u0005\u0005\t\u0019\u0001&\u0002\u0007a$\u0013'A\u0006mSZ,'/\u001a7pC\u0012\u0004\u0013aD:uCJ$H*\u001b<fe\u0016dw.\u00193\u0015\u0003Q\u000bA\u0001\\5oi\u0006q\u0001.\u00198eY\u0016l\u0015M]6e_^tGCA0c!\tY\u0003-\u0003\u0002b7\t!Q\t_5u\u0011\u0015\u0019'\u00021\u0001e\u0003\u00111\u0017\u000e\\3\u0011\u0005-*\u0017B\u00014\u001c\u0005%Ie\u000e];u\r&dW-A\tiC:$G.\u001a*fOVd\u0017M\u001d$jY\u0016$\"aX5\t\u000b\r\\\u0001\u0019\u00013\u0002\u0015!\fg\u000e\u001a7f\r&dW\r\u0006\u0002`Y\")1\r\u0004a\u0001I\u0006IqO]5uKB\u000bG\u000f\u001b\u000b\u0004)>\u0004\b\"B2\u000e\u0001\u0004!\u0007\"B9\u000e\u0001\u0004\u0011\u0018AB:ue&tw\r\u0005\u0002tu:\u0011A\u000f\u001f\t\u0003k\u0016j\u0011A\u001e\u0006\u0003o\u0006\na\u0001\u0010:p_Rt\u0014BA=&\u0003\u0019\u0001&/\u001a3fM&\u00111\u0010 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e,\u0013\u0001F4f]\u0016\u0014\u0018\r^3D_6\u0004H.\u001a;f'&$X\rF\u0001`\u0003\r\u0011XO\\\u0001\u0011Q\u0006tG\r\\3XCR\u001c\u0007.\u0012<f]R$2\u0001VA\u0003\u0011\u001d\t9\u0001\u0005a\u0001\u0003\u0013\tQ!\u001a<f]R\u0004B!a\u0003\u0002\u001a5\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"A\u0004xCR\u001c\u0007.\u001a:\u000b\t\u0005M\u0011QC\u0001\b[\u0016$\bN^5o\u0015\t\t9\"\u0001\u0002j_&!\u00111DA\u0007\u0005Q!\u0015N]3di>\u0014\u0018p\u00115b]\u001e,WI^3oi\u0006q!/\u001e8GS2,w+\u0019;dQ\u0016\u0014\u0018aC2mK\u0006\u00148k\u0019:fK:\fQc^1ji&twMR8s\r&dWm\u00115b]\u001e,7/A\u0007d_6\u0004\u0018\u000e\\3e\r&dWm\u001d\u000b\u0006)\u0006\u001d\u0012\u0011\u0007\u0005\b\u0003S!\u0002\u0019AA\u0016\u0003\u0005q\u0007c\u0001\u0013\u0002.%\u0019\u0011qF\u0013\u0003\u0007%sG\u000fC\u0004\u00024Q\u0001\r!!\u000e\u0002\u000bQLW.\u001a:\u0011\u0007-\n9$C\u0002\u0002:m\u0011Q\u0001V5nKJ\fabY8na&d\u0017N\\4GS2,7\u000fF\u0002U\u0003\u007fAq!!\u000b\u0016\u0001\u0004\tY#A\u0004NC&tw\n]:\u0011\u0005-:2CA\f$)\t\t\u0019%A\u0004qe>\u001cWm]:\u0015\r\u0005-\u0012QJA.\u0011\u0019I\u0013\u00041\u0001\u0002PA)\u0011\u0011KA,U5\u0011\u00111\u000b\u0006\u0003\u0003+\n!\"\\3uC\u000e|gNZ5h\u0013\u0011\tI&a\u0015\u0003\u0015\r{gNZ5hkJ,G\rC\u0003>3\u0001\u0007a\b")
public final class MainOps {
    private final Settings settings;
    private final MutableDataSet markdown;
    private final Reporter reporter;
    private Option<LiveReload> livereload;

    public static int process(Configured<Settings> configured, Reporter reporter) {
        return MainOps$.MODULE$.process(configured, reporter);
    }

    private Option<LiveReload> livereload() {
        return this.livereload;
    }

    private void livereload_$eq(Option<LiveReload> x$1) {
        this.livereload = x$1;
    }

    private void startLivereload() {
        if (!this.settings.noLivereload()) {
            UndertowLiveReload livereload = UndertowLiveReload$.MODULE$.apply(this.settings.out().toNIO(), this.settings.host(), this.settings.port(), this.reporter, UndertowLiveReload$.MODULE$.apply$default$5());
            livereload.start();
            this.livereload_$eq((Option<LiveReload>)new Some((Object)livereload));
        }
    }

    public void lint() {
        block0: {
            if (!this.settings.out().isDirectory() || this.settings.noLinkHygiene()) break block0;
            List<DocumentLinks> docs = DocumentLinks$.MODULE$.fromGeneratedSite(this.settings, this.reporter);
            LinkHygiene$.MODULE$.lint(docs, this.reporter, this.settings.verbose());
        }
    }

    public synchronized Exit handleMarkdown(InputFile file) {
        boolean fileHasErrors;
        int originalErrors = this.reporter.errorCount();
        if (this.settings.verbose()) {
            this.reporter.info(new StringBuilder(10).append("Compiling ").append(file.in()).toString());
        }
        Timer timer = new Timer();
        String source = FileIO$.MODULE$.slurp(file.in(), this.settings.charset());
        Input.VirtualFile input = package$.MODULE$.Input().VirtualFile().apply(file.in().toString(), source);
        this.markdown.set(Markdown$.MODULE$.InputKey(), (Object)new Some((Object)input));
        this.markdown.set(Markdown$.MODULE$.RelativePathKey(), (Object)new Some((Object)file.relpath()));
        String md = Markdown$.MODULE$.toMarkdown((Input)input, this.markdown, this.reporter, this.settings);
        boolean bl = fileHasErrors = this.reporter.errorCount() > originalErrors;
        if (!fileHasErrors) {
            this.writePath(file, md);
            if (this.settings.verbose()) {
                AbsolutePath arg$macro$1 = file.out();
                Timer arg$macro$2 = timer;
                this.reporter.info(new StringOps("  done => %s (%s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2})));
            }
            this.livereload().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.reload(file.out().toNIO());
                return BoxedUnit.UNIT;
            });
        }
        return this.reporter.hasErrors() ? Exit$.MODULE$.error() : Exit$.MODULE$.success();
    }

    public Exit handleRegularFile(InputFile file) {
        block0: {
            Files.createDirectories(file.out().toNIO().getParent(), new FileAttribute[0]);
            Files.copy(file.in().toNIO(), file.out().toNIO(), StandardCopyOption.REPLACE_EXISTING);
            if (!this.settings.verbose()) break block0;
            this.reporter.info(new StringBuilder(10).append("Copied    ").append(file.out().toNIO()).toString());
        }
        return Exit$.MODULE$.success();
    }

    public Exit handleFile(InputFile file) {
        Exit exit;
        block4: {
            try {
                if (!this.settings.isIncluded(file.relpath())) {
                    exit = Exit$.MODULE$.success();
                    break block4;
                }
                String string = PathIO$.MODULE$.extension(file.in().toNIO());
                Exit exit2 = "md".equals(string) ? this.handleMarkdown(file) : this.handleRegularFile(file);
                exit = exit2;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                new FileException(file.in(), e).printStackTrace();
                Exit exit3 = Exit$.MODULE$.error();
                exit = exit3;
            }
        }
        return exit;
    }

    public void writePath(InputFile file, String string) {
        if (this.settings.check()) {
            String expected;
            if (!file.out().isFile()) {
                return;
            }
            String string2 = expected = FileIO$.MODULE$.slurp(file.out(), this.settings.charset());
            String string3 = string;
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                String filename = file.out().toString();
                String diff = DiffUtils$.MODULE$.unifiedDiff(new StringBuilder(10).append(filename).append(" (on disk)").toString(), new StringBuilder(18).append(filename).append(" (expected output)").toString(), (List<String>)new StringOps(Predef$.MODULE$.augmentString(expected)).linesIterator().toList(), (List<String>)new StringOps(Predef$.MODULE$.augmentString(string)).linesIterator().toList(), 3);
                this.reporter.error(new StringBuilder(66).append("--test failed! To fix this problem, re-generate the documentation\n").append(diff).toString());
            }
        } else {
            Files.createDirectories(file.out().toNIO().getParent(), new FileAttribute[0]);
            Files.write(file.out().toNIO(), string.getBytes(this.settings.charset()), new OpenOption[0]);
        }
    }

    public Exit generateCompleteSite() {
        List<InputFile> files = IO$.MODULE$.inputFiles(this.settings);
        Timer timer = new Timer();
        int n = files.length();
        this.compilingFiles(n);
        Exit exit = (Exit)files.foldLeft((Object)Exit$.MODULE$.success(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Exit accum = (Exit)tuple2._1();
            InputFile file = (InputFile)tuple2._2();
            Exit fileExit = this.handleFile(file);
            Exit exit = accum.merge(fileExit);
            return exit;
        });
        this.lint();
        if (files.isEmpty()) {
            this.reporter.error(new StringBuilder(16).append("no input files: ").append(this.settings.in()).toString());
        } else {
            this.compiledFiles(n, timer);
        }
        return exit;
    }

    /*
     * WARNING - void declaration
     */
    public Exit run() {
        Exit exit;
        if (this.settings.cleanTarget() && Files.exists(this.settings.out().toNIO(), new LinkOption[0])) {
            IO$.MODULE$.cleanTarget(this.settings.out());
        }
        if (this.settings.watch()) {
            this.startLivereload();
        }
        Exit isOk = this.generateCompleteSite();
        if (this.settings.isFileWatching()) {
            this.waitingForFileChanges();
            this.runFileWatcher();
            exit = Exit$.MODULE$.success();
        } else {
            void var1_1;
            exit = var1_1;
        }
        return exit;
    }

    public void handleWatchEvent(DirectoryChangeEvent event) {
        AbsolutePath path;
        Option<InputFile> option;
        String string = PathIO$.MODULE$.extension(event.path());
        String string2 = "md";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.clearScreen();
        }
        if ((option = this.settings.toInputFile(path = AbsolutePath$.MODULE$.apply(event.path(), AbsolutePath$.MODULE$.workingDirectory()))) instanceof Some) {
            Some some = (Some)option;
            InputFile inputFile = (InputFile)some.value();
            this.reporter.reset();
            Timer timer = new Timer();
            this.compilingFiles(1);
            this.handleFile(inputFile);
            this.lint();
            this.compiledFiles(1, timer);
            this.waitingForFileChanges();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public void runFileWatcher() {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        MdocFileListener watcher = MdocFileListener$.MODULE$.create(this.settings.in(), executor, System.in, (Function1<DirectoryChangeEvent, BoxedUnit>)(Function1 & Serializable & scala.Serializable)event -> {
            this.handleWatchEvent(event);
            return BoxedUnit.UNIT;
        });
        watcher.watchUntilInterrupted();
        this.livereload().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.stop();
            return BoxedUnit.UNIT;
        });
    }

    public void clearScreen() {
        Predef$.MODULE$.print((Object)"\u001b[H\u001b[2J");
    }

    public void waitingForFileChanges() {
        this.reporter.println("Waiting for file changes (press enter to interrupt)");
    }

    public void compiledFiles(int n, Timer timer) {
        String errors = Messages$.MODULE$.count("error", this.reporter.errorCount());
        String warnings = this.reporter.hasWarnings() ? new StringBuilder(2).append(", ").append(Messages$.MODULE$.count("warning", this.reporter.warningCount())).toString() : "";
        this.reporter.info(new StringBuilder(15).append("Compiled in ").append(timer).append(" (").append(errors).append(warnings).append(")").toString());
    }

    public void compilingFiles(int n) {
        String files = Messages$.MODULE$.count("file", n);
        this.reporter.info(new StringBuilder(14).append("Compiling ").append(files).append(" to ").append(this.settings.out()).toString());
    }

    public MainOps(Settings settings, MutableDataSet markdown, Reporter reporter) {
        this.settings = settings;
        this.markdown = markdown;
        this.reporter = reporter;
        this.livereload = None$.MODULE$;
    }
}

