/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.builds;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.meta.internal.builds.BuildTool;
import scala.meta.internal.builds.BuildTools$;
import scala.meta.internal.builds.GradleBuildTool;
import scala.meta.internal.builds.GradleBuildTool$;
import scala.meta.internal.builds.MavenBuildTool;
import scala.meta.internal.builds.MavenBuildTool$;
import scala.meta.internal.builds.MillBuildTool;
import scala.meta.internal.builds.MillBuildTool$;
import scala.meta.internal.builds.SbtBuildTool;
import scala.meta.internal.builds.SbtBuildTool$;
import scala.meta.internal.builds.ScalaCliBuildTool$;
import scala.meta.internal.metals.BloopServers$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.UserConfiguration;
import scala.meta.io.AbsolutePath;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0005\u0005Ed\u0001\u0002\u0011\"\u0005)B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u001dQ\u0006A1A\u0005\nmCa\u0001\u001f\u0001!\u0002\u0013a\u0006\"B=\u0001\t\u0003Q\b\"B>\u0001\t\u0003Q\b\"\u0002?\u0001\t\u0003Q\b\"B?\u0001\t\u0013q\bBBA\u0002\u0001\u0011\u0005!\u0010\u0003\u0004\u0002\u0006\u0001!\tA\u001f\u0005\u0007\u0003\u000f\u0001A\u0011\u0001>\t\r\u0005%\u0001\u0001\"\u0001{\u0011\u0019\tY\u0001\u0001C\u0001u\"1\u0011Q\u0002\u0001\u0005\u0002iDa!a\u0004\u0001\t\u0003Q\bbBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u0019\t\u0019\u0003\u0001C\u0001u\"9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002bBA\u0015\u0001\u0011\u0005\u00131\u0006\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011\u001d\tY\u0004\u0001C\u0001\u0003{Aq!a\u0011\u0001\t\u0003\t)eB\u0004\u0002L\u0005B\t!!\u0014\u0007\r\u0001\n\u0003\u0012AA(\u0011\u0019\u0011F\u0004\"\u0001\u0002R!9\u00111\u000b\u000f\u0005\u0002\u0005U\u0003\"CA-9E\u0005I\u0011AA.\u0005)\u0011U/\u001b7e)>|Gn\u001d\u0006\u0003E\r\naAY;jY\u0012\u001c(B\u0001\u0013&\u0003!Ig\u000e^3s]\u0006d'B\u0001\u0014(\u0003\u0011iW\r^1\u000b\u0003!\nQa]2bY\u0006\u001c\u0001a\u0005\u0002\u0001WA\u0011A&L\u0007\u0002O%\u0011af\n\u0002\u0007\u0003:L(+\u001a4\u0002\u0013]|'o[:qC\u000e,\u0007CA\u00195\u001b\u0005\u0011$BA\u001a&\u0003\tIw.\u0003\u00026e\ta\u0011IY:pYV$X\rU1uQ\u0006!\"m\u001d9HY>\u0014\u0017\r\u001c#je\u0016\u001cGo\u001c:jKN\u00042\u0001\u000f!1\u001d\tIdH\u0004\u0002;{5\t1H\u0003\u0002=S\u00051AH]8pizJ\u0011\u0001K\u0005\u0003\u007f\u001d\nq\u0001]1dW\u0006<W-\u0003\u0002B\u0005\n!A*[:u\u0015\tyt%\u0001\u0006vg\u0016\u00148i\u001c8gS\u001e\u00042\u0001L#H\u0013\t1uEA\u0005Gk:\u001cG/[8oaA\u0011\u0001jS\u0007\u0002\u0013*\u0011!jI\u0001\u0007[\u0016$\u0018\r\\:\n\u00051K%!E+tKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006\u0011R\r\u001f9mS\u000eLGo\u00115pS\u000e,W*\u00193f!\raSi\u0014\t\u0003YAK!!U\u0014\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"R\u0001\u0016,X1f\u0003\"!\u0016\u0001\u000e\u0003\u0005BQaL\u0003A\u0002ABQAN\u0003A\u0002]BQaQ\u0003A\u0002\u0011CQ!T\u0003A\u00029\u000ba\u0003\\1ti\u0012+G/Z2uK\u0012\u0014U/\u001b7e)>|Gn]\u000b\u00029B\u0019QL\u001a5\u000e\u0003yS!a\u00181\u0002\r\u0005$x.\\5d\u0015\t\t'-\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u00193\u0002\tU$\u0018\u000e\u001c\u0006\u0002K\u0006!!.\u0019<b\u0013\t9gLA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\rIg\u000e]\u0007\u0002U*\u00111\u000e\\\u0001\nS6lW\u000f^1cY\u0016T!!\\\u0014\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002pU\n\u00191+\u001a;\u0011\u0005E,hB\u0001:t!\tQt%\u0003\u0002uO\u00051\u0001K]3eK\u001aL!A^<\u0003\rM#(/\u001b8h\u0015\t!x%A\fmCN$H)\u001a;fGR,GMQ;jY\u0012$vn\u001c7tA\u0005\t\u0012n]!vi>\u001cuN\u001c8fGR\f'\r\\3\u0016\u0003=\u000bq![:CY>|\u0007/A\u0003jg\n\u001b\b/A\u0006iCNT5o\u001c8GS2,GCA(\u0000\u0011\u0019\t\ta\u0003a\u0001a\u0005\u0019A-\u001b:\u0002\u000b%\u001c8K\u0019;\u0002\r%\u001cX*\u001b7m\u0003)I7oU2bY\u0006\u001cE.[\u0001\tSN<%/\u00193mK\u00069\u0011n]'bm\u0016t\u0017aB5t!\u0006tGo]\u0001\bSN\u0014\u0015M_3m\u00031\tG\u000e\\!wC&d\u0017M\u00197f+\t\t)\u0002\u0005\u00039\u0001\u0006]\u0001cA+\u0002\u001a%\u0019\u00111D\u0011\u0003\u0013\t+\u0018\u000e\u001c3U_>d\u0017aA1mYV\u0011\u0011\u0011\u0005\t\u0004q\u0001\u0003\u0018aB5t\u000b6\u0004H/_\u0001\u000eY>\fGmU;qa>\u0014H/\u001a3\u0015\u0005\u0005U\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003A\fa\"[:Ck&dGMU3mCR,G\r\u0006\u0003\u00022\u0005]\u0002\u0003\u0002\u0017\u00024AL1!!\u000e(\u0005\u0019y\u0005\u000f^5p]\"1\u0011\u0011\b\rA\u0002A\nA\u0001]1uQ\u0006Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u0005\u0005}\u0002\u0003B9\u0002BAL!a\\<\u0002\u00199,wOQ;jY\u0012$vn\u001c7\u0015\u0007=\u000b9\u0005\u0003\u0004\u0002Ji\u0001\r\u0001]\u0001\nEVLG\u000e\u001a+p_2\f!BQ;jY\u0012$vn\u001c7t!\t)Fd\u0005\u0002\u001dWQ\u0011\u0011QJ\u0001\bI\u00164\u0017-\u001e7u)\r!\u0016q\u000b\u0005\b_y\u0001\n\u00111\u00011\u0003E!WMZ1vYR$C-\u001a4bk2$H%M\u000b\u0003\u0003;R3\u0001MA0W\t\t\t\u0007\u0005\u0003\u0002d\u00055TBAA3\u0015\u0011\t9'!\u001b\u0002\u0013Ut7\r[3dW\u0016$'bAA6O\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0014Q\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public final class BuildTools {
    private final AbsolutePath workspace;
    private final List<AbsolutePath> bspGlobalDirectories;
    private final Function0<UserConfiguration> userConfig;
    private final Function0<Object> explicitChoiceMade;
    private final AtomicReference<Set<String>> lastDetectedBuildTools;

    public static AbsolutePath default$default$1() {
        return BuildTools$.MODULE$.default$default$1();
    }

    public static BuildTools default(AbsolutePath workspace) {
        return BuildTools$.MODULE$.default(workspace);
    }

    private AtomicReference<Set<String>> lastDetectedBuildTools() {
        return this.lastDetectedBuildTools;
    }

    public boolean isAutoConnectable() {
        return this.isBloop() || this.isBsp() && this.all().isEmpty() || this.isBsp() && this.explicitChoiceMade.apply$mcZ$sp() || this.isBsp() && this.isBazel();
    }

    public boolean isBloop() {
        return this.hasJsonFile(this.workspace.resolve(".bloop"));
    }

    public boolean isBsp() {
        return this.hasJsonFile(this.workspace.resolve(".bsp")) || this.bspGlobalDirectories.exists((Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)this.hasJsonFile(dir)));
    }

    private boolean hasJsonFile(AbsolutePath dir) {
        return MetalsEnrichments$.MODULE$.XtensionAbsolutePath(dir).list().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BuildTools.$anonfun$hasJsonFile$1(x$1)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSbt() {
        if (this.workspace.resolve("build.sbt").isFile()) return true;
        AbsolutePath buildProperties = this.workspace.resolve("project").resolve("build.properties");
        if (!buildProperties.isFile()) return false;
        Properties props = new Properties();
        try (InputStream in = Files.newInputStream(buildProperties.toNIO(), new OpenOption[0]);){
            props.load(in);
        }
        if (props.getProperty("sbt.version") == null) return false;
        return true;
    }

    public boolean isMill() {
        return this.workspace.resolve("build.sc").isFile();
    }

    public boolean isScalaCli() {
        return ScalaCliBuildTool$.MODULE$.pathsToScalaCliBsp(this.workspace).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isFile())) || this.workspace.resolve("project.scala").isFile();
    }

    public boolean isGradle() {
        .colon.colon defaultGradlePaths = new .colon.colon((Object)"settings.gradle", (List)new .colon.colon((Object)"settings.gradle.kts", (List)new .colon.colon((Object)"build.gradle", (List)new .colon.colon((Object)"build.gradle.kts", (List)Nil$.MODULE$))));
        return defaultGradlePaths.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)BuildTools.$anonfun$isGradle$1(this, x$3)));
    }

    public boolean isMaven() {
        return this.workspace.resolve("pom.xml").isFile();
    }

    public boolean isPants() {
        return this.workspace.resolve("pants.ini").isFile();
    }

    public boolean isBazel() {
        return this.workspace.resolve("WORKSPACE").isFile();
    }

    public List<BuildTool> allAvailable() {
        return new .colon.colon((Object)new SbtBuildTool((Option<String>)None$.MODULE$, this.userConfig), (List)new .colon.colon((Object)new GradleBuildTool(this.userConfig), (List)new .colon.colon((Object)new MavenBuildTool(this.userConfig), (List)new .colon.colon((Object)new MillBuildTool(this.userConfig), (List)new .colon.colon((Object)ScalaCliBuildTool$.MODULE$.apply(this.workspace, this.userConfig), (List)Nil$.MODULE$)))));
    }

    public List<String> all() {
        Builder buf = package$.MODULE$.List().newBuilder();
        Object object = this.isBloop() ? buf.$plus$eq((Object)BloopServers$.MODULE$.name()) : BoxedUnit.UNIT;
        Object object2 = this.isSbt() ? buf.$plus$eq((Object)"sbt") : BoxedUnit.UNIT;
        Object object3 = this.isMill() ? buf.$plus$eq((Object)"Mill") : BoxedUnit.UNIT;
        Object object4 = this.isGradle() ? buf.$plus$eq((Object)"Gradle") : BoxedUnit.UNIT;
        Object object5 = this.isMaven() ? buf.$plus$eq((Object)"Maven") : BoxedUnit.UNIT;
        Object object6 = this.isPants() ? buf.$plus$eq((Object)"Pants") : BoxedUnit.UNIT;
        Object object7 = this.isBazel() ? buf.$plus$eq((Object)"Bazel") : BoxedUnit.UNIT;
        return (List)buf.result();
    }

    public boolean isEmpty() {
        return this.all().isEmpty();
    }

    public List<BuildTool> loadSupported() {
        Builder buf = package$.MODULE$.List().newBuilder();
        Object object = this.isSbt() ? buf.$plus$eq((Object)SbtBuildTool$.MODULE$.apply(this.workspace, this.userConfig)) : BoxedUnit.UNIT;
        Object object2 = this.isGradle() ? buf.$plus$eq((Object)new GradleBuildTool(this.userConfig)) : BoxedUnit.UNIT;
        Object object3 = this.isMaven() ? buf.$plus$eq((Object)new MavenBuildTool(this.userConfig)) : BoxedUnit.UNIT;
        Object object4 = this.isMill() ? buf.$plus$eq((Object)new MillBuildTool(this.userConfig)) : BoxedUnit.UNIT;
        Object object5 = this.isScalaCli() ? buf.$plus$eq((Object)ScalaCliBuildTool$.MODULE$.apply(this.workspace, this.userConfig)) : BoxedUnit.UNIT;
        return (List)buf.result();
    }

    public String toString() {
        String names = this.all().mkString("+");
        if (names.isEmpty()) {
            return "<no build tool>";
        }
        return names;
    }

    public Option<String> isBuildRelated(AbsolutePath path2) {
        if (this.isSbt() && SbtBuildTool$.MODULE$.isSbtRelatedPath(this.workspace, path2)) {
            return new Some((Object)SbtBuildTool$.MODULE$.name());
        }
        if (this.isGradle() && GradleBuildTool$.MODULE$.isGradleRelatedPath(this.workspace, path2)) {
            return new Some((Object)GradleBuildTool$.MODULE$.name());
        }
        if (this.isMaven() && MavenBuildTool$.MODULE$.isMavenRelatedPath(this.workspace, path2)) {
            return new Some((Object)MavenBuildTool$.MODULE$.name());
        }
        if (this.isMill() && MillBuildTool$.MODULE$.isMillRelatedPath(path2)) {
            return new Some((Object)MillBuildTool$.MODULE$.name());
        }
        return None$.MODULE$;
    }

    public Set<String> initialize() {
        return this.lastDetectedBuildTools().getAndSet((Set<String>)this.loadSupported().map((Function1 & Serializable)x$4 -> x$4.executableName()).toSet());
    }

    public boolean newBuildTool(String buildTool) {
        Set<String> before = this.lastDetectedBuildTools().getAndUpdate(x$5 -> (Set)x$5.$plus((Object)buildTool));
        return !before.contains((Object)buildTool);
    }

    public static final /* synthetic */ boolean $anonfun$hasJsonFile$1(AbsolutePath x$1) {
        String string = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(x$1).extension();
        String string2 = "json";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isGradle$1(BuildTools $this, String x$3) {
        return $this.workspace.resolve(x$3).isFile();
    }

    public BuildTools(AbsolutePath workspace, List<AbsolutePath> bspGlobalDirectories, Function0<UserConfiguration> userConfig, Function0<Object> explicitChoiceMade) {
        this.workspace = workspace;
        this.bspGlobalDirectories = bspGlobalDirectories;
        this.userConfig = userConfig;
        this.explicitChoiceMade = explicitChoiceMade;
        this.lastDetectedBuildTools = new AtomicReference<Set>(Predef$.MODULE$.Set().empty());
    }
}

